//
// C++ Implementation: srcpretranslator
//
// Description:
//
//
// Author: Lorenzo Bettini <bettini@gnu.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "srcpretranslator.h"
#include "maingeneratormap.h"
#include "keys.h"

void
Pretranslator::generate (const string & s)
{
      generatormap->generate(GLOBAL, s);
}


void
Pretranslator::generate (const string & s, int start, int end)
{
      generatormap->generate(GLOBAL, s, start, end);
}


void
Pretranslator::generateln (const string & s)
{
      generatormap->generateln(GLOBAL, s);
}


void
Pretranslator::generate_preproc (const string & s)
{
      generatormap->generate_preproc (GLOBAL, s);
}


void
Pretranslator::generate_normal (const string & s)
{
      generatormap->generateEntire (NORMAL, s);
}


void
Pretranslator::generateTab (void)
{
      generate ("\t");
}


void
Pretranslator::startComment (const string & s)
{
      generatormap->beginText(COMMENT, s);
}


void
Pretranslator::endComment (const string & s)
{
      generatormap->endText(COMMENT, s);
}


void
Pretranslator::generateComment (const string & s)
{
      generatormap->generateEntire (COMMENT, s);
}


void
Pretranslator::startString (const string & s)
{
      generatormap->beginText (STRING, s);
}


void
Pretranslator::endString (const string & s)
{
      generatormap->endText (STRING, s);
}


void
Pretranslator::generateString (const string & s)
{
      generatormap->generateEntire (STRING, s);
}


void
Pretranslator::generateKeyWord (const string & s)
{
      generatormap->generateEntire (KEYWORD, s);
}


void
Pretranslator::generateBaseType (const string & s)
{
      generatormap->generateEntire (TYPE, s);
}


void
Pretranslator::generatePreProc (const string & s)
{
      generatormap->generateEntire (PREPROC, s);
}


void
Pretranslator::generateNumber (const string & s)
{
      generatormap->generateEntire (NUMBER, s);
}


void
Pretranslator::generateSymbol (const string & s)
{
      generatormap->generateEntire (SYMBOL, s);
}


void
Pretranslator::generateFunction (const string & s)
{
      generatormap->generateEntire (FUNCTION, s);
}


void
Pretranslator::generateCBracket (const string & s)
{
      generatormap->generateEntire (CBRACKET, s);
}

void
Pretranslator::generate( const std::string &elem, const std::string &s )
{
  generatormap->generate(elem, s);
}

void
Pretranslator::generate( const std::string &elem, const std::string &s, int start, int end )
{
  generatormap->generate(elem, s, start, end);
}

void
Pretranslator::generate_preproc(const std::string &elem, const std::string &s)
{
  generatormap->generate_preproc(elem, s);
}

void
Pretranslator::generateln( const std::string &elem, const std::string &s )
{
  generatormap->generateln(elem, s);
}

void
Pretranslator::generateEntire( const std::string &elem, const std::string &s )
{
  generatormap->generateEntire(elem, s);
}

void
Pretranslator::beginText( const std::string &elem, const std::string &s )
{
  generatormap->beginText(elem, s);
}

void
Pretranslator::endText( const std::string &elem, const std::string &s )
{
  generatormap->endText(elem, s);
}
