REM PROGRAMA DE DEMOSTRACION 1
REM DIBUJO DE UN CUBO EN TRES DIMENSIONES
REM PARA DEMOSTRACION DE LAS FORMULAS DE PROYECCION.

REM CONTROLES:
REM Q: SUBIR EL CUBO
REM A: BAJAR EL CUBO
REM P: MOVER A LA DERECHA EL CUBO
REM O: MOVER A LA IZQUIERDA EL CUBO
REM E: ALEJAR EL CUBO
REM D: ACERCAR EL CUBO
REM S: TERMINAR

REM INDICA CUAL ES LA TARJETA GRAFICA QUE PREFIERES EN LA VARIABLE TARJETA:
REM 1=CGA 4 COLORES (320 x 200 puntos)
REM 2=CGA 2 COLORES (640 x 200 puntos)
REM 3=EGA 16 COLORES (640 x 350 puntos)
REM 4=MCGA 2 COLORES (640 x 480 puntos)
REM 5=MCGA 256 COLORES (320 x 200 puntos)
REM 6=VGA/SVGA 16 COLORES (640 x 480 puntos)
REM 7=AT&T 2 COLORES (640 x 400 puntos)
REM 8=HERCULES 2 COLORES (720 x 348 puntos)
REM Para usar la tarjeta HERCULES, ejecutar antes desde DOS
REM la controladora de dispositivos MSHERC.COM

TARJETA = 1
GOSUB PREPARAR

REM LA VARIABLE RELAS INDICA LA RELACION DE ASPECTO DEL DISPOSITIVO DE SALIDA

RELAS = 3 / 4

REM CALCULAMOS LOS VALORES DE RELACION

IF RELAS <= 1 THEN
     REX = 480 / RELAS
     REY = 480
ELSE
     REX = 480
     REY = 480 * RELAS
END IF

REM LAS VARIABLES XMAX E YMAX SON LAS PROPORCIONES ENTRE LAS COORDENADAS
REM VISUALES Y LAS COORDENADAS ESPECIFICAS.

RELX = XMAX / REX
RELY = YMAX / REY


REM INCR ES EL FACTOR DE INCREMENTO POR CADA PULSACION DE TECLA
REM SI EL PROGRAMA VA MUY RAPIDO, DISMINUIR EL VALOR

INCR = 10

REM D ES LA DISTANCIA DESDE EL OBSERVADOR A LA PANTALLA EN PIXELS

D = 1000

REM INICIO

REM ESTOS SON LOS INCREMENTOS INICIALES PARA LAS COORDENADAS X,Y,Z

IX = 0
IY = 0
IZ = 0

REM LEEMOS LA TABLA DE DATOS

RESTORE DATOS
READ TOTV
DIM V(TOTV - 1, 6)
FOR N = 0 TO TOTV - 1
     FOR F = 0 TO 6
          READ V(N, F)
     NEXT F
NEXT N

FOR N = 0 TO TOTV - 1
     COLORES = V(N, 6)
     IF NUMCOLOR = 2 THEN COLORES = 1
     IF NUMCOLOR = 4 THEN COLORES = COLORES * 3 / 16 + 1
     V(N, 6) = COLORES
NEXT N

REM BUCLE PRINCIPAL

A$ = INKEY$
WHILE A$ <> "S" AND A$ <> "s"
     CLS
     PRINT "(C) 1994 RASTER SOFT."
     FOR N = 0 TO TOTV - 1
          
          REM AADIMOS EL DESPLAZAMIENTO A LAS COORDENADAS INICIALES

          X = V(N, 0) + IX
          Y = V(N, 1) + IY
          Z = V(N, 2) + IZ
         
          REM Y CALCULAMOS SU PROYECCION SOBRE LA PANTALLA
         
          GOSUB ECUACION
          XI = X
          YI = Y
         
          REM AADIMOS EL DESPLAZAMIENTO A LAS COORDENADAS FINALES
         
          X = V(N, 3) + IX
          Y = V(N, 4) + IY
          Z = V(N, 5) + IZ
         
          REM Y CALCULAMOS SU PROYECCION SOBRE LA PANTALLA
        
          GOSUB ECUACION
          XF = X
          YF = Y
         
          REM ASIGNAMOS EL COLOR QUE LE CORRESPONDE Y LA PINTAMOS
         
          COLORES = V(N, 6)
          GOSUB PINTAR
     NEXT N
     A$ = INKEY$
     WHILE A$ = ""
         A$ = INKEY$
     WEND
     IF A$ = "A" OR A$ = "a" THEN IY = IY + INCR
     IF A$ = "Q" OR A$ = "q" THEN IY = IY - INCR
     IF A$ = "P" OR A$ = "p" THEN IX = IX + INCR
     IF A$ = "O" OR A$ = "o" THEN IX = IX - INCR
     IF A$ = "E" OR A$ = "e" THEN IZ = IZ + INCR
     IF A$ = "D" OR A$ = "d" THEN IZ = IZ - INCR
WEND
END

REM SUBRUTINA DE PROYECCION PARA PASAR DE 3D A 2D
REM LAS COORDENADAS INICIALES SON X,Y,Z
REM DEVUELVE SUS PROYECCIONES EN X,Y

ECUACION:
     X = (X * D) / (Z + D) + REX / 2
     Y = (Y * D) / (Z + D) + REY / 2
     RETURN

PINTAR:
  
     LINE (XI * RELX, YI * RELY)-(XF * RELX, YF * RELY), COLORES
     RETURN

PREPARAR:
  
     ON TARJETA GOSUB CGA1, CGA2, EGA, MCGA1, MCGA2, VGA, ATT, HERCULES
     CLS
     RETURN

CGA1:
     XMAX = 320
     YMAX = 200
     SCREEN 1
     NUMCOLOR = 4
     RETURN

CGA2:
     XMAX = 640
     YMAX = 200
     SCREEN 2
     NUMCOLOR = 2
     RETURN

EGA:
     XMAX = 640
     YMAX = 350
     SCREEN 9
     NUMCOLOR = 16
     RETURN

MCGA1:
     XMAX = 640
     YMAX = 480
     SCREEN 11
     NUMCOLOR = 2
     RETURN

MCGA2:
     XMAX = 320
     YMAX = 200
     SCREEN 13
     NUMCOLOR = 256
     RETURN

VGA:
     XMAX = 640
     YMAX = 480
     SCREEN 12
     NUMCOLOR = 16
     RETURN

ATT:
     XMAX = 640
     YMAX = 400
     SCREEN 4
     NUMCOLOR = 2
     RETURN

HERCULES:
     XMAX = 720
     YMAX = 348
     SCREEN 3
     NUMCOLOR = 2
     RETURN




DATOS:
     REM ESTA ES LA BASE DE DATOS DEL CUBO.
     REM ESTA REFERIDA A UNA PANTALLA DE 640 x 480
     REM EL PRIMER VALOR ES EL NUMERO DE LINEAS
     REM CADA LINEA VIENE DEFINIDA POR SIETE NUMEROS:
     REM TRES COORDENADAS INICIALES
     REM TRES FINALES
     REM Y EL COLOR DE LA LINEA, DE 0 A 15
    
     DATA 12
     DATA -100,-100,-100,100,-100,-100,1
     DATA 100,-100,-100,100,100,-100,2
     DATA 100,100,-100,-100,100,-100,3
     DATA -100,100,-100,-100,-100,-100,5
     DATA -100,-100,100,100,-100,100,6
     DATA 100,-100,100,100,100,100,8
     DATA 100,100,100,-100,100,100,9
     DATA -100,100,100,-100,-100,100,11
     DATA -100,-100,-100,-100,-100,100,12
     DATA 100,-100,-100,100,-100,100,13
     DATA -100,100,-100,-100,100,100,14
     DATA 100,100,-100,100,100,100,15



