/*##################################################################

	Rutinas para gestin de ventanas de texto

	##################################################################

	(c) JEM, El Gran Cirimbolo

	Versin 0.0
	10 de Agosto de 1994

	##################################################################

*/

#define TWIN_C

#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include <alloc.h>
#include <string.h>


/* Estructuras de datos */

struct	ventana
				{
					unsigned char		ox,oy; 	/* Origen de la ventana */
					unsigned char		w,h; 		/* Ancho y alto de la ventana */
					unsigned char		x,y; 		/* Coordenadas actuales del cursor */
					unsigned char		c,f; 		/* Color primer plano y fondo */
				};

typedef struct ventana *VENTANA;

#include "twin.h"

/*
	###########################################################

	declaracin de funciones

	###########################################################
*/

VENTANA inic_ventana (unsigned char ox,unsigned char oy,unsigned char w,unsigned char h)
{
VENTANA	ptemp;

ptemp = malloc (sizeof(struct ventana));
if (ptemp==0)
	{
		puts ("\rinic_ventana () : ERROR FATAL 00");
		puts ("\rImposible reservar memoria para otra ventana");
		puts ("\rVentana no asignada");
	} else
	{
		ptemp->ox = ox;
		ptemp->oy = oy;
		ptemp->x  = 0;
		ptemp->y  = 0;
		ptemp->w  = w;
		ptemp->h  = h;
		ptemp->c  = 14;
		ptemp->f  = 9;
	}
return ptemp;
}

void	color_ventana (VENTANA win,unsigned char texto,unsigned char fondo)
{
win->c = texto;
win->f = fondo;

}

void vgotoxy (VENTANA win,unsigned char x,unsigned char y)
{
win->x = x;
win->y = y;
}

void scroll (VENTANA win)
{
union REGS	regs;

regs.h.ah = 6;	/*Funcin para scroll de pantalla del BIOS*/
regs.h.al = 1;  /*Nmero de lneas a scrollar */
regs.h.bh = (unsigned char) (win->f<<4)|(win->c);
regs.h.ch = win->oy-1; /* Fila Superior Izquiierda */
regs.h.cl = win->ox-1; /* Columna Superior Izquierda */
regs.h.dh = win->oy+win->h-1; /* Fila Inferior Derecha */
regs.h.dl = win->ox+win->w-1; /* Columna Inferior Derecha */
int86 (0x10,&regs,&regs);
}

void borrar (VENTANA win)
{
union REGS	regs;

regs.h.ah = 6;	/*Funcin para scroll de pantalla del BIOS*/
regs.h.al = 0;  /*Nmero de lneas a scrollar */
regs.h.bh = (unsigned char) (win->f<<4)|((win->c)&(0x0f));
regs.h.ch = win->oy-1; /* Fila Superior Izquiierda */
regs.h.cl = win->ox-1; /* Columna Superior Izquierda */
regs.h.dh = win->oy+win->h-1; /* Fila Inferior Derecha */
regs.h.dl = win->ox+win->w-1; /* Columna Inferior Derecha */
int86 (0x10,&regs,&regs);
}


void escribe_caracter (VENTANA win,unsigned char c)
{
unsigned char	oldx,oldy;

oldx = (unsigned char) wherex();
oldy = (unsigned char) wherey();

textcolor (win->c);
textbackground (win->f);

switch (c)
{
	case '\b' :
	{
		win->x--;
		if ((win->x>128))
			{
			win->x=0;
			if (win->y>0)
					{
						win->y--;
						win->x=win->w;
					} /*else win->x++;*/
			}


		gotoxy (win->ox+win->x,win->oy+win->y);
		putch (' ');
		win->x--;

		break;
	}
	case '\r':
	{
		win->x = win->w;
		break;
	}
	default :
	{
		gotoxy (win->ox+win->x,win->oy+win->y);
		putch (c);
	}
}

win->x++;
if (win->x>win->w)
	{
		win->x = 0;
		win->y++;
		if (win->y>win->h)
			{
				win->y--;
				scroll (win);
			}
	}

gotoxy (oldx,oldy);
}

void escribe_cadena (VENTANA win,unsigned char *c)
{
int		i;

i=0;
while (*(c+i)!='\0')
	{
		escribe_caracter (win,*(c+i));
		i++;
	}
}

void escribe_centrado (char *cadena,unsigned char fila)
{

gotoxy ((80-strlen(cadena))/2,fila);
cputs (cadena);

}

void vescribe_centrado (VENTANA win,char *cadena,unsigned char fila)
{

vgotoxy (win,(win->w-strlen(cadena))/2,fila);
escribe_cadena (win,cadena);

}