


    fract(6)                 GAMES AND DEMOS                 fract(6)

    NAME
         fract - draw Mandelbrot fractals

    SYNOPSIS
         fract [options]

    DESCRIPTION

    Fract generates,  stores,  and  displays   fractal   images   from  the
    Mandelbrot  set.   Fract was originally written for the Atari ST but it
    should be very easy to port to  other hosts like  Macintosh, Amiga, PC,
    Sun, and X. All you really need is to address a pixel and color it.  It
    is meant  for  mono-chrome  displays but  can  be made to work on color
    systems as well.  On the Atari ST it  is meant for  a  shell  but  also
    works from the desktop.

    Fract was designed to vary  both  the threshhold  for  convergence  (or
    divergence)  as  well  as  the  resolution  of the display. The default
    is maximum for both which  can  take  a long time to process.  For most
    cases, you should be able to get by  with iteration count of 50 to 100.
    The default coordinates plots the  entire  set.  Use  -x, -y, and -r to
    zoom in.

    Other default values will simply  plot  the  values  in the  set black,
    outside white.  The -a option allows  you  to alternate black and white
    contours for those values  outside  the  set (where color displays make
    the pretty pictures).

    For  resolutions  higher  than  the   lowest   (-s  0),   fract   first
    calculates  and  plots the image for  -s  0  -i 50, then calculates and
    plots the  desired  image.    The   first   image   is fairly  fast  on
    the  Atari ST (about 30 seconds) and looks like "fat" pixels 8x8.  This
    allows you to break the  calculation if the image is not in range (with
    any key press). On  non-unix  systems  with  no interrupt signals,  you
    can  break the calculation with a keystroke after any pixel is done.

    This program was based on an article in  the  December  1986 BYTE.

    OPTIONS

     The following command-line options are available :-

     -a   Causes every other contour value to be drawn black. The
          default  is  to just plot the threshhold (-i value) and
          above.


     -i iter
          The default number of iterations dividing values in the
          set  versus values outside the set. The default is 1000
          though 50 or 100 should be sufficient for most things.

     -x xcenter
          The x coordinate of the viewing window. The default  is
          -1.0.

     -y ycenter
          The y coordinate of the viewing window. The default  is
          0.0.

     -r range
          The x and y range of the viewing window. The default is
          3.0.

     -s scale
          The scale factor. Possible values currently are  0,  1,
          2, and 3. 0 is for coarse and 3 is for fine grain.

     -v   This toggles the "colors"  (black  to  white  and  visa
          versa).

     -h   Hold display after plot (before  return  to  the  Atari
          desktop, for example).

     -o outfile
          Write results to file outfile.

     -f infile
          Display previous results from file infile.

    PORTING
    Fract was designed to be  ported  to  other environments.  Most of  the
    code follows "normal" Unix  conventions.  The  file I/O needs  changing
    for  porting  to  non-680x0  architectures, though it has even run on a
    Cray!

     The following funtions are non-portable:

     int  init ()       - initialize things
     int  finish ()     - finish up
     int  check_key ()  - check for a key press (interrupt)
     int  wait_key ()   - wait for a key press
     int  do_pixel ()   - plot a pixel of some color
     int  do_line ()    - draw a line
     int  cursor ()     - toggle cursor on/off
     int  mv_cursor ()  - move cursor on screen
     int  clr_screen () - clear screen, home cursor
     long do_time ()    - for elapsed times


    FILE FORMAT
     The  binary  file  format   for   saved   images   uses   non-portable
    formats  (no  binary data file is  portable).  Binary data is much more
    compact, however.  It is a simple matter  to  write a simple program to
    convert to ASCII, however.

    In general, words are 16-bit. Most of the  data  is  integer words. The
    byte order is normal 68000 order  (first  byte read is most significant
    byte of word).   The  floating  point   data  was  originally using the
    Motorola  Fast  Floating  Point   format   (FFP)  largely  because  the
    development compiler is  twice  as fast  with  FFP  versus  IEEE.  Note
    that the floating point data  in  the  file  is  only for the  textural
    display  on  the image and will not effect image display at all.

     Here is the data format:

     magic           (8 char, !<fract>)
     machine         (1 16-bit word, 0=Atari, 1=Amiga, 2=PC,
                      3=Mac, 4=Sun,...)
     version         (1 16-bit word, e.g. 100 or 0x00C8)
     iter            (1 16-bit word)
     scale           (1 16-bit word, 45, 90, 180, 360 pixels
                      per unit)
     x               (1 32-bit FFP float)
     y               (1 32-bit FFP float)
     range           (1 32-bit FFP float)
     data            (scale * scale 16-bit words)
     ...


    AUTHOR
     Version 1.0 October 1989 (c) 1989 Bill Rosenkranz

     net:    rosenkra%boston@hall.cray.com
     CIS:    71460,17
     GENIE:  W.ROSENKRANZ
