hardaddr	EQU 	$FF8240


init_command MACRO
	IFEQ  interpreter
	movem.l a2-a6/d5-d7,saveblock
	move.l	(a7)+,RETURN			;Save return address
	cmpi.w	#\1,d0				;expect 1 parm
	bne	RANGEPARMERROR
	ELSE
	dc.w 0
	movem.l a0-a5/d0-d7,-(a7)
	ENDC
	ENDM

return_to_stos  MACRO
	IFEQ interpreter
	movem.l saveblock,a2-a6/d5-d7
	move.l RETURN,a0
	jmp (a0)
	ELSE
	movem.l (a7)+,a0-a5/d0-d7
	rts
	ENDC
	ENDM

save_int MACRO
	IFEQ  interpreter
	move.l	\1,d3
	clr.l	d2
	move.l	d2,d4
	ELSE
	move.l \1,-(a6)
	ENDC
	ENDM

getint MACRO
	IFEQ   interpreter
	movem.l	(a7)+,d2-d4
	tst.b	d2
	bne	MISMATCH
	move.l  d3,\1
	ELSE
	move.l (a6)+,\1
	ENDC
	ENDM

getstring MACRO
	IFEQ interpreter
	movem.l	(a7)+,d2-d4
	cmp.b	#$80,d2
	bne	MISMATCH
	add.l #2,d3
	move.l d3,\1
	ELSE
	move.l (a6)+,\1
	add.l #2,\1
	ENDC
	ENDM

movepc	MACRO
	IFC	'','\1'
	fail	missing parameter!
	MEXIT
	ENDC
	move.l a6,-(a7)
	lea \2(pc),a6
	move.\0 \1,(a6)
	move.l (a7)+,a6
	ENDM

cmppc 	MACRO
	IFC	'','\1'
	fail	missing parameter!
	MEXIT
	ENDC
	move.l a6,-(a7)
	lea  \2(pc),a6
	cmp.\0 \1,(a6)
	move.l (a7)+,a6
	ENDM

addpc	MACRO
	move.l a6,-(a7)
	lea \2(pc),a6
	add.\0 \1,(a6)
	move.l (a7)+,a6
	ENDM
	
subpc	MACRO
	move.l a6,-(a7)
	lea \2(pc),a6
	sub.\0 \1,(a6)
	move.l (a7)+,a6
	ENDM


wait_vbl 	MACRO
	movem.l d0-d3/a0-a3,-(a7)
	move.w #37,-(a7)
	trap 	#14
	addq.l	#2,a7
	movem.l (a7)+,d0-d3/a0-a3
	ENDM

error	MACRO
	IFEQ interpreter
	movem.l saveblock,a2-a6/d5-d7
	move.l  #\1,d0
	move.l	SYSTEM,a0
	move.l	$14(a0),a0
	jmp	(a0)
	ELSE
	move.l (a7)+,a5
	move.l #\1,d0
	move.l $93c(a5),a0
	jmp (a0)
	ENDC 
	ENDM


getbank 	MACRO
	IFEQ interpreter
	movem.l a0-a2,-(a7)
	move.l SYSTEM,a0
	move.l $88(a0),a0
	jsr (a0)
	movem.l (a7)+,a0-a2
	ELSE
	movem.l d0-d2/a0-a3,-(a7)
	move.l d3,-(a6)
	jsr 214
	movem.l (a7)+,d0-d2/a0-a3
	ENDM



do_merge 	MACRO
	move.l (a0)+,d6
	move.l (a0)+,d7


	move.l d6,d5
	or.l d7,d5
	move.l d5,d4
	swap d4
	or.l d4,d5
	not.l d5 

	and.l d5,(a3)
	or.l d6,(a3)+
	and.l d5,(a3)
	or.l d7,(a3)+	
	ENDM

do_replace 	MACRO
	REPT 2
	move.l (a0)+,(a3)+	
	ENDR
	ENDM	