/*-------------------------------------------------------------------
	FILE: tm-m6809.h
	SCCS: @(#)tm-m6809.h	1.2 SAL 1/22/92
-------------------------------------------------------------------*/
/* Definitions of target machine for GNU compiler.  MC6809 version.
   Copyright (C) 1989 Free Software Foundation, Inc.

 MC6809 Version by Tom Jones (jones@sal.wisc.edu)
 Space Astronomy Laboratory
 University of Wisconsin at Madison

 A couple of corrections were provided by Mike Albaugh
 of Atari Games Corp. and Joergen Haegg from the
 Lund Institute of Technology, Sweden.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


/* Names to predefine in the preprocessor for this target machine.  */

#define CPP_PREDEFINES "-Dmc6809 -DMC6809"
#define CC1_SPEC ""

/* Print subsidiary information on the compiler version in use.  */

#define TARGET_VERSION fprintf (stderr, " (MC6809)");

/* Run-time compilation parameters selecting different hardware subsets.  */

extern int target_flags;
extern short *reg_renumber;	/* def in local_alloc.c */

/* Macros used in the machine description to test the flags.  */

/* 
   -margcount	use standard calling sequence, with arg count word
   -mnoargcount don't push arg count (it's in the symbol table)
   -mshort_int	use short integers for type "int"
   -mlong_int	use long integers for type "int"
   -mshort_branch	use short branch instructions
*/

#define TARGET_ARGCOUNT (target_flags & 4)

/* Compile with 16-bit `int'.  */
#define TARGET_SHORT_INT (target_flags & 8)

/* Compile with short (+-255) branch instructions */
#define TARGET_SHORT_BRANCH (target_flags & 1)

/* Default target_flags if no switches specified.  */
#ifndef TARGET_DEFAULT
#define TARGET_DEFAULT 8
#endif

/* Macro to define tables used to set the flags.
   This is a list in braces of pairs in braces,
   each pair being { "NAME", VALUE }
   where VALUE is the bits to set or minus the bits to clear.
   An empty string NAME is used to identify the default VALUE.  */

#define TARGET_SWITCHES \
  { { "short_branch", 1 }, \
    { "long_branch", -1 }, \
    { "c2", 2 }, \
    { "noc2", -2 }, \
    { "argcount", 4 }, \
    { "noargcount", -4 }, \
    { "short_int", 8}, \
    { "long_int", -8}, \
    { "", TARGET_DEFAULT }}


/* Pick a target if none was specified */
#define OVERRIDE_OPTIONS  override_options ();

/* Allow $ in identifiers */
#define DOLLARS_IN_IDENTIFIERS 1

/*--------------------------------------------------------------
	Target machine storage layout
--------------------------------------------------------------*/

/* Define this if most significant bit is lowest numbered
   in instructions that operate on numbered bit-fields. */
/*** #define BITS_BIG_ENDIAN /* */

/* Define this if most significant byte of a word is the lowest numbered.  */
#define BYTES_BIG_ENDIAN /* */

/* Define this if most significant word of a multiword number is numbered.  */
/* #define WORDS_BIG_ENDIAN /* */

/* Number of bits in an addressible storage unit */
#define BITS_PER_UNIT 8

/* Width in bits of a "word", or the contents of a machine register.
   Note that this is not necessarily the width of data type `int';
   if using 16-bit ints on a 68000, this would still be 32.
   But on a machine with 16-bit registers, this would be 16.  */
/*** BITS_PER_WORD should equal 16 for the MC6809,
	but we use 32 because of gcc funnies. -- tej ***/
#define BITS_PER_WORD 16

/* Width of a word, in units (bytes).  */
#define UNITS_PER_WORD (BITS_PER_WORD/8)

/* Width in bits of a pointer.
   See also the macro `Pmode' defined below.  */
#define POINTER_SIZE 16

/* Allocation boundary (bits) for storing pointers in memory.  */
#define POINTER_BOUNDARY 8

/* Allocation boundary (bits) for storing arguments in argument list.  */
/* PARM_BOUNDARY is divided by BITS_PER_WORD in expr.c -- tej */
#define PARM_BOUNDARY (TARGET_SHORT_INT ? 16 : 32)

/* Boundary (bits) on which stack pointer should be aligned.  */
#define STACK_BOUNDARY 16

/* Allocation boundary (bits) for the code of a function.  */
#define FUNCTION_BOUNDARY 8

/* Alignment of field after `int : 0' in a structure.  */
#define EMPTY_FIELD_BOUNDARY 8

/* Every structure's size must be a multiple of this.  */
#define STRUCTURE_SIZE_BOUNDARY 8

/* A bitfield declared as `int' forces `int' alignment for the struct.  */
/*** #define PCC_BITFIELD_TYPE_MATTERS	/* */

/* largest mode to use -- try 16 -- tej */
#define MAX_FIXED_MODE_SIZE 16

/* No data type wants to be aligned rounder than this.  */
/* beware of doubles in structs -- 64 is incompatible with pcc */
#define BIGGEST_ALIGNMENT 8

/* Define this if move instructions will actually fail to work
   when given unaligned data.  */
/*** #define STRICT_ALIGNMENT /* */

/*--------------------------------------------------------------
	 Standard register usage.
--------------------------------------------------------------*/
/* assign names to real MC6809 registers -- tej */
#define HARD_D_REGNUM	0
#define HARD_X_REGNUM	1
#define HARD_Y_REGNUM	2
#define HARD_U_REGNUM	3
#define HARD_S_REGNUM	4
#define HARD_PC_REGNUM	5
#define HARD_A_REGNUM	8
#define HARD_B_REGNUM	9
#define HARD_CC_REGNUM 10
#define HARD_DP_REGNUM 11


/* Number of actual hardware registers.
   The hardware registers are assigned numbers for the compiler
   from 0 to just below FIRST_PSEUDO_REGISTER.
   All registers that the compiler knows about must be given numbers,
   even those that are not normally considered general registers.  */
#define FIRST_PSEUDO_REGISTER 12

/* 1 for registers that have pervasive standard uses
   and are not available for the register allocator.  */
#define FIXED_REGISTERS \
    {0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, } 
  /* D, X, Y, U, S, PC,-, -, A, B, C, DP */

/* 1 for registers not available across function calls.
   These must include the FIXED_REGISTERS and also any
   registers that can be used without being saved.
   The latter must include the registers where values are returned
   and the register where structure-value addresses are passed.
   Aside from that, you can include as many other registers as you like.  */
#define CALL_USED_REGISTERS \
    {1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, }
  /* D, X, Y, U, S, PC,-, -, A, B, C, DP */

/* --- DELETED
#define OVERLAPPING_REGNO_P(REGNO) (((REGNO) == HARD_D_REGNUM) \
    || ((REGNO) == HARD_A_REGNUM) || ((REGNO) == HARD_B_REGNUM))
--- DELETED --- */

/* Return number of consecutive hard regs needed starting at reg REGNO
   to hold something of mode MODE.
   This is ordinarily the length in words of a value of mode MODE
   but can be less for certain modes in special long registers.  */
#define HARD_REGNO_NREGS(REGNO, MODE) \
    ((REGNO >= HARD_A_REGNUM) ? (GET_MODE_SIZE (MODE)) \
	: ((GET_MODE_SIZE (MODE) + UNITS_PER_WORD - 1) / UNITS_PER_WORD))

/* Value is 1 if hard register REGNO can hold a value
of machine-mode MODE.  */
#define HARD_REGNO_MODE_OK(REGNO, MODE) \
    (((G_REGNO_P (REGNO)) && (GET_MODE_SIZE (MODE) == 2)) \
  || ((Q_REGNO_P (REGNO)) && (GET_MODE_SIZE (MODE) == 1)) \
  || (MODE == VOIDmode))

/* Value is 1 if it is a good idea to tie two pseudo registers
   when one has mode MODE1 and one has mode MODE2.
   If HARD_REGNO_MODE_OK could produce different values for MODE1 and MODE2,
   for any hard reg, then this must be 0 for correct output.  */
#define MODES_TIEABLE_P(MODE1, MODE2) 0

/* Specify the registers used for certain standard purposes.
   The values of these macros are register numbers.  */

/* program counter if referenced as a register */
#define PC_REGNUM HARD_PC_REGNUM /* */

/* Register to use for pushing function arguments.  */
#define STACK_POINTER_REGNUM HARD_S_REGNUM

/* Base register for access to local variables of the function.  */
#define FRAME_POINTER_REGNUM HARD_U_REGNUM

/* Value should be nonzero if functions must have frame pointers.
   Zero means the frame pointer need not be set up (and parms
   may be accessed via the stack pointer) in functions that seem suitable.
   This is computed in `reload', in reload1.c.  */
#define FRAME_POINTER_REQUIRED 0

/* Base register for access to arguments of the function.  */
#define ARG_POINTER_REGNUM FRAME_POINTER_REGNUM

/* Register in which static-chain is passed to a function.  */
#define STATIC_CHAIN_REGNUM HARD_D_REGNUM

/* Register in which address to store a structure value
   is passed to a function.  */
#define STRUCT_VALUE_REGNUM HARD_D_REGNUM

/* default (ascending) order is (almost) fine for MC6809 */
#define REG_ALLOC_ORDER \
    {1, 2, 0, 3, 4, 5, 6, 7, 9, 8, 10, 11, }  /* */
  /* X, Y, D, U, S, PC,-, -, B, A, CC, DP */

/*--------------------------------------------------------------
	classes of registers
--------------------------------------------------------------*/
/* Define the classes of registers for register constraints in the
   machine description.  Also define ranges of constants.

   One of the classes must always be named ALL_REGS and include all hard regs.
   If there is more than one class, another class must be named NO_REGS
   and contain no registers.

   The name GENERAL_REGS must be the name of a class (or an alias for
   another name such as ALL_REGS).  This is the class of registers
   that is allowed by "g" or "r" in a register constraint.
   Also, registers outside this class are allocated only when
   instructions express preferences for them.

   The classes must be numbered in nondecreasing order; that is,
   a larger-numbered class must never be contained completely
   in a smaller-numbered class.

   For any two classes, it is very desirable that there be another
   class that represents their union.  */
   
/* Define 3 classes A (address) and D (data), and Q (byte). */
enum reg_class {
    NO_REGS,
    D_REGS,		/* 16-bit (word (SI)) data */
    Q_REGS,		/* 8-bit (byte (HI)) data */
    A_REGS,		/* 16-bit addresses */
    G_REGS,		/* 16-bit data and address */
    ALL_REGS,
    LIM_REG_CLASSES
};

#define N_REG_CLASSES (int) LIM_REG_CLASSES

/* Since GENERAL_REGS is a smaller class than ALL_REGS,
   it is not an alias to ALL_REGS, but to G_REGS. */
#define GENERAL_REGS G_REGS

/* Give names of register classes as strings for dump file.   */
#define REG_CLASS_NAMES \
 {"NO_REGS", "D_REGS", "Q_REGS", "A_REGS", "G_REGS", "ALL_REGS" }

/* Define which registers fit in which classes.
   This is an initializer for a vector of HARD_REG_SET
   of length N_REG_CLASSES.  */

  /* -, -, -, -, | DP,C, B, A, | -, -, PC,S, | U, Y, X, D */
#define REG_CLASS_CONTENTS {0, 0x0001, 0x0001, 0x003e, 0x003f, 0x033f}

/* The same information, inverted:
   Return the class number of the smallest class containing
   reg number REGNO.  This could be a conditional expression
   or could index an array.  */

#define REGNO_REG_CLASS(REGNO) \
  (D_REGNO_P (REGNO) ? D_REGS : \
  (Q_REGNO_P (REGNO) ? Q_REGS : \
  (A_REGNO_P (REGNO) ? A_REGS : ALL_REGS)))

#define D_REGNO_P(REGNO) ((REGNO) == HARD_D_REGNUM)
#define Q_REGNO_P(REGNO) ((REGNO) == HARD_D_REGNUM)
#define A_REGNO_P(REGNO) (((REGNO) >= HARD_X_REGNUM) \
    && ((REGNO) <= HARD_PC_REGNUM))
#define G_REGNO_P(REGNO) ((REGNO) <= HARD_PC_REGNUM)

#define D_REG_P(X) (REG_P (X) && D_REGNO_P (REGNO (X)))
#define A_REG_P(X) (REG_P (X) && A_REGNO_P (REGNO (X)))
#define Q_REG_P(X) (REG_P (X) && Q_REGNO_P (REGNO (X)))

/* The class value for index registers, and the one for base regs.  */
#define INDEX_REG_CLASS D_REGS
#define BASE_REG_CLASS A_REGS

/* Get reg_class from a letter in the machine description.  */
/* 'a' -- Address (SI) class */
/* 'd' -- Data (SI) class */
/* 'q' -- Data class for byte mode */

#define REG_CLASS_FROM_LETTER(C) \
  (((C) == 'a' ? A_REGS : \
   ((C) == 'd' ? D_REGS : \
   ((C) == 'q' ? Q_REGS : NO_REGS))))

/*--------------------------------------------------------------
   The letters I, J, K, L and M in a register constraint string
   can be used to stand for particular ranges of immediate operands.
   This macro defines what the ranges are.
   C is the letter, and VALUE is a constant value.
   Return 1 if VALUE is in the range specified by C.

   For the 6809, J, K, L are used for indexed addressing.
   `I' is used for shift counts which can only be equal to 1.
   `J' is used for the 5-bit offsets.
   `K' is used for the 8-bit offsets.
   `L' is used for the range of signed numbers that fit in 16 bits.
--------------------------------------------------------------*/

#define CONST_OK_FOR_LETTER_P(VALUE, C)  \
  ((C) == 'I' ? ((unsigned)(VALUE) == 1) :    \
   (C) == 'J' ? ((unsigned)(VALUE) <= 31) :    \
   (C) == 'K' ? ((unsigned)(VALUE) <= 255) :    \
   (C) == 'L' ? ((unsigned)(VALUE) <= 0xffff) : 0)

/* Similar, but for floating constants, and defining letters G and H.
   No floating-point constants are valid on MC6809.  */
#define CONST_DOUBLE_OK_FOR_LETTER_P(VALUE, C)  0

/* Given an rtx X being reloaded into a reg required to be
   in class CLASS, return the class of reg to actually use.
   In general this is just CLASS; but on some machines
   in some cases it is preferable to use a more restrictive class.  */

/*   On the 6809, use the data reg if possible when the
   value is a constant in the range where ldb could be used
   and we ensure that HImodes are reloaded into data regs.  */

#define PREFERRED_RELOAD_CLASS(X,CLASS)  \
  ((GET_CODE (X) == CONST_INT			\
    && (unsigned) (INTVAL (X) + 0x80) < 0x100	\
    && (CLASS) != A_REGS)			\
   ? Q_REGS					\
   : GET_MODE (X) == HImode			\
   ? Q_REGS					\
   : (CLASS))

/* Return the maximum number of consecutive registers
   needed to represent mode MODE in a register of class CLASS.  */
#define CLASS_MAX_NREGS(CLASS, MODE) \
    ((GET_MODE_SIZE (MODE) + UNITS_PER_WORD - 1) / UNITS_PER_WORD)

/*--------------------------------------------------------------
	Stack layout; function entry, exit and calling.
--------------------------------------------------------------*/

/* Define this if pushing a word on the stack
   makes the stack pointer a smaller address.  */
#define STACK_GROWS_DOWNWARD

/* Define this if the nominal address of the stack frame
   is at the high-address end of the local variables;
   that is, each additional local variable allocated
   goes at a more negative offset in the frame.  */
#define FRAME_GROWS_DOWNWARD

/* Define this if should default to -fcaller-saves.  */
/*** #define DEFAULT_CALLER_SAVES	/* */

/* Offset within stack frame to start allocating local variables at.
   If FRAME_GROWS_DOWNWARD, this is the offset to the END of the
   first local allocated.  Otherwise, it is the offset to the BEGINNING
   of the first local allocated.  */
#define STARTING_FRAME_OFFSET 0

/* If we generate an insn to push BYTES bytes,
   this says how many the stack pointer really advances by. */
/* No rounding or alignment needed for MC6809 */
#define PUSH_ROUNDING(BYTES) (BYTES)

/* Offset of first parameter from the argument pointer register value.  */
#define FIRST_PARM_OFFSET(FNDECL) 2

/* Value is 1 if returning from a function call automatically
   pops the arguments described by the number-of-args field in the call.
   FUNTYPE is the data type of the function (as a tree),
   or for a library call it is an identifier node for the subroutine name. */
/* The standard MC6809 call, with arg count word, includes popping the
   args as part of the call template.  We optionally omit the arg count
   word and let gcc combine the arg pops. */
#define RETURN_POPS_ARGS(FUNTYPE) TARGET_ARGCOUNT

/* Define how to find the value returned by a function.
   VALTYPE is the data type of the value (as a tree).
   If the precise function being called is known, FUNC is its FUNCTION_DECL;
   otherwise, FUNC is 0.  */

/* All return values are in the D-register (register 0) */
#define FUNCTION_VALUE(VALTYPE, FUNC) \
  gen_rtx (REG, TYPE_MODE (VALTYPE), 0)

/* Define how to find the value returned by a library function
   assuming the value has mode MODE.  */

/* All return values are in the D-register (register 0) */
#define LIBCALL_VALUE(MODE)  gen_rtx (REG, MODE, 0)

/* Define this if PCC uses the nonreentrant convention for returning
   structure and union values.  */
#define PCC_STATIC_STRUCT_RETURN

/* 1 if N is a possible register number for a function value. */
#define FUNCTION_VALUE_REGNO_P(N) ((N) == HARD_D_REGNUM)

/* 1 if N is a possible register number for function argument passing. */
#define FUNCTION_ARG_REGNO_P(N) ((N) == HARD_D_REGNUM)

/*--------------------------------------------------------------
	Argument Lists
--------------------------------------------------------------*/
/* Define a data type for recording info about an argument list
   during the scan of that argument list.  This data type should
   hold all necessary information about the function itself
   and about the args processed so far, enough to enable macros
   such as FUNCTION_ARG to determine where the next arg should go.

   This is a single integer, which is a number of bytes
   of arguments scanned so far.  */

#define CUMULATIVE_ARGS int

/* Initialize a variable CUM of type CUMULATIVE_ARGS
   for a call to a function whose data type is FNTYPE.
   For a library call, FNTYPE is 0.  */

#define INIT_CUMULATIVE_ARGS(CUM,FNTYPE) \
 ((CUM) = 0)

/* Update the data in CUM to advance over an argument
   of mode MODE and data type TYPE.
   (TYPE is null for libcalls where that information may not be available.)  */

#define FUNCTION_ARG_ADVANCE(CUM, MODE, TYPE, NAMED) \
 ((CUM) += ((MODE) != BLKmode \
	    ? (GET_MODE_SIZE (MODE)) \
	    : (int_size_in_bytes (TYPE))))

/* Define where to put the arguments to a function.
   Value is zero to push the argument on the stack,
   or a hard register in which to store the argument.

   MODE is the argument's machine mode.
   TYPE is the data type of the argument (as a tree).
    This is null for libcalls where that information may
    not be available.
   CUM is a variable of type CUMULATIVE_ARGS which gives info about
    the preceding args and about the function being called.
   NAMED is nonzero if this argument is a named parameter
    (otherwise it is an extra parameter matching an ellipsis).  */

/* For now all args are pushed. -- tej */
#define FUNCTION_ARG(CUM, MODE, TYPE, NAMED) 0

/* This macro generates the assembly code for function entry.
   FILE is a stdio stream to output the code to.
   SIZE is an int: how many units of temporary storage to allocate.
   Refer to the array `regs_ever_live' to determine which registers
   to save; `regs_ever_live[I]' is nonzero if register number I
   is ever used in the function.  This macro is responsible for
   knowing which registers should not be saved even if used.  */

/*--------------------------------------------------------------
    Function Prologue Definition
--------------------------------------------------------------*/
#define FUNCTION_PROLOGUE(FILE, SIZE) \
{ register int regno; \
  int offset = 0; \
  char reglist[30]; \
  fprintf (FILE, ";;;-----------------------------------------\n"); \
  fprintf (FILE, ";;;  PROLOGUE for %s\n", current_function_name); \
  fprintf (FILE, ";;;-----------------------------------------\n"); \
  reglist[0] = '\0'; \
    if ((frame_pointer_needed) && (!regs_ever_live[HARD_U_REGNUM])) { \
	  strcat (reglist, reg_names[HARD_U_REGNUM]); \
	  offset += 2; \
    } \
    for  (regno = HARD_X_REGNUM; regno <= HARD_U_REGNUM; regno++) \
	{ if  (regs_ever_live[regno]) \
	    { \
	      if (reglist[0] != '\0') \
		  strcat (reglist, ","); \
	      strcat (reglist, reg_names[regno]); \
	      offset += 2; \
	    } \
	} \
    if ((SIZE) != 0) \
	fprintf (FILE, "\tleas\t-(%d),s\t; allocate auto variables\n", \
	    (SIZE)); \
    if (offset != 0) \
	fprintf (FILE, "\tpshs\t%s\t;save registers\n", reglist); \
    if (frame_pointer_needed) { \
	fprintf (FILE, "\tleau\t%d,s\t;use U-reg as frame pointer\n", \
	    offset+SIZE); \
    } \
  fprintf (FILE, ";;;END PROLOGUE\n"); \
}

/* Output assembler code to FILE to increment profiler label # LABELNO
   for profiling a function entry.  */

#define FUNCTION_PROFILER(FILE, LABELNO) \
   fprintf (FILE, "\tleax LP%d,a1\n\tjsr mcount\n", (LABELNO));

/* EXIT_IGNORE_STACK should be nonzero if, when returning from a function,
   the stack pointer does not matter.  The value is tested only in
   functions that have frame pointers.
   No definition is equivalent to always zero.  */

#define EXIT_IGNORE_STACK 0

/*--------------------------------------------------------------
	Function Epilogue Definition
----------------------------------------------------------------
   This macro generates the assembly code for function exit,
   on machines that need it.  If FUNCTION_EPILOGUE is not defined
   then individual return instructions are generated for each
   return statement.  Args are same as for FUNCTION_PROLOGUE.
--------------------------------------------------------------*/
#define FUNCTION_EPILOGUE(FILE, SIZE) \
{   register int regno; \
    int offset = 0; \
    char reglist[30]; \
    fprintf (FILE, ";;;EPILOGUE\n"); \
    reglist[0] = '\0'; \
    if ((frame_pointer_needed) && (!regs_ever_live[HARD_U_REGNUM])) { \
	  strcat (reglist, reg_names[HARD_U_REGNUM]); \
	  offset += 2; \
    } \
    for  (regno = HARD_X_REGNUM; regno <= HARD_U_REGNUM; regno++) \
	{ if  (regs_ever_live[regno]) \
	    { \
	      if (reglist[0] != '\0') \
		  strcat (reglist, ","); \
	      strcat (reglist, reg_names[regno]); \
	      offset += 2; \
	    } \
	} \
    if (offset != 0) \
	fprintf (FILE, "\tpuls\t%s\t;restore registers\n", reglist); \
    if ((SIZE) != 0) \
	fprintf (FILE, "\tleas\t%d,s\t; deallocate auto variables\n", \
	    (SIZE)); \
    fprintf (FILE, "\trts\t\t;return from function\n"); \
    fprintf (FILE, ";;;-----------------------------------------\n"); \
    fprintf (FILE, ";;; END EPILOGUE for %s\n", current_function_name); \
    fprintf (FILE, ";;;-----------------------------------------\n"); \
}

/* If the memory address ADDR is relative to the frame pointer,
   correct it to be relative to the stack pointer instead.
   This is for when we don't use a frame pointer.
   ADDR should be a variable name.  */

#define FIX_FRAME_POINTER_ADDRESS(ADDR,DEPTH) ADDR += DEPTH;

/*--------------------------------------------------------------
	Addressing modes,
	and classification of registers for them.
--------------------------------------------------------------*/

#define HAVE_POST_INCREMENT /* */
/* #define HAVE_POST_DECREMENT /* */

#define HAVE_PRE_DECREMENT /* */
/* #define HAVE_PRE_INCREMENT /* */

/* Macros to check register numbers against specific register classes.  */
#define HARD_OK_FOR_BASE_P(REGNO)  A_REGNO_P (REGNO)

/* MC6809 index registers do not allow scaling, */
/* but there is "accumulator-offset" mode. */
#define HARD_OK_FOR_INDEX_P(REGNO) D_REGNO_P (REGNO)

/* These assume that REGNO is a hard or pseudo reg number.
   They give nonzero only if REGNO is a hard reg of the suitable class
   or a pseudo reg currently allocated to a suitable hard reg.
   Since they use reg_renumber, they are safe only once reg_renumber
   has been allocated, which happens in local-alloc.c.  */

#define REGNO_OK_FOR_BASE_P(REGNO) \
    (HARD_OK_FOR_BASE_P (REGNO) \
    || (((unsigned) reg_renumber[REGNO]) \
	&& HARD_OK_FOR_BASE_P ((unsigned) reg_renumber[REGNO])))

#define REGNO_OK_FOR_INDEX_P(REGNO) \
    (HARD_OK_FOR_INDEX_P (REGNO) \
    || (((unsigned) reg_renumber[REGNO]) \
	&& HARD_OK_FOR_INDEX_P ((unsigned) reg_renumber[REGNO])))

/* Maximum number of registers that can appear in a valid memory address */
#define MAX_REGS_PER_ADDRESS 2

/* 1 if X is an rtx for a constant that is a valid address.  */
#define CONSTANT_ADDRESS_P(X) (CONSTANT_P (X))

/* Nonzero if the constant value X is a legitimate general operand.
   It is given that X satisfies CONSTANT_P or is a CONST_DOUBLE.  */

/* Any single-word constant is ok; the only contexts
   allowing general_operand of mode DI or DF are movdi and movdf. */
#define LEGITIMATE_CONSTANT_P(X) (GET_CODE (X) != CONST_DOUBLE)

/* The macros REG_OK_FOR..._P assume that the arg is a REG rtx
   and check its validity for a certain class.
   We have two alternate definitions for each of them.
   The usual definition accepts all pseudo regs; the other rejects
   them unless they have been allocated suitable hard regs.
   The symbol REG_OK_STRICT causes the latter definition to be used.

   Most source files want to accept pseudo regs in the hope that
   they will get allocated to the class that the insn wants them to be in.
   Source files for reload pass need to be strict.
   After reload, it makes no difference, since pseudo regs have
   been eliminated by then.  */

#ifndef REG_OK_STRICT

/* Nonzero if X is a hard reg that can be used as a base reg
   or if it is a pseudo reg.  */
#define REG_OK_FOR_BASE_P(X) \
    ((REGNO(X) >= FIRST_PSEUDO_REGISTER) \
    || HARD_OK_FOR_BASE_P (REGNO (X)))

/* Nonzero if X is a hard reg that can be used as an index
   or if it is a pseudo reg.  */
#define REG_OK_FOR_INDEX_P(X) \
    ((REGNO(X) >= FIRST_PSEUDO_REGISTER) \
    || HARD_OK_FOR_INDEX_P (REGNO (X)))

#else

/* Nonzero if X is a hard reg that can be used as a base reg.  */
#define REG_OK_FOR_BASE_P(X) (REGNO_OK_FOR_BASE_P (REGNO (X)))

/* Nonzero if X is a hard reg that can be used as an index.  */
#define REG_OK_FOR_INDEX_P(X) (REGNO_OK_FOR_INDEX_P (REGNO (X)))

#endif

/*--------------------------------------------------------------
	Test for valid memory addresses
--------------------------------------------------------------*/
/* GO_IF_LEGITIMATE_ADDRESS recognizes an RTL expression
   that is a valid memory address for an instruction.
   The MODE argument is the machine mode for the MEM expression
   that wants to use this address. */

/*--------------------------------------------------------------
   Valid addresses are either direct or indirect (MEM) versions
   of the following forms.
	constant		N
	register		,X
	constant indexed	N,X
	accumulator indexed	D,X
	auto_increment		,X++
	auto_decrement		,--X
--------------------------------------------------------------*/

#define REGISTER_ADDRESS_P(X) \
  (GET_CODE (X) == REG && REG_OK_FOR_BASE_P (X))

#define EXTENDED_ADDRESS_P(X) \
    CONSTANT_ADDRESS_P (X) \

#define LEGITIMATE_BASE_P(X) \
  ((GET_CODE (X) == REG && REG_OK_FOR_BASE_P (X))	\
   || (GET_CODE (X) == SIGN_EXTEND			\
       && GET_CODE (XEXP (X, 0)) == REG			\
       && GET_MODE (XEXP (X, 0)) == HImode		\
       && REG_OK_FOR_BASE_P (XEXP (X, 0))))

#define LEGITIMATE_OFFSET_P(X) \
    (CONSTANT_ADDRESS_P (X) \
    || (GET_CODE (X) == REG && REG_OK_FOR_INDEX_P (X)))

/* 1 if X is the sum of a base register and an offset. */
#define INDEXED_ADDRESS(X) \
   ((GET_CODE (X) == PLUS \
       && LEGITIMATE_BASE_P (XEXP (X, 0)) \
       && LEGITIMATE_OFFSET_P (XEXP (X, 1))) \
   || (GET_CODE (X) == PLUS \
       && LEGITIMATE_BASE_P (XEXP (X, 1)) \
       && LEGITIMATE_OFFSET_P (XEXP (X, 0))))

#define PUSH_POP_ADDRESS_P(X) \
    (((GET_CODE (X) == PRE_DEC) || (GET_CODE (X) == POST_INC)) \
	&& (LEGITIMATE_BASE_P (XEXP (X, 0))))

/* Go to ADDR if X is a valid address. */
#define GO_IF_LEGITIMATE_ADDRESS(MODE, X, ADDR) \
{ \
  if (REGISTER_ADDRESS_P(X)) goto ADDR; \
  if (PUSH_POP_ADDRESS_P (X)) goto ADDR; \
  if (EXTENDED_ADDRESS_P (X)) goto ADDR; \
  if (INDEXED_ADDRESS (X)) goto ADDR; \
  if ((GET_CODE (X) == MEM) && REGISTER_ADDRESS_P(XEXP (X, 0))) goto ADDR; \
  if ((GET_CODE (X) == MEM) && PUSH_POP_ADDRESS_P (XEXP (X, 0))) goto ADDR; \
  if ((GET_CODE (X) == MEM) && EXTENDED_ADDRESS_P (XEXP (X, 0))) goto ADDR; \
  if ((GET_CODE (X) == MEM) && INDEXED_ADDRESS (XEXP (X, 0))) goto ADDR; \
}

/*--------------------------------------------------------------
	Address Fix-up
--------------------------------------------------------------*/
/* Try machine-dependent ways of modifying an illegitimate address
   to be legitimate.  If we find one, return the new, valid address.
   This macro is used in only one place: `memory_address' in explow.c.

   OLDX is the address as it was before break_out_memory_refs was called.
   In some cases it is useful to look at this to decide what needs to be done.

   MODE and WIN are passed so that this macro can use
   GO_IF_LEGITIMATE_ADDRESS.

   It is always safe for this macro to do nothing.
   It exists to recognize opportunities to optimize the output.
   --------*/

#define LEGITIMIZE_ADDRESS(X,OLDX,MODE,WIN) \
{ \
}

/* Go to LABEL if ADDR (a legitimate address expression)
   has an effect that depends on the machine mode it is used for. */

#define GO_IF_MODE_DEPENDENT_ADDRESS(ADDR,LABEL) \
{ if (GET_CODE (ADDR) == POST_INC || GET_CODE (ADDR) == PRE_DEC) \
    goto LABEL; \
}

/*--------------------------------------------------------------
	Cross-Compilation and Floating Point Format
--------------------------------------------------------------*/
/*** TBD ***/

/*--------------------------------------------------------------
	Miscellaneous Parameters
--------------------------------------------------------------*/
/* Specify the machine mode that this machine uses
   for the index in the tablejump instruction.  */
#define CASE_VECTOR_MODE Pmode

/* Define this if the case instruction expects the table
   to contain offsets from the address of the table.
   Do not define this if the table should contain absolute addresses.  */
/* #define CASE_VECTOR_PC_RELATIVE */

/* Define this if the case instruction drops through after the table
   when the index is out of range.  Don't define it if the case insn
   jumps to the default label instead.  */
/* #define CASE_DROPS_THROUGH */

/* Specify the tree operation to be used to convert reals to integers. */
#define IMPLICIT_FIX_EXPR FIX_ROUND_EXPR

/* This is the kind of divide that is easiest to do in the general case.  */
#define EASY_DIV_EXPR TRUNC_DIV_EXPR

/* Define this as 1 if `char' should by default be signed; else as 0.  */
#define DEFAULT_SIGNED_CHAR 1

/* define SCCS_DIRECTIVE if SCCS directives should be ignored */
#define SCCS_DIRECTIVE 1

/* This flag, if defined, says the same insns that convert to a signed fixnum
   also convert validly to an unsigned one.  */
#define FIXUNS_TRUNC_LIKE_FIX_TRUNC

/* Max number of bytes we can move from memory to memory
   in one reasonably fast instruction.  */
#define MOVE_MAX 2

/* Size (bits) of the type "int" on target machine */
/*   (If undefined, default is BITS_PER_WORD).  */
#define INT_TYPE_SIZE (TARGET_SHORT_INT ? 16 : 16)

/* Size (bits) of the type "short" on target machine */
#define SHORT_TYPE_SIZE 16

/* Size (bits) of the type "long" on target machine */
#define LONG_TYPE_SIZE 16

/* Size (bits) of the type "char" on target machine */
#define CHAR_TYPE_SIZE 8

/* Size (bits) of the type "float" on target machine */
#define FLOAT_TYPE_SIZE 32

/* Size (bits) of the type "double" on target machine */
#define DOUBLE_TYPE_SIZE 32

/* Define this if zero-extension is slow
	(more than one real instruction).  */
/*** #define SLOW_ZERO_EXTEND /* */

/* Nonzero if access to memory by bytes is slow and undesirable.  */
#define SLOW_BYTE_ACCESS 0 /* */

/* Define if shifts truncate the shift count
   which implies one can omit a sign-extension or zero-extension
   of a shift count.  */
#define SHIFT_COUNT_TRUNCATED

/* Value is 1 if truncating an integer of INPREC bits to OUTPREC bits
   is done just by pretending it is already truncated.  */
#define TRULY_NOOP_TRUNCATION(OUTPREC, INPREC) 1

/* It is as good to call a constant function address as to
   call an address kept in a register. */
#define NO_FUNCTION_CSE

/* When a prototype says `char' or `short', really pass an `int'.  */
#define PROMOTE_PROTOTYPES /* */

/* Specify the machine mode that pointers have.
   After generation of rtl, the compiler makes no further distinction
   between pointers and any other objects of this machine mode.  */
/*** #define Pmode SImode /* nomal definition */
#define Pmode SImode

/* A function address in a call instruction
   is a byte address (for indexing purposes)
   so give the MEM rtx a byte's mode.  */
#define FUNCTION_MODE HImode

/* Compute the cost of computing a constant rtl expression RTX
   whose rtx-code is CODE.  The body of this macro is a portion
   of a switch statement.  If the code is computed here,
   return it with a return statement.
   Otherwise, break from the switch.  */

#define CONST_COSTS(RTX,CODE) \
 case CONST: \
    /* Constant zero is super cheap due to clr instruction.  */ \
    if (RTX == const0_rtx) return 0;                            \
    if ((unsigned) INTVAL (RTX) < 077) return 1;                \
 case LABEL_REF: \
 case SYMBOL_REF: \
 case CONST_INT: \
   return 3; \
 case CONST_DOUBLE: \
   return 4;

/* Check a `double' value for validity for a particular machine mode.  */

#define CHECK_FLOAT_VALUE(mode, d) \
  if ((mode) == SFmode) \
    { \
      if ((d) > 1.7014117331926443e+38) \
	{ error ("magnitude of constant too large for `float'"); \
	  (d) = 1.7014117331926443e+38; } \
      else if ((d) < -1.7014117331926443e+38) \
	{ error ("magnitude of constant too large for `float'"); \
	  (d) = -1.7014117331926443e+38; } \
      else if (((d) > 0) && ((d) < 2.9387358770557188e-39)) \
	{ warning ("`float' constant truncated to zero"); \
	  (d) = 0.0; } \
      else if (((d) < 0) && ((d) > -2.9387358770557188e-39)) \
	{ warning ("`float' constant truncated to zero"); \
	  (d) = 0.0; } \
    }

/*--------------------------------------------------------------
	machine-dependent
--------------------------------------------------------------*/
/* Tell final.c how to eliminate redundant test instructions.  */

/* Here we define machine-dependent flags and fields in cc_status
   (see `conditions.h').  */

/* Store in cc_status the expressions
   that the condition codes will describe
   after execution of an instruction whose pattern is EXP.
   Do not alter them if the instruction would not alter the cc's.  */

/* On the 6809, most the insns to store in an address register
   fail to set the cc's.  However, in some cases these instructions
   can make it possibly invalid to use the saved cc's.  In those
   cases we clear out some or all of the saved cc's so they won't be used.  */

#define NOTICE_UPDATE_CC(EXP, INSN) \
  notice_update_cc((EXP), (INSN))

/*--------------------------------------------------------------
	ASSEMBLER FORMAT
--------------------------------------------------------------*/
/* Output at beginning of assembler file.  */
#define ASM_FILE_START(FILE) \
    fprintf (FILE, ";;;-----------------------------------------\n"); \
    fprintf (FILE, ";;; Start MC6809 gcc assembly output\n"); \
    fprintf (FILE, ";;; gcc compiler compiled on TBD\n"); \
    print_options (FILE); \
    fprintf (FILE, ";;;-----------------------------------------\n"); \
    fprintf (FILE, "\textern ___mulsi3\n"); \
    fprintf (FILE, "\textern ___divsi3\n"); \
    fprintf (FILE, "\textern ___modsi3\n");

#define ASM_FILE_END(FILE) \
    fprintf (FILE, "\tend\n")

/* Output to assembler file text saying following lines
   may contain character constants, extra white space, comments, etc.  */
#define ASM_APP_ON "; Begin inline assembler code\n"

/* Output to assembler file text saying following lines
   no longer contain unusual constructs.  */
#define ASM_APP_OFF "; End of inline assembler code\n"

/* Output before read-only data.  */
#define TEXT_SECTION_ASM_OP ("\t.text")

/* Output before writable data.  */
#define DATA_SECTION_ASM_OP ("\t.data") 

/* Output before uninitialized data.  */
#define BSS_SECTION_ASM_OP ("\t.bss") 

#define EXTRA_SECTIONS in_bss

#define EXTRA_SECTION_FUNCTIONS \
void \
bss_section () \
{ \
  if (in_section != in_bss) \
    { \
      fprintf (asm_out_file, "%s\n", BSS_SECTION_ASM_OP); \
      in_section = in_bss; \
    } \
}

/* This is how to output an assembler line
   that says to advance the location counter
   to a multiple of 2**LOG bytes.  */

#define ASM_OUTPUT_ALIGN(FILE,LOG) \
  if ((LOG) > 1) \
    fprintf (FILE, "\t.align %d\n", 1 << (LOG))

/* How to refer to registers in assembler output.
   This sequence is indexed by compiler's hard-register-number (see above).  */

#define REGISTER_NAMES \
{"d", "x", "y", "u", "s", "p","-", "-", \
 "a", "b", "cc","dp",}

/* This is BSD, so it wants DBX format.  */

#define DBX_DEBUGGING_INFO

/* How to renumber registers for dbx and gdb. */

#define DBX_REGISTER_NUMBER(REGNO) (REGNO)

/* Do not break .stabs pseudos into continuations.  */

#define DBX_CONTIN_LENGTH 0

/* This is the char to use for continuation (in case we need to turn
   continuation back on).  */

#define DBX_CONTIN_CHAR '?'

/* Don't use the `xsfoo;' construct in DBX output; this system
   doesn't support it.  */

#define DBX_NO_XREFS

/* This is how to output the definition of a user-level label named NAME,
   such as the label on a static function or variable NAME.  */

#define ASM_OUTPUT_LABEL(FILE,NAME) \
  {assemble_name (FILE, NAME); \
  fputs (":\n", FILE);}

/* This is how to output a command to make the user-level label
    named NAME defined for reference from other files.  */

#define ASM_GLOBALIZE_LABEL(FILE,NAME) \
  {fputs ("\tglobal ", FILE); \
  assemble_name (FILE, NAME); \
  fputs ("\n", FILE);}

/* This is how to output a reference to a user label named NAME. */
#define ASM_OUTPUT_LABELREF(FILE,NAME) \
  fprintf (FILE, "_%s", NAME)

/* output external reference -- tej */
#define ASM_OUTPUT_EXTERNAL(FILE,DECL,NAME) \
  {fputs ("\textern\t", FILE); \
  assemble_name (FILE, NAME); \
  fputs ("\n", FILE);}

/* This is how to output an internal numbered label where
   PREFIX is the class of label and NUM is the number within the class.  */

#define ASM_OUTPUT_INTERNAL_LABEL(FILE,PREFIX,NUM) \
  fprintf (FILE, "%s%d:\n", PREFIX, NUM)

#define ASM_OUTPUT_CASE_LABEL(FILE,PREFIX,NUM,TABLE) \
  ASM_OUTPUT_ALIGN (FILE, 1); \
  ASM_OUTPUT_INTERNAL_LABEL (FILE, PREFIX, NUM)

#define ASM_OUTPUT_CASE_END(FILE,NUM,TABLE) \
  ASM_OUTPUT_ALIGN (FILE, 1)

/* This is how to store into the string LABEL
   the symbol_ref name of an internal numbered label where
   PREFIX is the class of label and NUM is the number within the class.
   This is suitable for output with `assemble_name'.  */

#define ASM_GENERATE_INTERNAL_LABEL(LABEL,PREFIX,NUM) \
  sprintf (LABEL, "*%s%d", PREFIX, NUM)

/* This is how to output an assembler line defining a `double' constant.  */

#define ASM_OUTPUT_DOUBLE(FILE,VALUE) \
  fprintf (FILE, "\tdd %.17#g\n", (VALUE))

/* This is how to output an assembler line defining a `float' constant.  */

#define ASM_OUTPUT_FLOAT(FILE,VALUE) \
  fprintf (FILE, "\tdf %.9#g\n", (VALUE))

/* This is how to output an assembler line defining an `int' constant.  */

#define ASM_OUTPUT_INT(FILE,VALUE) \
( fprintf (FILE, "\tdw "), \
  output_addr_const (FILE, (VALUE)), \
  fprintf (FILE, "\n"))

/* Likewise for `char' and `short' constants.  */

#define ASM_OUTPUT_SHORT(FILE,VALUE) \
( fprintf (FILE, "\tdw "), \
  output_addr_const (FILE, (VALUE)), \
  fprintf (FILE, "\n"))

#define ASM_OUTPUT_CHAR(FILE,VALUE) \
( fprintf (FILE, "\tdb "), \
  output_addr_const (FILE, (VALUE)), \
  fprintf (FILE, "\n"))

/* This is how to output an assembler line for a numeric constant byte.  */

#define ASM_OUTPUT_BYTE(FILE,VALUE) \
  fprintf (FILE, "\tdb %#x\n", (VALUE))

/* This is how to output a string */

#define ASM_OUTPUT_ASCII(FILE,STR,SIZE) do { \
  int i; \
  fprintf (FILE, "\t.ascii \""); \
  for (i = 0; i < (SIZE); i++) { \
      register int c = (STR)[i] & 0377; \
      if (c >= ' ' && c < 0177 && c != '\\' && c != '"') \
	  putc (c, FILE); \
      else { \
	  switch (c) { \
	  case TARGET_CR: \
	    fputs ("\\r", FILE); \
	    break; \
	  case TARGET_NEWLINE: \
	    fputs ("\\n", FILE); \
	    break; \
	  case TARGET_TAB: \
	    fputs ("\\t", FILE); \
	    break; \
	  case TARGET_FF: \
	    fputs ("\\f", FILE); \
	    break; \
	  case 0: \
	    fputs ("\\0", FILE); \
	    break; \
	  default: \
	    fprintf (FILE, "\\%03o", c); \
	    break; \
	  } \
      } \
    } \
  fprintf (FILE, "\"\n");} while (0)

/* This is how to output an insn to push a register on the stack.
   It need not be very fast code.  */

#define ASM_OUTPUT_REG_PUSH(FILE,REGNO) \
   fprintf (FILE, "\tpshs\t%s\n", \
	    reg_names[REGNO])

/* This is how to output an insn to pop a register from the stack.
   It need not be very fast code.  */

#define ASM_OUTPUT_REG_POP(FILE,REGNO) \
   fprintf (FILE, "\tpuls\t%s\n", \
	    reg_names[REGNO])

/* This is how to output an element of a case-vector that is absolute. */

#define ASM_OUTPUT_ADDR_VEC_ELT(FILE, VALUE) \
  fprintf (FILE, "\tdw L%d\n", VALUE)

/* This is how to output an element of a case-vector that is relative.  
*/

#define ASM_OUTPUT_ADDR_DIFF_ELT(FILE, VALUE, REL) \
  fprintf (FILE, "\tdw L%d-L%d\n", VALUE, REL)

/* This is how to output an assembler line
   that says to advance the location counter by SIZE bytes.  */

#define ASM_OUTPUT_SKIP(FILE,SIZE) \
  fprintf (FILE, "\trmb\t%d\t;reserve space\n", (SIZE))

/* This says how to output an assembler line
   to define a global common symbol.  */

#define ASM_OUTPUT_COMMON(FILE, NAME, SIZE, ROUNDED) \
  do {bss_section (); \
  fputs ("\tglobal\t", FILE); \
  assemble_name ((FILE), (NAME)); \
  fputs ("\n", FILE); \
  assemble_name ((FILE), (NAME)); \
  fprintf ((FILE), ":\trmb\t%d\n", (ROUNDED));} while(0)

/* This says how to output an assembler line
   to define a local common symbol.  */

#define ASM_OUTPUT_LOCAL(FILE, NAME, SIZE, ROUNDED) \
do {bss_section (); \
  assemble_name ((FILE), (NAME)); \
  fprintf ((FILE), ":\trmb\t%d\n", (ROUNDED));} while(0)

/* Store in OUTPUT a string (made with alloca) containing
   an assembler-name for a local static variable named NAME.
   LABELNO is an integer which is different for each call.  */

#define ASM_FORMAT_PRIVATE_NAME(OUTPUT, NAME, LABELNO) \
( (OUTPUT) = (char *) alloca (strlen ((NAME)) + 10), \
  sprintf ((OUTPUT), "%s.%d", (NAME), (LABELNO)))

/* Define the parentheses used to group arithmetic operations
   in assembler code.  */

#define ASM_OPEN_PAREN "("
#define ASM_CLOSE_PAREN ")"

/* Define results of standard character escape sequences.  */
#define TARGET_BELL 007
#define TARGET_BS 010
#define TARGET_TAB 011
#define TARGET_NEWLINE 012
#define TARGET_VT 013
#define TARGET_FF 014
#define TARGET_CR 015

/* Print an instruction operand X on file FILE.
   CODE is the code from the %-spec for printing this operand.
   If `%z3' was used to print operand 3, then CODE is 'z'. */

#define PRINT_OPERAND(FILE, X, CODE) \
    print_operand (FILE, X, CODE)

/* Print a memory operand whose address is X, on file FILE. */
#define PRINT_OPERAND_ADDRESS(FILE, ADDR) \
    print_operand_address (FILE, ADDR)
