This is Info file binutils.i, produced by Makeinfo-1.50 from the input
file ./binutils.texi.

START-INFO-DIR-ENTRY
* Binutils: (binutils).		The GNU binary utilities "ar", "ld", "objdump",
				"nm", "size", "strip", and "ranlib".
END-INFO-DIR-ENTRY

   Copyright (C) 1991 Free Software Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided also
that the entire resulting derived work is distributed under the terms
of a permission notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions.


File: binutils.i,  Node: Top,  Next: ar,  Prev: (dir),  Up: (dir)

Introduction
************

   This brief manual contains preliminary documentation for the GNU
binary utilities (collectively version 1.97):

* Menu:

* ar::                          Create, modify, and extract from archives
* ld:(ld)Overview.              Combine object and archive files
* nm::                          List symbols from object files
* objdump::                     Display information from object files
* ranlib::                      Generate index to archive contents
* size::                        List section sizes and total size
* strip::                       Discard symbols
* Index::


File: binutils.i,  Node: ar,  Next: nm,  Prev: Top,  Up: Top

ar
**

       ar [-]PMOD [ MEMBERNAME ] ARCHIVE FILES...
       ar -M [ <mri-script ]

   The GNU `ar' program creates, modifies, and extracts from archives. 
An "archive" is a single file holding a collection of other files in a
structure that makes it possible to retrieve the original individual
files (called "members" of the archive).

   The original files' contents, mode (permissions), timestamp, owner,
and group are preserved in the archive, and may be reconstituted on
extraction.

   GNU `ar' can maintain archives whose members have names of any
length; however, depending on how `ar' is configured on your system, a
limit on member-name length may be imposed (for compatibility with
archive formats maintained with other tools).  If it exists, the limit
is often 15 characters (typical of formats related to a.out) or 16
characters (typical of formats related to coff).

   `ar' is considered a binary utility because archives of this sort
are most often used as "libraries" holding commonly needed subroutines.

   `ar' will create an index to the symbols defined in relocatable
object modules in the archive when you specify the modifier `s'. Once
created, this index is updated in the archive whenever `ar' makes a
change to its contents (save for the `q' update operation). An archive
with such an index speeds up linking to the library, and allows
routines in the library to call each other without regard to their
placement in the archive.

   You may use `nm -s' or `nm +print-armap' to list this index table. 
If an archive lacks the table, another form of `ar' called `ranlib' can
be used to add just the table.

   GNU `ar' is designed to be compatible with two different facilities.
 You can control its activity using command-line options, like the
different varieties of `ar' on Unix systems; or, if you specify the
single command-line option `-M', you can control it with a script
supplied via standard input, like the MRI "librarian" program.

* Menu:

* ar-cmdline::                  Controlling `ar' on the command line
* ar-scripts::                  Controlling `ar' with a script


File: binutils.i,  Node: ar-cmdline,  Next: ar-scripts,  Prev: ar,  Up: ar

Controlling `ar' on the command line
====================================

       ar [-]PMOD [ MEMBERNAME ] ARCHIVE FILES...

   When you use `ar' in the Unix style, `ar' insists on at least two
arguments to execute: one keyletter specifying the *operation*
(optionally accompanied by other keyletters specifying *modifiers*),
and the archive name to act on.

   Most operations can also accept further FILES arguments, specifying
particular files to operate on.

   GNU `ar' allows you to mix the operation code P and modifier flags
MOD in any order, within the first command-line argument.

   If you wish, you may begin the first command-line argument with a
dash.

   The P keyletter specifies what operation to execute; it may be any
of the following, but you must specify only one of them:

`d'
     *Delete* modules from the archive.  Specify the names of modules to
     be deleted as FILES; the archive is untouched if you specify no
     files to delete.

     If you specify the `v' modifier, `ar' will list each module as it
     is deleted.

`m'
     Use this operation to *move* members in an archive.

     The ordering of members in an archive can make a difference in how
     programs are linked using the library, if a symbol is defined in
     more than one member.

     If no modifiers are used with `m', any members you name in the
     FILES arguments are moved to the *end* of the archive; you can use
     the `a', `b', or `i' modifiers to move them to a specified place
     instead.

`p'
     *Print* the specified members of the archive, to the standard
     output file.  If the `v' modifier is specified, show the member
     name before copying its contents to standard output.

     If you specify no FILES, all the files in the archive are printed.

`q'
     *Quick append*; add FILES to the end of ARCHIVE, without checking
     for replacement.

     The modifiers `a', `b', and `i' do *not* affect this operation;
     new members are always placed at the end of the archive.

     The modifier `v' makes `ar' list each file as it is appended.

     Since the point of this operation is speed, the archive's symbol
     table index is not updated, even if it already existed; you can
     use `ar s' or `ranlib' explicitly to update the symbol table index.

`r'
     Insert FILES into ARCHIVE (with *replacement*). This operation
     differs from `q' in that any previously existing members are
     deleted if their names match those being added.

     If one of the files named in FILES doesn't exist, `ar' displays an
     error message, and leaves undisturbed any existing members of the
     archive matching that name.

     By default, new members are added at the end of the file; but you
     may use one of the modifiers `a', `b', or `i' to request placement
     relative to some existing member.

     The modifier `v' used with this operation elicits a line of output
     for each file inserted, along with one of the letters `a' or `r'
     to indicate whether the file was appended (no old member deleted)
     or replaced.

`t'
     Display a *table* listing the contents of ARCHIVE, or those of the
     files listed in FILES that are present in the archive.  Normally
     only the member name is shown; if you also want to see the modes
     (permissions), timestamp, owner, group, and size, you can request
     that by also specifying the `v' modifier.

     If you do not specify any FILES, all files in the archive are
     listed.

     If there is more than one file with the same name (say, `fie') in
     an archive (say `b.a'), `ar t b.a fie' will list only the first
     instance; to see them all, you must ask for a complete listing--in
     our example, `ar t b.a'.

`x'
     *Extract* members (named FILES) from the archive.  You can use the
     `v' modifier with this operation, to request that `ar' list each
     name as it extracts it.

     If you do not specify any FILES, all files in the archive are
     extracted.

   A number of modifiers (MOD) may immediately follow the P keyletter,
to specify variations on an operation's behavior:

`a'
     Add new files *after* an existing member of the archive.  If you
     use the modifier `a', the name of an existing archive member must
     be present as the MEMBERNAME argument, before the ARCHIVE
     specification.

`b'
     Add new files *before* an existing member of the archive.  If you
     use the modifier `b', the name of an existing archive member must
     be present as the MEMBERNAME argument, before the ARCHIVE
     specification.  (same as `i').

`c'
     *Create* the archive.  The specified ARCHIVE is always created if
     it didn't exist, when you request an update.  But a warning is
     issued unless you specify in advance that you expect to create it,
     by using this modifier.

`i'
     Insert new files *before* an existing member of the archive.  If
     you use the modifier `i', the name of an existing archive member
     must be present as the MEMBERNAME argument, before the ARCHIVE
     specification.  (same as `b').

`l'
     This modifier is accepted but not used.

`o'
     Preserve the *original* dates of members when extracting them.  If
     you do not specify this modifier, files extracted from the archive
     will be stamped with the time of extraction.

`s'
     Write an object-file index into the archive, or update an existing
     one, even if no other change is made to the archive.  You may use
     this modifier flag either with any operation, or alone.  Running
     `ar s' on an archive is equivalent to running `ranlib' on it.

`u'
     Normally, `ar r'... inserts all files listed into the archive.  If
     you would like to insert *only* those of the files you list that
     are newer than existing members of the same names, use this
     modifier.  The `u' modifier is allowed only for the operation `r'
     (replace).  In particular, the combination `qu' is not allowed,
     since checking the timestamps would lose any speed advantage from
     the operation `q'.

`v'
     This modifier requests the *verbose* version of an operation.  Many
     operations display additional information, such as filenames
     processed, when the modifier `v' is appended.


File: binutils.i,  Node: ar-scripts,  Prev: ar-cmdline,  Up: ar

Controlling `ar' with a script
==============================

     ar -M [ <SCRIPT ]

   If you use the single command-line option `-M' with `ar', you can
control its operation with a rudimentary command language.  This form
of `ar' will operate interactively if standard input is coming directly
from a terminal.  During interactive use, `ar' prompts for input (the
prompt is `AR >'), and continues executing even after errors.  If you
redirect standard input to a script file, no prompts are issued, and
`ar' will abandon execution (with a nonzero exit code) on any error.

   The `ar' command language is *not* designed to be equivalent to the
command-line options; in fact, it provides somewhat less control over
archives.  The only purpose of the command language is to ease the
transition to GNU `ar' for developers who already have scripts written
for the MRI "librarian" program.

   The syntax for the `ar' command language is straightforward:
   * commands are recognized in upper or lower case; for example, `LIST'
     is the same as `list'.  In the following descriptions, commands are
     shown in upper case for clarity.

   * a single command may appear on each line; it is the first word on
     the line.

   * empty lines are allowed, and have no effect.

   * comments are allowed; text after either of the characters `*' or
     `;' is ignored.

   * Whenever you use a list of names as part of the argument to an `ar'
     command, you can separate the individual names with either commas
     or blanks.  Commas are shown in the explanations below, for
     clarity.

   * `+' is used as a line continuation character; if `+' appears at
     the end of a line, the text on the following line is considered
     part of the current command.

   Here are the commands you can use in `ar' scripts, or when using
`ar' interactively.  Three of them have special significance:

   `OPEN' or `CREATE' specify a "current archive", which is a temporary
file required for most of the other commands.

   `SAVE' commits the changes so far specified by the script.  Prior to
`SAVE', commands affect only the temporary copy of the current archive.

`ADDLIB ARCHIVE'
`ADDLIB ARCHIVE (MODULE, MODULE, ... MODULE)'
     Add all the contents of ARCHIVE (or, if specified, each named
     MODULE from ARCHIVE) to the current archive.

     Requires prior use of `OPEN' or `CREATE'.

`ADDMOD FILE, FILE, ... FILE'
     Add each named FILE as a module in the current archive.

     Requires prior use of `OPEN' or `CREATE'.

`CLEAR'
     Discard the contents of the current archive, cancelling the effect
     of any operations since the last `SAVE'.  May be executed (with no
     effect) even if  no current archive is specified.

`CREATE ARCHIVE'
     Creates an archive, and makes it the current archive (required for
     many other commands).  The new archive is created with a temporary
     name; it is not actually saved as ARCHIVE until you use `SAVE'.
     You can overwrite existing archives; similarly, the contents of any
     existing file named ARCHIVE will not be destroyed until `SAVE'.

`DELETE MODULE, MODULE, ... MODULE'
     Delete each listed MODULE from the current archive; equivalent to
     `ar -d ARCHIVE MODULE ... MODULE'.

     Requires prior use of `OPEN' or `CREATE'.

`DIRECTORY ARCHIVE (MODULE, ... MODULE)'
`DIRECTORY ARCHIVE (MODULE, ... MODULE) OUTPUTFILE'
     List each named MODULE present in ARCHIVE.  The separate command
     `VERBOSE' specifies the form of the output: when verbose output is
     off, output is like that of `ar -t ARCHIVE MODULE...'.  When
     verbose output is on, the listing is like `ar -tv ARCHIVE
     MODULE...'.

     Output normally goes to the standard output stream; however, if you
     specify OUTPUTFILE as a final argument, `ar' directs the output to
     that file.

`END'
     Exit from `ar', with a `0' exit code to indicate successful
     completion.  This command does not save the output file; if you
     have changed the current archive since the last `SAVE' command,
     those changes are lost.

`EXTRACT MODULE, MODULE, ... MODULE'
     Extract each named MODULE from the current archive, writing them
     into the current directory as separate files.  Equivalent to `ar -x
     ARCHIVE MODULE...'.

     Requires prior use of `OPEN' or `CREATE'.

`LIST'
     Display full contents of the current archive, in "verbose" style
     regardless of the state of `VERBOSE'.  The effect is like `ar tv
     ARCHIVE').  (This single command is a GNU `ld' enhancement, rather
     than present for MRI compatibility.)

     Requires prior use of `OPEN' or `CREATE'.

`OPEN ARCHIVE'
     Opens an existing archive for use as the current archive (required
     for many other commands).  Any changes as the result of subsequent
     commands will not actually affect ARCHIVE until you next use
     `SAVE'.

`REPLACE MODULE, MODULE, ... MODULE'
     In the current archive, replace each existing MODULE (named in the
     `REPLACE' arguments) from files in the current working directory.
     To execute this command without errors, both the file, and the
     module in the current archive, must exist.

     Requires prior use of `OPEN' or `CREATE'.

`VERBOSE'
     Toggle an internal flag governing the output from `DIRECTORY'.
     When the flag is on, `DIRECTORY' output matches output from `ar
     -tv ...'.

`SAVE'
     Commit your changes to the current archive, and actually save it
     as a file with the name specified in the last `CREATE' or `OPEN'
     command.

     Requires prior use of `OPEN' or `CREATE'.


File: binutils.i,  Node: nm,  Next: objdump,  Prev: ar,  Up: Top

nm
**

       nm [ -a | +debug-syms ]  [ -g | +extern-only ]
           [ -s | +print-armap ]  [ -o | +print-file-name ]
           [ -n | +numeric-sort ]  [ -p | +no-sort ]
           [ -r | +reverse-sort ]  [ -u | +undefined-only ]
           [ +target BFDNAME ]
           [ OBJFILES... ]

   GNU `nm' will list the symbols from object files OBJFILES.

   The long and short forms of options, shown here as alternatives, are
equivalent.

`OBJFILES...'
     Object files whose symbols are to be listed.  If no object files
     are listed as arguments, `nm' assumes `a.out'.

`-a'
`+debug-syms'
     Display debugger-only symbols; normally these are not listed.

`-g'
`+extern-only'
     Display only external symbols.

`-p'
`+no-sort'
     Don't bother to sort the symbols in any order; just print them in
     the order encountered.

`-n'
`+numeric-sort'
     Sort symbols numerically by their addresses, not alphabetically by
     their names.

`-s'
`+print-armap'
     When listing symbols from archive members, include the index: a
     mapping (stored in the archive by `ar' or `ranlib') of what modules
     contain definitions for what names.

`-o'
`+print-file-name'
     Precede each symbol by the name of the input file where it was
     found, rather than identifying the input file once only before all
     of its symbols.

`-r'
`+reverse-sort'
     Reverse the sense of the sort (whether numeric or alphabetic); let
     the last come first.

`+target BFDNAME'
     Specify an object code format other than your system's default
     format. *Note objdump::, for information on listing available
     formats.

`-u'
`+undefined-only'
     Display only undefined symbols (those external to each object
     file).


File: binutils.i,  Node: objdump,  Next: ranlib,  Prev: nm,  Up: Top

objdump
*******

       objdump [ -a ]  [ -b BFDNAME ]  [ -d ]  [ -f ]
               [ -h | --header ]  [ -i ]  [ -j SECTION ]  [ -l ]
               [ -m MACHINE ]  [ -r | --reloc ]  [ -s ]
               [ --stabs ]  [ -t | --syms ]  [ -x ]
               OBJFILES...

   `objdump' displays information about one or more object files. The
options control what particular information to display.  This
information is mostly useful to programmers who are working on the
compilation tools, as opposed to programmers who just want their
program to compile and work.

   The long and short forms of options, shown here as alternatives, are
equivalent.

`OBJFILES...'
     The object files to be examined.  When you specify archives,
     `objdump' shows information on each of the member object files.

`-a'
     If any files from OBJFILES are archives, display the archive
     header information (in a format similar to `ls -l').  Besides the
     information you could list with `ar tv', `objdump -a' shows the
     object file format of each archive member.

`-b BFDNAME'
     You can specify a particular object-code format for your object
     files as BFDNAME.  This may not be necessary; OBJDUMP can
     automatically recognize many formats.  For example,
          objdump -b oasys -m vax -h fu.o

     Displays summary information from the section headers (`-h') of
     `fu.o', which is explicitly identified (`-m') as a Vax object file
     in the format produced by Oasys compilers.  You can list the
     formats available with the `-i' option.

`-d'
     Disassemble.  Display the assembler mnemonics for the machine
     instructions from OBJFILES.

`-f'
     File header.  Display summary information from the overall header
     of each file in OBJFILES.

`-h'
`--header'
     Header.  Display summary information from the section headers of
     the object file.

`-i'
     Display a list showing all architectures and object formats
     available for specification with `-b' or `-m'.

`-j NAME'
     Display information only for section NAME

`-l'
     Label the display (using debugging information) with the source
     filename and line numbers corresponding to the object code shown.

`-m MACHINE'
     Specify the object files OBJFILES are for architecture MACHINE. 
     You can list available architectures using the `-i' option.

`-r'
`--reloc'
     Relocation.  Print the relocation entries of the file.

`-s'
     Display the full contents of any sections requested.

`--stabs'
     Display the full contents of any sections requested.  Display the
     contents of the .stab and .stab.index and .stab.excl sections from
     an ELF file.  This is only useful on systems (such as Solaris 2.0)
     in which `.stab' debugging symbol-table entries are carried in an
     ELF section.  In most other file formats, debugging symbol-table
     entries are interleaved with linkage symbols, and are visible in
     the `--syms' output.

`-t'
`--syms'
     Symbol Table.  Print the symbol table entries of the file. This is
     similar to the information provided by the `nm' program.

`-x'
     Display all available header information, including the symbol
     table and relocation entries.  Using `-x' is equivalent to
     specifying all of `-a -f -h -r -t'.


File: binutils.i,  Node: ranlib,  Next: size,  Prev: objdump,  Up: Top

ranlib
******

       ranlib ARCHIVE

   `ranlib' generates an index to the contents of an archive, and
stores it in the archive.  The index lists each symbol defined by a
member of an archive that is a relocatable object file.

   You may use `nm -s' or `nm +print-armap' to list this index.

   An archive with such an index speeds up linking to the library, and
allows routines in the library to call each other without regard to
their placement in the archive.

   The GNU `ranlib' program is another form of GNU `ar'; running
`ranlib' is completely equivalent to executing `ar -s'. *Note ar::.


File: binutils.i,  Node: size,  Next: strip,  Prev: ranlib,  Up: Top

size
****

       size [ -A | -B | +format COMPATIBILITY ]
            [ +help ]  [ -d | -o | -x | +radix NUMBER ]
            [ +target BFDNAME ]  [ -V | +version ]
            OBJFILES...

   The GNU `size' utility lists the section sizes--and the total
size--for each of the object files OBJFILES in its argument list. By
default, one line of output is generated for each object file or each
module in an archive.

   The command line options have the following meanings:
`OBJFILES...'
     The object files to be examined.

`-A'
`-B'
`+format COMPATIBILITY'
     Using one of these options, you can choose whether the output from
     GNU `size' resembles output from System V `size' (using `-A', or
     `+format sysv'), or Berkeley `size' (using `-B', or `+format
     berkeley').  The default is the one-line format similar to
     Berkeley's.

     Here is an example of the Berkeley (default) format of output from
     `size':
           eg$  size +format Berkeley ranlib size
          text    data    bss     dec     hex     filename
          294880  81920   11592   388392  5ed28   ranlib
          294880  81920   11888   388688  5ee50   size

     This is the same data, but displayed closer to System V
     conventions:

           eg$  size +format SysV ranlib size
          ranlib  :
          section         size         addr
          .text         294880         8192
          .data          81920       303104
          .bss           11592       385024
          Total         388392
          
          
          size  :
          section         size         addr
          .text         294880         8192
          .data          81920       303104
          .bss           11888       385024
          Total         388688

`+help'
     Show a summary of acceptable arguments and options.

`-d'
`-o'
`-x'
`+radix NUMBER'
     Using one of these options, you can control whether the size of
     each section is given in decimal (`-d', or `+radix 10'); octal
     (`-o', or `+radix 8'); or hexadecimal (`-x', or `+radix 16').  In
     `+radix NUMBER', only the three values (8, 10, 16) are supported. 
     The total size is always given in two radices; decimal and
     hexadecimal for `-d' or `-x' output, or octal and hexadecimal if
     you're using `-o'.

`+target BFDNAME'
     You can specify a particular object-code format for OBJFILES as
     BFDNAME.  This may not be necessary; SIZE can automatically
     recognize many formats.  *Note objdump::, for information on
     listing available formats.

`-V'
`+version'
     Display version number information on `size' itself.


File: binutils.i,  Node: strip,  Next: Index,  Prev: size,  Up: Top

strip
*****

       strip [ -v ] OBJFILES...

   GNU `strip' will discard all symbols from object files OBJFILES. 
The list of object files may include archives.

   `strip' will not execute unless at least one object file is listed.

     *WARNING:* `strip' modifies the files named in its argument,
     rather than writing modified copies under different names.

`-v'
     Verbose operation: list all object files modified.  In the case of
     archives, `strip -v' will list all members of the archive.


File: binutils.i,  Node: Index,  Prev: strip,  Up: Top

Index
*****

* Menu:

* .stab:                                objdump.
* ar compatibility:                     ar.
* a.out:                                nm.
* all header information, object file:  objdump.
* ar:                                   ar.
* architecture:                         objdump.
* architectures available:              objdump.
* archive contents:                     ranlib.
* archive headers:                      objdump.
* archives:                             ar.
* collections of files:                 ar.
* compatibility, ar:                    ar.
* contents of archive:                  ar-cmdline.
* creating archives:                    ar-cmdline.
* dates in archive:                     ar-cmdline.
* debug symbols:                        objdump.
* debugging symbols:                    nm.
* deleting from archive:                ar-cmdline.
* disassembling object code:            objdump.
* discarding symbols:                   strip.
* ELF object file format:               objdump.
* external symbols:                     nm.
* external symbols:                     nm.
* extract from archive:                 ar-cmdline.
* file name:                            nm.
* header information, all:              objdump.
* input file name:                      nm.
* libraries:                            ar.
* machine instructions:                 objdump.
* moving in archive:                    ar-cmdline.
* MRI compatibility, ar:                ar-scripts.
* name duplication in archive:          ar-cmdline.
* name length:                          ar.
* nm:                                   nm.
* objdump:                              objdump.
* object code format:                   objdump.
* object code format:                   size.
* object code format:                   nm.
* object file header:                   objdump.
* object file information:              objdump.
* object file sections:                 objdump.
* object formats available:             objdump.
* operations on archive:                ar-cmdline.
* printing from archive:                ar-cmdline.
* quick append to archive:              ar-cmdline.
* radix for section sizes:              size.
* ranlib:                               ranlib.
* relative placement in archive:        ar-cmdline.
* relocation entries, in object file:   objdump.
* removing symbols:                     strip.
* repeated names in archive:            ar-cmdline.
* replacement in archive:               ar-cmdline.
* scripts, ar:                          ar-scripts.
* section headers:                      objdump.
* section information:                  objdump.
* section sizes:                        size.
* sections, full contents:              objdump.
* size:                                 size.
* size display format:                  size.
* size number format:                   size.
* sorting symbols:                      nm.
* source file name:                     nm.
* source filenames for object files:    objdump.
* stab:                                 objdump.
* strip:                                strip.
* symbol index:                         ranlib.
* symbol index:                         ar.
* symbol index, listing:                nm.
* symbol table entries, printing:       objdump.
* symbols:                              nm.
* symbols, discarding:                  strip.
* undefined symbols:                    nm.
* Unix compatibility, ar:               ar-cmdline.
* updating an archive:                  ar-cmdline.
* version:                              Top.
* writing archive index:                ar-cmdline.



Tag Table:
Node: Top875
Node: ar1559
Node: ar-cmdline3738
Node: ar-scripts10081
Node: nm15759
Node: objdump17558
Node: ranlib20919
Node: size21593
Node: strip24287
Node: Index24866

End Tag Table
