This is Info file ld.i, produced by Makeinfo-1.50 from the input file
ld.texinfo.

START-INFO-DIR-ENTRY
* Ld: (ld).			The GNU linker.
END-INFO-DIR-ENTRY

   This file documents the GNU linker LD.

   Copyright (C) 1991, 1992 Free Software Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided also
that the entire resulting derived work is distributed under the terms
of a permission notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions.


File: ld.i,  Node: Top,  Next: Overview,  Prev: (DIR),  Up: (DIR)

Using ld
********

   This file documents the GNU linker ld.

* Menu:

* Overview::                    Overview
* Invocation::                  Invocation
* Commands::                    Command Language
* H8/300::                      ld and the H8/300
* MRI::                         MRI Compatible Script Files
* Index::                       Index


File: ld.i,  Node: Overview,  Next: Invocation,  Prev: Top,  Up: Top

Overview
********

   `ld' combines a number of object and archive files, relocates their
data and ties up symbol references. Often the last step in building a
new compiled program to run is a call to `ld'.

   `ld' accepts Linker Command Language files written in a superset of
AT&T's Link Editor Command Language syntax, to provide explicit and
total control over the linking process.

   Aside from its flexibility, the GNU linker is more helpful than other
linkers in providing diagnostic information.  Many linkers abandon
execution immediately upon encountering an error; whenever possible,
`ld' continues executing, allowing you to identify other errors (or, in
some cases, to get an output file in spite of the error).


File: ld.i,  Node: Invocation,  Next: Commands,  Prev: Overview,  Up: Top

Invocation
**********

   The GNU linker `ld' is meant to cover a broad range of situations,
and to be as compatible as possible with other linkers.  As a result,
you have many choices to control its behavior.

   Here is a sketch of the options you can use on the `ld' command line:

     ld [-o OUTPUT ] OBJFILES...
       [ -Bstatic ]  [ -c MRI-COMMANDFILE ]  [ -d | -dc | -dp ]
       [ -defsym SYMBOL = EXPRESSION ]
       [ -e ENTRY ]  [ -F ]  [ -F FORMAT ]
       [ -format INPUT-FORMAT ]  [ -g ]  [ -i ]
       [ -lAR ]  [ -LSEARCHDIR ]  [ -M | -m ]
       [ -n | -N ]  [ -noinhibit-exec ]  [ -R FILENAME ]
       [ -relax ]  [ -r | -Ur ]  [ -S ]  [ -s ]  [ -T COMMANDFILE ]
       [ -Ttext TEXTORG ]  [ -Tdata DATAORG ]  [ -Tbss BSSORG ]
       [ -t ]  [ -u SYM]  [-v]  [ -X ]  [ -x ]
       [ { SCRIPT } ]

   This plethora of command-line options may seem intimidating, but in
actual practice few of them are used in any particular context. For
instance, a frequent use of `ld' is to link standard Unix object files
on a standard, supported Unix system.  On such a system, to link a file
`hello.o':
     $ ld -o output /lib/crt0.o hello.o -lc
   This tells `ld' to produce a file called `output' as the result of
linking the file `/lib/crt0.o' with `hello.o' and the library `libc.a'
which will come from the standard search directories.

   The command-line options to `ld' may be specified in any order, and
may be repeated at will.  For the most part, repeating an option with a
different argument will either have no further effect, or override prior
occurrences (those further to the left on the command line) of an
option.

   The exceptions--which may meaningfully be used more than once--are
`-A', `-defsym', `-L', `-l', `-R', and `-u'.

   The list of object files to be linked together, shown as OBJFILES,
may follow, precede, or be mixed in with command-line options; save that
an OBJFILES argument may not be placed between an option flag and its
argument.

   Usually the linker is invoked with at least one object file, but
other forms of binary input files can also be specified with `-l',
`-R', and the script command language.  If *no* binary input files at
all are specified, the linker does not produce any output, and issues
the message `No input files'.

   Option arguments must either follow the option letter without
intervening whitespace, or be given as separate arguments immediately
following the option that requires them.

`OBJFILES...'
     The object files OBJFILES to be linked.

`-Bstatic'
     This flag is accepted for command-line compatibility with the
     SunOS linker, but has no effect on `ld'.

`-c MRI-COMMANDFILE'
     For compatibility with linkers produced by MRI, `ld' accepts script
     files written in an alternate, restricted command language,
     described in *Note MRI Compatible Script Files: MRI.  Introduce
     such script files with the option flag `-c'.

     Use the `-T' option to run linker scripts written in the
     general-purpose `ld' scripting language.

`-d'
`-dc'
`-dp'
     These three options are equivalent; multiple forms are supported
     for compatibility with other linkers.  Use any of them to make `ld'
     assign space to common symbols even if a relocatable output file is
     specified (`-r').  The script command `FORCE_COMMON_ALLOCATION'
     has the same effect.

`-defsym SYMBOL = EXPRESSION'
     Create a global symbol in the output file, containing the absolute
     address given by EXPRESSION.  You may use this option as many
     times as necessary to define multiple symbols in the command line.
      A limited form of arithmetic is supported for the EXPRESSION in
     this context: you may give a hexadecimal constant or the name of
     an existing symbol, or use `+' and `-' to add or subtract
     hexadecimal constants or symbols.  If you need more elaborate
     expressions, consider using the linker command language from a
     script.

`-e ENTRY'
     Use ENTRY as the explicit symbol for beginning execution of your
     program, rather than the default entry point. *Note Entry Point::,
     for a discussion of defaults and other ways of specifying the
     entry point.

`-g'
     Accepted, but ignored; provided for compatibility with other tools.

`-i'
     Perform an incremental link (same as option `-r').

`-lAR'
     Add an archive file AR to the list of files to link.  This option
     may be used any number of times.  `ld' will search its path-list
     for occurrences of `libAR.a' for every AR specified.

`-LSEARCHDIR'
     This command adds path SEARCHDIR to the list of paths that `ld'
     will search for archive libraries.  You may use this option any
     number of times.

     The paths can also be specified in a link script with the
     `SEARCH_DIR' command.

`-M'
`-m'
     Print (to the standard output file) a link map--diagnostic
     information about where symbols are mapped by `ld', and
     information on global common storage allocation.

`-N'
     specifies readable and writable `text' and `data' sections. If the
     output format supports Unix style magic numbers, the output is
     marked as `OMAGIC'.

     When you use the `-N' option, the linker does not page-align the
     data segment.

`-n'
     sets the text segment to be read only, and `NMAGIC' is written if
     possible.

`-noinhibit-exec'
     Normally, the linker will not produce an output file if it
     encounters errors during the link process.  With this flag, you
     can specify that you wish the output file retained even after
     non-fatal errors.

`-o OUTPUT'
     OUTPUT is a name for the program produced by `ld'; if this option
     is not specified, the name `a.out' is used by default.  The script
     command `OUTPUT' can also specify the output file name.

`-R FILENAME'
     Read symbol names and their addresses from FILENAME, but do not
     relocate it or include it in the output.  This allows your output
     file to refer symbolically to absolute locations of memory defined
     in other programs.

`-relax'
     An option with machine dependent effects.  Currently this option
     is only supported on the H8/300; see *Note `ld' and the H8/300:
     H8/300.

     On some platforms, use this option to perform global optimizations
     that become possible when the linker resolves addressing in your
     program, such as relaxing address modes and synthesizing new
     instructions in the output object file.

     On platforms where this is not supported, `-relax' is accepted, but
     has no effect.

`-r'
     Generates relocatable output--i.e., generate an output file that
     can in turn serve as input to `ld'.  This is often called "partial
     linking".  As a side effect, in environments that support standard
     Unix magic numbers, this option also sets the output file's magic
     number to `OMAGIC'. If this option is not specified, an absolute
     file is produced.  When linking C++ programs, this option *will
     not* resolve references to constructors; `-Ur' is an alternative.

     This option does the same as `-i'.

`-S'
     Omits debugger symbol information (but not all symbols) from the
     output file.

`-s'
     Omits all symbol information from the output file.

`{ SCRIPT }'
     You can, if you wish, include a script of linker commands directly
     in the command line instead of referring to it via an input file. 
     When the character `{' occurs on the command line, the linker
     switches to interpreting the command language until the end of the
     list of commands is reached--flagged with a closing brace `}'. 
     Other command-line options will not be recognized while parsing
     the script. *Note Commands:: for a description of the command
     language.

`-Tbss ORG'
`-Tdata ORG'
`-Ttext ORG'
     Use ORG as the starting address for--respectively--the `bss',
     `data', or the `text' segment of the output file. TEXTORG must be
     a hexadecimal integer.

`-T COMMANDFILE'
`-TCOMMANDFILE'
     Directs `ld' to read link commands from the file COMMANDFILE. 
     These commands will completely override `ld''s default link format
     (rather than adding to it); COMMANDFILE must specify everything
     necessary to describe the target format. *Note Commands::.

     You may also include a script of link commands directly in the
     command line by bracketing it between `{' and `}' characters.

`-t'
     Prints names of input files as `ld' processes them.

`-u SYM'
     Forces SYM to be entered in the output file as an undefined symbol.
     This may, for example, trigger linking of additional modules from
     standard libraries.  `-u' may be repeated with different option
     arguments to enter additional undefined symbols.

`-Ur'
     For anything other than C++ programs, this option is equivalent to
     `-r': it generates relocatable output--i.e., an output file that
     can in turn serve as input to `ld'.  When linking C++ programs,
     `-Ur' *will* resolve references to constructors, unlike `-r'.

`-v'
     Display the version number for `ld'.

`-X'
     If `-s' or `-S' is also specified, delete only local symbols
     beginning with `L'.

`-x'
     If `-s' or `-S' is also specified, delete all local symbols, not
     just those beginning with `L'.


File: ld.i,  Node: Commands,  Next: H8/300,  Prev: Invocation,  Up: Top

Command Language
****************

   The command language allows explicit control over the link process,
allowing complete specification of the mapping between the linker's
input files and its output.  This includes:
   * input files

   * file formats

   * output file format

   * addresses of sections

   * placement of common blocks

   You may supply a command file (also known as a link script) to the
linker either explicitly through the `-T' option, or implicitly as an
ordinary file. If the linker opens a file which it cannot recognize as
a supported object or archive format, it tries to interpret the file as
a command file.

   You can also include a script directly on the `ld' command line,
delimited by the characters `{' and `}'.

* Menu:

* Scripts::                     Linker Scripts
* Expressions::                 Expressions
* MEMORY::                      MEMORY Command
* SECTIONS::                    SECTIONS Command
* Entry Point::                 The Entry Point
* Other Commands::              Other Commands


File: ld.i,  Node: Scripts,  Next: Expressions,  Up: Commands

Linker Scripts
==============

   The `ld' command language is a collection of statements; some are
simple keywords setting a particular flag, some are used to select and
group input files or name output files; and two particular statement
types have a fundamental and pervasive impact on the linking process.

   The most fundamental command of the `ld' command language is the
`SECTIONS' command (*note SECTIONS::.).  Every meaningful command
script must have a `SECTIONS' command: it specifies a "picture" of the
output file's layout, in varying degrees of detail. No other command is
required in all cases.

   The `MEMORY' command complements `SECTIONS' by describing the
available memory in the target architecture.  This command is optional;
if you don't use a `MEMORY' command, `ld' assumes sufficient memory is
available in a contiguous block for all output. *Note MEMORY::.

   You may include comments in linker scripts just as in C: delimited
by `/*' and `*/'.  As in C, comments are syntactically equivalent to
whitespace.


File: ld.i,  Node: Expressions,  Next: MEMORY,  Prev: Scripts,  Up: Commands

Expressions
===========

   Many useful commands involve arithmetic expressions.  The syntax for
expressions in the command language is identical to that of C
expressions, with the following features:
   * All expressions evaluated as integers and are of "long" or
     "unsigned long" type.

   * All constants are integers.

   * All of the C arithmetic operators are provided.

   * You may reference, define, and create global variables.

   * You may call special purpose built-in functions.

* Menu:

* Integers::                    Integers
* Symbols::                     Symbol Names
* Location Counter::            The Location Counter
* Operators::                   Operators
* Evaluation::                  Evaluation
* Assignment::                  Assignment: Defining Symbols
* Built-ins::                   Built-In Functions


File: ld.i,  Node: Integers,  Next: Symbols,  Up: Expressions

Integers
--------

   An octal integer is `0' followed by zero or more of the octal digits
(`01234567').
     _as_octal = 0157255;

   A decimal integer starts with a non-zero digit followed by zero or
more digits (`0123456789').
     _as_decimal = 57005;

   A hexadecimal integer is `0x' or `0X' followed by one or more
hexadecimal digits chosen from `0123456789abcdefABCDEF'.
     _as_hex = 0xdead;

   Decimal integers have the usual values.  To write a negative
integer, use the prefix operator `-'; *note Operators::..
     _as_neg = -57005;

   Additionally the suffixes `K' and `M' may be used to scale a
constant by `1024' or `1024*1024' respectively. For example, the
following all refer to the same quantity:

             _fourk_1 = 4K;
             _fourk_2 = 4096;
             _fourk_3 = 0x1000;


File: ld.i,  Node: Symbols,  Next: Location Counter,  Prev: Integers,  Up: Expressions

Symbol Names
------------

   Unless quoted, symbol names start with a letter, underscore, point or
hyphen and may include any letters, underscores, digits, points, and
minus signs.  Unquoted symbol names must not conflict with any
keywords.  You can specify a symbol which contains odd characters or has
the same name as a keyword, by surrounding the symbol name in double
quotes:
             "SECTION" = 9;
             "with a space" = "also with a space" + 10;


File: ld.i,  Node: Location Counter,  Next: Operators,  Prev: Symbols,  Up: Expressions

The Location Counter
--------------------

   The special linker variable "dot" `.' always contains the current
output location counter. Since the `.' always refers to a location in
an output section, it must always appear in an expression within a
`SECTIONS' command. The `.' symbol may appear anywhere that an ordinary
symbol is allowed in an expression, but its assignments have a side
effect. Assigning a value to the `.' symbol will cause the location
counter to be moved. This may be used to create holes in the output
section.  The location counter may never be moved backwards.
     SECTIONS
     {
             output :
             {
             file1(.text)
             . = . + 1000;
             file2(.text)
             . += 1000;
             file3(.text)
             } = 0x1234;
     }

In the previous example, `file1' is located at the beginning of the
output section, then there is a 1000 byte gap.  Then `file2' appears,
also with a 1000 byte gap following before `file3' is loaded.  The
notation `= 0x1234' specifies what data to write in the gaps (*note
Section Options::.).


File: ld.i,  Node: Operators,  Next: Evaluation,  Prev: Location Counter,  Up: Expressions

Operators
---------

   The linker recognizes  the standard C set of arithmetic operators,
with the standard bindings and precedence levels:
     precedence      associativity   Operators                Notes
     (highest)
     1               left            !  -  ~                  (1)
     2               left            *  /  %
     3               left            +  -
     4               left            >>  <<
     5               left            ==  !=  >  <  <=  >=
     6               left            &
     7               left            |
     8               left            &&
     9               left            ||
     10              right           ? :
     11              right           &=  +=  -=  *=  /=       (2)
     (lowest)
   Notes: (1) Prefix operators (2) *Note Assignment::


File: ld.i,  Node: Evaluation,  Next: Assignment,  Prev: Operators,  Up: Expressions

Evaluation
----------

   The linker uses "lazy evaluation" for expressions; it only calculates
an expression when absolutely necessary.  The linker needs the value of
the start address, and the lengths of memory regions, in order to do any
linking at all; these values are computed as soon as possible when the
linker reads in the command file.  However, other values (such as symbol
values) are not known or needed until after storage allocation.  Such
values are evaluated later, when other information (such as the sizes of
output sections) is available for use in the symbol assignment
expression.


File: ld.i,  Node: Assignment,  Next: Built-ins,  Prev: Evaluation,  Up: Expressions

Assignment: Defining Symbols
----------------------------

   You may create global symbols, and assign values (addresses) to
global symbols, using any of the C assignment operators:

`SYMBOL  = EXPRESSION ;'
`SYMBOL &= EXPRESSION ;'
`SYMBOL += EXPRESSION ;'
`SYMBOL -= EXPRESSION ;'
`SYMBOL *= EXPRESSION ;'
`SYMBOL /= EXPRESSION ;'
   Two things distinguish assignment from other operators in `ld'
expressions.
   * Assignment may only be used at the root of an expression; `a=b+3;'
     is allowed, but `a+b=3;' is an error.

   * A trailing semicolon is required at the end of an assignment
     statement.

   Assignment statements may appear:
   * as commands in their own right in an `ld' script; or

   * as independent statements within a `SECTIONS' command; or

   * as part of the contents of a section definition in a `SECTIONS'
     command.

   The first two cases are equivalent in effect--both define a symbol
with an absolute address; the last case defines a symbol whose address
is relative to a particular section (*note SECTIONS::.).

   When a linker expression is evaluated and assigned to a variable, it
is given either an absolute or a relocatable type. An absolute
expression type is one in which the symbol contains the value that it
will have in the output file, a relocateable expression type is one in
which the value is expressed as a fixed offset from the base of a
section.

   The type of the expression is controlled by its position in the
script file.  A symbol assigned within a section definition is created
relative to the base of the section; a symbol assigned in any other
place is created as an absolute symbol. Since a symbol created within a
section definition is relative to the base of the section, it will
remain relocatable if relocatable output is requested.  A symbol may be
created with an absolute value even when assigned to within a section
definition by using the absolute assignment function `ABSOLUTE'.  For
example, to create an absolute symbol whose address is the last byte of
an output section named `.data':
     SECTIONS{ ...
     .data :
             {
                     *(.data)
                     _edata = ABSOLUTE(.) ;
             }
     ... }

   The linker tries to put off the evaluation of an assignment until all
the terms in the source expression are known (*note Evaluation::.).  For
instance the sizes of sections cannot be known until after allocation,
so assignments dependent upon these are not performed until after
allocation. Some expressions, such as those depending upon the location
counter "dot", `.' must be evaluated during allocation. If the result
of an expression is required, but the value is not available, then an
error results.  For example, a script like the following
     SECTIONS { ...
           text 9+this_isnt_constant :
                     { ...
                     }
     ... }

will cause the error message "`Non constant expression for initial
address'".


File: ld.i,  Node: Built-ins,  Prev: Assignment,  Up: Expressions

Built-In Functions
------------------

   The command language includes a number of special purpose built-in
functions for use in link script expressions.
`ABSOLUTE(EXP)'
     returns the absolute value of the expression EXP.  Primarily
     useful to assign an absolute value to a symbol within a section
     definition, where symbol values are normally section-relative.

`ADDR(SECTION)'
     returns the absolute address of the named SECTION.  Your script
     must previously have defined the location of that section. In the
     following example the `symbol_1' and `symbol_2' are assigned
     identical values:
          SECTIONS{ ...
                  .output1 :
                          {
                          start_of_output_1 = ABSOLUTE(.);
                          ...
                          }
                  .output :
                          {
                          symbol_1 = ADDR(.output1);
                          symbol_2 = start_of_output_1;
                          }
          ... }

`ALIGN(EXP)'
     returns the result of the current location counter (`.') aligned to
     the next EXP boundary.  EXP must be an expression whose value is a
     power of two.  This is equivalent to
          (. + EXP - 1) & ~(EXP - 1)

     `ALIGN' doesn't change the value of the location counter--it just
     does arithmetic on it.  As an example, to align the output `.data'
     section to the next `0x2000' byte boundary after the preceding
     section and to set a variable within the section to the next
     `0x8000' boundary after the input sections:
          SECTIONS{ ...
                  .data ALIGN(0x2000): {
                          *(.data)
                          variable = ALIGN(0x8000);
                  }
          ... }

     The first use of `ALIGN' in this example specifies the location of
     a section because it is used as the optional START attribute of a
     section definition (*note Section Options::.).  The second use
     simply defines the value of a variable.

     The built-in `NEXT' is closely related to `ALIGN'.

`DEFINED(SYMBOL)'
     Returns `1' if SYMBOL is in the linker global symbol table and is
     defined, otherwise it returns `0'.  You can use this to provide
     default values for symbols.  For example, this command-file
     fragment shows how to set a global symbol `begin' to the first
     location in the `.text' section--but if a symbol called `begin'
     already existed, its value is preserved:
          SECTIONS{ ...
                  .text : {
                          begin = DEFINED(begin) ? begin : . ;
                          ...
                  }
          ... }

`NEXT(EXP)'
     Returns the next unallocated address that is a multiple of EXP.
     This command is closely related to `ALIGN(EXP)'; unless you use
     the `MEMORY' command to define discontinuous memory for the output
     file, the two commands are equivalent.

`SIZEOF(SECTION)'
     returns the size in bytes of the named SECTION, if the section has
     been allocated.  In the following example the `symbol_1' and
     `symbol_2' are assigned identical values:
          SECTIONS{ ...
                  .output {
                          .start = . ;
                          ...
                          .end = . ;
                          }
                  symbol_1 = .end - .start ;
                  symbol_2 = SIZEOF(.output);
          ... }

`SIZEOF_HEADERS'
`sizeof_headers'
     the size in bytes of the output file's headers.  You can use this
     number as the start address of the first section, if you choose,
     to facilitate paging.


File: ld.i,  Node: MEMORY,  Next: SECTIONS,  Prev: Expressions,  Up: Commands

MEMORY Command
==============

   The linker's default configuration permits allocation of all memory.
You can override this by using the `MEMORY' command.  The `MEMORY'
command describes the location and size of blocks of memory in the
target.  By using it carefully, you can describe which memory regions
may be used by the linker, and which memory regions it must avoid.  The
linker does not shuffle sections to fit into the available regions, but
does move the requested sections into the correct regions and issue
errors when the regions become too full.

   Command files may contain at most one use of the `MEMORY' command;
however, you can define as many blocks of memory within it as you wish.
 The syntax is:

     MEMORY
           {
            NAME (ATTR) : ORIGIN = ORIGIN, LENGTH = LEN
            ...
           }

`NAME'
     is a name used internally by the linker to refer to the region. Any
     symbol name may be used.  The region names are stored in a separate
     name space, and will not conflict with symbols, filenames or
     section names.  Use distinct names to specify multiple regions.

`(ATTR)'
     is an optional list of attributes, permitted for compatibility
     with the AT&T linker but not used by `ld' beyond checking that the
     attribute list is valid.  Valid attribute lists must be made up of
     the characters "`LIRWX'".  If you omit the attribute list, you may
     omit the parentheses around it as well.

`ORIGIN'
     is the start address of the region in physical memory.  It is
     expressed as an expression, which must evaluate to a constant
     before memory allocation is performed. The keyword `ORIGIN' may be
     abbreviated to `org' or `o'.

`LEN'
     is the size in bytes of the region (an expression). The keyword
     `LENGTH' may be abbreviated to `len' or `l'.

   For example, to specify that memory has two regions available for
allocation--one starting at `0' for 256 kilobytes, and the other
starting at `0x40000000' for four megabytes:

     MEMORY
             {
             rom : ORIGIN = 0, LENGTH = 256K
             ram : org = 0x40000000, l = 4M
             }

   Once you have defined a region of memory named MEM, you can direct
specific output sections there by using a command ending in `>MEM'
within the `SECTIONS' command (*note Section Options::.).  If the
combined output sections directed to a region are too big for the
region, the linker will issue an error message.


File: ld.i,  Node: SECTIONS,  Next: Entry Point,  Prev: MEMORY,  Up: Commands

SECTIONS Command
================

   The `SECTIONS' command controls exactly where input sections are
placed into output sections, their order and to which output sections
they are allocated.

   You may use at most one `SECTIONS' command in a commands file, but
you can have as many statements within it as you wish.  Statements
within the `SECTIONS' command can do one of three things:
   * define the entry point;

   * assign a value to a symbol;

   * describe the placement of a named output section, and what input
     sections make it up.

   The first two possibilities--defining the entry point, and defining
symbols--can also be done outside the `SECTIONS' command: *note Entry
Point::., *note Assignment::..  They are permitted here as well for
your convenience in reading the script, so that symbols or the entry
point can be defined at meaningful points in your output-file layout.

   When no `SECTIONS' command is specified, the default action of the
linker is to place each input section into an identically named output
section in the order that the sections are first encountered in the
input files; if all input sections are present in the first file, for
example, the order of sections in the output file will match the order
in the first input file.

* Menu:

* Section Definition::          Section Definitions
* Section Contents::            Section Contents
* Section Options::             Optional Section Attributes


File: ld.i,  Node: Section Definition,  Next: Section Contents,  Up: SECTIONS

Section Definitions
-------------------

   The most frequently used statement in the `SECTIONS' command is the
"section definition", which you can use to specify the properties of an
output section: its location, alignment, contents, fill pattern, and
target memory region can all be specified.  Most of these
specifications are optional; the simplest form of a section definition
is
     SECTIONS { ...
     SECNAME : {
                      CONTENTS
                     }
     ... }

SECNAME is the name of the output section, and CONTENTS a specification
of what goes there--for example a list of input files or sections of
input files.  As you might assume, the whitespace shown is optional;
you do need the colon `:' and the braces `{}', however.

   SECNAME must meet the constraints of your output format.  In formats
which only support a limited number of sections, such as `a.out', the
name must be one of the names supported by the format (`a.out', for
example, allows only `.text', `.data' or `.bss'). If the output format
supports any number of sections, but with numbers and not names (as is
the case for Oasys), the name should be supplied as a quoted numeric
string.  A section name may consist of any sequence characters, but any
name which does not conform to the standard `ld' symbol name syntax
must be quoted.


File: ld.i,  Node: Section Contents,  Next: Section Options,  Prev: Section Definition,  Up: SECTIONS

Section Contents
----------------

   In a section definition, you can specify the contents of an output
section by listing particular object files; by listing particular
input-file sections; or a combination of the two.  You can also place
arbitrary data in the section, and define symbols relative to the
beginning of the section.

   The CONTENTS of a section definition may include any of the
following kinds of statement.  You can include as many of these as you
like in a single section definition, separated from one another by
whitespace.

`FILENAME'
     You may simply name a particular input file to be placed in the
     current output section; *all* sections from that file are placed
     in the current section definition. To specify a list of particular
     files by name:
          .data : { afile.o bfile.o cfile.o }

     The example also illustrates that multiple statements can be
     included in the contents of a section definition, since each
     filename is a separate statement.

     If the file name has already been mentioned in another section
     definition, with an explicit section name list, then only those
     sections which have not yet been allocated are used.

`FILENAME( SECTION )'
`FILENAME( SECTION, SECTION, ... )'
`FILENAME( SECTION SECTION ... )'
     You can name one or more sections from your input files, for
     insertion in the current output section.  If you wish to specify a
     list of input-file sections inside the parentheses, you may
     separate the section names by either commas or whitespace.

`* (SECTION)'
`* (SECTION, SECTION, ...)'
`* (SECTION SECTION ...'
     Instead of explicitly naming particular input files in a link
     control script, you can refer to *all* files from the `ld' command
     line: use `*' instead of a particular filename before the
     parenthesized input-file section list.

     For example, to copy sections `1' through `4' from a Oasys file
     into the `.text' section of an `a.out' file, and sections `13' and
     `14' into the `.data' section:
          SECTIONS {
                  .text :{
                          *("1" "2" "3" "4")
                  }
          
                  .data :{
                          *("13" "14")
                  }
          }

     If you have already explicitly included some files by name, `*'
     refers to all *remaining* files--those whose places in the output
     file have not yet been defined.

`[ SECTION ]'
`[ SECTION, SECTION, ... ]'
`[ SECTION SECTION ... ]'
     This is an alternate notation to specify named sections from all
     unallocated input files; its effect is exactly the same as that of
     `* (SECTION...)'

`FILENAME`( COMMON )''
`[ COMMON ]'
     Specify where in your output file to place uninitialized data with
     this notation.  `[COMMON]' by itself refers to all uninitialized
     data from all input files (so far as it is not yet allocated);
     FILENAME`(COMMON)' refers to uninitialized data from a particular
     file.  Both are special cases of the general mechanisms for
     specifying where to place input-file sections: `ld' permits you to
     refer to uninitialized data as if it were in an input-file section
     named `COMMON', regardless of the input file's format.

   For example, the following command script arranges the output file
into three consecutive sections, named `.text', `.data', and `.bss',
taking the input for each from the correspondingly named sections of
all the input files:
     SECTIONS {
       .text : { *(.text) }
       .data : { *(.data) }
       .bss :  { *(.bss)  [COMMON] }
     }

   The following example reads all of the sections from file `all.o'
and places them at the start of output section `outputa' which starts
at location `0x10000'. All of section `.input1' from file `foo.o'
follows immediately, in the same output section.  All of section
`.input2' from `foo.o' goes into output section `outputb', followed by
section `.input1' from `foo1.o'. All of the remaining `.input1' and
`.input2' sections from any files are written to output section
`outputc'.

     SECTIONS {
             outputa 0x10000 :
                     {
                     all.o
                     foo.o (.input1)
                     }
             outputb :
                     {
                     foo.o (.input2)
                     foo1.o (.input1)
                     }
             outputc :
                     {
                     *(.input1)
                     *(.input2)
                     }
     }

   There are still more kinds of statements permitted in the contents of
output section definitions.  The foregoing statements permitted you to
arrange, in your output file, data originating from your input files.
You can also place data directly in an output section from the link
command script.  Most of these additional statements involve
expressions; *note Expressions::..  Although these statements are shown
separately here for ease of presentation, no such segregation is needed
within a section definition in the `SECTIONS' command; you can intermix
them freely with any of the statements we've just described.

`CREATE_OBJECT_SYMBOLS'
     instructs the linker to create a symbol for each input file in the
     current section, set with the address of the first byte of data
     written from the input file.  For instance, with `a.out' files it
     is conventional to have a symbol for each input file.  You can
     accomplish this by defining the output `.text' section as follows:
          SECTIONS {
                  .text 0x2020 :
                           {
                          CREATE_OBJECT_SYMBOLS
                          *(.text)
                          _etext = ALIGN(0x2000);
                          }
                  ...
          }

     If `objsym' is a file containing this script, and `a.o', `b.o',
     `c.o', and `d.o' are four input files with contents like the
     following--
          /* a.c */
          
          afunction() { }
          int adata=1;
          int abss;

     `ld -M sample a.o b.o c.o d.o' would create a map like this,
     containing symbols matching the object file names:
          00000000 A __DYNAMIC
          00004020 B _abss
          00004000 D _adata
          00002020 T _afunction
          00004024 B _bbss
          00004008 D _bdata
          00002038 T _bfunction
          00004028 B _cbss
          00004010 D _cdata
          00002050 T _cfunction
          0000402c B _dbss
          00004018 D _ddata
          00002068 T _dfunction
          00004020 D _edata
          00004030 B _end
          00004000 T _etext
          00002020 t a.o
          00002038 t b.o
          00002050 t c.o
          00002068 t d.o

`SYMBOL = EXPRESSION ;'
`SYMBOL F= EXPRESSION ;'
     SYMBOL is any symbol name (*note Symbols::.).  "F=" refers to any
     of the operators `&= += -= *= /=' which combine arithmetic and
     assignment.

     When you assign a value to a symbol within a particular section
     definition, the value is relative to the beginning of the section
     (*note Assignment::.).  If you write
          SECTIONS {
            abs = 14 ;
            ...
            .data : { ... rel = 14 ; ... }
            abs2 = 14 + ADDR(.data);
            ...
          }

     `abs' and REL do not have the same value; `rel' has the same value
     as `abs2'.

`BYTE(EXPRESSION)'
`SHORT(EXPRESSION)'
`LONG(EXPRESSION)'
     By including one of these three statements in a section
     definition, you can explicitly place one, two, or four bytes
     (respectively) at the current address of that section.

`FILL(EXPRESSION)'
     Specifies the "fill pattern" for the current section.  Any
     otherwise unspecified regions of memory within the section (for
     example, regions you skip over by assigning a new value to the
     location counter `.') are filled with the two least significant
     bytes from the EXPRESSION argument.  A `FILL' statement covers
     memory locations *after* the point it occurs in the section
     definition; by including more than one `FILL' statement, you can
     have different fill patterns in different parts of an output
     section.


File: ld.i,  Node: Section Options,  Prev: Section Contents,  Up: SECTIONS

Optional Section Attributes
---------------------------

   Here is the full syntax of a section definition, including all the
optional portions:

     SECTIONS {
     ...
     SECNAME START BLOCK(ALIGN) : { CONTENTS } =FILL >REGION
     ...
     }

   SECNAME and CONTENTS are required.  *Note Section Definition::, and
*note Section Contents::. for details on CONTENTS. The remaining
elements--START, `BLOCK(ALIGN)', `=FILL', and `>REGION'--are all
optional.

`START'
     You can force the output section to be loaded at a specified
     address by specifying START immediately following the section name.
     START can be represented as any expression. The following example
     generates section OUTPUT at location `0x40000000':
          SECTIONS {
                  ...
                  output 0x40000000: {
                         ...
                    }
                  ...
          }

`BLOCK(ALIGN)'
     You can include `BLOCK()' specification to advance the location of
     the location counter `.' prior to the beginning of the section, so
     that the section will begin at the specified alignment.  ALIGN is
     an expression.

`=FILL'
     You may use any expression to specify FILL.  Including `=FILL' in
     a section definition specifies the initial fill value for that
     section. Any unallocated holes in the current output section when
     written to the output file will be filled with the two least
     significant bytes of the value, repeated as necessary.  You can
     also change the fill value with a `FILL' statement in the CONTENTS
     of a section definition.

`>REGION'
     Assign this section to a previously defined region of memory.
     *Note MEMORY::.


File: ld.i,  Node: Entry Point,  Next: Other Commands,  Prev: SECTIONS,  Up: Commands

The Entry Point
===============

   The linker command language includes a command specifically for
defining the first executable instruction in an output file (its "entry
point").  Its argument is a symbol name:
     ENTRY(SYMBOL)

   Like symbol assignments, the `ENTRY' command may be placed either as
an independent command in the command file, or among the section
definitions within the `SECTIONS' command--whatever makes the most
sense for your layout.

   `ENTRY' is only one of several ways of choosing the entry point. You
may indicate it in any of the following ways (shown in descending order
of priority: methods higher in the list override methods lower down).
   * the `-e' ENTRY command-line option;

   * the `ENTRY(SYMBOL' command in a linker control script;

   * the value of the symbol `start', if present;

   * the value of the symbol `_main', if present;

   * the address of the first byte of the `.text' section, if present;

   * The address `0'.

   For example, you can use these rules to generate an entry point with
an assignment statement: if no symbol `start' is defined within your
input files, you can simply define it, assigning it an appropriate
value--
     start = 0x2020;

The example shows an absolute address, but you can use any expression.
For example, if your input object files use some other symbol-name
convention for the entry point, you can just assign the value of
whatever symbol contains the start address to `start':
     start = other_symbol ;


File: ld.i,  Node: Other Commands,  Prev: Entry Point,  Up: Commands

Other Commands
==============

   The command language includes a number of other commands that you can
use for specialized purposes.  They are similar in purpose to
command-line options.

`FLOAT'
`NOFLOAT'
     These keywords were used in some older linkers to request a
     particular math subroutine library.  `ld' doesn't use the
     keywords, assuming instead that any necessary subroutines are in
     libraries specified using the general mechanisms for linking to
     archives; but to permit the use of scripts that were written for
     the older linkers, the keywords `FLOAT' and `NOFLOAT' are accepted
     and ignored.

`FORCE_COMMON_ALLOCATION'
     This command has the same effect as the `-d' command-line option:
     to make `ld' assign space to common symbols even if a relocatable
     output file is specified (`-r').

`INPUT ( FILE, FILE, ... )'
`INPUT ( FILE FILE ... )'
     Use this command to include binary input files in the link, without
     including them in a particular section definition.  Files
     specified this way are treated identically to object files listed
     on the command line.

`OUTPUT ( FILENAME )'
     Name the link output file FILENAME.  The effect of
     `OUTPUT(FILENAME)' is identical to the effect of `-o FILENAME',
     and whichever is encountered last will control the name actually
     used to name the output file.  In particular, you can use this
     command to supply a default output-file name other than `a.out'.

`SEARCH_DIR ( PATH )'
     Add PATH to the list of paths where `ld' looks for archive
     libraries.  `SEARCH_DIR(PATH)' has the same effect as `-LPATH)' on
     the command line.

`STARTUP ( FILENAME )'
     Ensure that FILENAME is the first input file used in the link
     process.


File: ld.i,  Node: H8/300,  Next: MRI,  Prev: Commands,  Up: Top

`ld' and the H8/300
*******************

   For the H8/300, `ld' can perform these global optimizations when you
specify the `-relax' command-line option.

*relaxing address modes*
     `ld' finds all `jsr' and `jmp' instructions whose targets are
     within eight bits, and turns them into eight-bit program-counter
     relative `bsr' and `bra' instructions, respectively.

*synthesizing instructions*
     `ld' finds all `mov.b' instructions which use the sixteen-bit
     absolute address form, but refer to the top page of memory, and
     changes them to use the eight-bit address form. (That is: the
     linker turns `mov.b `@'AA:16' into `mov.b `@'AA:8' whenever the
     address AA is in the top page of memory).


File: ld.i,  Node: MRI,  Next: Index,  Prev: H8/300,  Up: Top

MRI Compatible Script Files
***************************

   To aid users making the transition to GNU `ld' from the MRI linker,
`ld' can use MRI compatible linker scripts as an alternative to the
more general-purpose linker scripting language described in *Note
Command Language: Commands.  MRI compatible linker scripts have a much
simpler command set than the scripting language otherwise used with
`ld'.  GNU `ld' supports the most commonly used MRI linker commands;
these commands are described here.

   You can specify a file containing an MRI-compatible script using the
`-c' command-line option.

   Each command in an MRI-compatible script occupies its own line; each
command line starts with the keyword that identifies the command (though
blank lines are also allowed for punctuation).  If a line of an
MRI-compatible script begins with an unrecognized keyword, `ld' issues
a warning message, but continues processing the script.

   Lines beginning with `*' are comments.

   You can write these commands using all upper-case letters, or all
lower case; for example, `chip' is the same as `CHIP'. The following
list shows only the upper-case form of each command.

`ABSOLUTE SECNAME'
`ABSOLUTE SECNAME, SECNAME, ... SECNAME'
     Normally, `ld' includes in the output file all sections from all
     the input files.  However, in an MRI-compatible script, you can
     use the `ABSOLUTE' command to restrict the sections that will be
     present in your output program.  If the `ABSOLUTE' command is used
     at all in a script, then only the sections named explicitly in
     `ABSOLUTE' commands will appear in the linker output.  You can
     still use other input sections (whatever you select on the command
     line, or using `LOAD') to resolve addresses in the output file.

`ALIAS OUT-SECNAME, IN-SECNAME'
     Use this command to place the data from input section IN-SECNAME
     in a section called OUT-SECNAME in the linker output file.

     IN-SECNAME may be an integer.

`BASE EXPRESSION'
     Use the value of EXPRESSION as the lowest address (other than
     absolute addresses) in the output file.

`CHIP EXPRESSION'
`CHIP EXPRESSION, EXPRESSION'
     This command does nothing whatever; it's only accepted for
     compatibility.

`END'
     This command does nothing whatever; it's only accepted for
     compatibility.

`FORMAT OUTPUT-FORMAT'
     Similar to the `OUTPUT_FORMAT' command in the more general linker
     language, but restricted to one of these output formats:
       1. S-records, if OUTPUT-FORMAT is `S'

       2. IEEE, if OUTPUT-FORMAT is `IEEE'

       3. COFF (the `coff-m68k' variant in BFD), if OUTPUT-FORMAT is
          `COFF'

`LIST ...'
     Print (to the standard output file) a link map, as produced by the
     `ld' command-line option `-M'.

     (The keyword `LIST' may be followed by anything whatsoever on the
     same line, with no change in its effect.)

`LOAD FILENAME'
`LOAD FILENAME, FILENAME, ... FILENAME'
     Include one or more object file FILENAME in the link; this has the
     same effect as specifying FILENAME directly on the `ld' command
     line.

`NAME OUTPUT-NAME'
     OUTPUT-NAME is the name for the program produced by `ld'; the
     MRI-compatible command `NAME' is equivalent to the command-line
     option `-o' or the general script language command `OUTPUT'.

`ORDER SECNAME, SECNAME, ... SECNAME'
`ORDER SECNAME SECNAME SECNAME'
     Normally, `ld' orders the sections in its output file in whatever
     order they first appear in the input files.  In an MRI-compatible
     script, you can override this with the `ORDER' command.  The
     sections you list with `ORDER' will appear first in your output
     file, in the order specified.

`PUBLIC NAME=EXPRESSION'
`PUBLIC NAME,EXPRESSION'
`PUBLIC NAME EXPRESSION'
     This command supplies a value (EXPRESSION) for an external symbol
     NAME used in the linker input files.

`SECT SECNAME, EXPRESSION'
`SECT SECNAME=EXPRESSION'
`SECT SECNAME EXPRESSION'
     You can use any of these three forms of the `SECT' command to
     specify the start address (EXPRESSION) for section SECNAME. If you
     have more than one `SECT' statement for the same SECNAME, only the
     *first* sets the start address.


File: ld.i,  Node: Index,  Prev: MRI,  Up: Top

Index
*****

* Menu:

* ":                                    Symbols.
* *(SECTION):                           Section Contents.
* -Bstatic:                             Invocation.
* -c MRI-CMDFILE:                       Invocation.
* -d:                                   Invocation.
* -dc:                                  Invocation.
* -defsym SYMBOL = EXP:                 Invocation.
* -dp:                                  Invocation.
* -e ENTRY:                             Invocation.
* -g:                                   Invocation.
* -i:                                   Invocation.
* -lAR:                                 Invocation.
* -LDIR:                                Invocation.
* -m:                                   Invocation.
* -M:                                   Invocation.
* -N:                                   Invocation.
* -n:                                   Invocation.
* -noinhibit-exec:                      Invocation.
* -o OUTPUT:                            Invocation.
* -r:                                   Invocation.
* -R FILE:                              Invocation.
* -relax:                               Invocation.
* -s:                                   Invocation.
* -S:                                   Invocation.
* -t:                                   Invocation.
* -T SCRIPT:                            Invocation.
* -Tbss ORG:                            Invocation.
* -Tdata ORG:                           Invocation.
* -Ttext ORG:                           Invocation.
* -u SYM:                               Invocation.
* -Ur:                                  Invocation.
* -v:                                   Invocation.
* -X:                                   Invocation.
* -x:                                   Invocation.
* .:                                    Location Counter.
* 0x:                                   Integers.
* ;:                                    Assignment.
* =FILL:                                Section Options.
* >REGION:                              Section Options.
* ABSOLUTE (MRI):                       MRI.
* ALIAS (MRI):                          MRI.
* BASE (MRI):                           MRI.
* CHIP (MRI):                           MRI.
* END (MRI):                            MRI.
* FORMAT (MRI):                         MRI.
* LIST (MRI):                           MRI.
* LOAD (MRI):                           MRI.
* NAME (MRI):                           MRI.
* ORDER (MRI):                          MRI.
* PUBLIC (MRI):                         MRI.
* SECT (MRI):                           MRI.
* FILENAME:                             Section Contents.
* FILENAME(SECTION):                    Section Contents.
* SYMBOL = EXPRESSION ;:                Section Contents.
* SYMBOL F= EXPRESSION ;:               Section Contents.
* { SCRIPT }:                           Invocation.
* absolute and relocatable symbols:     Assignment.
* ABSOLUTE(EXP):                        Built-ins.
* ADDR(SECTION):                        Built-ins.
* ALIGN(EXP):                           Built-ins.
* aligning sections:                    Section Options.
* allocating memory:                    MEMORY.
* archive files, from cmd line:         Invocation.
* arithmetic:                           Expressions.
* arithmetic operators:                 Operators.
* assignment in scripts:                Assignment.
* assignment, in section defn:          Section Contents.
* binary input files:                   Other Commands.
* BLOCK(ALIGN):                         Section Options.
* BYTE(EXPRESSION):                     Section Contents.
* command files:                        Commands.
* command line:                         Invocation.
* commands, fundamental:                Scripts.
* comments:                             Scripts.
* common allocation:                    Other Commands.
* common allocation:                    Invocation.
* commons in output:                    Section Contents.
* compatibility, MRI:                   Invocation.
* constructors:                         Invocation.
* contents of a section:                Section Contents.
* CREATE_OBJECT_SYMBOLS:                Section Contents.
* current output location:              Location Counter.
* decimal integers:                     Integers.
* DEFINED(SYMBOL):                      Built-ins.
* deleting local symbols:               Invocation.
* direct output:                        Section Contents.
* discontinuous memory:                 MEMORY.
* dot:                                  Location Counter.
* entry point, defaults:                Entry Point.
* entry point, from command line:       Invocation.
* ENTRY(SYMBOL):                        Entry Point.
* expression evaluation order:          Evaluation.
* expression syntax:                    Expressions.
* expression, absolute:                 Built-ins.
* filename symbols:                     Section Contents.
* files and sections, section defn:     Section Contents.
* files, including in output sections:  Section Contents.
* fill pattern, entire section:         Section Options.
* FILL(EXPRESSION):                     Section Contents.
* first input file:                     Other Commands.
* first instruction:                    Entry Point.
* FLOAT:                                Other Commands.
* FORCE_COMMON_ALLOCATION:              Other Commands.
* functions in expression language:     Built-ins.
* fundamental script commands:          Scripts.
* GNU linker:                           Overview.
* H8/300 support:                       H8/300.
* header size:                          Built-ins.
* hexadecimal integers:                 Integers.
* holes:                                Location Counter.
* holes, filling:                       Section Contents.
* incremental link:                     Invocation.
* INPUT ( FILES ):                      Other Commands.
* input filename symbols:               Section Contents.
* input files, displaying:              Invocation.
* input files, section defn:            Section Contents.
* input sections to output section:     Section Contents.
* integer notation:                     Integers.
* integer suffixes:                     Integers.
* K and M integer suffixes:             Integers.
* l =:                                  MEMORY.
* L, deleting symbols beginning:        Invocation.
* layout of output file:                Scripts.
* lazy evaluation:                      Evaluation.
* len =:                                MEMORY.
* LENGTH =:                             MEMORY.
* link map:                             Invocation.
* local symbols, deleting:              Invocation.
* location counter:                     Location Counter.
* LONG(EXPRESSION):                     Section Contents.
* M and K integer suffixes:             Integers.
* MEMORY:                               MEMORY.
* memory region attributes:             MEMORY.
* memory regions and sections:          Section Options.
* MRI compatibility:                    MRI.
* names:                                Symbols.
* naming memory regions:                MEMORY.
* naming output sections:               Section Definition.
* naming the output file:               Invocation.
* naming the output file:               Other Commands.
* negative integers:                    Integers.
* NEXT(EXP):                            Built-ins.
* NMAGIC:                               Invocation.
* NOFLOAT:                              Other Commands.
* Non constant expression:              Assignment.
* o =:                                  MEMORY.
* object files:                         Invocation.
* octal integers:                       Integers.
* OMAGIC:                               Invocation.
* Operators for arithmetic:             Operators.
* options:                              Invocation.
* org =:                                MEMORY.
* ORIGIN =:                             MEMORY.
* OUTPUT ( FILENAME ):                  Other Commands.
* output file after errors:             Invocation.
* output file layout:                   Scripts.
* partial link:                         Invocation.
* path for libraries:                   Other Commands.
* precedence in expressions:            Operators.
* quoted symbol names:                  Symbols.
* read-only text:                       Invocation.
* read/write from cmd line:             Invocation.
* regions of memory:                    MEMORY.
* relaxing addressing modes:            Invocation.
* relaxing on i960:                     H8/300.
* relocatable and absolute symbols:     Assignment.
* relocatable output:                   Invocation.
* rounding up location counter:         Built-ins.
* scaled integers:                      Integers.
* script files:                         Invocation.
* scripts on command line:              Invocation.
* search directory, from cmd line:      Invocation.
* search path, libraries:               Other Commands.
* SEARCH_DIR ( PATH ):                  Other Commands.
* section address:                      Section Options.
* section address:                      Built-ins.
* section alignment:                    Section Options.
* section definition:                   Section Definition.
* section defn, full syntax:            Section Options.
* section fill pattern:                 Section Options.
* section size:                         Built-ins.
* section start:                        Section Options.
* section, assigning to memory region:  Section Options.
* SECTIONS:                             SECTIONS.
* segment origins, cmd line:            Invocation.
* semicolon:                            Assignment.
* SHORT(EXPRESSION):                    Section Contents.
* SIZEOF(SECTION):                      Built-ins.
* SIZEOF_HEADERS:                       Built-ins.
* sizeof_headers:                       Built-ins.
* standard Unix system:                 Invocation.
* start address, section:               Section Options.
* start of execution:                   Entry Point.
* STARTUP ( FILENAME ):                 Other Commands.
* strip all symbols:                    Invocation.
* strip debugger symbols:               Invocation.
* suffixes for integers:                Integers.
* symbol defaults:                      Built-ins.
* symbol definition, scripts:           Assignment.
* symbol names:                         Symbols.
* symbol-only input:                    Invocation.
* symbols, from command line:           Invocation.
* symbols, relocatable and absolute:    Assignment.
* synthesizing linker:                  Invocation.
* synthesizing on i960:                 H8/300.
* unallocated address, next:            Built-ins.
* undefined symbol:                     Invocation.
* uninitialized data:                   Section Contents.
* unspecified memory:                   Section Contents.
* variables, defining:                  Assignment.
* verbose:                              Invocation.
* version:                              Invocation.
* what is this?:                        Overview.
* [ SECTIONS ]:                         Section Contents.
* [ COMMON ]:                           Section Contents.



Tag Table:
Node: Top829
Node: Overview1251
Node: Invocation2051
Node: Commands11448
Node: Scripts12566
Node: Expressions13668
Node: Integers14592
Node: Symbols15469
Node: Location Counter16026
Node: Operators17218
Node: Evaluation18125
Node: Assignment18817
Node: Built-ins21874
Node: MEMORY25593
Node: SECTIONS28139
Node: Section Definition29666
Node: Section Contents31080
Node: Section Options39413
Node: Entry Point41201
Node: Other Commands42790
Node: H8/30044635
Node: MRI45428
Node: Index49750

End Tag Table
