;{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}
;{}                                                            {}
;{} Prepared EXCLUSIVELY for Microchip PICSTART Design Contest.{}
;{} Copyright (C)1993 Don Lekei, ALL RIGHTS RESERVED.          {}
;{}                                                            {}
;{} Limited use for educational purposes permitted. Commercial {}
;{} use of large portions of the software requires written     {}
;{} permission of the author.                                  {}
;{}                                                            {}
;{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}

;****************************************************************
;**           :
;** Project   : Personal Logic Debugger (PLD)
;** Filename  : PLD.ASM
;** Author    : Don Lekei
;** Status    : Experimental
;** Date      : 08/27/93
;** Purpose   : Project control file
;**           :
;****************************************************************
;
;**********************************************************************
;* 
;* Handle and simulator / execution differences, for simulation, compile
;* with command line option -d:objectname
;* 
;**********************************************************************

        .objfil inhx8m         ;object format for programmer

        .if     clop_d          ;-d on command line for simulator
	 .if clop_d==-1		;set to -1 if there is a string
	  .objfil "",#CLOP_D	;use environmedt
	 .else
          .objfil "out.obj"     ;genaric file name for simulator
	 .endif
         .if     .._pass=1
          .echo   *** Simulator version ***
         .endif
rtcf    = 0     ;Constant to add for RTCC fixups 
        .else
rtcf    = 1     ;1 extra cycle for pic sync 
        .endif

;**********************************************************************
;* 
;* Setup system defaults for use by portability macros, timing
;* calculations, etc.
;* 
;**********************************************************************

PICDEVICE 	= 1671      		;pic model
Fosc    	= 4000000        	;oscilator in Hz
Clock   	= Fosc/4          	;instruction clock
MSEC    	= Clock+500/1000        ;instructions / ms

microsec(   .macro  * time )
(       time * MSEC / 1000 )
        .endm


;**********************************************************************
;* 
;* Macro definitions
;* 
;**********************************************************************

        .include "SEGMACS.ASI"  ;segment macros
        .include "PICMACRO.ASM" ;pic macros
	.include "CSET.ASM"	;character set translation
	.include "MACROS.ASM"	;more macros for this app


;**********************************************************************
;* 
;* Define PIC options and ID
;* 
;**********************************************************************
	.if !clop_d		;simulator won't tolerate fuses!

	SEG FUSES		;Config fuse area

	.word _XTOSC|_CP|_PWRTE ;Mode: xt osc, no code protext, timer enabled

	.if isdef( IDLOC )      ;if there is an ID area (ie. not 17C42)
	 SEG ID
	 .word	_year&$0f,_month,_day,_hour	 ;set id number to compile time
	.endif
	.endif

        
;*************************************************************************
; START OF CODE
;*************************************************************************

        .include "regs.asm"     ;register definitions
	.include "int.asm"      ;interrupt handler routine - must be first code
        .include "delay.asm"    ;delay macros / code
        .include "reset.asm"    ;reset code
	.include "lcd.asm"      ;lcd display driver
	.include "keys.asm"     ;keyboard driver
	.include "logic.asm"    ;logic probe handler
	.include "main.asm"     ;body and glue code

        seg_report
