%{
#include <stdio.h>
#include "zasm.h"

SENTRY stab[SMAX];
int sptr = 0;

RENTRY refs[RMAX];
int rptr = 0;

int linenum = 0;
int dot = 0;

char wordbuf[LEN];
int isword = 0;
char linebuf[LEN];
int linelen = 0;

int outbyte[3];
int isvalue[3];
int outsize[3];
int isabsol[3];
int outcnt;

%}
%token NAME NUMBER BYTE COMMENT DOT STRING WORD SH_R SH_L
%token ADC  ADD  AND  CALL CCF  CLR  COM  CP   DA   DEC
%token DECW DI   DJNZ EI   INC  INCW IRET JP   JR   LD
%token LDC  LDCI LDE  LDEI NOP  OR   POP  PUSH RCF  RET
%token RL   RLC  RR   RRC  SBC  SCF  SRA  SRP  SUB  SWAP
%token TCM  TM   XOR

%left	'|'
%left	'&'
%left	'+' '-'
%left	'*' '/' '^'
%left	SH_R SH_L
%left	UMINUS
%%
prog	:	
	|	prog line
	;
line	: 	stat '\n'
			{
				do_out();
				reset();
			}
	|	stat COMMENT '\n'	
			{
				do_out();
				reset();
			}
	|	decl stat '\n'
			{
				do_out();
				reset();
			}
	|	decl stat COMMENT '\n'
			{
				do_out();
				reset();
			}
	;
decl	:	NAME ':'	
			{
			if (indx_has($1))
			{
				fprintf(stderr,"multiply defined symbol %s\n",
						indx_symb($1));
			}
			add_indx($1,dot);
			outcnt = 0;
			}	
	;
stat	:	
			{
				outcnt = 0;
			}
	|	cexpr
			{
				outbyte[0] = $1;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	DOT  '=' cexpr
			{
				dot = $3;
				outcnt = 0;
			}
	|	NAME '=' cexpr
			{
				add_indx($1,$3);
				outcnt = 0;
			}	
	|	STRING WORD
			{
				int i;
				int tocnt;
				char wb[256],*to,*from;
				char sb[100];
				to = wb;
				from = wordbuf;
				for(tocnt = 0;*from != '\0';from++)
				{
					switch (*from)
					{
					case '\\':
						switch(*(from+1))
						{
						case 'r' :
							*to++ = '\015';	
							tocnt++;
							from++;
							break;
						case 'n' :
							*to++ = '\012';	
							tocnt++;
							from++;
							break;
						case 't' :
							*to++ = '\011';	
							tocnt++;
							from++;
							break;
						case '0' :
						case '1' :
						case '2' :
						case '3' :
							sb[0] = *(from+1);
							sb[1] = *(from+2);
							sb[2] = *(from+3);
							sb[3] = '\0';
							*to++ = (char)aton(sb,8);
							tocnt++;
							from += 3;
							break;
						default :
							from++;
							*to++ = *from;
							tocnt++;
							break;
						}
						break;
					default :
						*to++ = *from;
						tocnt++;
						break;
					}
				}
				*to = '\0';
				tocnt++;
				for(from=wb,to=wordbuf,i=0;i<tocnt;i++)
				{
					*to++ = *from++;
				}

				for(i=0;(i<tocnt) && (i < 3);i++)
				{
					outbyte[i] = (int)wordbuf[i];
					isvalue[i] = 1;
				}
				outcnt = tocnt;
				isword = 1;
			}
	|	BYTE	cexpr
			{
				if ($2 < 0)
				{
					printf(stderr,
				         "can't allocate less than 0 bytes\n");
					outcnt = 0;
				}
				else
				switch ($2)
				{
					case 0 :
						outcnt = 0;
						break;
					case 1 :
						outcnt = 1;
						outbyte[0] = 0;
						isvalue[0] = 1;
						break;
					case 2 :
						outcnt = 2;
						outbyte[0] = 0;
						isvalue[0] = 1;
						outbyte[1] = 0;
						isvalue[1] = 1;
						break;
					case 3 :
					default :
						outbyte[0] = 0;
						isvalue[0] = 1;
						outbyte[1] = 0;
						isvalue[1] = 1;
						outbyte[2] = 0;
						isvalue[2] = 1;
						outcnt = $2;
						break;
				}
			}
	|	CALL dest
			{
				outbyte[0] = 0xD6;
				isvalue[0] = 1;

				if (isvalue[1])
				{
					outbyte[2] = outbyte[1]&0377;
					isvalue[2] = 1;
					outbyte[1] = (outbyte[1]>>8)&0377;
					isvalue[1] = 1;
				}
				else
				{
					outbyte[2] = outbyte[1];
					isvalue[1] = 0;
					isvalue[2] = 0;
					outsize[1] = 16;
					outsize[2] = 0;
				}
				outcnt = 3;
			}
	|	CALL	'@' dest
			{
				outbyte[0] = 0xD4;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	CCF
			{
				outbyte[0] = 0xEF;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	 CLR	dest
			{
				outbyte[0] = 0xB0;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	 CLR	'@' dest
			{
				outbyte[0] = 0xB1;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	 COM	dest
			{
				outbyte[0] = 0x60;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	 COM	'@' dest
			{
				outbyte[0] = 0x61;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	DA	dest
			{
				outbyte[0] = 0x40;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	DA	'@' dest
			{
				outbyte[0] = 0x41;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	DEC	dest
			{
				outbyte[0] = 0x00;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	DEC	'@' dest
			{
				outbyte[0] = 0x01;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	DECW	dest
			{
				outbyte[0] = 0x80;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	DECW	'@' dest
			{
				outbyte[0] = 0x81;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	DI
			{
				outbyte[0] = 0x08F;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	DJNZ src ',' dest
			{
				if (isvalue[2])
				{
					outbyte[0] =
					  0x0A | (outbyte[2]<<4);
					isvalue[0] = 1;
				}
				else
				{
					printf("panic -- condition flags ill-defined\n");
				}
				if (isvalue[1])
				{
					outbyte[1] = outbyte[1] - (dot+2);
				}
				else
				{
					outbyte[1] = outbyte[2];
					isvalue[1] = 0;
					isabsol[1] = 0;
					outsize[1] = 8;
				}
				outcnt = 2;
			}
	|	EI
			{
				outbyte[0] = 0x9F;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	INC	dest
			{
				outbyte[0] = 0x20;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	INC	'@' dest
			{
				outbyte[0] = 0x21;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	INCW	dest
			{
				outbyte[0] = 0xA0;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	INCW	'@' dest
			{
				outbyte[0] = 0xA1;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	IRET
			{
				outbyte[0] = 0xBF;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	JP src ',' dest
			{
				if (isvalue[2])
				{
					outbyte[0] =
					  0x0D | (outbyte[2]<<4);
					isvalue[0] = 1;
				}
				else
				{
					printf("panic -- condition flags ill-defined\n");
				}
				if (isvalue[1])
				{
					outbyte[2] = outbyte[1]&0377;
					isvalue[2] = 1;
					outbyte[1] = (outbyte[1]>>8)&0377;
					isvalue[1] = 1;
				}
				else
				{
					outbyte[2] = outbyte[1];
					isvalue[1] = 0;
					isvalue[2] = 0;
					outsize[1] = 16;
					outsize[2] = 0;
				}
				outcnt = 3;
			}
	|	JP	'@' dest
			{
				outbyte[0] = 0x30;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	JR	dest ',' src
			{
				if (isvalue[1])
				{
					if ((outbyte[1] > 15) || (outbyte[1] < 0))
					{
						printf("panic -- condition code out of range\n");
					}
					outbyte[0] =
					  0x0B | (outbyte[1]<<4);
					isvalue[0] = 1;
				}
				else
				{
					printf("panic -- condition flags ill-defined\n");
				}
				if (isvalue[2])
				{
					outbyte[1] = outbyte[2] - (dot+2);
					isvalue[1] = 1;
				}
				else
				{
					outbyte[1] = outbyte[2];
					isvalue[1] = 0;
					isabsol[1] = 0;
					outsize[1] = 8;
				}
				outcnt = 2;
			}
	|	LD     dest ',' src
			{
				outbyte[0] = 0xE4;
				isvalue[0] = 1;
				swap_ops();
				outcnt = 3;
			}
	|	LD     dest ',' '@' src
			{
				outbyte[0] = 0xE5;
				isvalue[0] = 1;
				swap_ops();
				outcnt = 3;
			}
	|	LD     dest ',' '#' src
			{
				outbyte[0] = 0xE6;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	LD '@' dest ',' '#' src
			{
				outbyte[0] = 0xE7;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	LD '@' dest ',' src
			{
				outbyte[0] = 0xF5;
				isvalue[0] = 1;
				swap_ops();
				outcnt = 3;
			}
	|	LDC dest ',' '@' src
			{
				outbyte[0]  = 0xC2;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1]  = outbyte[1]<<4;
					outbyte[1] |= outbyte[2];
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			}
	|	LDC '@' dest ',' src
			{
				outbyte[0]  = 0xD2;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1] |= outbyte[2]<<4;
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			}
	|	LDCI dest ',' '@' src
			{
				outbyte[0]  = 0xC3;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1]  = outbyte[1]<<4;
					outbyte[1] |= outbyte[2];
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			}
	|	LDCI '@' dest ',' src
			{
				outbyte[0]  = 0xD3;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1] |= outbyte[2]<<4;
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			}
	|	LDE dest ',' '@' src
			{
				outbyte[0]  = 0x82;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1]  = outbyte[1]<<4;
					outbyte[1] |= outbyte[2];
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			}
	|	LDE '@' dest ',' src
			{
				outbyte[0]  = 0x92;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1] |= outbyte[2]<<4;
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			}
	|	LDEI dest ',' '@' src
			{
				outbyte[0]  = 0x83;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1]  = outbyte[1]<<4;
					outbyte[1] |= outbyte[2];
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			}
	|	LDEI '@' dest ',' src
			{
				outbyte[0]  = 0x93;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1] |= outbyte[2]<<4;
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			}
	|	NOP
			{
				outbyte[0] = 0xFF;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	POP	dest
			{
				outbyte[0] = 0x50;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	POP	'@' dest
			{
				outbyte[0] = 0x51;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	PUSH	dest
			{
				outbyte[0] = 0x70;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	PUSH	'@' dest
			{
				outbyte[0] = 0x71;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	RCF
			{
				outbyte[0] = 0xCF;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	RET
			{
				outbyte[0] = 0xAF;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	RL 	dest
			{
				outbyte[0] = 0x90;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	RL	'@' dest
			{
				outbyte[0] = 0x91;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	RLC	dest
			{
				outbyte[0] = 0x10;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	RLC	'@' dest
			{
				outbyte[0] = 0x11;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	RR	dest
			{
				outbyte[0] = 0xE0;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	RR	'@' dest
			{
				outbyte[0] = 0xE1;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	RRC	dest
			{
				outbyte[0] = 0xC0;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	RRC	'@' dest
			{
				outbyte[0] = 0xC1;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	SCF
			{
				outbyte[0] = 0xDF;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	SRA	dest
			{
				outbyte[0] = 0xD0;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	SRA	'@' dest
			{
				outbyte[0] = 0xD1;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	SRP	'#' dest
			{
				outbyte[0] = 0x31;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	SWAP	dest
			{
				outbyte[0] = 0xF0;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	SWAP	'@' dest
			{
				outbyte[0] = 0xF1;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	two_op    dest ',' src
			{
				outbyte[0] |= 0x04;
				isvalue[0] = 1;
				swap_ops();
				outcnt = 3;
			}
	|	two_op    dest ',' '@' src
			{
				outbyte[0] |= 0x05;
				isvalue[0] = 1;
				swap_ops();
				outcnt = 3;
			}
	|	two_op    dest ',' '#' src
			{
				outbyte[0] |= 0x06;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	two_op '@' dest ',' '#' src
			{
				outbyte[0] |= 0x07;
				isvalue[0] = 1;
				outcnt = 3;
			}
	;
two_op  :	ADC
		{
			outbyte[0] = 0x10;
		}
	|	ADD
		{
			outbyte[0] = 0x00;
		}
	|	AND
		{
			outbyte[0] = 0x50;
		}
	|	CP
		{
			outbyte[0] = 0xA0;
		}
	|	OR
		{
			outbyte[0] = 0x40;
		}
	|	SBC
		{
			outbyte[0] = 0x30;
		}
	|	SUB
		{
			outbyte[0] = 0x20;
		}
	|	TCM
		{
			outbyte[0] = 0x60;
		}
	|	TM
		{
			outbyte[0] = 0x70;
		}
	|	XOR
		{
			outbyte[0] = 0xB0;
		}
	;
dest	:	cexpr
			{
				outbyte[1] = $1;
				isvalue[1] = 1;
			}
	|	NAME
			{
				outbyte[1] = $1;
				isvalue[1] = 0;
				outsize[1] = 8;
			}
	;
src	:	cexpr
			{
				outbyte[2] = $1;
				isvalue[2] = 1;
			}
	|	NAME
			{
				outbyte[2] = $1;
				isvalue[2] = 0;
				outsize[2] = 8;
			}
cexpr	:	NUMBER
	|	DOT
			{
				$$ = dot;
			}
	|	'(' cexpr ')'	
			{
				$$ = $2;
			}
	|	cexpr	'+'	cexpr
			{
				$$ = $1 + $3;
			}
	|	cexpr	'-'	cexpr
			{
				$$ = $1 - $3;
			}
	|	cexpr	'*'	cexpr
			{
				$$ = $1 * $3;
			}
	|	cexpr	'/'	cexpr
			{
				$$ = $1 / $3;
			}
	|	cexpr	'^'	cexpr
			{
				$$ = $1 % $3;
			}
	|	cexpr	'&'	cexpr
			{
				$$ = $1 & $3;
			}
	|	cexpr	'|'	cexpr
			{
				$$ = $1 | $3;
			}
	|	cexpr	SH_R	cexpr
			{
				$$ = $1 >> $3;
			}
	|	cexpr	SH_L	cexpr
			{
				$$ = $1 << $3;
			}
	|	'-' cexpr	%prec UMINUS
			{
				$$ = - $2;
			}
	;
%%
#include "lex.yy.c"
swap_ops()
{
	int ou1,is1,si1,ab1;

	ou1 = outbyte[1];
	is1 = isvalue[1];
	si1 = outsize[1];
	ab1 = isabsol[1];

	outbyte[1] = outbyte[2];
	isvalue[1] = isvalue[2];
	outsize[1] = outsize[2];
	isabsol[1] = isabsol[2];

	outbyte[2] = ou1;
	isvalue[2] = is1;
	outsize[2] = si1;
	isabsol[2] = ab1;
}

do_out()
{
	char *from,*to;
	int i;
	if ((outcnt < 0) )
	{
		fprintf(stderr,"got funny value %d in do_out\n",outcnt);
		return(0);
	}

	fprintf(tmpfile,"%4d\t",linenum);
	if (outcnt > 0)
	{
		fprintf(tmpfile,"%4x\t",dot);
		if (isvalue[0])
		{
			outbyte[0] &= 0377;
			if (outbyte[0] < 16)
			{
				fprintf(tmpfile,"  0%1x\t",outbyte[0]);
			}
			else
			{
				fprintf(tmpfile,"%4x\t",outbyte[0]);
			}
		}
		else
		{
			fprintf(tmpfile,"ZZZZ\t");
			addref(outbyte[0],dot,outsize[0],isabsol[0]);
		}
	}
	else
	{
		fprintf(tmpfile,"....\t....\t");
	}
	from = linebuf;
	/*
	**	print out the contents of the input buffer
	**	up to and including the CR
	*/
	do
	{
		if (*from == '\0')
		{
			fprintf(stderr,"unexpected null in buffer\n");
			exit(0);
		}
		putc(*from,tmpfile);
	} while (*from++ != '\n');

	/*
	**	now shift anything else in the buffer to the
	**	beginning
	*/
	to = linebuf;
	linelen = -1;
	do
	{
		*to++ == *from;
		linelen++;
	} while (*from++ != '\0');
	
	if (outcnt > 1)
	{
		fprintf(tmpfile,"%4d\t%4x\t",linenum,dot+1);
		if (isvalue[1])
		{
			outbyte[1] &= 0377;
			if (outbyte[1] < 16)
			{
				fprintf(tmpfile,"  0%1x\n",outbyte[1]);
			}
			else
			{
				fprintf(tmpfile,"%4x\n",outbyte[1]);
			}
		}
		else
		{
			fprintf(tmpfile,"ZZZZ\n");
			addref(outbyte[1],dot+1,outsize[1],isabsol[1]);
		}
	}
	if (outcnt > 2)
	{
		fprintf(tmpfile,"%4d\t%4x\t",linenum,dot+2);
		if (isvalue[2])
		{
			outbyte[2] &= 0377;
			if (outbyte[2] < 16)
			{
				fprintf(tmpfile,"  0%1x\n",outbyte[2]);
			}
			else
			{
				fprintf(tmpfile,"%4x\n",outbyte[2]);
			}
		}
		else
		{
			fprintf(tmpfile,"ZZZZ\n");
			addref(outbyte[2],dot+2,outsize[2],isabsol[2]);
		}
	}
	for(i=3;i<outcnt;i++)
	{
		if (isword)
		{
			fprintf(tmpfile,"%4d\t%4x\t%4x\n",linenum,dot+i,(int)wordbuf[i]);
		}
		else
		{
			fprintf(tmpfile,"%4d\t%4x\t  00\n",linenum,dot+i);
		}
	}
	isword = 0;
	dot += outcnt;
}

reset()
{
	isabsol[0] = 1;
	isabsol[1] = 1;
	isabsol[2] = 1;
}
