%{
#undef input()
%}
%%
;[\t\40-\176]*$	return(COMMENT);

adc		return(ADC);
add		return(ADD);
and		return(AND);
call		return(CALL);
ccf		return(CCF);

clr		return(CLR);
com		return(COM);
cp		return(CP);
da		return(DA);
dec		return(DEC);

decw		return(DECW);
di		return(DI);
djnz		return(DJNZ);
ei		return(EI);
inc		return(INC);

incw		return(INCW);
iret		return(IRET);
jp		return(JP);
jr		return(JR);
ld		return(LD);

ldc		return(LDC);
ldci		return(LDCI);
lde		return(LDE);
ldei		return(LDEI);
nop		return(NOP);

or		return(OR);
pop		return(POP);
push		return(PUSH);
rcf		return(RCF);
ret		return(RET);

rl		return(RL);
rlc		return(RLC);
rr		return(RR);
rrc		return(RRC);
sbc		return(SBC);

scf		return(SCF);
sra		return(SRA);
srp		return(SRP);
sub		return(SUB);
swap		return(SWAP);

tcm		return(TCM);
tm		return(TM);
xor		return(XOR);

byte		return(BYTE);
string		return(STRING);

\"[\t !\43-\176]*\"		{
					if (yytext[yyleng-2] == '\\')
					{
						yyless(yyleng-1);
						yymore();
					}
					else
					{
						strcpy(wordbuf,yytext+1);
						wordbuf[strlen(wordbuf)-1] = '\0';
						return(WORD);
					}
				}
"."		return(DOT);
":"		return(':');
"+"		return('+');
"^"		return('^');
"/"		return('/');
"*"		return('*');
"-"		return('-');
"&"		return('&');
"|"		return('|');
"<<"		return(SH_L);
">>"		return(SH_R);
"("		return('(');
")"		return(')');

","		return(',');
"="		return('=');
"@"		return('@');
"#"		return('#');
[a-zA-Z_\.][a-z0-9A-Z_\.]*  {
			if(is_symb(yytext))
			{ 
				if (symb_has(yytext))
				{
					yylval = symb_val(yytext);
					return(NUMBER);
				}
				else
				{
					yylval = symb_to_indx(yytext);
					return(NAME);
				}
			}
			yylval = add_symb(yytext);
			return(NAME);
		}
[ \t]	;
[\n]		{
			linenum++ ;
			return('\n');
		}
0[0-7]*		{
			yylval = aton(yytext,8);
			return(NUMBER);
		}
[1-9][0-9]*	{
			yylval = aton(yytext,10);
			return(NUMBER);	
		}
0[x][0-9A-Fa-f]+	{
			yylval = aton(yytext+2,16);
			return(NUMBER);
		}
%[0-9A-Fa-f]+	{
			yylval = aton(yytext+1,16);
			return(NUMBER);
		}

%%
input()
{
	return(((yytchar=yysptr>yysbuf?U(*--yysptr):mygetc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar);
}

mygetc(ptr)
FILE *ptr;
{
	linebuf[linelen++] = getc(ptr);
	linebuf[linelen] = '\0';
	return(linebuf[linelen-1]);
}

