%{
#define	SMAX	1000
#define RMAX	1000
#define	LEN	256

extern char *int_symb();
extern char *indx_symb();
typedef struct blob {
	char string[LEN];
	int  val_flag;
	int  value;
}	SENTRY;
SENTRY stab[SMAX];
int sptr = 0;

typedef struct zarg {
	int where;
	int indx;
	int size;
}	RENTRY;
RENTRY refs[RMAX];
int rptr = 0;

int linenum = 0;
int dot = 0;

char linebuf[LEN];
int linelen = 0;

int outbyte[3];
int isvalue[3];
int outsize[3];
int outcnt;

%}
%token NAME NUMBER BYTE COMMENT DOT
%token ADC  ADD  AND  CALL CCF  CLR  COM  CP   DA   DEC
%token DECW DI   DJNZ EI   INC  INCW IRET JP   JR   LD
%token LDC  LDCI LDE  LDEI NOP  OR   POP  PUSH RCF  RET
%token RL   RLC  RR   RRC  SBC  SCF  SRA  SRP  SUB  SWAP
%token TCM  TM   XOR
%%
prog	:	
	|	prog line
	;
line	: 	stat '\n'
			{
				do_out();
			}
	|	stat COMMENT '\n'	
			{
				do_out();
			}
	|	decl stat '\n'
			{
				do_out();
			}
	|	decl stat COMMENT '\n'
			{
				do_out();
			}
	;
decl	:	NAME ':'	
			{
			if (indx_has($1))
			{
				fprintf(stderr,"multiply defined symbol %s\n",
						indx_symb($1));
			}
			add_indx($1,dot);
			outcnt = 0;
			}	
	;
stat	:	
			{
				outcnt = 0;
			}
	|	cexpr
			{
				outbyte[0] = $1;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	DOT  '=' cexpr
			{
				dot = $3;
				outcnt = 0;
			}
	|	NAME '=' cexpr
			{
				add_indx($1,$3);
				outcnt = 0;
			}	
	|	BYTE	cexpr
			{
				if ($2 < 0)
				{
					printf(stderr,
				         "can't allocate less than 0 bytes\n");
					outcnt = 0;
				}
				else
				switch ($2)
				{
					case 0 :
						outcnt = 0;
						break;
					case 1 :
						outcnt = 1;
						outbyte[0] = 0;
						isvalue[0] = 1;
						break;
					case 2 :
						outcnt = 2;
						outbyte[0] = 0;
						isvalue[0] = 1;
						outbyte[1] = 0;
						isvalue[1] = 1;
						break;
					case 3 :
					default :
						outbyte[0] = 0;
						isvalue[0] = 1;
						outbyte[1] = 0;
						isvalue[1] = 1;
						outbyte[2] = 0;
						isvalue[2] = 1;
						outcnt = $2;
						break;
				}
			}
	|	ADC     dest ',' src
			{
				outbyte[0] = 0x14;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	ADC     dest ',' '@' src
			{
				outbyte[0] = 0x15;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	ADC     dest ',' '#' src
			{
				outbyte[0] = 0x16;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	ADC '@' dest ',' '#' src
			{
				outbyte[0] = 0x17;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	ADD     dest ',' src
			{
				outbyte[0] = 0x04;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	ADD     dest ',' '@' src
			{
				outbyte[0] = 0x05;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	ADD     dest ',' '#' src
			{
				outbyte[0] = 0x06;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	ADD '@' dest ',' '#' src
			{
				outbyte[0] = 0x07;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	AND     dest ',' src
			{
				outbyte[0] = 0x54;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	AND     dest ',' '@' src
			{
				outbyte[0] = 0x55;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	AND     dest ',' '#' src
			{
				outbyte[0] = 0x56;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	AND '@' dest ',' '#' src
			{
				outbyte[0] = 0x57;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	CALL dest
			{
				outbyte[0] = 0xD6;
				isvalue[0] = 1;

				if (isvalue[1])
				{
					outbyte[2] = outbyte[1]&0377;
					isvalue[2] = 1;
					outbyte[1] = (outbyte[1]>>8)&0377;
					isvalue[1] = 1;
				}
				else
				{
					outbyte[2] = outbyte[1];
					isvalue[1] = 0;
					isvalue[2] = 0;
					outsize[1] = 16;
					outsize[2] = 0;
				}
				outcnt = 3;
			}
	|	CALL	'@' dest
			{
				outbyte[0] = 0xD4;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	CCF
			{
				outbyte[0] = 0xEF;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	 CLR	dest
			{
				outbyte[0] = 0xB0;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	 CLR	'@' dest
			{
				outbyte[0] = 0xB1;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	 COM	dest
			{
				outbyte[0] = 0x60;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	 COM	'@' dest
			{
				outbyte[0] = 0x61;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	CP	dest ',' src
			{
				outbyte[0] = 0xA4;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	CP     dest ',' '@' src
			{
				outbyte[0] = 0xA5;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	CP     dest ',' '#' src
			{
				outbyte[0] = 0xA6;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	CP '@' dest ',' '#' src
			{
				outbyte[0] = 0xA7;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	DA	dest
			{
				outbyte[0] = 0x40;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	DA	'@' dest
			{
				outbyte[0] = 0x41;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	DEC	dest
			{
				outbyte[0] = 0x00;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	DEC	'@' dest
			{
				outbyte[0] = 0x01;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	DECW	dest
			{
				outbyte[0] = 0x80;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	DECW	'@' dest
			{
				outbyte[0] = 0x81;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	DI
			{
				outbyte[0] = 0x08F;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	DJNZ src ',' dest
			{
				if (isvalue[2])
				{
					outbyte[0] =
					  0x0A | (outbyte[2]<<4);
					isvalue[0] = 1;
				}
				else
				{
					printf("panic -- condition flags ill-defined\n");
				}
				if (isvalue[1])
				{
					outbyte[1] = outbyte[1] - (dot+2);
				}
				else
				{
					fprintf(stderr,"can't forward reference with DJNZ\n");
				}
				outcnt = 2;
			}
	|	EI
			{
				outbyte[0] = 0x9F;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	INC	dest
			{
				outbyte[0] = 0x20;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	INC	'@' dest
			{
				outbyte[0] = 0x21;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	INCW	dest
			{
				outbyte[0] = 0xA0;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	INCW	'@' dest
			{
				outbyte[0] = 0xA1;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	IRET
			{
				outbyte[0] = 0xBF;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	JP src ',' dest
			{
				if (isvalue[2])
				{
					outbyte[0] =
					  0x0D | (outbyte[2]<<4);
					isvalue[0] = 1;
				}
				else
				{
					printf("panic -- condition flags ill-defined\n");
				}
				if (isvalue[1])
				{
					outbyte[2] = outbyte[1]&0377;
					isvalue[2] = 1;
					outbyte[1] = (outbyte[1]>>8)&0377;
					isvalue[1] = 1;
				}
				else
				{
					outbyte[2] = outbyte[1];
					isvalue[1] = 0;
					isvalue[2] = 0;
					outsize[1] = 16;
					outsize[2] = 0;
				}
				outcnt = 3;
			}
	|	JP	'@' dest
			{
				outbyte[0] = 0x30;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	JR	dest
			{
				if (isvalue[2])
				{
					outbyte[0] =
					  0x0B | (outbyte[2]<<4);
					isvalue[0] = 1;
				}
				else
				{
					printf("panic -- condition flags ill-defined\n");
				}
				if (isvalue[1])
				{
					outbyte[1] = outbyte[1] - (dot+2);
				}
				else
				{
					fprintf(stderr,"can't forward reference with JR\n");
				}
				outcnt = 2;
			}
	|	LD     dest ',' src
			{
				outbyte[0] = 0xE4;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	LD     dest ',' '@' src
			{
				outbyte[0] = 0xE5;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	LD     dest ',' '#' src
			{
				outbyte[0] = 0xE6;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	LD '@' dest ',' '#' src
			{
				outbyte[0] = 0xE7;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	LD '@' dest ',' src
			{
				outbyte[0] = 0xF5;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	LDC dest ',' '@' src
			{
				outbyte[0]  = 0xC2;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1]  = outbyte[1]<<4;
					outbyte[1] |= outbyte[2];
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			}
	|	LDC '@' dest ',' src
			{
				outbyte[0]  = 0xD2;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1] |= outbyte[2]<<4;
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			}
	|	LDCI dest ',' '@' src
			{
				outbyte[0]  = 0xC3;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1]  = outbyte[1]<<4;
					outbyte[1] |= outbyte[2];
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			}
	|	LDCI '@' dest ',' src
			{
				outbyte[0]  = 0xD3;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1] |= outbyte[2]<<4;
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			}
	|	LDE dest ',' '@' src
			{
				outbyte[0]  = 0x82;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1]  = outbyte[1]<<4;
					outbyte[1] |= outbyte[2];
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			}
	|	LDE '@' dest ',' src
			{
				outbyte[0]  = 0x92;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1] |= outbyte[2]<<4;
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			}
	|	LDEI dest ',' '@' src
			{
				outbyte[0]  = 0x83;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1]  = outbyte[1]<<4;
					outbyte[1] |= outbyte[2];
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			}
	|	LDEI '@' dest ',' src
			{
				outbyte[0]  = 0x93;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1] |= outbyte[2]<<4;
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			}
	|	NOP
			{
				outbyte[0] = 0xFF;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	OR      dest ',' src
			{
				outbyte[0] = 0x44;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	OR      dest ',' '@' src
			{
				outbyte[0] = 0x45;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	OR      dest ',' '#' src
			{
				outbyte[0] = 0x46;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	OR  '@' dest ',' '#' src
			{
				outbyte[0] = 0x47;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	POP	dest
			{
				outbyte[0] = 0x50;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	POP	'@' dest
			{
				outbyte[0] = 0x51;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	PUSH	dest
			{
				outbyte[0] = 0x70;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	PUSH	'@' dest
			{
				outbyte[0] = 0x71;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	RCF
			{
				outbyte[0] = 0xCF;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	RET
			{
				outbyte[0] = 0xAF;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	RL 	dest
			{
				outbyte[0] = 0x90;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	RL	'@' dest
			{
				outbyte[0] = 0x91;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	RLC	dest
			{
				outbyte[0] = 0x10;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	RLC	'@' dest
			{
				outbyte[0] = 0x11;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	RR	dest
			{
				outbyte[0] = 0xE0;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	RR	'@' dest
			{
				outbyte[0] = 0xE1;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	RRC	dest
			{
				outbyte[0] = 0xC0;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	RRC	'@' dest
			{
				outbyte[0] = 0xC1;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	SBC     dest ',' src
			{
				outbyte[0] = 0x34;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	SBC     dest ',' '@' src
			{
				outbyte[0] = 0x35;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	SBC     dest ',' '#' src
			{
				outbyte[0] = 0x36;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	SBC '@' dest ',' '#' src
			{
				outbyte[0] = 0x37;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	SCF
			{
				outbyte[0] = 0xDF;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	SRA	dest
			{
				outbyte[0] = 0xD0;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	SRA	'@' dest
			{
				outbyte[0] = 0xD1;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	SRP	'#' dest
			{
				outbyte[0] = 0x31;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	SUB     dest ',' src
			{
				outbyte[0] = 0x24;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	SUB     dest ',' '@' src
			{
				outbyte[0] = 0x25;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	SUB     dest ',' '#' src
			{
				outbyte[0] = 0x26;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	SUB '@' dest ',' '#' src
			{
				outbyte[0] = 0x27;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	SWAP	dest
			{
				outbyte[0] = 0xF0;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	SWAP	'@' dest
			{
				outbyte[0] = 0xF1;
				isvalue[0] = 1;
				outcnt = 2;
			}
	|	TCM     dest ',' src
			{
				outbyte[0] = 0x64;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	TCM     dest ',' '@' src
			{
				outbyte[0] = 0x65;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	TCM     dest ',' '#' src
			{
				outbyte[0] = 0x66;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	TCM '@' dest ',' '#' src
			{
				outbyte[0] = 0x67;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	TM      dest ',' src
			{
				outbyte[0] = 0x74;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	TM      dest ',' '@' src
			{
				outbyte[0] = 0x75;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	TM      dest ',' '#' src
			{
				outbyte[0] = 0x76;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	TM  '@' dest ',' '#' src
			{
				outbyte[0] = 0x77;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	XOR     dest ',' src
			{
				outbyte[0] = 0xB4;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	XOR     dest ',' '@' src
			{
				outbyte[0] = 0xB5;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	XOR     dest ',' '#' src
			{
				outbyte[0] = 0xB6;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	XOR '@' dest ',' '#' src
			{
				outbyte[0] = 0xB7;
				isvalue[0] = 1;
				outcnt = 3;
			}
	;
dest	:	cexpr
			{
				outbyte[1] = $1;
				isvalue[1] = 1;
			}
	|	NAME
			{
				outbyte[1] = $1;
				isvalue[1] = 0;
				outsize[1] = 8;
			}
	;
src	:	cexpr
			{
				outbyte[2] = $1;
				isvalue[2] = 1;
			}
	|	NAME
			{
				outbyte[2] = $1;
				isvalue[2] = 0;
				outsize[1] = 8;
			}
cexpr	:	NUMBER
	|	DOT
			{
				$$ = dot;
			}
	;
%%
#include "lex.yy.c"
do_out()
{
	char *from,*to;
	int i;
	if ((outcnt < 0) )
	{
		fprintf(stderr,"got funny value %d in do_out\n",outcnt);
		return(0);
	}

	printf("%4d\t",linenum);
	if (outcnt > 0)
	{
		printf("%4x\t",dot);
		if (isvalue[0])
		{
			printf("%4x\t",outbyte[0]);
		}
		else
		{
			printf("ZZZZ\t");
			addref(outbyte[0],dot,outsize[0]);
		}
	}
	else
	{
		printf("....\t....\t");
	}
	from = linebuf;
	/*
	**	print out the contents of the input buffer
	**	up to and including the CR
	*/
	do
	{
		if (*from == '\0')
		{
			fprintf(stderr,"unexpected null in buffer\n");
			exit(0);
		}
		putchar(*from);
	} while (*from++ != '\n');

	/*
	**	now shift anything else in the buffer to the
	**	beginning
	*/
	to = linebuf;
	linelen = -1;
	do
	{
		*to++ == *from;
		linelen++;
	} while (*from++ != '\0');
	
	if (outcnt > 1)
	{
		printf("%4d\t%4x\t",linenum,dot+1);
		if (isvalue[1])
		{
			printf("%4x\n",outbyte[1]);
		}
		else
		{
			printf("ZZZZ\n");
			addref(outbyte[1],dot+1,outsize[1]);
		}
	}
	if (outcnt > 2)
	{
		printf("%4d\t%4x\t",linenum,dot+2);
		if (isvalue[2])
		{
			printf("%4x\n",outbyte[2]);
		}
		else
		{
			printf("ZZZZ\n");
			addref(outbyte[2],dot+2,outsize[2]);
		}
	}
	for(i=3;i<outcnt;i++)
	{
		printf("%4d\t%4x\t%4x\n",linenum,dot+i,0);
	}
	dot += outcnt;
}

addref(index,loc,bits)
int index,loc,bits;
{
	refs[rptr].indx = index;
	refs[rptr].where= loc;
	refs[rptr].size = bits;
	rptr++;
}
is_symb(ptr)
char *ptr;
{
	return(symb_to_indx(ptr) >= 0);
}
is_indx(index)
int index;
{
	return((index >= 0) && (index < sptr));
}
symb_has(ptr)
char *ptr;
{
	int tmp;
	if ((tmp = symb_to_indx(ptr)) >= 0)
	{
		return(indx_has(tmp));
	}
	fprintf(stderr,"symb_has called with unknown symbol %s\n",ptr);
}

indx_has(index)
int index;
{
	return(stab[index].val_flag);
}

add_symb(ptr)
char *ptr;
{
	strcpy(stab[sptr].string,ptr);
	stab[sptr].val_flag = 0;
	sptr++;
	return(sptr-1);
}
add_indx(index,val)
int index,val;
{
	if (is_indx(index))
	{
		if (!indx_has(index))
		{
			stab[index].value = val;
			stab[index].val_flag = 1;
		}
		else
		{
			fprintf(stderr,
				"assigning a second value to symbol %d %d\n",
				index,val);
		}
	}
	else
	{
		fprintf(stderr,"add_indx called with illegal value %d\n",
			index);
	}
}
symb_val(ptr)
char *ptr;
{
	return(indx_val(symb_to_indx(ptr)));
}
indx_val(index)
{
	if (is_indx(index))
	{
		if (indx_has(index))
		{
			return(stab[index].value);
		}
		else
		{
			fprintf(stderr,
				"trying to get unset value with index %d",
				index);
		}
	}
	else
	{
		fprintf(stderr,"indx_val called with bad index %d\n",index);
	}
}
char *
indx_symb(index)
int index;
{
	if (is_indx(index))
	{
		return(stab[index].string);
	}
	fprintf(stderr,"indx_symb called with bad value %d",index);
}

symb_to_indx(ptr)
char *ptr;
{
	int i;
	for(i=0;i<sptr;i++)
	{
		if (!strcmp(stab[i].string,ptr))
		{
			return(i);
		}
	}
	return(-1);
}

dumptab()
{
	int i;
	printf("SYMBOLS\n");
	for (i=0;i<sptr;i++)
	{
		if (stab[i].val_flag)
		{
			printf("%s\t%x\n",stab[i].string,stab[i].value);
		}
		else
		{
			printf("%s\tUNDEFINED\n",stab[i].string);
		}
	}
	printf("REFERENCES\n");
	for (i=0;i<rptr;i++)
	{
		if (stab[refs[i].indx].val_flag)
		{
			printf("%x\t%d\t%x\n",
				refs[i].where,
				refs[i].size,
				stab[refs[i].indx].value);
		}
		else
		{
			printf("%x\t%d\tindex = %d, %s UNDEFINED\n",
				refs[i].where,
				refs[i].size,
				refs[i].indx,
				stab[refs[i].indx].string);
		}
	}
}
