%{
#define	SMAX	1000
#define RMAX	1000
#define	LEN	256

extern char *int_symb();
extern char *indx_symb();
typedef struct blob {
	char string[LEN];
	int  val_flag;
	int  value;
}	SENTRY;
SENTRY stab[SMAX];
int sptr = 0;

typedef struct zarg {
	int where;
	int indx;
	int size;
}	RENTRY;
RENTRY refs[RMAX];
int rptr = 0;

int linenum = 0;
int dot = 0;

char linebuf[LEN];
int linelen = 0;

int outbyte[3];
int isvalue[3];
int outsize[3];
int outcnt;

%}
%token NAME NUMBER BYTE COMMENT DOT
%token NOP ADC ADD AND CALL JP
%%
prog	:	
	|	prog line
	;
line	: 	stat '\n'
			{
				do_out();
			}
	|	stat COMMENT '\n'	
			{
				do_out();
			}
	|	decl stat '\n'
			{
				do_out();
			}
	|	decl stat COMMENT '\n'
			{
				do_out();
			}
	;
decl	:	NAME ':'	
			{
			if (indx_has($1))
			{
				fprintf(stderr,"multiply defined symbol %s\n",
						indx_symb($1));
			}
			add_indx($1,dot);
			outcnt = 0;
			}	
	;
stat	:	
			{
				outcnt = 0;
			}
	|	cexpr
			{
				outbyte[0] = $1;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	DOT  '=' cexpr
			{
				dot = $3;
				outcnt = 0;
			}
	|	NAME '=' cexpr
			{
				add_indx($1,$3);
				outcnt = 0;
			}	
	|	BYTE	cexpr
			{
				if ($2 < 0)
				{
					printf(stderr,
				         "can't allocate less than 0 bytes\n");
					outcnt = 0;
				}
				else
				switch ($2)
				{
					case 0 :
						outcnt = 0;
						break;
					case 1 :
						outcnt = 1;
						outbyte[0] = 0;
						isvalue[0] = 1;
						break;
					case 2 :
						outcnt = 2;
						outbyte[0] = 0;
						isvalue[0] = 1;
						outbyte[1] = 0;
						isvalue[1] = 1;
						break;
					case 3 :
					default :
						outbyte[0] = 0;
						isvalue[0] = 1;
						outbyte[1] = 0;
						isvalue[1] = 1;
						outbyte[2] = 0;
						isvalue[2] = 1;
						outcnt = $2;
						break;
				}
			}
	|	NOP
			{
				outbyte[0] = 0xFF;
				isvalue[0] = 1;
				outcnt = 1;
			}
	|	ADC     dest ',' src
			{
				outbyte[0] = 0x14;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	ADC     dest ',' '@' src
			{
				outbyte[0] = 0x15;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	ADC     dest ',' '#' src
			{
				outbyte[0] = 0x16;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	ADC '@' dest ',' '#' src
			{
				outbyte[0] = 0x17;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	ADD     dest ',' src
			{
				outbyte[0] = 0x04;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	ADD     dest ',' '@' src
			{
				outbyte[0] = 0x05;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	ADD     dest ',' '#' src
			{
				outbyte[0] = 0x06;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	ADD '@' dest ',' '#' src
			{
				outbyte[0] = 0x07;
				isvalue[0] = 1;
				outcnt = 3;
			}
	|	JP src ',' dest
			{
				if (isvalue[2])
				{
					outbyte[0] =
					  0x0D | (outbyte[2]<<4);
					isvalue[0] = 1;
				}
				else
				{
					printf("panic -- condition flags ill-defined\n");
				}
				if (isvalue[1])
				{
					outbyte[2] = outbyte[1]&0377;
					isvalue[2] = 1;
					outbyte[1] = (outbyte[1]>>8)&0377;
					isvalue[1] = 1;
				}
				else
				{
					outbyte[2] = outbyte[1];
					isvalue[1] = 0;
					isvalue[2] = 0;
					outsize[1] = 16;
					outsize[2] = 0;
				}
				outcnt = 3;
			}
	;
dest	:	cexpr
			{
				outbyte[1] = $1;
				isvalue[1] = 1;
			}
	|	NAME
			{
				outbyte[1] = $1;
				isvalue[1] = 0;
				outsize[1] = 8;
			}
	;
src	:	cexpr
			{
				outbyte[2] = $1;
				isvalue[2] = 1;
			}
	|	NAME
			{
				outbyte[2] = $1;
				isvalue[2] = 0;
				outsize[1] = 8;
			}
cexpr	:	NUMBER
	|	DOT
			{
				$$ = dot;
			}
	;
%%
#include "lex.yy.c"
do_out()
{
	char *from,*to;
	int i;
	if ((outcnt < 0) )
	{
		fprintf(stderr,"got funny value %d in do_out\n",outcnt);
		return(0);
	}

	printf("%4d\t",linenum);
	if (outcnt > 0)
	{
		printf("%4x\t",dot);
		if (isvalue[0])
		{
			printf("%4x\t",outbyte[0]);
		}
		else
		{
			printf("ZZZZ\t");
			addref(outbyte[0],dot,outsize[0]);
		}
	}
	else
	{
		printf("....\t....\t");
	}
	from = linebuf;
	/*
	**	print out the contents of the input buffer
	**	up to and including the CR
	*/
	do
	{
		if (*from == '\0')
		{
			fprintf(stderr,"unexpected null in buffer\n");
			exit(0);
		}
		putchar(*from);
	} while (*from++ != '\n');

	/*
	**	now shift anything else in the buffer to the
	**	beginning
	*/
	to = linebuf;
	linelen = -1;
	do
	{
		*to++ == *from;
		linelen++;
	} while (*from++ != '\0');
	
	if (outcnt > 1)
	{
		printf("%4d\t%4x\t",linenum,dot+1);
		if (isvalue[1])
		{
			printf("%4x\n",outbyte[1]);
		}
		else
		{
			printf("ZZZZ\n");
			addref(outbyte[1],dot+1,outsize[1]);
		}
	}
	if (outcnt > 2)
	{
		printf("%4d\t%4x\t",linenum,dot+2);
		if (isvalue[2])
		{
			printf("%4x\n",outbyte[2]);
		}
		else
		{
			printf("ZZZZ\n");
			addref(outbyte[2],dot+2,outsize[2]);
		}
	}
	for(i=3;i<outcnt;i++)
	{
		printf("%4d\t%4x\t%4x\n",linenum,dot+i,0);
	}
	dot += outcnt;
}

addref(index,loc,bits)
int index,loc,bits;
{
	refs[rptr].indx = index;
	refs[rptr].where= loc;
	refs[rptr].size = bits;
	rptr++;
}
is_symb(ptr)
char *ptr;
{
	return(symb_to_indx(ptr) >= 0);
}
is_indx(index)
int index;
{
	return((index >= 0) && (index < sptr));
}
symb_has(ptr)
char *ptr;
{
	int tmp;
	if ((tmp = symb_to_indx(ptr)) >= 0)
	{
		return(indx_has(tmp));
	}
	fprintf(stderr,"symb_has called with unknown symbol %s\n",ptr);
}

indx_has(index)
int index;
{
	return(stab[index].val_flag);
}

add_symb(ptr)
char *ptr;
{
	strcpy(stab[sptr].string,ptr);
	stab[sptr].val_flag = 0;
	sptr++;
	return(sptr-1);
}
add_indx(index,val)
int index,val;
{
	if (is_indx(index))
	{
		if (!indx_has(index))
		{
			stab[index].value = val;
			stab[index].val_flag = 1;
		}
		else
		{
			fprintf(stderr,
				"assigning a second value to symbol %d %d\n",
				index,val);
		}
	}
	else
	{
		fprintf(stderr,"add_indx called with illegal value %d\n",
			index);
	}
}
symb_val(ptr)
char *ptr;
{
	return(indx_val(symb_to_indx(ptr)));
}
indx_val(index)
{
	if (is_indx(index))
	{
		if (indx_has(index))
		{
			return(stab[index].value);
		}
		else
		{
			fprintf(stderr,
				"trying to get unset value with index %d",
				index);
		}
	}
	else
	{
		fprintf(stderr,"indx_val called with bad index %d\n",index);
	}
}
char *
indx_symb(index)
int index;
{
	if (is_indx(index))
	{
		return(stab[index].string);
	}
	fprintf(stderr,"indx_symb called with bad value %d",index);
}

symb_to_indx(ptr)
char *ptr;
{
	int i;
	for(i=0;i<sptr;i++)
	{
		if (!strcmp(stab[i].string,ptr))
		{
			return(i);
		}
	}
	return(-1);
}

dumptab()
{
	int i;
	printf("SYMBOLS\n");
	for (i=0;i<sptr;i++)
	{
		if (stab[i].val_flag)
		{
			printf("%s\t%x\n",stab[i].string,stab[i].value);
		}
		else
		{
			printf("%s\tUNDEFINED\n",stab[i].string);
		}
	}
	printf("REFERENCES\n");
	for (i=0;i<rptr;i++)
	{
		if (stab[refs[i].indx].val_flag)
		{
			printf("%x\t%d\t%x\n",
				refs[i].where,
				refs[i].size,
				stab[refs[i].indx].value);
		}
		else
		{
			printf("%x\t%d\tindex = %d, %s UNDEFINED\n",
				refs[i].where,
				refs[i].size,
				refs[i].indx,
				stab[refs[i].indx].string);
		}
	}
}
