#include <stdio.h>
#include "zasm.h"

addref(idex,loc,bits,isabs)
int idex,loc,bits,isabs;
{
	refs[rptr].indx = idex;
	refs[rptr].where= loc;
	refs[rptr].size = bits;
	refs[rptr].abs = isabs;
	rptr++;
}
is_symb(ptr)
char *ptr;
{
	return(symb_to_indx(ptr) >= 0);
}

is_indx(idex)
int idex;
{
	return((idex >= 0) && (idex < sptr));
}

symb_has(ptr)
char *ptr;
{
	int tmp;
	if ((tmp = symb_to_indx(ptr)) >= 0)
	{
		return(indx_has(tmp));
	}
	fprintf(stderr,"symb_has called with unknown symbol %s\n",ptr);
}

indx_has(idex)
int idex;
{
	return(stab[idex].val_flag);
}

add_symb(ptr)
char *ptr;
{
	strcpy(stab[sptr].string,ptr);
	stab[sptr].val_flag = 0;
	sptr++;
	return(sptr-1);
}
add_indx(idex,val)
int idex,val;
{
	if (is_indx(idex))
	{
		if (!indx_has(idex))
		{
			stab[idex].value = val;
			stab[idex].val_flag = 1;
		}
		else
		{
			fprintf(stderr,
				"assigning a second value to symbol %d %d\n",
				idex,val);
		}
	}
	else
	{
		fprintf(stderr,"add_indx called with illegal value %d\n",
			idex);
	}
}
symb_val(ptr)
char *ptr;
{
	return(indx_val(symb_to_indx(ptr)));
}
indx_val(idex)
int idex;
{
	if (is_indx(idex))
	{
		if (indx_has(idex))
		{
			return(stab[idex].value);
		}
		else
		{
			fprintf(stderr,
				"trying to get unset value with index %d",
				idex);
		}
	}
	else
	{
		fprintf(stderr,"indx_val called with bad index %d\n",idex);
	}
}
char *
indx_symb(idex)
int idex;
{
	if (is_indx(idex))
	{
		return(stab[idex].string);
	}
	fprintf(stderr,"indx_symb called with bad value %d",idex);
}

symb_to_indx(ptr)
char *ptr;
{
	int i;
	for(i=0;i<sptr;i++)
	{
		if (!strcmp(stab[i].string,ptr))
		{
			return(i);
		}
	}
	return(-1);
}

dumptab()
{
	int i;
	fprintf(tmpfile,"SYMBOLS\n");
	fprintf(tmpfile,"Name\tValue\n");
	for (i=0;i<sptr;i++)
	{
		if (stab[i].val_flag)
		{
			fprintf(tmpfile,"%s\t%x\n",stab[i].string,stab[i].value);
		}
		else
		{
			fprintf(tmpfile,"%s\tUNDEFINED\n",stab[i].string);
		}
	}
	fprintf(tmpfile,"REFERENCES\n");
	fprintf(tmpfile,"Addr\tSize\tAbs\tIndex\tValue\n");
	for (i=0;i<rptr;i++)
	{
		if (stab[refs[i].indx].val_flag)
		{
			fprintf(tmpfile,"%x\t%d\t%d\t%d\t%x\n",
				refs[i].where,
				refs[i].size,
				refs[i].abs,
				refs[i].indx,
				stab[refs[i].indx].value);
		}
		else
		{
			fprintf(tmpfile,"%x\t%d\tindex = %d, %s UNDEFINED\n",
				refs[i].where,
				refs[i].size,
				refs[i].indx,
				stab[refs[i].indx].string);
		}
	}
}
