
# line 2 "gram.y"
#include <stdio.h>
#include "zasm.h"

SENTRY stab[SMAX];
int sptr = 0;

RENTRY refs[RMAX];
int rptr = 0;

int linenum = 0;
int dot = 0;

char wordbuf[LEN];
int isword = 0;
char linebuf[LEN];
int linelen = 0;

int outbyte[3];
int isvalue[3];
int outsize[3];
int isabsol[3];
int outcnt;

# define NAME 257
# define NUMBER 258
# define BYTE 259
# define COMMENT 260
# define DOT 261
# define STRING 262
# define WORD 263
# define SH_R 264
# define SH_L 265
# define ADC 266
# define ADD 267
# define AND 268
# define CALL 269
# define CCF 270
# define CLR 271
# define COM 272
# define CP 273
# define DA 274
# define DEC 275
# define DECW 276
# define DI 277
# define DJNZ 278
# define EI 279
# define INC 280
# define INCW 281
# define IRET 282
# define JP 283
# define JR 284
# define LD 285
# define LDC 286
# define LDCI 287
# define LDE 288
# define LDEI 289
# define NOP 290
# define OR 291
# define POP 292
# define PUSH 293
# define RCF 294
# define RET 295
# define RL 296
# define RLC 297
# define RR 298
# define RRC 299
# define SBC 300
# define SCF 301
# define SRA 302
# define SRP 303
# define SUB 304
# define SWAP 305
# define TCM 306
# define TM 307
# define XOR 308
# define UMINUS 309
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 845 "gram.y"

#include "lex.yy.c"
swap_ops()
{
	int ou1,is1,si1,ab1;

	ou1 = outbyte[1];
	is1 = isvalue[1];
	si1 = outsize[1];
	ab1 = isabsol[1];

	outbyte[1] = outbyte[2];
	isvalue[1] = isvalue[2];
	outsize[1] = outsize[2];
	isabsol[1] = isabsol[2];

	outbyte[2] = ou1;
	isvalue[2] = is1;
	outsize[2] = si1;
	isabsol[2] = ab1;
}

do_out()
{
	char *from,*to;
	int i;
	if ((outcnt < 0) )
	{
		fprintf(stderr,"got funny value %d in do_out\n",outcnt);
		return(0);
	}

	fprintf(tmpfile,"%4d\t",linenum);
	if (outcnt > 0)
	{
		fprintf(tmpfile,"%4x\t",dot);
		if (isvalue[0])
		{
			outbyte[0] &= 0377;
			if (outbyte[0] < 16)
			{
				fprintf(tmpfile,"  0%1x\t",outbyte[0]);
			}
			else
			{
				fprintf(tmpfile,"%4x\t",outbyte[0]);
			}
		}
		else
		{
			fprintf(tmpfile,"ZZZZ\t");
			addref(outbyte[0],dot,outsize[0],isabsol[0]);
		}
	}
	else
	{
		fprintf(tmpfile,"....\t....\t");
	}
	from = linebuf;
	/*
	**	print out the contents of the input buffer
	**	up to and including the CR
	*/
	do
	{
		if (*from == '\0')
		{
			fprintf(stderr,"unexpected null in buffer\n");
			exit(0);
		}
		putc(*from,tmpfile);
	} while (*from++ != '\n');

	/*
	**	now shift anything else in the buffer to the
	**	beginning
	*/
	to = linebuf;
	linelen = -1;
	do
	{
		*to++ == *from;
		linelen++;
	} while (*from++ != '\0');
	
	if (outcnt > 1)
	{
		fprintf(tmpfile,"%4d\t%4x\t",linenum,dot+1);
		if (isvalue[1])
		{
			outbyte[1] &= 0377;
			if (outbyte[1] < 16)
			{
				fprintf(tmpfile,"  0%1x\n",outbyte[1]);
			}
			else
			{
				fprintf(tmpfile,"%4x\n",outbyte[1]);
			}
		}
		else
		{
			fprintf(tmpfile,"ZZZZ\n");
			addref(outbyte[1],dot+1,outsize[1],isabsol[1]);
		}
	}
	if (outcnt > 2)
	{
		fprintf(tmpfile,"%4d\t%4x\t",linenum,dot+2);
		if (isvalue[2])
		{
			outbyte[2] &= 0377;
			if (outbyte[2] < 16)
			{
				fprintf(tmpfile,"  0%1x\n",outbyte[2]);
			}
			else
			{
				fprintf(tmpfile,"%4x\n",outbyte[2]);
			}
		}
		else
		{
			fprintf(tmpfile,"ZZZZ\n");
			addref(outbyte[2],dot+2,outsize[2],isabsol[2]);
		}
	}
	for(i=3;i<outcnt;i++)
	{
		if (isword)
		{
			fprintf(tmpfile,"%4d\t%4x\t%4x\n",linenum,dot+i,(int)wordbuf[i]);
		}
		else
		{
			fprintf(tmpfile,"%4d\t%4x\t  00\n",linenum,dot+i);
		}
	}
	isword = 0;
	dot += outcnt;
}

reset()
{
	isabsol[0] = 1;
	isabsol[1] = 1;
	isabsol[2] = 1;
}
short yyexca[] ={
-1, 1,
	0, -1,
	260, 8,
	10, 8,
	-2, 0,
	};
# define YYNPROD 103
# define YYLAST 856
short yyact[]={

  45,  68,  69,  73, 193,  46, 191, 189, 187,  71,
  72,  70,  72, 198, 194, 192, 190, 188, 186, 176,
 165, 163, 161, 159, 157, 156, 154, 151, 213, 124,
 179, 131,   3,  43,   4,   2,   1,  59,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,  66,
   0,   0,  45,  63,  61,   0,  62,  46,  64,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 132,   0,   0,
   0,   0,  57,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  66,   0,   0, 178,  63,
  61,  63,  62,  66,  64,  65,  64,  63,  61,   0,
  62,   0,  64,  63,  61, 197,  62, 185,  64,   0,
  45,   0,  45, 201,   0,  46,  45,  46,  45,   0,
   0,  46,   0,  46,  45,  67,  45,   0,   0,  46,
   0,  46,  45,   0, 196,   0, 184,  46,   0,  45,
   0,  65,   0,  65,  46,   0,  45,   0, 128,  65,
 126,  46,  45,   0,  45,  65, 123,  46,   0,  46,
  45,   0,  45, 121,   0,  46,   0,  46,  45,   0,
 119,  67,   0,  46,  45,   0, 117,   0, 115,  46,
  45,   0,  45,   0, 113,  46, 111,  46,   0,  45,
   0,  45, 109,   0,  46,   0,  46,   0, 107,   0,
   0,   0,   0,   0, 105,   0, 103,  60,  44,   9,
   0,   6,   8, 101,   0,  98,  47,  48,  49,  10,
  11,  12,  13,  50,  14,  15,  16,  17,  18,  19,
  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  51,  31,  32,  33,  34,  35,  36,  37,  38,
  52,  39,  40,  41,  53,  42,  54,  55,  56,   7,
  44,   9,  45,   6,   8,  68,  69,  46,  47,  48,
  49,  10,  11,  12,  13,  50,  14,  15,  16,  17,
  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,
  28,  29,  30,  51,  31,  32,  33,  34,  35,  36,
  37,  38,  52,  39,  40,  41,  53,  42,  54,  55,
  56,  68,  69,  68,  69,   0,  45, 133,  45,  68,
  69,  46,  58,  46,   0,  68,  69,  92,  44,  92,
  44,  75,   0,  75,  44,  92,  44,  75,   0,  75,
  96,  79,  44,  79,  44,  75,   0,  75,   0,  79,
  44,   0,   0,  75,   0,   0,  79,  44,   0,   0,
  75,   0,   0,  79,  44,   0,   0,  75,   0,  79,
  44,  79,  44,  75,   0,  75,   0,  79,  44,  79,
  44,  75,   0,  75,   0,  79,  44,   0,   0,  75,
   0,  79,  44,  90,   0,  75,   0,  79,  44,  79,
  44,  75,   0,  75,   0,   0,  79,  44,  92,  44,
  75,  45,  75,  45,   0,   0,  46,  97,  46,  45,
   0,  45,   0,   0,  46,   0,  46,  45,   0,  45,
   0,   0,  46,   0,  46,  94,  45,  89,   0,   0,
   0,  46,   0,  87,   0,  85,   0,   0,   0,   0,
   0,  83,   0,  81,   0,   0,   0,   0,   0,   0,
  77,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,  92,
  44,   0,   0,  75,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  78,   0,   5,   0,   0,   5,
   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,
   0,   0,   0,  91,   0,   0,   0,   0,  91,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,  79,  44,  79,  44,  75,   0,  75,
 129, 130,   0,   0,   0,   0,   0,   0,   0,   0,
 182, 183,   0,   0,   0,   0, 134, 135, 136, 137,
 138, 139, 140, 141, 142, 143,   0, 144,   0,   0,
 195,   0,   0,   0,   0,   0,   0,   0, 199, 200,
 202, 203, 204, 205, 206, 207, 208, 209, 210,   0,
 211, 212,   0,   0,   0, 214,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 215,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  79,  44,
  79,  44,  75,   0,  75,   0,  79,  44,  79,  44,
  75,   0,  75,   0,  79,  44,  79,  44,  75,   0,
  75,  91,  91,  79,  44,   0,   0,  75,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  91,   0,   0,   0,   0,   0,   0,   0,  91,
  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,
  76,  91,  91,   0,   0,   0,  91,   0,   0,   0,
   0,   0,   0,  80,  82,  84,  86,  88,  91,   0,
   0,  93,  95,   0,   0,  99, 100, 102, 104, 106,
 108,   0, 110, 112,   0,   0, 114, 116, 118, 120,
   0, 122,   0, 125, 127,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 145,   0,
   0,   0, 146,   0, 147,   0, 148,   0, 149,   0,
 150,   0,   0,   0,   0, 152,   0, 153,   0, 155,
   0,   0, 158,   0, 160,   0, 162,   0, 164,   0,
 166,   0, 167,   0, 168,   0, 169,   0, 170,   0,
 171,   0, 172,   0, 173, 174,   0, 175,   0, 177,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 180,   0,   0, 181 };
short yypact[]={

-1000,  12,-1000,  72, -40,  11, -50, -49,-260,  86,
 406,-1000, 399, 397, 391, 389, 383,-1000, 232,-1000,
 381, 286,-1000, 161, 288, 159, 152, 150, 144, 138,
-1000, 132, 130,-1000,-1000, 124, 122, 116, 109,-1000,
 102,  -6,  96,  94,-1000,  86,  86,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,  21,  67,
 -51,  86,  86,  86,  86,  86,  86,  86,  86,  86,
  86,-1000,  86,-1000,  11,-1000,-1000, 288,  11,-1000,
-1000, 288,-1000, 288,-1000, 288,-1000, 288,-1000, 288,
 -17,  11,-1000,-1000, 288,-1000, 288, -18, 288, -19,
 -20, 288, -21, 288, -22, 288, -23, 288, -24, 288,
-1000, 288,-1000, 288,-1000, 288,-1000, 288,-1000, 288,
-1000, 288,-1000, 288, 288,-1000, 288, -25, 288,  57,
-1000,-1000,-1000,  20,  59,  59,-263,-263,-263,  71,
  65,-1000,-1000,  11,  11,-1000,-1000,-1000,-1000,-1000,
-1000, 288,-1000,-1000, 288,-1000, 232,  82, -26, -56,
 -27, -57, -28, -58, -29, -60, -30,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,  80, -31,-1000,-1000,
-1000,-1000,-1000,-1000, 232, 232,  88, 232, 232, 232,
 232, 232, 232, 232, 232,-1000, 232, 232,  -7,-1000,
-1000, 232,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000, 232,-1000,-1000 };
short yypgo[]={

   0,  36,  35,  32,  34, 504, 700, 403,  33 };
short yyr1[]={

   0,   1,   1,   2,   2,   2,   2,   4,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   8,   8,   8,   8,
   8,   8,   8,   8,   8,   8,   6,   6,   7,   7,
   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
   5,   5,   5 };
short yyr2[]={

   0,   0,   2,   2,   3,   3,   4,   2,   0,   1,
   3,   3,   2,   2,   2,   3,   1,   2,   3,   2,
   3,   2,   3,   2,   3,   2,   3,   1,   4,   1,
   2,   3,   2,   3,   1,   4,   3,   4,   4,   5,
   5,   6,   5,   5,   5,   5,   5,   5,   5,   5,
   5,   1,   2,   3,   2,   3,   1,   1,   2,   3,
   2,   3,   2,   3,   2,   3,   1,   2,   3,   3,
   2,   3,   4,   5,   5,   6,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   2 };
short yychk[]={

-1000,  -1,  -2,  -3,  -4,  -5, 261, 257, 262, 259,
 269, 270, 271, 272, 274, 275, 276, 277, 278, 279,
 280, 281, 282, 283, 284, 285, 286, 287, 288, 289,
 290, 292, 293, 294, 295, 296, 297, 298, 299, 301,
 302, 303, 305,  -8, 258,  40,  45, 266, 267, 268,
 273, 291, 300, 304, 306, 307, 308,  10, 260,  -3,
 257,  43,  45,  42,  47,  94,  38, 124, 264, 265,
  61,  58,  61, 263,  -5, 261,  -6,  64,  -5, 257,
  -6,  64,  -6,  64,  -6,  64,  -6,  64,  -6,  64,
  -7,  -5, 257,  -6,  64,  -6,  64,  -7,  64,  -6,
  -6,  64,  -6,  64,  -6,  64,  -6,  64,  -6,  64,
  -6,  64,  -6,  64,  -6,  64,  -6,  64,  -6,  64,
  -6,  64,  -6,  64,  35,  -6,  64,  -6,  64,  -5,
  -5,  10,  10, 260,  -5,  -5,  -5,  -5,  -5,  -5,
  -5,  -5,  -5,  -5,  -5,  -6,  -6,  -6,  -6,  -6,
  -6,  44,  -6,  -6,  44,  -6,  44,  44,  -6,  44,
  -6,  44,  -6,  44,  -6,  44,  -6,  -6,  -6,  -6,
  -6,  -6,  -6,  -6,  -6,  -6,  44,  -6,  41,  10,
  -6,  -6,  -7,  -7,  64,  35,  44,  64,  44,  64,
  44,  64,  44,  64,  44,  -7,  64,  35,  44,  -7,
  -7,  35,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -7,
  -7,  -7,  -7,  35,  -7,  -7 };
short yydef[]={

   1,  -2,   2,   0,   8,   9,  91,   0,   0,   0,
   0,  16,   0,   0,   0,   0,   0,  27,   0,  29,
   0,   0,  34,   0,   0,   0,   0,   0,   0,   0,
  51,   0,   0,  56,  57,   0,   0,   0,   0,  66,
   0,   0,   0,   0,  90,   0,   0,  76,  77,  78,
  79,  80,  81,  82,  83,  84,  85,   3,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   7,   0,  12,  13,  91,  14,   0,  86,  87,
  17,   0,  19,   0,  21,   0,  23,   0,  25,   0,
   0,  88,  89,  30,   0,  32,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  52,   0,  54,   0,  58,   0,  60,   0,  62,   0,
  64,   0,  67,   0,   0,  70,   0,   0,   0,   0,
 102,   4,   5,   0,  93,  94,  95,  96,  97,  98,
  99, 100, 101,  10,  11,  15,  18,  20,  22,  24,
  26,   0,  31,  33,   0,  36,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  53,  55,  59,
  61,  63,  65,  68,  69,  71,   0,   0,  92,   6,
  28,  35,  37,  38,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  72,   0,   0,   0,  39,
  40,   0,  42,  43,  44,  45,  46,  47,  48,  49,
  50,  73,  74,   0,  41,  75 };
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif not lint

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 3:
# line 44 "gram.y"
{
				do_out();
				reset();
			} break;
case 4:
# line 49 "gram.y"
{
				do_out();
				reset();
			} break;
case 5:
# line 54 "gram.y"
{
				do_out();
				reset();
			} break;
case 6:
# line 59 "gram.y"
{
				do_out();
				reset();
			} break;
case 7:
# line 65 "gram.y"
{
			if (indx_has(yypvt[-1]))
			{
				fprintf(stderr,"multiply defined symbol %s\n",
						indx_symb(yypvt[-1]));
			}
			add_indx(yypvt[-1],dot);
			outcnt = 0;
			} break;
case 8:
# line 76 "gram.y"
{
				outcnt = 0;
			} break;
case 9:
# line 80 "gram.y"
{
				outbyte[0] = yypvt[-0];
				isvalue[0] = 1;
				outcnt = 1;
			} break;
case 10:
# line 86 "gram.y"
{
				dot = yypvt[-0];
				outcnt = 0;
			} break;
case 11:
# line 91 "gram.y"
{
				add_indx(yypvt[-2],yypvt[-0]);
				outcnt = 0;
			} break;
case 12:
# line 96 "gram.y"
{
				int i;
				int tocnt;
				char wb[256],*to,*from;
				char sb[100];
				to = wb;
				from = wordbuf;
				for(tocnt = 0;*from != '\0';from++)
				{
					switch (*from)
					{
					case '\\':
						switch(*(from+1))
						{
						case 'r' :
							*to++ = '\015';	
							tocnt++;
							from++;
							break;
						case 'n' :
							*to++ = '\012';	
							tocnt++;
							from++;
							break;
						case 't' :
							*to++ = '\011';	
							tocnt++;
							from++;
							break;
						case '0' :
						case '1' :
						case '2' :
						case '3' :
							sb[0] = *(from+1);
							sb[1] = *(from+2);
							sb[2] = *(from+3);
							sb[3] = '\0';
							*to++ = (char)aton(sb,8);
							tocnt++;
							from += 3;
							break;
						default :
							from++;
							*to++ = *from;
							tocnt++;
							break;
						}
						break;
					default :
						*to++ = *from;
						tocnt++;
						break;
					}
				}
				*to = '\0';
				tocnt++;
				for(from=wb,to=wordbuf,i=0;i<tocnt;i++)
				{
					*to++ = *from++;
				}

				for(i=0;(i<tocnt) && (i < 3);i++)
				{
					outbyte[i] = (int)wordbuf[i];
					isvalue[i] = 1;
				}
				outcnt = tocnt;
				isword = 1;
			} break;
case 13:
# line 166 "gram.y"
{
				if (yypvt[-0] < 0)
				{
					printf(stderr,
				         "can't allocate less than 0 bytes\n");
					outcnt = 0;
				}
				else
				switch (yypvt[-0])
				{
					case 0 :
						outcnt = 0;
						break;
					case 1 :
						outcnt = 1;
						outbyte[0] = 0;
						isvalue[0] = 1;
						break;
					case 2 :
						outcnt = 2;
						outbyte[0] = 0;
						isvalue[0] = 1;
						outbyte[1] = 0;
						isvalue[1] = 1;
						break;
					case 3 :
					default :
						outbyte[0] = 0;
						isvalue[0] = 1;
						outbyte[1] = 0;
						isvalue[1] = 1;
						outbyte[2] = 0;
						isvalue[2] = 1;
						outcnt = yypvt[-0];
						break;
				}
			} break;
case 14:
# line 204 "gram.y"
{
				outbyte[0] = 0xD6;
				isvalue[0] = 1;

				if (isvalue[1])
				{
					outbyte[2] = outbyte[1]&0377;
					isvalue[2] = 1;
					outbyte[1] = (outbyte[1]>>8)&0377;
					isvalue[1] = 1;
				}
				else
				{
					outbyte[2] = outbyte[1];
					isvalue[1] = 0;
					isvalue[2] = 0;
					outsize[1] = 16;
					outsize[2] = 0;
				}
				outcnt = 3;
			} break;
case 15:
# line 226 "gram.y"
{
				outbyte[0] = 0xD4;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 16:
# line 232 "gram.y"
{
				outbyte[0] = 0xEF;
				isvalue[0] = 1;
				outcnt = 1;
			} break;
case 17:
# line 238 "gram.y"
{
				outbyte[0] = 0xB0;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 18:
# line 244 "gram.y"
{
				outbyte[0] = 0xB1;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 19:
# line 250 "gram.y"
{
				outbyte[0] = 0x60;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 20:
# line 256 "gram.y"
{
				outbyte[0] = 0x61;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 21:
# line 262 "gram.y"
{
				outbyte[0] = 0x40;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 22:
# line 268 "gram.y"
{
				outbyte[0] = 0x41;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 23:
# line 274 "gram.y"
{
				outbyte[0] = 0x00;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 24:
# line 280 "gram.y"
{
				outbyte[0] = 0x01;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 25:
# line 286 "gram.y"
{
				outbyte[0] = 0x80;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 26:
# line 292 "gram.y"
{
				outbyte[0] = 0x81;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 27:
# line 298 "gram.y"
{
				outbyte[0] = 0x08F;
				isvalue[0] = 1;
				outcnt = 1;
			} break;
case 28:
# line 304 "gram.y"
{
				if (isvalue[2])
				{
					outbyte[0] =
					  0x0A | (outbyte[2]<<4);
					isvalue[0] = 1;
				}
				else
				{
					printf("panic -- condition flags ill-defined\n");
				}
				if (isvalue[1])
				{
					outbyte[1] = outbyte[1] - (dot+2);
				}
				else
				{
					outbyte[1] = outbyte[2];
					isvalue[1] = 0;
					isabsol[1] = 0;
					outsize[1] = 8;
				}
				outcnt = 2;
			} break;
case 29:
# line 329 "gram.y"
{
				outbyte[0] = 0x9F;
				isvalue[0] = 1;
				outcnt = 1;
			} break;
case 30:
# line 335 "gram.y"
{
				outbyte[0] = 0x20;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 31:
# line 341 "gram.y"
{
				outbyte[0] = 0x21;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 32:
# line 347 "gram.y"
{
				outbyte[0] = 0xA0;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 33:
# line 353 "gram.y"
{
				outbyte[0] = 0xA1;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 34:
# line 359 "gram.y"
{
				outbyte[0] = 0xBF;
				isvalue[0] = 1;
				outcnt = 1;
			} break;
case 35:
# line 365 "gram.y"
{
				if (isvalue[2])
				{
					outbyte[0] =
					  0x0D | (outbyte[2]<<4);
					isvalue[0] = 1;
				}
				else
				{
					printf("panic -- condition flags ill-defined\n");
				}
				if (isvalue[1])
				{
					outbyte[2] = outbyte[1]&0377;
					isvalue[2] = 1;
					outbyte[1] = (outbyte[1]>>8)&0377;
					isvalue[1] = 1;
				}
				else
				{
					outbyte[2] = outbyte[1];
					isvalue[1] = 0;
					isvalue[2] = 0;
					outsize[1] = 16;
					outsize[2] = 0;
				}
				outcnt = 3;
			} break;
case 36:
# line 394 "gram.y"
{
				outbyte[0] = 0x30;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 37:
# line 400 "gram.y"
{
				if (isvalue[1])
				{
					if ((outbyte[1] > 15) || (outbyte[1] < 0))
					{
						printf("panic -- condition code out of range\n");
					}
					outbyte[0] =
					  0x0B | (outbyte[1]<<4);
					isvalue[0] = 1;
				}
				else
				{
					printf("panic -- condition flags ill-defined\n");
				}
				if (isvalue[2])
				{
					outbyte[1] = outbyte[2] - (dot+2);
					isvalue[1] = 1;
				}
				else
				{
					outbyte[1] = outbyte[2];
					isvalue[1] = 0;
					isabsol[1] = 0;
					outsize[1] = 8;
				}
				outcnt = 2;
			} break;
case 38:
# line 430 "gram.y"
{
				outbyte[0] = 0xE4;
				isvalue[0] = 1;
				swap_ops();
				outcnt = 3;
			} break;
case 39:
# line 437 "gram.y"
{
				outbyte[0] = 0xE5;
				isvalue[0] = 1;
				swap_ops();
				outcnt = 3;
			} break;
case 40:
# line 444 "gram.y"
{
				outbyte[0] = 0xE6;
				isvalue[0] = 1;
				outcnt = 3;
			} break;
case 41:
# line 450 "gram.y"
{
				outbyte[0] = 0xE7;
				isvalue[0] = 1;
				outcnt = 3;
			} break;
case 42:
# line 456 "gram.y"
{
				outbyte[0] = 0xF5;
				isvalue[0] = 1;
				swap_ops();
				outcnt = 3;
			} break;
case 43:
# line 463 "gram.y"
{
				outbyte[0]  = 0xC2;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1]  = outbyte[1]<<4;
					outbyte[1] |= outbyte[2];
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			} break;
case 44:
# line 478 "gram.y"
{
				outbyte[0]  = 0xD2;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1] |= outbyte[2]<<4;
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			} break;
case 45:
# line 492 "gram.y"
{
				outbyte[0]  = 0xC3;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1]  = outbyte[1]<<4;
					outbyte[1] |= outbyte[2];
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			} break;
case 46:
# line 507 "gram.y"
{
				outbyte[0]  = 0xD3;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1] |= outbyte[2]<<4;
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			} break;
case 47:
# line 521 "gram.y"
{
				outbyte[0]  = 0x82;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1]  = outbyte[1]<<4;
					outbyte[1] |= outbyte[2];
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			} break;
case 48:
# line 536 "gram.y"
{
				outbyte[0]  = 0x92;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1] |= outbyte[2]<<4;
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			} break;
case 49:
# line 550 "gram.y"
{
				outbyte[0]  = 0x83;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1]  = outbyte[1]<<4;
					outbyte[1] |= outbyte[2];
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			} break;
case 50:
# line 565 "gram.y"
{
				outbyte[0]  = 0x93;
				isvalue[0]  = 1;
				if (isvalue[1] && isvalue[2])
				{
					outbyte[1] |= outbyte[2]<<4;
					outcnt = 2;
				}
				else
				{
					fprintf(stderr,"panic - LDC didn't get constants\n");
				}
			} break;
case 51:
# line 579 "gram.y"
{
				outbyte[0] = 0xFF;
				isvalue[0] = 1;
				outcnt = 1;
			} break;
case 52:
# line 585 "gram.y"
{
				outbyte[0] = 0x50;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 53:
# line 591 "gram.y"
{
				outbyte[0] = 0x51;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 54:
# line 597 "gram.y"
{
				outbyte[0] = 0x70;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 55:
# line 603 "gram.y"
{
				outbyte[0] = 0x71;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 56:
# line 609 "gram.y"
{
				outbyte[0] = 0xCF;
				isvalue[0] = 1;
				outcnt = 1;
			} break;
case 57:
# line 615 "gram.y"
{
				outbyte[0] = 0xAF;
				isvalue[0] = 1;
				outcnt = 1;
			} break;
case 58:
# line 621 "gram.y"
{
				outbyte[0] = 0x90;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 59:
# line 627 "gram.y"
{
				outbyte[0] = 0x91;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 60:
# line 633 "gram.y"
{
				outbyte[0] = 0x10;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 61:
# line 639 "gram.y"
{
				outbyte[0] = 0x11;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 62:
# line 645 "gram.y"
{
				outbyte[0] = 0xE0;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 63:
# line 651 "gram.y"
{
				outbyte[0] = 0xE1;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 64:
# line 657 "gram.y"
{
				outbyte[0] = 0xC0;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 65:
# line 663 "gram.y"
{
				outbyte[0] = 0xC1;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 66:
# line 669 "gram.y"
{
				outbyte[0] = 0xDF;
				isvalue[0] = 1;
				outcnt = 1;
			} break;
case 67:
# line 675 "gram.y"
{
				outbyte[0] = 0xD0;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 68:
# line 681 "gram.y"
{
				outbyte[0] = 0xD1;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 69:
# line 687 "gram.y"
{
				outbyte[0] = 0x31;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 70:
# line 693 "gram.y"
{
				outbyte[0] = 0xF0;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 71:
# line 699 "gram.y"
{
				outbyte[0] = 0xF1;
				isvalue[0] = 1;
				outcnt = 2;
			} break;
case 72:
# line 705 "gram.y"
{
				outbyte[0] |= 0x04;
				isvalue[0] = 1;
				swap_ops();
				outcnt = 3;
			} break;
case 73:
# line 712 "gram.y"
{
				outbyte[0] |= 0x05;
				isvalue[0] = 1;
				swap_ops();
				outcnt = 3;
			} break;
case 74:
# line 719 "gram.y"
{
				outbyte[0] |= 0x06;
				isvalue[0] = 1;
				outcnt = 3;
			} break;
case 75:
# line 725 "gram.y"
{
				outbyte[0] |= 0x07;
				isvalue[0] = 1;
				outcnt = 3;
			} break;
case 76:
# line 732 "gram.y"
{
			outbyte[0] = 0x10;
		} break;
case 77:
# line 736 "gram.y"
{
			outbyte[0] = 0x00;
		} break;
case 78:
# line 740 "gram.y"
{
			outbyte[0] = 0x50;
		} break;
case 79:
# line 744 "gram.y"
{
			outbyte[0] = 0xA0;
		} break;
case 80:
# line 748 "gram.y"
{
			outbyte[0] = 0x40;
		} break;
case 81:
# line 752 "gram.y"
{
			outbyte[0] = 0x30;
		} break;
case 82:
# line 756 "gram.y"
{
			outbyte[0] = 0x20;
		} break;
case 83:
# line 760 "gram.y"
{
			outbyte[0] = 0x60;
		} break;
case 84:
# line 764 "gram.y"
{
			outbyte[0] = 0x70;
		} break;
case 85:
# line 768 "gram.y"
{
			outbyte[0] = 0xB0;
		} break;
case 86:
# line 773 "gram.y"
{
				outbyte[1] = yypvt[-0];
				isvalue[1] = 1;
			} break;
case 87:
# line 778 "gram.y"
{
				outbyte[1] = yypvt[-0];
				isvalue[1] = 0;
				outsize[1] = 8;
			} break;
case 88:
# line 785 "gram.y"
{
				outbyte[2] = yypvt[-0];
				isvalue[2] = 1;
			} break;
case 89:
# line 790 "gram.y"
{
				outbyte[2] = yypvt[-0];
				isvalue[2] = 0;
				outsize[2] = 8;
			} break;
case 91:
# line 797 "gram.y"
{
				yyval = dot;
			} break;
case 92:
# line 801 "gram.y"
{
				yyval = yypvt[-1];
			} break;
case 93:
# line 805 "gram.y"
{
				yyval = yypvt[-2] + yypvt[-0];
			} break;
case 94:
# line 809 "gram.y"
{
				yyval = yypvt[-2] - yypvt[-0];
			} break;
case 95:
# line 813 "gram.y"
{
				yyval = yypvt[-2] * yypvt[-0];
			} break;
case 96:
# line 817 "gram.y"
{
				yyval = yypvt[-2] / yypvt[-0];
			} break;
case 97:
# line 821 "gram.y"
{
				yyval = yypvt[-2] % yypvt[-0];
			} break;
case 98:
# line 825 "gram.y"
{
				yyval = yypvt[-2] & yypvt[-0];
			} break;
case 99:
# line 829 "gram.y"
{
				yyval = yypvt[-2] | yypvt[-0];
			} break;
case 100:
# line 833 "gram.y"
{
				yyval = yypvt[-2] >> yypvt[-0];
			} break;
case 101:
# line 837 "gram.y"
{
				yyval = yypvt[-2] << yypvt[-0];
			} break;
case 102:
# line 841 "gram.y"
{
				yyval = - yypvt[-0];
			} break;
		}
		goto yystack;  /* stack new state and value */

	}
