#include <stdio.h>
#include "zasm.h"

# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)

extern int errno;
static char tmpname[20] = "/tmp/zasm.XXXXXX";
FILE *tmpfile;
FILE *outfile;
char lbuf[LEN];
char lbuf2[LEN];

main(argc,argv)
int argc; char **argv;
{
	int ftmp,tmp,i;
	
	if (argc>1)
	{
		close(0);
		if ((ftmp = open(argv[1],0)) != 0)
		{
			fprintf(stderr,"can't open the file named %s\n",argv[1]);
			fprintf(stderr,"usage: %s <filename>\n", argv[0]);
			exit(1);
		}
	}
	init();
	/*
	**	do the first pass, placing the results in a tmp file
	**	and building the symbol and reference tables in core
	*/
	if (tmp = yyparse())
	{
		fprintf(stderr,"panic -- got parser error %d",tmp);
		exit(tmp);
	}
	dumptab();

	fclose(tmpfile);
	if ((tmpfile = fopen(tmpname,"r")) == NULL)
	{
		fprintf(stderr,"can't open temp file %s for reading\n",tmpname);
		exit(1);
	}
	/*
	**	now read the tmpfile back in, filling in forward references.
	**	since the list of references was built in the same order as
	**	as the bytes were assembled, the ordinal position of references
	**	in the table should be identical to the ordinal position of the
	**	references in the program.
	**	so all we need to do is:
	**	1) marching down the list of references (refs[])
	**	2) reading in the lines of temp file until we reach the line we need
	**	3) replacing the "ZZZZ" with the approriate value
	*/
	for(i=0;i<rptr;i++)
	{
		getloc(refs[i].where,lbuf);
		subval(i,lbuf,lbuf2);
		fputs(lbuf,outfile);
		if (refs[i].size == 16)
		{
			fputs(lbuf2,outfile);
			i++;
		}
	}
	while (fgets(lbuf,LEN,tmpfile) != (char*) NULL)
	{
		fputs(lbuf,outfile);
	}
	cleanup();
	exit(tmp);
}

subval(idx,ptr,ptr2)
int idx;
char *ptr;
char *ptr2;
{
	char *start;
	char valbuf[LEN];
	int theval;

	if (stab[refs[idx].indx].val_flag == 0)
	{
		fprintf(stderr,
		"panic -- can't find value for reference %d wants stab entry %d\n",idx,refs[idx].indx);
		exit(1);
	}

	if ((start = (char*) index(ptr,'Z')) == (char*) 0)
	{
		fprintf(stderr,
		"panic -- couldn't find 'Z' in :%s:\n",ptr);
		exit(1);
	}

	if (refs[idx].abs)
	{
		theval = stab[refs[idx].indx].value;
	}
	else
	{
		theval = stab[refs[idx].indx].value - (refs[idx].where + 1);
	}
	theval &= 0377;


	switch(refs[idx].size)
	{
		case 8 :
			if (theval < 16)
			{
				sprintf(valbuf,"  0%x",theval);
			}
			else
			{
				sprintf(valbuf,"%4x", theval);
			}
			strncpy(start,valbuf,4);
			break;
		case 16 :
			theval = stab[refs[idx].indx].value >> 8;
			theval &= 0377;
			if (theval < 16)
			{
				sprintf(valbuf,"  0%x",theval);
			}
			else
			{
				sprintf(valbuf,"%4x", theval);
			}
			strncpy(start,valbuf,4);
			if (!readline(ptr2))
			{
				fprintf(stderr,
				"panic -- unexpected eof while looking for second byte index = %d\n",idx);
				exit(1);
			}
			if ((start = (char*) index(ptr2,'Z')) == (char*) 0)
			{
				fprintf(stderr,
				"panic -- couldn't find 'Z' in :%s:\n",ptr);
				exit(1);
			}
			theval = stab[refs[idx].indx].value;
			theval &= 0377;
			if (theval < 16)
			{
				sprintf(valbuf,"  0%x",theval);
			}
			else
			{
				sprintf(valbuf,"%4x", theval);
			}
			strncpy(start,valbuf,4);
			break;
		
		default :
			fprintf(stderr,
			"panic -- got bad size %d for reference number %d\n",refs[idx].size,idx);
			exit(1);
	}
}

readline(ptr)
char *ptr;
{
	return((fgets(ptr,LEN,tmpfile) != (char*)NULL) &&
		strncmp(ptr,"SYMBOLS",strlen("SYMBOLS")));
}

getloc(addr,ptr)
int addr;
char *ptr;
{
	char linen[LEN], address[LEN], contents[LEN];

	while (readline(ptr))
	{
		if(sscanf(ptr,"%s%s%s",linen,address,contents) != 2)
		{
			if(!strcmp(address,"....") ||
				(aton(address,16) < addr))
			{
				fputs(ptr,outfile);
				continue;
			}
			if (aton(address,16) > addr)
			{
				fprintf(stderr,
				"panic -- looking for an address that has already passed needed %x got :%s:\n",
				addr, address);
				exit(1);
			}

			if (aton(address,16) == addr)
			{
				return(1);
			}
		
			fprintf(stderr, "panic -- fell off end of loop when looking for %x got :%d:\n",
			addr, address);
			exit(1);
		}
	}

	fprintf(stderr, "panic -- fell off end of file when looking for %x got :%s:\n",
	addr, address);
	exit(1);
}

yyerror(s)
char *s;
{
	fprintf(stderr,"line %d -- %s\n",linenum,s);
}

init()
{
	mktemp(tmpname);
	if ((tmpfile = fopen(tmpname,"w")) == NULL)
	{
		fprintf(stderr,"can't open temp file %s for writing\n",tmpname);
		exit(1);
	}
	yyin = stdin;	/* this matters */
	yyout = stdout; /* this doesn't */
	outfile = stdout;
	reset();
}

cleanup()
{
	fclose(tmpfile);
	unlink(tmpname);
}

aton(ptr,radix)
char *ptr;
int radix;
{
	int tmp = 0;
	while (*ptr != '\0')
	{
		switch (*ptr)
		{
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				tmp = (tmp*radix)+  (*ptr - '0');
				break;
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
				tmp = (tmp*radix) + ((*ptr - 'a')+10);
				break;
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
				tmp = (tmp*radix) + ((*ptr - 'A')+10);
				break;
			default:
				fprintf(stderr,
					"panic - weird char in number\n");
		}
		ptr++;
	}
	return(tmp);
}
