/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.test.BaseTest;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;
import java.security.MessageDigest;
import java.security.Parameterized;

class TestHMAC
extends BaseTest {
    private static final String[][] tests = new String[][]{{"'Hi There", "0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b", "9294727a3638bb1c13f48ef8158bfc9d", "0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b", "b617318655057264e28bc0b6fb378c8ef146be00"}, {"'what do ya want for nothing?", "4a656665", "750c783e6ab0b503eaa86e310a5db738", "4a656665", "effcdf6ae5eb2fa2d27416d5f184df9c259a7c79"}, {"DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD", "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", "56be34521d144c88dbb8c733f0e8b3f6", "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", "125d7342b9ac11cd91a39af48aa17b4f63f175d3"}, {"CDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCD", "0102030405060708090a0b0c0d0e0f10111213141516171819", "697eaf0aca3a3aea3a75164746ffaa79", "0102030405060708090a0b0c0d0e0f10111213141516171819", "4c9007f4026250c6bc8414f9bf50c86c2d7235da"}, {"'Test With Truncation", "0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c", "56461ef2342edc00f9bab995690efd4c", "0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c", "4c1a03424b55e07fe7f27be1d58bb9324a9a5a04"}, {"'Test Using Larger Than Block-Size Key - Hash Key First", "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", "6b1ab7fe4bd7bf8f0b62e6ce61b9d0cd", "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", "aa4ae5e15272d00e95705637ce8a3b55ed402112"}, {"'Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data", "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", "6f630fad67cda0ee1fb1f562db3aa53e", "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", "e8e99d0f45237d786d6bbaa7965c7808bbff1a91"}};

    public static void main(String[] stringArray) {
        new TestHMAC().commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        this.setExpectedPasses(14);
        MessageDigest messageDigest = MessageDigest.getInstance("HMAC-MD5", "Cryptix");
        MessageDigest messageDigest2 = MessageDigest.getInstance("HMAC-SHA-1", "Cryptix");
        int n = 0;
        while (n < tests.length) {
            byte[] byArray;
            String string = tests[n][0];
            if (string.startsWith("'")) {
                byArray = new byte[string.length() - 1];
                int n2 = 0;
                while (n2 < byArray.length) {
                    byArray[n2] = (byte)string.charAt(n2 + 1);
                    ++n2;
                }
            } else {
                byArray = Hex.fromString((String)string);
            }
            byte[] byArray2 = Hex.fromString((String)tests[n][1]);
            byte[] byArray3 = Hex.fromString((String)tests[n][2]);
            byte[] byArray4 = Hex.fromString((String)tests[n][3]);
            byte[] byArray5 = Hex.fromString((String)tests[n][4]);
            ((Parameterized)messageDigest).setParameter("key", (Object)byArray2);
            byte[] byArray6 = messageDigest.digest(byArray);
            this.passIf(ArrayUtil.areEqual((byte[])byArray3, (byte[])byArray6), "HMAC-MD5 #" + (n + 1));
            ((Parameterized)messageDigest2).setParameter("key", (Object)byArray4);
            byArray6 = messageDigest2.digest(byArray);
            this.passIf(ArrayUtil.areEqual((byte[])byArray5, (byte[])byArray6), "HMAC-SHA-1 #" + (n + 1));
            ++n;
        }
    }

    TestHMAC() {
    }
}

