/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.pgp.Certificate;
import cryptix.pgp.FormatException;
import cryptix.pgp.KeyRingTrust;
import cryptix.pgp.KeyStore;
import cryptix.pgp.Packet;
import cryptix.pgp.PacketFactory;
import cryptix.pgp.PacketInputStream;
import cryptix.pgp.PublicKeyCertificate;
import cryptix.pgp.UserId;
import cryptix.pgp.UserIdCertificate;
import cryptix.security.rsa.PublicKey;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public final class KeyRingEntry {
    private Certificate cert;
    private KeyRingTrust trust;
    private Vector userNameCerts;

    public KeyRingEntry(Certificate certificate, KeyRingTrust keyRingTrust) {
        this.cert = certificate;
        this.trust = keyRingTrust;
        this.userNameCerts = new Vector();
    }

    public KeyRingEntry(Certificate certificate, KeyRingTrust keyRingTrust, Vector vector) {
        this.cert = certificate;
        this.trust = keyRingTrust;
        this.userNameCerts = vector;
    }

    public KeyRingEntry(PacketInputStream packetInputStream, KeyRingTrust keyRingTrust) throws IOException {
        this.userNameCerts = new Vector();
        this.restore(packetInputStream, keyRingTrust);
    }

    public void addNameAndSignatures(UserId userId, KeyRingTrust keyRingTrust, Vector vector, Vector vector2) throws FormatException {
        this.userNameCerts.addElement(new UserIdCertificate(userId, keyRingTrust, vector, vector2));
    }

    public int trustValue() {
        return this.trust.trustValue();
    }

    public Certificate certificate() {
        return this.cert;
    }

    public PublicKey publicKey() {
        if (this.cert instanceof PublicKeyCertificate) {
            return ((PublicKeyCertificate)this.cert).publicKey();
        }
        return null;
    }

    public UserIdCertificate[] getUserIdCertificates() {
        int n = this.userNameCerts.size();
        Object[] objectArray = new UserIdCertificate[n];
        this.userNameCerts.copyInto(objectArray);
        return objectArray;
    }

    public String primaryName() {
        return ((UserIdCertificate)this.userNameCerts.elementAt(0)).userName();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Cert:").append(this.cert.getClass().getName()).append('\n').append(this.trust).append('\n');
        Enumeration enumeration = this.userNameCerts.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement()).append('\n');
        }
        return stringBuffer.toString();
    }

    public boolean checkSignatures(KeyStore keyStore) {
        Enumeration enumeration = this.userNameCerts.elements();
        while (enumeration.hasMoreElements()) {
            if (((UserIdCertificate)enumeration.nextElement()).checkSignatures(keyStore, this.cert)) continue;
            return false;
        }
        return true;
    }

    private void restore(PacketInputStream packetInputStream, KeyRingTrust keyRingTrust) throws IOException {
        UserIdCertificate userIdCertificate;
        Packet packet = packetInputStream.readPacket();
        if (packet == null) {
            throw new IOException("Tried to read a KeyRingEntry from an empty stream");
        }
        if (!(packet instanceof Certificate)) {
            throw new IOException("KeyRingEntry must start with a Certificate.");
        }
        this.cert = (Certificate)packet;
        packet = packetInputStream.readPacket();
        if (!(packet instanceof KeyRingTrust)) {
            this.trust = keyRingTrust;
            if (packet != null) {
                packetInputStream.pushback(packet);
            }
        } else {
            this.trust = (KeyRingTrust)packet;
        }
        while ((userIdCertificate = packetInputStream.readUserIdCertificate(keyRingTrust)) != null) {
            this.userNameCerts.addElement(userIdCertificate);
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        PacketFactory.write(dataOutput, this.cert);
        PacketFactory.write(dataOutput, this.trust);
        int n = 0;
        while (n < this.userNameCerts.size()) {
            ((UserIdCertificate)this.userNameCerts.elementAt(n)).write(dataOutput);
            ++n;
        }
    }
}

