/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.pgp.Comment;
import cryptix.pgp.CompressedData;
import cryptix.pgp.ConvEncryptedData;
import cryptix.pgp.FormatException;
import cryptix.pgp.KeyRingTrust;
import cryptix.pgp.LiteralData;
import cryptix.pgp.Packet;
import cryptix.pgp.PacketHeader;
import cryptix.pgp.PublicKeyCertificate;
import cryptix.pgp.PublicKeyEncrypted;
import cryptix.pgp.SecretKeyCertificate;
import cryptix.pgp.Signature;
import cryptix.pgp.UserId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public final class PacketFactory {
    private PacketFactory() {
    }

    public static Packet read(DataInput dataInput) throws IOException {
        int n;
        int n2;
        try {
            PacketHeader packetHeader = new PacketHeader(dataInput);
            n2 = packetHeader.len;
            n = packetHeader.type;
        }
        catch (EOFException eOFException) {
            return null;
        }
        switch (n) {
            case 5: {
                return new SecretKeyCertificate(dataInput, n2);
            }
            case 6: {
                return new PublicKeyCertificate(dataInput, n2);
            }
            case 12: {
                return new KeyRingTrust(dataInput, n2);
            }
            case 1: {
                return new PublicKeyEncrypted(dataInput, n2);
            }
            case 8: {
                return new CompressedData(dataInput, n2);
            }
            case 9: {
                return new ConvEncryptedData(dataInput, n2);
            }
            case 11: {
                return new LiteralData(dataInput, n2);
            }
            case 2: {
                return new Signature(dataInput, n2);
            }
            case 13: {
                return new UserId(dataInput, n2);
            }
            case 14: {
                return new Comment(dataInput, n2);
            }
        }
        throw new FormatException("Unknown packet type (" + n + ")");
    }

    public static void write(DataOutput dataOutput, Packet packet) throws IOException {
        byte[] byArray = packet.save();
        PacketFactory.getHeaderFor(packet, byArray.length).write(dataOutput);
        dataOutput.write(byArray);
    }

    public static byte[] save(Packet packet) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PacketFactory.write(new DataOutputStream(byteArrayOutputStream), packet);
        return byteArrayOutputStream.toByteArray();
    }

    public static Packet load(byte[] byArray) throws IOException {
        return PacketFactory.read(new DataInputStream(new ByteArrayInputStream(byArray)));
    }

    private static PacketHeader getHeaderFor(Packet packet, int n) throws IOException {
        return new PacketHeader(packet.getType(), n, packet.getDefaultLengthSpecifier());
    }
}

