/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp.charset;

import cryptix.pgp.FormatException;
import cryptix.pgp.charset.Ascii;
import cryptix.pgp.charset.Cp850;
import cryptix.pgp.charset.Cp852;
import cryptix.pgp.charset.Cp860;
import cryptix.pgp.charset.Cp866;
import cryptix.pgp.charset.Keybcs;
import cryptix.pgp.charset.Mac;
import cryptix.pgp.charset.Next;

public class CharSet {
    private CharSet() {
    }

    public static byte[] encode(byte[] byArray, String string) throws FormatException {
        String string2 = string.toLowerCase();
        if (string2.equals("ascii")) {
            return Ascii.encode(byArray);
        }
        if (string2.equals("alt_codes")) {
            return Cp866.encode(byArray);
        }
        if (string2.equals("cp850")) {
            return Cp850.encode(byArray);
        }
        if (string2.equals("cp852")) {
            return Cp852.encode(byArray);
        }
        if (string2.equals("cp860")) {
            return Cp860.encode(byArray);
        }
        if (string2.equals("cp866")) {
            return Cp866.encode(byArray);
        }
        if (string2.equals("keybcs")) {
            return Keybcs.encode(byArray);
        }
        if (string2.equals("ko18")) {
            return byArray;
        }
        if (string2.equals("latin1")) {
            return byArray;
        }
        if (string2.equals("mac")) {
            return Mac.encode(byArray);
        }
        if (string2.equals("next")) {
            return Next.encode(byArray);
        }
        if (string2.equals("noconv")) {
            return byArray;
        }
        throw new FormatException("Charset '" + string + "' not recognised");
    }

    public static byte[] decode(byte[] byArray, String string) throws FormatException {
        String string2 = string.toLowerCase();
        if (string2.equals("ascii")) {
            return Ascii.decode(byArray);
        }
        if (string2.equals("alt_codes")) {
            return Cp866.decode(byArray);
        }
        if (string2.equals("cp850")) {
            return Cp850.decode(byArray);
        }
        if (string2.equals("cp852")) {
            return Cp852.decode(byArray);
        }
        if (string2.equals("cp860")) {
            return Cp860.decode(byArray);
        }
        if (string2.equals("cp866")) {
            return Cp866.decode(byArray);
        }
        if (string2.equals("keybcs")) {
            return Keybcs.decode(byArray);
        }
        if (string2.equals("ko18")) {
            return byArray;
        }
        if (string2.equals("latin1")) {
            return byArray;
        }
        if (string2.equals("mac")) {
            return Mac.decode(byArray);
        }
        if (string2.equals("next")) {
            return Next.decode(byArray);
        }
        if (string2.equals("noconv")) {
            return byArray;
        }
        throw new FormatException("Charset '" + string + "' not recognised");
    }
}

