/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.CryptixException;
import cryptix.provider.cipher.NativeLink;
import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Debug;
import cryptix.util.core.Hex;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.Cipher;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SymmetricCipher;

public final class DES
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel;
    private static final PrintWriter err;
    private static NativeLink linkStatus;
    private long native_cookie;
    private Object native_lock;
    private static final int ROUNDS = 16;
    private static final int BLOCK_SIZE = 8;
    private static final int KEY_LENGTH = 8;
    private static final int INTERNAL_KEY_LENGTH = 32;
    private static final int[] SKB;
    private int[] sKey = new int[32];
    private static final int[] SP_TRANS;
    private static final String[][] tests;

    private static void debug(String string) {
        err.println("DES: " + string);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(DES.getLibMajorVersion(), DES.getLibMinorVersion());
                        linkStatus.check(this.native_clinit());
                    }
                    if (linkStatus.useNative()) {
                        linkStatus.check(this.native_init());
                        this.native_lock = new Object();
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    linkStatus.fail((Throwable)unsatisfiedLinkError);
                    if (debuglevel <= 2) break block8;
                    DES.debug(unsatisfiedLinkError.getMessage());
                }
            }
            if (debuglevel > 2) {
                DES.debug("Using native library? " + (this.native_lock != null));
            }
            return;
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private native String native_clinit();

    private native String native_init();

    private native String native_ks(long var1, byte[] var3);

    private native int native_crypt(long var1, byte[] var3, int var4, byte[] var5, int var6, boolean var7);

    private native int[] native_crypt3(long var1, int var3, int var4);

    private native String native_finalize();

    public DES() {
        super(false, false, "Cryptix");
        this.link();
    }

    protected final void finalize() {
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                String string = this.native_finalize();
                if (string != null) {
                    DES.debug(String.valueOf(string) + " in native_finalize");
                }
                return;
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 8;
    }

    public void engineInitEncrypt(Key key) throws InvalidKeyException {
        this.makeKey(key);
    }

    public void engineInitDecrypt(Key key) throws InvalidKeyException, CryptixException {
        this.makeKey(key);
    }

    protected int engineUpdate(byte[] object, int n, int n2, byte[] byArray, int n3) {
        Object object2;
        boolean bl;
        if (n2 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n4 = n2 / 8;
        n2 = n4 * 8;
        boolean bl2 = bl = this.getState() == 1;
        if (object == byArray && (n3 >= n && (long)n3 < (long)n + (long)n2 || n >= n3 && (long)n < (long)n3 + (long)n2)) {
            object2 = new byte[n2];
            System.arraycopy(object, n, object2, 0, n2);
            object = object2;
            n = 0;
        }
        if (this.native_lock != null) {
            object2 = this.native_lock;
            synchronized (object2) {
                if (n < 0 || (long)n + (long)n2 > (long)((byte[])object).length || n3 < 0 || (long)n3 + (long)n2 > (long)byArray.length) {
                    throw new ArrayIndexOutOfBoundsException(String.valueOf(this.getAlgorithm()) + ": Arguments to native_crypt would cause a buffer overflow");
                }
                int n5 = 0;
                while (n5 < n4) {
                    if (this.native_crypt(this.native_cookie, (byte[])object, n, byArray, n3, bl) == 0) {
                        throw new CryptixException(String.valueOf(this.getAlgorithm()) + ": Error in native code");
                    }
                    n += 8;
                    n3 += 8;
                    ++n5;
                }
            }
        } else {
            int n6 = 0;
            while (n6 < n4) {
                this.des((byte[])object, n, byArray, n3, bl);
                n += 8;
                n3 += 8;
                ++n6;
            }
        }
        return n2;
    }

    private void makeKey(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(String.valueOf(this.getAlgorithm()) + ": Null user key");
        }
        if (byArray.length != 8) {
            throw new InvalidKeyException(String.valueOf(this.getAlgorithm()) + ": Invalid user key length");
        }
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                try {
                    linkStatus.check(this.native_ks(this.native_cookie, byArray));
                    Object var4_5 = null;
                    return;
                }
                catch (Error error) {
                    this.native_finalize();
                    this.native_lock = null;
                    if (debuglevel > 0) {
                        DES.debug(String.valueOf(error) + ". Will use 100% Java.");
                    }
                }
            }
        }
        int n = 0;
        int n2 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n3 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n4 = (n3 >>> 4 ^ n2) & 0xF0F0F0F;
        n2 ^= n4;
        n3 ^= n4 << 4;
        n4 = (n2 << 18 ^ n2) & 0xCCCC0000;
        n2 ^= n4 ^ n4 >>> 18;
        n4 = (n3 << 18 ^ n3) & 0xCCCC0000;
        n3 ^= n4 ^ n4 >>> 18;
        n4 = (n3 >>> 1 ^ n2) & 0x55555555;
        n2 ^= n4;
        n3 ^= n4 << 1;
        n4 = (n2 >>> 8 ^ n3) & 0xFF00FF;
        n3 ^= n4;
        n2 ^= n4 << 8;
        n4 = (n3 >>> 1 ^ n2) & 0x55555555;
        n3 ^= n4 << 1;
        n3 = (n3 & 0xFF) << 16 | n3 & 0xFF00 | (n3 & 0xFF0000) >>> 16 | ((n2 ^= n4) & 0xF0000000) >>> 4;
        n2 &= 0xFFFFFFF;
        int n5 = 0;
        n = 0;
        while (n < 16) {
            if ((32508 >> n & 1) == 1) {
                n2 = (n2 >>> 2 | n2 << 26) & 0xFFFFFFF;
                n3 = (n3 >>> 2 | n3 << 26) & 0xFFFFFFF;
            } else {
                n2 = (n2 >>> 1 | n2 << 27) & 0xFFFFFFF;
                n3 = (n3 >>> 1 | n3 << 27) & 0xFFFFFFF;
            }
            int n6 = SKB[n2 & 0x3F] | SKB[0x40 | (n2 >>> 6 & 3 | n2 >>> 7 & 0x3C)] | SKB[0x80 | (n2 >>> 13 & 0xF | n2 >>> 14 & 0x30)] | SKB[0xC0 | (n2 >>> 20 & 1 | n2 >>> 21 & 6 | n2 >>> 22 & 0x38)];
            n4 = SKB[0x100 | n3 & 0x3F] | SKB[0x140 | (n3 >>> 7 & 3 | n3 >>> 8 & 0x3C)] | SKB[0x180 | n3 >>> 15 & 0x3F] | SKB[0x1C0 | (n3 >>> 21 & 0xF | n3 >>> 22 & 0x30)];
            this.sKey[n5++] = n4 << 16 | n6 & 0xFFFF;
            n6 = n6 >>> 16 | n4 & 0xFFFF0000;
            this.sKey[n5++] = n6 << 4 | n6 >>> 28;
            ++n;
        }
    }

    protected void des(byte[] byArray, int n, byte[] byArray2, int n2, boolean bl) {
        int[] nArray = new int[]{byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24, byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n] & 0xFF) << 24};
        DES.initialPermutation(nArray);
        if (bl) {
            this.encrypt_base(nArray);
        } else {
            this.decrypt_base(nArray);
        }
        DES.finalPermutation(nArray);
        int n3 = nArray[0];
        int n4 = nArray[1];
        byArray2[n2++] = (byte)n4;
        byArray2[n2++] = (byte)(n4 >> 8);
        byArray2[n2++] = (byte)(n4 >> 16);
        byArray2[n2++] = (byte)(n4 >> 24);
        byArray2[n2++] = (byte)n3;
        byArray2[n2++] = (byte)(n3 >> 8);
        byArray2[n2++] = (byte)(n3 >> 16);
        byArray2[n2] = (byte)(n3 >> 24);
    }

    private void encrypt_base(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = n2 << 1 | n2 >>> 31;
        n2 = n << 1 | n >>> 31;
        n = n3;
        int n4 = 0;
        while (n4 < 32) {
            n3 = n2 ^ this.sKey[n4++];
            int n5 = n2 ^ this.sKey[n4++];
            n5 = n5 >>> 4 | n5 << 28;
            n ^= SP_TRANS[0x40 | n5 & 0x3F] | SP_TRANS[0xC0 | n5 >>> 8 & 0x3F] | SP_TRANS[0x140 | n5 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n5 >>> 24 & 0x3F] | SP_TRANS[n3 & 0x3F] | SP_TRANS[0x80 | n3 >>> 8 & 0x3F] | SP_TRANS[0x100 | n3 >>> 16 & 0x3F] | SP_TRANS[0x180 | n3 >>> 24 & 0x3F];
            n3 = n ^ this.sKey[n4++];
            n5 = n ^ this.sKey[n4++];
            n5 = n5 >>> 4 | n5 << 28;
            n2 ^= SP_TRANS[0x40 | n5 & 0x3F] | SP_TRANS[0xC0 | n5 >>> 8 & 0x3F] | SP_TRANS[0x140 | n5 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n5 >>> 24 & 0x3F] | SP_TRANS[n3 & 0x3F] | SP_TRANS[0x80 | n3 >>> 8 & 0x3F] | SP_TRANS[0x100 | n3 >>> 16 & 0x3F] | SP_TRANS[0x180 | n3 >>> 24 & 0x3F];
        }
        nArray[0] = n2 >>> 1 | n2 << 31;
        nArray[1] = n >>> 1 | n << 31;
    }

    private void decrypt_base(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = n2 << 1 | n2 >>> 31;
        n2 = n << 1 | n >>> 31;
        n = n3;
        int n4 = 31;
        while (n4 > 0) {
            int n5 = n2 ^ this.sKey[n4--];
            n3 = n2 ^ this.sKey[n4--];
            n5 = n5 >>> 4 | n5 << 28;
            n ^= SP_TRANS[0x40 | n5 & 0x3F] | SP_TRANS[0xC0 | n5 >>> 8 & 0x3F] | SP_TRANS[0x140 | n5 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n5 >>> 24 & 0x3F] | SP_TRANS[n3 & 0x3F] | SP_TRANS[0x80 | n3 >>> 8 & 0x3F] | SP_TRANS[0x100 | n3 >>> 16 & 0x3F] | SP_TRANS[0x180 | n3 >>> 24 & 0x3F];
            n5 = n ^ this.sKey[n4--];
            n3 = n ^ this.sKey[n4--];
            n5 = n5 >>> 4 | n5 << 28;
            n2 ^= SP_TRANS[0x40 | n5 & 0x3F] | SP_TRANS[0xC0 | n5 >>> 8 & 0x3F] | SP_TRANS[0x140 | n5 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n5 >>> 24 & 0x3F] | SP_TRANS[n3 & 0x3F] | SP_TRANS[0x80 | n3 >>> 8 & 0x3F] | SP_TRANS[0x100 | n3 >>> 16 & 0x3F] | SP_TRANS[0x180 | n3 >>> 24 & 0x3F];
        }
        nArray[0] = n2 >>> 1 | n2 << 31;
        nArray[1] = n >>> 1 | n << 31;
    }

    private static void initialPermutation(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = (n2 >>> 4 ^ n) & 0xF0F0F0F;
        n ^= n3;
        n2 ^= n3 << 4;
        n3 = (n >>> 16 ^ n2) & 0xFFFF;
        n2 ^= n3;
        n ^= n3 << 16;
        n3 = (n2 >>> 2 ^ n) & 0x33333333;
        n ^= n3;
        n2 ^= n3 << 2;
        n3 = (n >>> 8 ^ n2) & 0xFF00FF;
        n2 ^= n3;
        n ^= n3 << 8;
        n3 = (n2 >>> 1 ^ n) & 0x55555555;
        nArray[0] = n ^ n3;
        nArray[1] = n2 ^ n3 << 1;
    }

    private static void finalPermutation(int[] nArray) {
        int n = nArray[1];
        int n2 = nArray[0];
        int n3 = (n2 >>> 1 ^ n) & 0x55555555;
        n ^= n3;
        n2 ^= n3 << 1;
        n3 = (n >>> 8 ^ n2) & 0xFF00FF;
        n2 ^= n3;
        n ^= n3 << 8;
        n3 = (n2 >>> 2 ^ n) & 0x33333333;
        n ^= n3;
        n2 ^= n3 << 2;
        n3 = (n >>> 16 ^ n2) & 0xFFFF;
        n2 ^= n3;
        n ^= n3 << 16;
        n3 = (n2 >>> 4 ^ n) & 0xF0F0F0F;
        nArray[1] = n ^ n3;
        nArray[0] = n2 ^ n3 << 4;
    }

    public int[] crypt3(int n, int n2) {
        int n3;
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                int[] nArray = this.native_crypt3(this.native_cookie, n, n2);
                if (nArray == null) {
                    throw new CryptixException(String.valueOf(this.getAlgorithm()) + ": Error in native code");
                }
                int[] nArray2 = nArray;
                Object var5_9 = null;
                return nArray2;
            }
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < 25) {
            int n7 = 0;
            while (n7 < 32) {
                int n8 = n5 ^ n5 >>> 16;
                int n9 = n8 & n;
                n9 ^= n9 << 16 ^ n5 ^ this.sKey[n7++];
                n3 = (n8 &= n2) ^ n8 << 16 ^ n5 ^ this.sKey[n7++];
                n3 = n3 >>> 4 | n3 << 28;
                n8 = (n4 ^= SP_TRANS[0x40 | n3 & 0x3F] | SP_TRANS[0xC0 | n3 >>> 8 & 0x3F] | SP_TRANS[0x140 | n3 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n3 >>> 24 & 0x3F] | SP_TRANS[n9 & 0x3F] | SP_TRANS[0x80 | n9 >>> 8 & 0x3F] | SP_TRANS[0x100 | n9 >>> 16 & 0x3F] | SP_TRANS[0x180 | n9 >>> 24 & 0x3F]) ^ n4 >>> 16;
                n9 = n8 & n;
                n9 ^= n9 << 16 ^ n4 ^ this.sKey[n7++];
                n3 = (n8 &= n2) ^ n8 << 16 ^ n4 ^ this.sKey[n7++];
                n3 = n3 >>> 4 | n3 << 28;
                n5 ^= SP_TRANS[0x40 | n3 & 0x3F] | SP_TRANS[0xC0 | n3 >>> 8 & 0x3F] | SP_TRANS[0x140 | n3 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n3 >>> 24 & 0x3F] | SP_TRANS[n9 & 0x3F] | SP_TRANS[0x80 | n9 >>> 8 & 0x3F] | SP_TRANS[0x100 | n9 >>> 16 & 0x3F] | SP_TRANS[0x180 | n9 >>> 24 & 0x3F];
            }
            n3 = n4;
            n4 = n5;
            n5 = n3;
            ++n6;
        }
        n3 = n4;
        n4 = n5 >>> 1 | n5 << 31;
        n5 = n3 >>> 1 | n3 << 31;
        n3 = (n5 >>> 1 ^ n4) & 0x55555555;
        n4 ^= n3;
        n5 ^= n3 << 1;
        n3 = (n4 >>> 8 ^ n5) & 0xFF00FF;
        n5 ^= n3;
        n4 ^= n3 << 8;
        n3 = (n5 >>> 2 ^ n4) & 0x33333333;
        n4 ^= n3;
        n5 ^= n3 << 2;
        n3 = (n4 >>> 16 ^ n5) & 0xFFFF;
        n5 ^= n3;
        n4 ^= n3 << 16;
        n3 = (n5 >>> 4 ^ n4) & 0xF0F0F0F;
        int[] nArray = new int[]{n4 ^ n3, n5 ^ n3 << 4};
        return nArray;
    }

    public static void main(String[] stringArray) {
        try {
            DES.self_test();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static void self_test() throws Exception {
        Cipher cipher = Cipher.getInstance((String)"DES", (String)"Cryptix");
        int n = 0;
        while (n < tests.length) {
            RawSecretKey rawSecretKey = new RawSecretKey("DES", Hex.fromString((String)tests[n][0]));
            byte[] byArray = Hex.fromString((String)tests[n][1]);
            byte[] byArray2 = Hex.fromString((String)tests[n][2]);
            cipher.initEncrypt((Key)rawSecretKey);
            byte[] byArray3 = cipher.crypt(byArray);
            if (!ArrayUtil.areEqual((byte[])byArray2, (byte[])byArray3)) {
                throw new CryptixException("encrypt #" + n + " failed");
            }
            cipher.initDecrypt((Key)rawSecretKey);
            byArray3 = cipher.crypt(byArray2);
            if (!ArrayUtil.areEqual((byte[])byArray, (byte[])byArray3)) {
                throw new CryptixException("decrypt #" + n + " failed");
            }
            ++n;
        }
        if (debuglevel > 0) {
            DES.debug("Self-test OK");
        }
    }

    static {
        int n;
        int n2;
        debuglevel = Debug.getLevel((String)"DES");
        err = Debug.getOutput();
        linkStatus = new NativeLink("DES", 2, 3);
        SKB = new int[512];
        SP_TRANS = new int[512];
        String string = "D]PKESYM`UBJ\\@RXA`I[T`HC`LZQ\\PB]TL`[C`JQ@Y`HSXDUIZRAM`EK";
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < string.length()) {
            int n6 = string.charAt(n5) - 64;
            if (n6 != 32) {
                n2 = 1 << n3++;
                n = 0;
                while (n < 64) {
                    if ((n2 & n) != 0) {
                        int n7 = n4 + n;
                        SKB[n7] = SKB[n7] | 1 << n6;
                    }
                    ++n;
                }
                if (n3 == 6) {
                    n4 += 64;
                    n3 = 0;
                }
            }
            ++n5;
        }
        String string2 = "g3H821:80:H03BA0@N1290BAA88::3112aIH8:8282@0@AH0:1W3A8P810@22;22A18^@9H9@129:<8@822`?:@0@8PH2H81A19:G1@03403A0B1;:0@1g192:@919AA0A109:W21492H@0051919811:215011139883942N8::3112A2:31981jM118::A101@I88:1aN0<@030128:X;811`920:;H0310D1033@W980:8A4@804A3803o1A2021B2:@1AH023GA:8:@81@@12092B:098042P@:0:A0HA9>1;289:@1804:40Ph=1:H0I0HP0408024bC9P8@I808A;@0@0PnH0::8:19J@818:@iF0398:8A9H0<13@001@11<8;@82B01P0a2989B:0AY0912889bD0A1@B1A0A0AB033O91182440A9P8@I80n@1I03@1J828212A`A8:12B1@19A9@9@8^B:0@H00<82AB030bB840821Q:8310A302102::A1::20A1;8";
        n4 = 0;
        int n8 = 0;
        while (n8 < 32) {
            int n9 = -1;
            n2 = 1 << n8;
            n = 0;
            while (n < 32) {
                int n10 = string2.charAt(n4 >> 1) - 48 >> (n4 & 1) * 3 & 7;
                ++n4;
                if (n10 < 5) {
                    int n11 = n9 += n10 + 1;
                    SP_TRANS[n11] = SP_TRANS[n11] | n2;
                } else {
                    int n12 = string2.charAt(n4 >> 1) - 48 >> (n4 & 1) * 3 & 7;
                    ++n4;
                    if (n10 == 5) {
                        int n13 = n9 += n12 + 6;
                        SP_TRANS[n13] = SP_TRANS[n13] | n2;
                    } else if (n10 == 6) {
                        int n14 = n9 += (n12 << 6) + 1;
                        SP_TRANS[n14] = SP_TRANS[n14] | n2;
                    } else {
                        n9 += n12 << 6;
                        --n;
                    }
                }
                ++n;
            }
            ++n8;
        }
        tests = new String[][]{{"0101010101010101", "95f8a5e5dd31d900", "8000000000000000"}, {"0101010101010101", "dd7f121ca5015619", "4000000000000000"}, {"0101010101010101", "2e8653104f3834ea", "2000000000000000"}};
    }
}

