/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtil {
    public static boolean loadProperties(Properties properties, String string) {
        if (!string.endsWith(".properties")) {
            string = String.valueOf(string) + ".properties";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            if (!FileUtil.doFileOrDir(properties, string, new File(stringTokenizer.nextToken()))) continue;
            return true;
        }
        return false;
    }

    static boolean doFileOrDir(Properties properties, String string, File file) {
        ZipInputStream zipInputStream;
        if (file.isDirectory()) {
            String[] stringArray = file.list(new IdentityFilter(string));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (FileUtil.doFileOrDir(properties, string, new File(file, stringArray[n2]))) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        String string2 = file.getName();
        if (string2.equals(string)) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                properties.load(bufferedInputStream);
                ((FilterInputStream)bufferedInputStream).close();
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
        if (!(string2 = string2.toUpperCase()).endsWith(".ZIP") && !string2.endsWith(".JAR")) {
            return false;
        }
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        boolean bl = false;
        try {
            try {
                ZipEntry zipEntry;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    int n;
                    if (zipEntry.isDirectory() || !(string2 = zipEntry.getName()).endsWith(string)) continue;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
                    byte[] byArray = new byte[512];
                    while ((n = zipInputStream.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                    properties.load(bufferedInputStream);
                    ((FilterInputStream)bufferedInputStream).close();
                    bl = true;
                    break;
                }
            }
            catch (IOException iOException) {
            }
            Object var8_15 = null;
        }
        catch (Throwable throwable) {
            Object var8_16 = null;
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zipInputStream.close();
        }
        catch (IOException iOException) {}
        return bl;
    }

    static boolean doZip(Properties properties, String string, File file) {
        ZipInputStream zipInputStream;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        boolean bl = false;
        try {
            try {
                ZipEntry zipEntry;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    int n;
                    String string2;
                    if (zipEntry.isDirectory() || !(string2 = zipEntry.getName()).endsWith(string)) continue;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
                    byte[] byArray = new byte[512];
                    while ((n = zipInputStream.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                    properties.load(bufferedInputStream);
                    ((FilterInputStream)bufferedInputStream).close();
                    bl = true;
                    break;
                }
            }
            catch (IOException iOException) {
            }
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zipInputStream.close();
        }
        catch (IOException iOException) {}
        return bl;
    }

    static class IdentityFilter
    implements FilenameFilter {
        private String it;

        public IdentityFilter(String string) {
            this.it = string;
        }

        public boolean accept(File file, String string) {
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                return true;
            }
            return file2.isFile() && string.equals(this.it);
        }
    }
}

