#include "globals.h"
#include "scanargs.h"

static int Gargc;
unsigned char **Gargv;
static unsigned char UsageString[] = "Usage: 	laybat input [-u] [-i inc] [-f first] [-s seq1 -s seq2...]\n\t\t[-o output]\n";
static unsigned char VerboseUsage[] = "\t-u Uncompressed output files\n\t-i counter increment\n\t-f counter start\n\t-s imageSequence\n\t-o output File prefix\n";


unsigned char *NextArg()
/* This uses the global args Gargc and Gargv to return the
	next argument.  It returns nil if no more arguments.
*/
{
	if(--Gargc <= 0)
		return(NULL);
	else
		return(*++Gargv);
}

int ScanArgs(argc, argv, scanData)
int argc;
unsigned char *argv[];
ScanData *scanData;
{
	unsigned char *arg, *arg1;
	unsigned char ***imageList;
	int imageCount, seqCount, newCount, i, number;
	unsigned char mode;
	
	if(argc <= 1) {
		printf("%s%s", UsageString, VerboseUsage);
		return(-1);
	}
	Gargc = argc;
	Gargv = argv;
	arg = NextArg();
	if(arg == NULL) {
		printf(UsageString);
		return(-1);
	}
	else 
		scanData->maskName = arg;
	imageList = (unsigned char ***)mMalloc(argc * (sizeof(unsigned char **)/2));
	if(imageList == NULL)
		return(-1);
	imageCount = 0;
	seqCount = 0;
	mode = 0;
	scanData->outName = "layout";		/* Default name */
	scanData->outMode = 1;				/* Default compressed */
	scanData->countFirst = 0;
	scanData->countInc = 1;
	arg = NextArg();
	while(arg != NULL) {
		if(arg[0] == '-') {
			mode = arg[1];
			switch (mode) {
				case 's':
					arg = NextArg();
					imageList[imageCount++] = Gargv;
					newCount = 0;
					while(arg != NULL && arg[0] != '-') {
						arg = NextArg();
						newCount++;
					}
					if(newCount == 0) {
						printf("-s options must have one or more arguments.\n");
						return(-1);
					}
					if(seqCount == 0)
						seqCount = newCount;
					else if(seqCount != newCount) {
						printf("All -s options must have the same number of arguments.\n");
						return(-1);
					}
					break;
				case 'o':
					arg = NextArg();
					if(arg == NULL || arg[0] == '-') {
						printf(UsageString);
						return(-1);
					}
					else {
						scanData->outName = arg;
						arg = NextArg();
					}
					break;
				case 'u':
					scanData->outMode = 0;	/* Uncompressed */
					arg = NextArg();
					break;
				case 'f':
				case 'i':
					arg1 = NextArg();
					if(arg == NULL) {
						printf(UsageString);
						return(-1);
					}
					if(sscanf(arg1, "%d", &number) != 1) {
						printf("%s %s is not a valid option.\n", arg, arg1);
						printf(UsageString);
						return(-1);
					}
					if(mode == 'f')
						scanData->countFirst = number;
					else
						scanData->countInc = number;
					arg = NextArg();
					break;
				default:
					printf("-%c is an invalid option.\n", mode);
					printf(UsageString);
					return(-1);
			}
		}
		else {
				printf(UsageString);
				return(-1);
		}
	}
	scanData->seqCount = seqCount;
	scanData->imageCount = imageCount;
	scanData->imageList = (unsigned char ***)mMalloc(imageCount * sizeof(unsigned char **));
	if(scanData->imageList == NULL)
		return(-1);
	for(i = 0; i < imageCount; i++)
		scanData->imageList[i] = imageList[i];
	free(imageList);
	return(0);
}


