/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: magDialog.c,v 1.6 1993/11/05 18:12:24 gbourhis Exp $";
#endif

/* $Log: magDialog.c,v $
 * Revision 1.6  1993/11/05  18:12:24  gbourhis
 * Initialize the magnify factors in case of wrong input from user.
 *
 * Revision 1.5  1993/08/04  19:46:29  gbourhis
 * Directly destroy the shell widget.
 * 
 */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/SelectioB.h>
#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/LabelG.h>
#include <Xm/TextF.h>
#include <Xm/ToggleBG.h>

#include "view.h"


#ifndef MALLOC
#define MALLOC	malloc
#define FREE	free
#endif

extern double strtod();
extern long strtol();
extern void MakeRaster();


void
CBMagnify(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;
	Arg argList[10];
	Widget toggleInterp, f;
	Cardinal i;
	XmString string;
	char *value, *sptr;
	int xmag=1, ymag=1;
	IntOrFloat min, max;
	int isFloat = V->cData->type == D_FLOAT;

	XtUnmanageChild(V->dialog);

        XtSetArg(argList[0], XmNtextString, &string);
        XtGetValues(V->dialog, argList, 1);
        XmStringGetLtoR(string, XmSTRING_DEFAULT_CHARSET, &value);

	sscanf(value," %d %d", &xmag, &ymag);
	if (xmag < 1)
	{
		xmag = 1;
	}
	if (ymag < 1)
	{
		ymag = 1;
	}
	f = XtNameToWidget(V->dialog, "magnifyForm");
	toggleInterp = XtNameToWidget(f, "toggleInterpolate");

	value = XmTextFieldGetString(XtNameToWidget(f, "min"));
	if (isFloat)
		min.f = strtod(value, &sptr);
	else
		min.i = strtol(value, &sptr, 0);
	if (sptr == value)
		min = V->cData->min;
	XtFree(value);

	value = XmTextFieldGetString(XtNameToWidget(f, "max"));
	if (isFloat)
		max.f = strtod(value, &sptr);
	else
		max.i = strtol(value, &sptr, 0);
	if (sptr == value)
		max = V->cData->max;
	XtFree(value);

	MakeRaster(V, xmag, ymag, XmToggleButtonGadgetGetState(toggleInterp),
		   min, max);

	XtDestroyWidget(XtParent(V->dialog));
	V->dialog = (Widget)NULL;
}


void
CBCancelDialog(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

        XtUnmanageChild(V->dialog);
	XtDestroyWidget(XtParent(V->dialog));
	V->dialog = (Widget)NULL;
}


void
CBGetMagnification(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;
	Cardinal i;
	Arg argList[15];
	Widget dialog, toggleInterp, f, b[5];
	XmString label, valLabel;
	char buff[1024];
	char value[1024];


	if (V->dialog != (Widget)NULL) 
	  {
	    XtManageChild(V->dialog);
	    return;
	  }

	i = 0;
	XtSetArg(argList[i], XtNtitle, "Define X and Y Magnification"); i++;
	XtSetArg(argList[i], XmNallowShellResize, True); i++;
	XtSetArg(argList[i], XmNcolormap,
		 DefaultColormapOfScreen(XtScreen(V->shell))); i++;
	dialog = XmCreateDialogShell(V->shell, "magnifyDialog_popup",
				     argList, i);

	sprintf(buff, "X Y Magnification Levels for %s\n(must be greater than 0)", V->cData->name);
	sprintf(value, "%d %d", 1, 1);

        label = XmStringCreateLtoR(buff, XmSTRING_DEFAULT_CHARSET);
        valLabel = XmStringCreateSimple(value);
	i = 0;
        XtSetArg(argList[i], XmNselectionLabelString, label); i++;
        XtSetArg(argList[i], XmNtextString, valLabel); i++;
        XtSetArg(argList[i], XmNdialogType, XmDIALOG_PROMPT); i++;
        dialog = XtCreateWidget("magnifyDialog", xmSelectionBoxWidgetClass,
				dialog, argList, i);

	XmStringFree(label);

	i = 0;
	f = XmCreateForm(dialog, "magnifyForm", argList, i);


	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_POSITION); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_POSITION); i++;
	b[0] = XmCreateLabelGadget(f, "minLabel", argList, i);

	i = 0;
	if (V->cData->type == D_FLOAT)
	  sprintf(buff, "%g", V->cData->min.f);
	else
	  sprintf(buff, "%d", V->cData->min.i);
	XtSetArg(argList[i], XmNvalue, buff); i++;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_POSITION); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_POSITION); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_POSITION); i++;
	b[1] = XmCreateTextField(f, "min", argList, i);

	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_POSITION); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_POSITION); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_POSITION); i++;
	b[2] = XmCreateLabelGadget(f, "maxLabel", argList, i);

	i = 0;
	if (V->cData->type == D_FLOAT)
	  sprintf(buff, "%g", V->cData->max.f);
	else
	  sprintf(buff, "%d", V->cData->max.i);
	XtSetArg(argList[i], XmNvalue, buff); i++;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_POSITION); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_POSITION); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_POSITION); i++;
	b[3] = XmCreateTextField(f, "max", argList, i);


	label = XmStringCreateSimple("Interpolate");
	i = 0;
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, b[0]); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM); i++;
	b[4] =
	  toggleInterp = XmCreateToggleButtonGadget(f, "toggleInterpolate",
						    argList, i);
	XtManageChildren(b, XtNumber(b));
	XtManageChild(f);
	XmStringFree(valLabel);
	XmStringFree(label);

        XtAddCallback(dialog, XmNokCallback, CBMagnify, (caddr_t)V);
        XtAddCallback(dialog, XmNcancelCallback, CBCancelDialog, (caddr_t)V);
	V->dialog = dialog;
	XtManageChild(dialog);
}

