/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: put.c,v 1.2 1993/05/14 19:13:39 gbourhis Exp $";
#endif


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "doodle.h"
#include "view.h"


extern void RubberBox();
extern void DrawPoints();
extern int MySendDoodle();
extern unsigned long BestColor();


extern int start_x, end_x, start_y, end_y;
extern XColor grabCCells[];


void
StartPutArea(V, w, x, y)
	View *V;
	Widget w;
	int x, y;
{
	start_x = x;
	start_y = y;
	end_x = x + V->cutbuffer->width;
	end_y = y + V->cutbuffer->height;
	RubberBox(w);
}


void
MovePutArea(V, w, x, y)
	View *V;
	Widget w;
	int x, y;
{
	RubberBox(w);
	start_x = x;
	start_y = y;
	end_x = x + V->cutbuffer->width;
	end_y = y + V->cutbuffer->height;
	RubberBox(w);
}



static unsigned long
GrabToDataColor(V, gpixel)
	View *V;
	unsigned long gpixel;
{
	DColor color;

        color.red = grabCCells[gpixel].red / 256;
        color.green = grabCCells[gpixel].green / 256;
        color.blue = grabCCells[gpixel].blue / 256;

	return BestColor(V->cData, &color);
}


static void
NewPutArea(V, w, x0, y0, noback)
	View *V;
	Widget w;
	int x0, y0;
	Boolean noback;
{
        int i, x, y, cnt, status;
	int x1, y1;
	int sent[256];
        unsigned long colr;
        unsigned long save_color;
	POINT doodle[MAXDRAWDOODLE];

	save_color = V->doodleColor;
        RubberBox(w);

	for (i=0; i<256; i++)
	{
		sent[i] = 0;
	}

	cnt = 0;
	if (noback)
	{
		colr = XGetPixel(V->cutbuffer, 0, 0);
		sent[colr] = 1;
	}
	for (y = 0; y < V->cutbuffer->height; y++)
	{
		for (x = 0; x < V->cutbuffer->width; x++)
		{
			colr = XGetPixel(V->cutbuffer, x, y);
			if (sent[colr])
			{
				continue;
			}
			cnt = 0;
			for (y1 = y; y1 < V->cutbuffer->height; y1++)
			{
				for (x1 = 0; x1 < V->cutbuffer->width; x1++)
				{
					if (XGetPixel(V->cutbuffer, x1, y1)
					    != colr)
					{
						continue;
					}
					if (cnt == MAXDRAWDOODLE)
					{
						V->doodleColor =
							GrabToDataColor(V,
									colr);
						DrawPoints(V, V->cData, doodle,
							   0, (cnt - 1),
							   V->doodleColor, 1);
						status = MySendDoodle
							(V, 1, cnt,
							 doodle, True, True);
						cnt = 0;
					}
					doodle[cnt].x = x0 + x1;
					doodle[cnt].y = y0 + y1;
					cnt++;
				}
			}
			V->doodleColor = GrabToDataColor(V, colr);
			DrawPoints(V, V->cData, doodle, 0, (cnt - 1),
				   V->doodleColor, 1);
			status = MySendDoodle(V, 1, cnt, doodle, True, True);
			sent[colr] = 1;
		}
	}
	V->doodleColor = save_color;
}


void
DonePutArea(V, w, x0, y0)
	View *V;
	Widget w;
	int x0, y0;
{
	if (V->cutbuffer != NULL)
	{
		NewPutArea(V, w, x0, y0, False);
	}
}


void
DonePutAreaTrans(V, w, x0, y0)
	View *V;
	Widget w;
	int x0, y0;
{
	if (V->cutbuffer != NULL)
	{
		NewPutArea(V, w, x0, y0, True);
	}
}

