/***********************************************************
        Copyright 1991 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#ifndef _PREFERENCESTRUCT_H
#define _PREFERENCESTRUCT_H

static char PreferenceStruct_rcs_idH[]= "$Header: /afs/andrew.cmu.edu/system/src/local/depot/016/RCS/PreferenceStruct.h,v 4.2 1992/02/12 18:05:04 ww0r Exp $";

/*
 * Author: Sohan C. Ramakrishna Pillai
 */



typedef struct preference
{
  char *ItemName;	/* item whose preference is being referred to */
  char *PreferenceName;	/* preference being referred to */
  u_short type;	/* type of value of preference */
  union
    {
      int ival;
      unsigned uval;
      Boolean boolval;
      char *strval;
      char **strarrval;
    } value;
} PREFERENCE;

typedef struct preferencelist
{
  struct preferencelist	*next;
  PREFERENCE		preference;
} PREFERENCELIST;

#define PREFERENCELIST_next(p)	((p)->next)
/*
 * $Log: PreferenceStruct.h,v $
 * Revision 4.2  1992/02/12  18:05:04  ww0r
 * make RCS headers visibile
 * added protection against double includes
 *
 * Revision 4.1  1991/10/08  21:52:49  dl2n
 * add CMU copyright
 *
 * Revision 4.0  1991/09/25  17:36:33  sohan
 * Release 4
 *
 * Revision 4.0  1991/09/25  16:08:52  sohan
 * Version 4.0
 *
 */

#endif /* _PREFERENCESTRUCT_H */
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot/016/RCS/PreferenceStruct.h,v $ */

