#include <stdio.h>
#include "gchdr.h"
#include "gcio.h"

#if DEBUG_ALLOC > 0

static unsigned long total_allocated;
static unsigned long max_allocated;

void _assert_(P(char *) expr, P(char *) file, P(long) line)
PP(char *expr;)
PP(char *file;)
PP(long line;)
{
	fflush(stdout);
	fprintf(stderr, "Assertion failed: %s\n", expr);
	fprintf(stderr, "file %s, line %ld\n", file, line);
	abort();
}


#ifdef __TOS__
#define display_allocated() \
	if (debug) \
	{ \
		fprintf(stderr, "\033j\033Y \\%8lu\033k", total_allocated); \
		if (total_allocated > max_allocated) \
		{ \
			max_allocated = total_allocated; \
			fprintf(stderr, "\033j\033Y f%8lu\033k", max_allocated); \
		} \
		fflush(stderr); \
	}
#else
#define display_allocated() \
	if (debug) \
	{ \
		fprintf(stderr, "\033[s\033[1;60H%8lu\033[u", total_allocated); \
		if (total_allocated > max_allocated) \
		{ \
			max_allocated = total_allocated; \
			fprintf(stderr, "\033[s\033[1;70H%8lu\033[u", max_allocated); \
		} \
		fflush(stderr); \
	}
#endif

#define HEAD_MEM (sizeof(ALLOC_HEAD))
#define TAIL_MEM 4
#define EXTRA_MEM (HEAD_MEM + TAIL_MEM)
#define MAGIC1 0x55
#define MAGIC2 0x77

#if DEBUG_ALLOC > 1
ALLOC_HEAD *alloc_list;

static void delete_alloc_list _(( ALLOC_HEAD * ));

static void delete_alloc_list(P(ALLOC_HEAD *) block)
PP(ALLOC_HEAD *block;)
{
	ALLOC_HEAD *search = alloc_list;
	
	if (block == search)
	{
		alloc_list = search->next;
	} else {
		while (search && search->next != block)
			search = search->next;
		if (search && search->next == block)
		{
			search->next = search->next->next;
		} else {
			_assert_("Block not found", __FILE__, __LINE__);
		}
	}
}
#endif /* DEBUG_ALLOC > 1 */


void debug_free(P(void *) block, P(size_t) size)
PP(void *block;)
PP(size_t size;)
{
	register ALLOC_HEAD *start = (ALLOC_HEAD *)block - 1;
	
	block = start;
	ASSERT(start->magic1[0] == MAGIC1);
	ASSERT(start->magic1[1] == MAGIC1);
	ASSERT(start->magic1[2] == MAGIC1);
	ASSERT(start->magic1[3] == MAGIC1);
	if (size == -1)
		size = start->sf.size;
	ASSERT(size == start->sf.size);
#if DEBUG_ALLOC > 1
	delete_alloc_list(start);
#endif
	size = start->sf.size;
	total_allocated -= size;
	display_allocated();
	start = (ALLOC_HEAD *)((char *)(start + 1) + start->sf.size);
	ASSERT(start->sf.magic2[0] == MAGIC2);
	ASSERT(start->sf.magic2[1] == MAGIC2);
	ASSERT(start->sf.magic2[2] == MAGIC2);
	ASSERT(start->sf.magic2[3] == MAGIC2);
	memset(block, 0x99, size + EXTRA_MEM);
	free(block);
}


void *debug_getmem(P(size_t) size, P(char *) from)
PP(size_t size;)
PP(char *from;)
{
	ALLOC_HEAD *block;
	char *start;
	
	block = malloc(size + EXTRA_MEM);
	if (block != NULL)
	{
		block->sf.size = size;
		block->who = from;
#if DEBUG_ALLOC > 1
		block->next = alloc_list;
		alloc_list = block;
#endif
		start = block->magic1;
		*start++ = MAGIC1;
		*start++ = MAGIC1;
		*start++ = MAGIC1;
		*start++ = MAGIC1;
		start += size;
		*start++ = MAGIC2;
		*start++ = MAGIC2;
		*start++ = MAGIC2;
		*start++ = MAGIC2;
		++block;
		total_allocated += size;
		memset(block, 0xBB, size);
		display_allocated();
	}
	return(block);
}


void *debug_getcmem(P(size_t) nitems, P(size_t) size, P(char *) from)
PP(size_t nitems;)
PP(size_t size;)
PP(char *from;)
{
	void *block;
	
	block = debug_getmem(size * nitems, from);
	if (block != NULL)
	{
		memset(block, 0, size * nitems);
	}
	return(block);
}


char *debug_str_dup(P(char *) str, P(char *) from)
PP(char *str;)
PP(char *from;)
{
	char *new;
	
	if (str == NULL)
		return(NULL);
	new = debug_getmem(strlen(str)+1, from);
	if (new != 0)
		strcpy(new, str);
	return(new);
}


void *debug_realloc(P(void *) old, P(size_t) newsize, P(size_t) oldsize,
	P(char *) from)
PP(void *old;)
PP(size_t newsize;)
PP(size_t oldsize;)
PP(char *from;)
{
	ALLOC_HEAD *block = (ALLOC_HEAD *)old - 1;
	
	ASSERT(block->magic1[0] == MAGIC1);
	ASSERT(block->magic1[1] == MAGIC1);
	ASSERT(block->magic1[2] == MAGIC1);
	ASSERT(block->magic1[3] == MAGIC1);
	ASSERT(block->sf.size == oldsize);
#if DEBUG_ALLOC > 1
	delete_alloc_list(block);
#endif
	block = realloc(block, newsize+EXTRA_MEM);
	if (block != NULL)
	{
		register char *start;
		
		block->sf.size = newsize;
		block->who = from;
#if DEBUG_ALLOC > 1
		block->next = alloc_list;
		alloc_list = block;
#endif
		start = block->magic1;
		ASSERT(*start == MAGIC1); start++;
		ASSERT(*start == MAGIC1); start++;
		ASSERT(*start == MAGIC1); start++;
		ASSERT(*start == MAGIC1); start++;
		start += oldsize;
		ASSERT(*start == MAGIC2); *start++ = 0;
		ASSERT(*start == MAGIC2); *start++ = 0;
		ASSERT(*start == MAGIC2); *start++ = 0;
		ASSERT(*start == MAGIC2); *start++ = 0;
		start += newsize - oldsize - 4;
		*start++ = MAGIC2;
		*start++ = MAGIC2;
		*start++ = MAGIC2;
		*start++ = MAGIC2;
		++block;
		total_allocated += newsize - oldsize;
		if (newsize > oldsize)
			memset((char *)block + oldsize, 0xbb, newsize - oldsize);
		display_allocated();
	}
	return(block);
}

#endif /* DEBUG_ALLOC */
