#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "gcio.h"

#ifndef FALSE
#  define FALSE 0
#  define TRUE (!FALSE)
#endif

int verbose = TRUE;


int main(argc, argv)
int argc;
char **argv;
{
	char *argp;
	char *p;
	PLAYER *me;
	int ok;
	
	while (--argc)
	{
		if (*(argp = *++argv) == '-')
		{
			switch (*++argp)
			{
			case 'v':
				verbose = TRUE;
				break;
			}
		} else {
			p = strrchr(argp, '\\');
			if (p == NULL)
				p = strrchr(argp, '/');
			if (p == NULL)
				p = argp;
			else
				++p;
			if ((p = strchr(p, '.')) != NULL)
				*p = '\0';
			ok = FALSE;
			switch (get_gcb(argp, &gc_global))
			{
			case OK:
				me = get_player(gc_global.sp_nummer);
				switch (get_fln(me, argp))
				{
				case OK:
					switch (put_flb(me, argp))
					{
					case FEHLER_O:
						fprintf(stderr, "can't create %s%s\n", argp, EXT_FLB);
						break;
					case FEHLER_W:
						fprintf(stderr, "error writing %s%s\n", argp, EXT_FLB);
						break;
					case FEHLER_M:
						fprintf(stderr, "not enough memory\n");
						break;
					case OK:
						ok = TRUE;
						break;
					}
					break;
				case FEHLER_O:
					fprintf(stderr, "can't open %s%s\n", argp, EXT_FLN);
					break;
				case FEHLER_F:
					fprintf(stderr, "format error in %s%s\n", argp, EXT_FLN);
					break;
				case FEHLER_M:
					fprintf(stderr, "not enough memory\n");
					break;
				}
				break;
			case FEHLER_V:
				fprintf(stderr, "version mismatch in %s%s\n", argp, EXT_GCB);
				break;
			case FEHLER_O:
				fprintf(stderr, "can't open %s%s\n", argp, EXT_GCB);
				break;
			case FEHLER_F:
				fprintf(stderr, "format error in %s%s\n", argp, EXT_GCB);
				break;
			case FEHLER_M:
				fprintf(stderr, "not enough memory\n");
				break;
			}
			if (ok == FALSE)
				exit(1);
		}
	}
	return(0);
}
