#include <stdio.h>
#include <ctype.h>
#include "gchdr.h"
#include "gcio.h"

#if defined(__TURBOC__) && defined(__TOS__) && !defined(DIRENT)
#include <ext.h>
#else
#if defined(__TURBOC__) && defined(__MSDOS__) && !defined(DIRENT)
#include <dir.h>
#else
#if defined(MSWIN) || defined(MSDOS) || defined(MSVCPP) || defined(__BORLANDC__)
#ifdef __BORLANDC__
# define _find_t find_t
#else
# include <machine.h>
#endif
#include <direct.h>
#include <dos.h>
#else
#if defined(DIRENT) || (defined(_POSIX_VERSION) && !defined(NeXT))
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#include <dirent.h>
#ifdef direct
#undef direct
#endif
#define direct dirent
#define NLENGTH(direct) (strlen((direct)->d_name))
#else /* not (DIRENT or _POSIX_VERSION) */
#define NLENGTH(direct) ((direct)->d_namlen)
#ifdef SYSNDIR
#include <sys/ndir.h>
#endif /* SYSNDIR */
#ifdef SYSDIR
#include <sys/dir.h>
#endif /* SYSDIR */
#ifdef NDIR
#include <ndir.h>
#endif /* NDIR */
#endif /* MSWIN || MSDOS || MSVCPP */
#endif /* DIRENT or _POSIX_VERSION */
#endif /* __TURBOC__ && __MSDOS__ */
#endif /* __TURBOC__ && __TOS__ */

#ifdef VOID_CLOSEDIR
/* Fake a return value. */
#define CLOSEDIR(d) (closedir (d), 0)
#else
#define CLOSEDIR(d) closedir (d)
#endif

/*
 * GCB-Datei fuer Spieler im Verzeichnis suchen
 */
WORD suche_spielername(P(char *) namen, P(char *) ext, P(WORD) max_namen)
PP(char *namen;)
PP(char *ext;)
PP(WORD max_namen;)
{
	WORD spieler = 0;
#if defined(MSWIN) || defined(MSDOS) || defined(MSCVPP) || defined(__BORLANDC__)
	WORD nichtda;
	char *gefunden;
	struct _find_t info;
	char pattern[20];
	char ext2[MAX_PATHLEN];

	strcpy(ext2, ext);
	gefunden = ext2;
	while (*gefunden)
	{
		*gefunden = toupper(*gefunden);
		gefunden++;
	}
	sprintf(pattern, "*%s", ext);
	nichtda = _dos_findfirst(pattern, _A_NORMAL, &info );
    while (!nichtda)
    {
        if (spieler < max_namen)
        {
            gefunden = strstr(&info.name[0], ext);
            if (gefunden == NULL)
                gefunden = strstr(&info.name[0], ext2);
            if (gefunden != NULL)
            {
                *gefunden = '\0';
                strncpy(namen + (MAX_NAMELG * spieler), info.name, MAX_NAMELG);
                spieler++;
            }
        }
        nichtda = _dos_findnext(&info);
    }
#else   /* !MSWIN && !MSDOS && !MSVCPP */
#if defined(__TURBOC__) && !defined(DIRENT)
	WORD nichtda;
	char *gefunden;
	struct ffblk info;
	char pattern[20];
	char ext2[MAX_PATHLEN];

	*namen = '\0';
	strcpy(ext2, ext);
	gefunden = ext2;
	while (*gefunden)
	{
		*gefunden = toupper(*gefunden);
		gefunden++;
	}
	sprintf(pattern, "*%s", ext);
	nichtda = findfirst(pattern, &info, 0);
	while (!nichtda)
	{
		if (spieler < max_namen)
		{
			gefunden = strstr(&info.ff_name[0], ext);
			if (gefunden == NULL)
				gefunden = strstr(&info.ff_name[0], ext2);
			if (gefunden != NULL)
			{
				*gefunden = '\0';
				strncpy(namen + (MAX_NAMELG * spieler), info.ff_name, MAX_NAMELG);
				spieler++;
			}
		}
		nichtda = findnext(&info);
	}
#else	/* !__TURBOC__ */
	DIR *ordner;
	char *gefunden;
	struct direct *info;
	char ext2[MAX_PATHLEN];

	strcpy(ext2, ext);
	gefunden = ext2;
	while (*gefunden)
	{
		*gefunden = toupper(*gefunden);
		gefunden++;
	}
	*namen = '\0';
	ordner = opendir(".");
	if (ordner != NULL)
	{
		while (((info = readdir(ordner)) != NULL) && (spieler < max_namen))
		{
			gefunden = strstr(&info->d_name[0], ext);
			if (gefunden == NULL)
				gefunden = strstr(&info->d_name[0], ext2);
			if (gefunden != NULL)
			{
				*gefunden = '\0';
				strncpy(namen + (MAX_NAMELG * spieler), info->d_name, MAX_NAMELG);
				spieler++;
			}
		}
		closedir(ordner);
	}
#endif /* MSWIN || MSDOS || MSVCPP */
#endif	/* __TURBOC__ */
	return(spieler);
}


