#include <stdio.h>
#include "gchdr.h"
#include "gcio.h"

#if !DEBUG_ALLOC
#define getmem malloc
#define getcmem calloc
#endif

static BYTE _get_lgb _(( BYTE **, FILE *, long, int ));

/*
 * Lagebericht einlesen
 */
static BYTE _get_lgb(P(BYTE **) lgb_datei, P(FILE *) datei_handle,
	P(long) lgb_gr, P(int) zeichensatz)
PP(BYTE **lgb_datei;)
PP(FILE *datei_handle;)
PP(long lgb_gr;)
PP(int zeichensatz;)
{
	UBYTE *b_zeiger;
	UBYTE *sucher;
	WORD umlaut = 0;

	/* Wenn kein Iso-zeichensatz dann 1% mehr Platz, fuer die E's */
	if (zeichensatz == Z_IBM_TO_ASCII)
		umlaut = (int) (lgb_gr / 100) + 1;
	*lgb_datei = (BYTE *) long_alloc(lgb_gr + umlaut + 1, "_get_lgb");
	if (*lgb_datei == NULL)
		return(FEHLER_M);

	/* einlesen in Anfang + Umlaut, wegen der Umlaut E's */
	sucher = (UBYTE *)(*lgb_datei + umlaut);
	if (fread(sucher, 1, lgb_gr, datei_handle) != lgb_gr)
	{
		return(FEHLER_R);
	}
	sucher[lgb_gr] = '\0';
	b_zeiger = (UBYTE *)(*lgb_datei);

	switch (zeichensatz)
	{
	case Z_IBM_TO_ISO:
		while (*sucher)
		{
			/* suchen der Umlaute (>127) */
			switch (*sucher)
			{
			case 0x81:
				*b_zeiger++ = 0xfc;		/* ue */
				break;
			case 0x84:
				*b_zeiger++ = 0xe4;		/* ae */
				break;
			case 0x8e:
				*b_zeiger++ = 0xc4;		/* Ae */
				break;
			case 0x94:
				*b_zeiger++ = 0xf6;		/* oe */
				break;
			case 0x99:
				*b_zeiger++ = 0xd6;		/* Oe */
				break;
			case 0x9a:
				*b_zeiger++ = 0xdc;		/* Ue */
				break;
			case 0x9e:
			case 0xe1:
				*b_zeiger++ = 0xdf;		/* ss */
				break;
			case 0xdd:
				*b_zeiger++ = 0xa7;		/* deutsches Paragraphz.*/
				break;
			default:
				*b_zeiger++ = *sucher;
				break;
			}
			sucher++;
		}
		break;
		
	case Z_IBM_TO_ATARI:
		while (*sucher)
		{
			switch (*sucher)
			{
			case 0xe1:
				*b_zeiger++ = 0x9e;
				break;
			default:
				*b_zeiger++ = *sucher;
			}
			sucher++;
		}
		break;
		
	case Z_IBM_TO_ASCII:
		while (*sucher && umlaut)
		{
			switch (*sucher)
			{
			case 0x81:					/* ue */
				*b_zeiger++ = 'u';
				*b_zeiger++ = 'e';
				umlaut--;
				break;
			case 0x84:					/* ae */
				*b_zeiger++ = 'a';
				*b_zeiger++ = 'e';
				umlaut--;
				break;
			case 0x8e:					/* Ae */
				*b_zeiger++ = 'A';
				*b_zeiger++ = 'e';
				umlaut--;
				break;
			case 0x94:					/* oe */
				*b_zeiger++ = 'o';
				*b_zeiger++ = 'e';
				umlaut--;
				break;
			case 0x99:					/* Oe */
				*b_zeiger++ = 'O';
				*b_zeiger++ = 'e';
				umlaut--;
				break;
			case 0x9a:					/* Ue */
				*b_zeiger++ = 'U';
				*b_zeiger++ = 'e';
				umlaut--;
				break;
			case 0x9e:
			case 0xe1:					/* ss */
				*b_zeiger++ = 's';
				*b_zeiger++ = 's';
				umlaut--;
				break;
			default:
				*b_zeiger++ = *sucher;
				break;
			}
			sucher++;
		}
		/* Rest kopieren */
		while (*sucher)
			*b_zeiger++ = *sucher++;
		*b_zeiger = '\0';
		break;
	}
	return(OK);
}


BYTE get_lgb(P(char *) pathname, P(BYTE **) lgb_datei, P(int) zeichensatz)
PP(char *pathname;)
PP(BYTE **lgb_datei;)
PP(int zeichensatz;)
{
	FILE *datei_handle;
	long lgb_gr;
	BYTE fehler;
	char datei[MAX_PATHLEN + 5];

	sprintf(datei, "%s%s", pathname, EXT_LGB);

	if ((datei_handle = fopen(datei, FREAD_BIN)) == NULL)
	{
		return(FEHLER_O);
	}
	if (verbose)
		fprintf (stderr, "reading %s ...\n", datei);
	lgb_gr = datei_laenge(datei_handle);
	fehler = _get_lgb(lgb_datei, datei_handle, lgb_gr, zeichensatz);
	f_close(datei_handle);
	return(fehler);
}



