#ifndef WORD
# define WORD short
#endif
#ifndef UWORD
# define UWORD unsigned WORD
#endif
#ifndef BYTE
#  ifdef __STDC__
#    ifdef __CHAR_UNSIGNED__
#      define BYTE signed char
#    endif
#  endif
#  ifndef BYTE
#    define BYTE char
#  endif
#endif
#ifndef UBYTE
#  define UBYTE unsigned char
#endif

/* minimale Versions-Nummern, die die Routinen behandeln koennen */
#define GC_MIN_MAJOR 2
#define GC_MIN_MINOR 41

/* aktuelle Versions-Nummer */
#define GC_MAJOR 2
#define GC_MINOR 50

#define GC_VERSION_NUMBER(major, minor) ((major) * 100 + (minor))
#define GC_MIN_VERSION GC_VERSION_NUMBER(GC_MIN_MAJOR, GC_MIN_MINOR)
#define GC_VERSION     GC_VERSION_NUMBER(GC_MAJOR, GC_MINOR)
#define GCB_VERSION    GC_VERSION_NUMBER(gc_global.major, gc_global.minor)

#ifndef FALSE
#  define FALSE (0)
#  define TRUE (!FALSE)
#endif

#define MAX_PATHLEN 512				/* an arbitrary value */

/*
 * Open-Modi fuer fopen()
 */
#ifndef FREAD_TEXT
#  define FREAD_TEXT "r"
#endif
#ifndef FREAD_BIN
#  define FREAD_BIN "rb"
#endif
#ifndef FWRITE_TEXT
#  define FWRITE_TEXT "w"
#endif
#ifndef FWRITE_BIN
#  define FWRITE_BIN "wb"
#endif


#define	BUFFER_GR		256

#define	MAX_SPIELER		50				/* Max.	Anzahl der GC-Spieler			*/
#define	MAX_NAMELG		21				/* Max.	Laenge des Spielernamen			*/
#define	MAX_SCHIFFE		200				/* Max.	Anzahl der Schiffe				*/
#define	MAX_STYPEN		39				/* Max.	Anzahl der Schiffstypen			*/
#define	MAX_WERFT		3				/* Max.	Anzahl der Werften pro Planet	*/
#define MAX_GEHEIM      50		 		/* Max. Anzahl Spionage/Korruption		*/
#define	ANZ_TL			10				/* Anzahl der Tech-Level				*/

/* Ladungen */
#define LAD_SPARES		0
#define LAD_MPE			1
#define LAD_LPE			2
#define LAD_RPE			3
#define LAD_MKITS		4
#define LAD_LKITS		5
#define LAD_RKITS		6
#define LAD_FKITS		7
#define LAD_KOLONIST	8
#define	ANZ_LADUNG		9				/* transportable Gueter					*/

/* Produzierbare Gueter */

#define GUT_FESTUNG 	0
#define GUT_MINEN   	1
#define GUT_MKITS   	2
#define GUT_LANDW   	3
#define GUT_LKITS   	4
#define GUT_RAFF    	5
#define GUT_RKITS   	6
#define GUT_FABRIK  	7
#define GUT_FKITS   	8
#define GUT_WERFT1  	9
#define GUT_WERFT2  	10
#define GUT_WERFT3  	11
#define	ANZ_GUETER		12				/* Festungen, Kits,	Werften,...			*/

#define FG_DEFENSE  	0
#define FG_SPY      	1
#define FG_MEDICINE 	2
#define FG_ARMS     	3
#define FG_SHIELDS  	4
#define FG_RANGE    	5
#define FG_CONS     	6
#define	ANZ_FG			7				/* Anzahl der Forschungsbereiche		*/

typedef struct {
	UWORD	percent_planetoff;			/* +% pro TL zu treffen					*/
	UWORD	percent_planetdef;			/* -% pro TL getroffen zu werden		*/
	UWORD	range[ANZ_TL];				/* + Reichweite je TL					*/
	UWORD	radius[ANZ_TL];				/* + Sichtbereich um Planet je TL		*/
	UWORD	percent_spionage[ANZ_TL];	/* % Spionage pro PE je TL				*/
	UWORD	loyal[ANZ_TL];				/* +/- Loyal. pro 10 PE je TL			*/
	UWORD	percent_medicine[ANZ_TL];	/* % Bevoelkerungswachstum je TL		*/
	UWORD	percent_arms;				/* +% pro TL zu treffen					*/
	UWORD	percent_shield;				/* -% pro TL getroffen zu werden		*/
	UWORD	drive[ANZ_TL];				/* + Reichweite je TL					*/
	UWORD	percent_construction;		/* -% Schiffsbaukosten pro TL			*/
	UWORD	percent_kills;				/* +% pro Kill zu treffen				*/
	UWORD	bonus_festung;				/* -PE Festungsbaukosten pro TL			*/
	UWORD	spares_per_pe;				/* #Ersatzteile pro PE					*/ 
	UWORD	percent_natdef;				/* -% pro Natv. getroffen zu werden		*/
	UWORD	percent_loyal;				/* -% pro 10 - Loyal. PEs				*/
	UWORD	percent_pop_grow;			/* +% pro 10 - Natv. Bevwachstum		*/ 
} GC_CONFIG;


typedef	struct shp {
/* Daten aus FLN-Datei */
	WORD	s_number;					/* Schiffsnummer						*/
	WORD	s_kills;					/* Anz.	der	vernichteten Feindschiffe	*/
	WORD	s_pos;						/* Moment. Position	(Planetennummer)	*/
										/* Falls 0 ist Schiff unterwegs			*/
	WORD	s_ziel;						/* Zielplanet							*/
	UBYTE	s_typ;						/* Schiffstyp							*/
	UBYTE	s_atl;						/* Angriffs-Tech-Level des Schiffs		*/
	UBYTE	s_vtl;						/* Verteid.-Tech-Level des Schiffs		*/
	UBYTE	s_reichw;					/* Reichweite							*/
	UBYTE	s_moved;					/* In dieser Runde schon bewegt?		*/
	UBYTE	s_distance;					/* Distanz bis zum Zielplanet			*/
	UBYTE	s_tf_nr;					/* zugeordnete Task-Force				*/
	BYTE	s_cur_def;					/* Momentaner Verteidigungswert			*/
	UBYTE	s_cur_transp;				/* Belegte Transportkapazitaet			*/
	UBYTE	s_ladung[ANZ_LADUNG];		/* Ladung (TE=Transporteinheit)			*/
										/* ladung[0] = Anz.	TE m. Ersatzteile	*/
										/* ladung[1] = Anz.	TE m. Minen-PE		*/
										/* ...									*/
										/* ladung[8] = Anz.	TE m. Kolonisten	*/
										/* Die wirklich	geladene Anz. ergibt	*/
										/* sich	aus	diesem Wert	und	der	aus		*/
										/* der aus der GCB-Datei zu	entneh-		*/
										/* menden Anz. pro Transporteinh.		*/

/* ab hier die Sachen fuer'n EDITOR */
	WORD s_new_ziel;					/* neuer ZielPl							*/
	WORD s_new_pos;						/* neue Position                        */
	WORD s_new_ladung[ANZ_LADUNG];		/* neue Ladung, +L/-E					*/
	UBYTE s_schrott;					/* Schiff verschrotten					*/
	UBYTE s_new_tf_nr;					/* neue TF-Nummer						*/
	UWORD s_new_owner;					/* Neuer Besitzer des Schiffs			*/
} SCHIFF;


typedef	struct {
	UBYTE	w_groesse;					/* Werftgroesse							*/
	UBYTE	w_pe_in_runde;				/* In der laufenden	Runde invest. PE	*/
	WORD	w_pe;						/* Bereits in den Bau investierte PE	*/
	UBYTE	w_typ;						/* zu bauender Schiffstyp				*/
	UBYTE	w_erster;					/* Erstes Schiff dieses	Typs ?			*/
} WFT;

typedef struct {
	WORD  m_target;						/* ZielPL +Information/-Korruption		*/
	WORD  m_pe;							/* Anzahl der in I/K investierte PE		*/
} MAD;


/*
 * Planeten-Struktur
 */ 
typedef	struct plnt {
/* Daten aus BAS- bzw. PLB-Datei */
	WORD	p_number;					/* Nummer des Planeten					*/
	UBYTE	p_pos_x;					/* X-Position							*/
	UBYTE	p_pos_y;					/* Y-Position							*/
	UBYTE	p_owner;					/* Besitzer	(Spielernummer)				*/
	UBYTE	p_nat_def;					/* natuerliche Verteidigung				*/
	WORD	p_pe;						/* Verfuegbare PE						*/
	UBYTE	p_max_minen;				/* Maximale	Anzahl Minen				*/
	UBYTE	p_minen;					/* Vorhandene Minen						*/
	UBYTE	p_max_landw;				/* Maximale	Anz. Landw.					*/
	UBYTE	p_landw;					/* Vorhandene Landw.					*/
	UBYTE	p_max_raffs;				/* Maximale	Anzahl Raffs				*/
	UBYTE	p_raffs;					/* Vorhandene Raffs.					*/
	WORD	p_fabriken;					/* Vorhandene Fabriken					*/
	WORD	p_ladung[ANZ_LADUNG];		/* Vorhandene Ersatzteile etc.			*/
	WORD	p_festungen;				/* Anzahl Festungen						*/
	WORD	p_loyal;					/* Loyalitaet der Bevoelkerung			*/
	WORD	p_kampf;					/* -------------------------			*/
	WORD	p_num_ships;				/* Anzahl Schiffe in Umlaufbahn			*/
	WFT		p_werft[MAX_WERFT];			/* Infos zu	den	Werften					*/
	UBYTE	p_visited;					/* Datum des Besuchs (1=Zug	1,...)		*/
	BYTE	p_bonus;					/* Bonus								*/
										/* > 0 : Bonusplanet					*/
										/*   0 : kein Bonusplanet				*/
										/*	-1 : befreiter Ex-Bonusplanet		*/
	WORD	p_no_use1;
	WORD	p_no_use2;
	
/* ab hier die Sachen fuer'n EDITOR */
	UBYTE	p_old;						/* 0 = in dieser Runde neu erobert		*/
	UWORD	p_new_pe;					/* noch verfuegbare PE					*/
	WORD	p_locked;					/* Sperr-Flag bei mehreren Fenstern		*/
	
	WFT		p_new_werft[MAX_WERFT];		/* neue Werftdaten						*/
	MAD		p_geheim[MAX_GEHEIM];		/* insgesamt nur 50 I und K pro PL		*/
	UWORD	p_inst_mkits;				/* Installierte M-Kits					*/
	UWORD	p_inst_lkits;				/* Installierte L-Kits					*/
	UWORD	p_inst_rkits;				/* Installierte R-Kits					*/
	UWORD	p_inst_fkits;				/* Installierte F-Kits					*/
	WORD	p_new_ladung[ANZ_LADUNG];	/* neue Ladung, +L/-E					*/
	UWORD	p_forschen[ANZ_FG];			/* In Forschung investierte PE			*/
	WORD	p_new_minen;				/* Neue Anzahl Minen					*/
	WORD	p_new_landw;				/* Neue Anzahl landw. Betriebe			*/
	WORD	p_new_raffs;				/* Neue Anzahl Raffinerien				*/
	WORD	p_new_fabriken;				/* Neue Anzahl Fabriken					*/
	WORD	p_new_festungen;			/* Anzahl Festungen						*/
} PLANET;


/*
 * Koordinatenangaben
 */
typedef struct {
	WORD	x;
	WORD	y;
} XY;


/*
 * Grenzen
 */
typedef struct _limes {
	WORD	l_number;					/* Planeten-Nummer; 0: nur Koordinaten	*/
	double	l_x;						/* X-Koordinate							*/
	double	l_y;						/* Y-Koordinate							*/
	WORD	l_limes_number;				/* fortlaufende Nummer					*/
	struct  _limes *l_next;
} LIMES;


typedef struct {
	char *textbuf;						/* Text									*/
	char **lines;						/* Zeiger auf Zeilenanfaenge			*/
	long numlines;						/* Anzahl der Zeilen					*/
	long maxw;							/* Laenge der breitesten Zeile			*/
} REPORT;


/*
 * Planeteninformation pro Spieler
 */

typedef struct planetlist {
	WORD	l_owner;					/* Eigentuemer des Planeten				*/
	WORD	l_number;					/* Nummer des Planeten					*/
	XY		l_koordinate;				/* Absolute bzw. relative Koordinate	*/
	WORD	l_status;					/* Status der Planeteninformation		*/
	WORD	l_planetrange;				/* spyrange des Planeten				*/
	WORD	l_flight_min;				/* minimale Flugreichweite              */
	WORD	l_flight_max;				/* maximale Flugreichweite              */
	UBYTE	l_natdef;					/* Natuerliche Planetenverteidigung		*/
	WORD	l_festungen;				/* Anzahl Festungen						*/
	WORD	l_visited;					/* Datum der Information				*/
	PLANET	*l_planet;					/* Restliche Informationen				*/
	struct	planetlist *l_next;			/* -> Naechster Planet					*/
} PlanetList;

typedef struct _player {
	WORD	pl_number;					/* Spielernummer						*/
	char	pl_name[MAX_NAMELG];		/* Name des GC-Spielers					*/
	char	pl_address[26];				/* Mail-Addresse des GC-Spielers		*/
	char	pl_path[MAX_PATHLEN];		/* Basis-Datei-Name (ohne Extension)	*/
	WORD	pl_heimat;					/* Nummer des Heimatplaneten			*/
	WORD	pl_known_planets;			/* bekannte	Planetenanzahl				*/
	WORD	pl_num_planets;				/* Planetenanzahl fuer Spieler			*/
	WORD	pl_num_ships;				/* Schiffsanzahl fuer Spieler			*/
	WORD	pl_num_won;					/* Gewonnene Planeten diese Runde		*/
	WORD	pl_num_lost;				/* Verlorene Planeten diese Runde		*/
	SCHIFF	*pl_ships[MAX_SCHIFFE];		/* Eigene Schiffe						*/
	PLANET	**pl_planets;				/* Bekannte Planeten					*/
	
	WORD	pl_tech_level[ANZ_FG];		/* Erreichte Tech-Level					*/
	WORD	pl_tech_level_pes[ANZ_FG];	/* Bisher investiertes PEs				*/
	
	LIMES	*pl_limes;					/* Grenzen								*/
	WORD	pl_limes_number;			/* fortlaufende Nummer fuer Grenzen		*/
	PlanetList *pl_planetlist;			/* Information fuer mehrere Spieler		*/
	
	REPORT	pl_report;					/* Lagebericht fuer Spieler				*/
	
	UWORD	pl_kg_player;				/* Spielernummer fuer das Kopfgeld		*/
	UWORD	pl_kg_pes;					/* Hoehe des Kopfgeldes					*/
	WORD	pl_tech_level_new[ANZ_FG];	/* Neuer Tech-Level						*/
	WORD	pl_tech_level_newpes[ANZ_FG];/* Neu investierte PEs					*/
	
	WORD	pl_bas_file_changed;
	WORD	pl_bef_file_renamed;
	WORD	pl_platz;					/* Platzierung							*/
	UWORD	pl_score;					/* Score								*/
	WORD	pl_zuwachs;					/* Zuwachs gegenber letzer Runde		*/
	
} PLAYER;


/*
 * Kennungen der GC-Runde (aus GCB-Datei)
 */
typedef	struct {
	WORD	major;						/* benoetigte Majornummer zB. 2			*/
	WORD	minor;						/* benoetigte Minornummer zB. 41		*/
	WORD	sp_nummer;					/* Eigene Spieler-Nummer				*/
	BYTE	gc_id[MAX_NAMELG];			/* Kennung der GC-Runde zB. "GC10"		*/
	WORD	starDate;					/* Sternzeit zB. 3515					*/
	UBYTE	maxMapSize;					/* Groesse des Universums				*/
	WORD	anz_planeten;				/* Anzahl der Planeten d. GC-Runde		*/
	UBYTE	max_tf;						/* Max.	Anzahl von Task	Forces			*/
	WORD	anz_spieler;				/* Anzahl d. Spieler d.	akt. GC-Runde	*/
	PLAYER	**spieler;					/* Namen der GC-Spieler					*/
	UBYTE	anz_stypen;					/* Anz.	der	versch.	Schiffstypen		*/
	UBYTE	kosten_goods[ANZ_GUETER];	/* Kosten fuer Festungen, Kits, ...		*/
	UBYTE	trans_goods[ANZ_LADUNG];	/* Lademenge/Volumen fuer Gueter		*/
	WORD	kosten_tl[ANZ_TL];			/* Investitionsvolumen fuer Tech-Level	*/
	UWORD	anonym[MAX_SPIELER];		/* Anonyme Scoreliste					*/
} GC_MISC;
  

/*
 * Die Grundwerte eines Schiffstypes (Angriff etc.) werden nicht
 * in den einzelnen Schiffsdatensaetzen untergebracht, sondern
 * sind aus den Informationen im GCB-File zu ermitteln.
 * Dabei kann folgender Typ verwendet werden.
 */
typedef	struct {
	int t_att;							/* Angriffswert							*/
	int t_def;							/* Verteidigungswert					*/
	int t_transp;						/* Transportkapazitaet					*/
	int t_kosten[ANZ_TL];				/* Baukosten in	PE						*/
	int t_reichw[ANZ_TL];				/* Reichweite							*/
} SCH_TYP;


/* Rechengroessen von Strukturen, Variabeln u.a. */

#define	GR__PLANET		sizeof(PLANET)
#define	GR__SCHIFF		sizeof(SCHIFF)

#define	BAS_ST_GR	64					/* Groesse der Planetenstruktur (BAS)	*/
#define	PLB_ST_GR	66					/* Groesse der Planetenstruktur (PLB)	*/
#define	FLB_ST_GR	26					/* Groesse der Schiffsstruktur (FLB)	*/
#define	VLB_ST_GR	8					/* Groesse der Nachrichtenstruktur (VLB)*/

#define	STD_MES		(ANZ_FG	+ 1)		/* minimale	Anzahl Nachrichten			*/
#define	VLB_MIN		VLB_ST_GR *	STD_MES	/* minimale	Groesse von VLB				*/


/* Werte fuer Config-Datei, zur Zeit nur Deutsch und Englisch */

#define	ENGLISH			0	
#define	DEUTSCH			1
#define NATIONS			2				/* # der unterstuetzten Nationen		*/
#define MESSAGES		12				/* # der Schluesselworte				*/

#define DRIVE			0				/* Nummern der Schluesselworte			*/
#define MEDICINE		1
#define INFORMATION		2
#define CONSTRUCTION	3
#define KILLS			4
#define PLANETDEFENSE	5
#define ARMS			6
#define SCHILD			7
#define LOYAL			8
#define DEFENSEFAKTOR	9
#define SPARES			10
#define VERSION			11

/* Nummern fuer Fehler	*/

#define	OK			0

#define	FEHLER_O	1					/* Datei nicht gefunden					*/
#define	FEHLER_R	2					/* Lese-Fehler							*/
#define	FEHLER_W	3					/* Schreib-Fehler						*/
#define FEHLER_V	4					/* Falscher Version der Datei			*/
#define FEHLER_M	5					/* Nicht genug Speicher					*/
#define FEHLER_F	6					/* Format-Fehler						*/
#define FEHLER_STYPEN 8					/* Zu viele Schiffstytpen (>MAX_STYPEN) */
#define FEHLER_SPIELER 9				/* Zu viele Spieler (>MAX_SPIELER)		*/
#define FEHLER_SPIELER_NUMMER 10		/* Falsche SpielerNummer				*/
#define FEHLER_C	11					/* Datei konnte nicht erzeugt werden	*/

/* Zeichensatz-Umwandlungen */
#define Z_NONE 0
#define Z_IBM_TO_ISO 1
#define Z_IBM_TO_ATARI 2
#define Z_IBM_TO_ASCII 3

extern GC_MISC		gc_global;
extern SCH_TYP		ship_typ[MAX_STYPEN];
extern GC_CONFIG	regel;
extern int          language;

#define fputbyte(datei, b) putc((b), datei)

#define fputword(datei, w) \
	fputbyte(datei, ((w) >> 8) & 0xff); \
	fputbyte(datei, (w) & 0xff)

#define fput_planet(datei, planet) \
	fputbyte(datei, (planet)->p_pos_x); \
	fputbyte(datei, (planet)->p_pos_y); \
	fputbyte(datei, (planet)->p_owner); \
	fputbyte(datei, (planet)->p_nat_def); \
	fputword(datei, (planet)->p_pe); \
	fputbyte(datei, (planet)->p_max_minen); \
	fputbyte(datei, (planet)->p_minen); \
	fputbyte(datei, (planet)->p_max_landw); \
	fputbyte(datei, (planet)->p_landw); \
	fputbyte(datei, (planet)->p_max_raffs); \
	fputbyte(datei, (planet)->p_raffs); \
	fputword(datei, (planet)->p_fabriken); \
	for (wz = 0; wz < ANZ_LADUNG; wz++) \
	{ \
		fputword(datei, (planet)->p_ladung[wz]); \
	} \
	fputword(datei, (planet)->p_festungen); \
	fputword(datei, (planet)->p_loyal); \
	fputword(datei, (planet)->p_kampf); \
	fputword(datei, (planet)->p_num_ships); \
	for (wz = 0; wz < MAX_WERFT; wz++) \
	{ \
		fputbyte(datei, (planet)->p_werft[wz].w_groesse); \
		fputbyte(datei, (planet)->p_werft[wz].w_pe_in_runde); \
		fputword(datei, (planet)->p_werft[wz].w_pe); \
		fputbyte(datei, (planet)->p_werft[wz].w_typ); \
		fputbyte(datei, (planet)->p_werft[wz].w_erster); \
	} \
	fputbyte(datei, (planet)->p_visited); \
	fputbyte(datei, (planet)->p_bonus); \
	fputword(datei, (planet)->p_no_use1); \
	fputword(datei, (planet)->p_no_use2)


/*
 * Planeteninformation in ASCII-Format schreiben.
 * gesplittet in zwei Teile, um Probleme mit zu grossen Macros zu vermeiden
 */
#define fprint_planet1(datei, planet) \
	(fprintf(datei, "%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d ", \
	(planet)->p_number, \
	(planet)->p_pos_x, \
	(planet)->p_pos_y, \
	(planet)->p_owner, \
	(planet)->p_nat_def, \
	(planet)->p_pe, \
	(planet)->p_max_minen, \
	(planet)->p_minen, \
	(planet)->p_max_landw, \
	(planet)->p_landw, \
	(planet)->p_max_raffs, \
	(planet)->p_raffs, \
	(planet)->p_fabriken, \
	(planet)->p_ladung[LAD_SPARES], \
	(planet)->p_ladung[LAD_MPE], \
	(planet)->p_ladung[LAD_LPE], \
	(planet)->p_ladung[LAD_RPE], \
	(planet)->p_ladung[LAD_MKITS], \
	(planet)->p_ladung[LAD_LKITS], \
	(planet)->p_ladung[LAD_RKITS], \
	(planet)->p_ladung[LAD_FKITS], \
	(planet)->p_ladung[LAD_KOLONIST]) == EOF)

#define fprint_planet2(datei, planet) \
	(fprintf(datei, "%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d\n", \
	(planet)->p_festungen, \
	(planet)->p_loyal, \
	(planet)->p_kampf, \
	(planet)->p_num_ships, \
	(planet)->p_werft[0].w_groesse, \
	(planet)->p_werft[0].w_pe_in_runde, \
	(planet)->p_werft[0].w_pe, \
	(planet)->p_werft[0].w_typ, \
	(planet)->p_werft[0].w_erster, \
	(planet)->p_werft[1].w_groesse, \
	(planet)->p_werft[1].w_pe_in_runde, \
	(planet)->p_werft[1].w_pe, \
	(planet)->p_werft[1].w_typ, \
	(planet)->p_werft[1].w_erster, \
	(planet)->p_werft[2].w_groesse, \
	(planet)->p_werft[2].w_pe_in_runde, \
	(planet)->p_werft[2].w_pe, \
	(planet)->p_werft[2].w_typ, \
	(planet)->p_werft[2].w_erster, \
	(planet)->p_visited, \
	(planet)->p_bonus, \
	(planet)->p_no_use1, \
	(planet)->p_no_use2) == EOF)


#define bgetbyte(var) \
	var = r_buf[(offset)++]

#define bgetword(var) \
	var = (r_buf[(offset)] << 8) | r_buf[(offset)+1]; offset += 2


#define bget_rest_of_planet(planet, r_buf, offset) \
	bgetbyte((planet)->p_nat_def); \
	bgetword((planet)->p_pe); \
	bgetbyte((planet)->p_max_minen); \
	bgetbyte((planet)->p_minen); \
	bgetbyte((planet)->p_max_landw); \
	bgetbyte((planet)->p_landw); \
	bgetbyte((planet)->p_max_raffs); \
	bgetbyte((planet)->p_raffs); \
	bgetword((planet)->p_fabriken); \
	bgetword((planet)->p_ladung[LAD_SPARES]); \
	bgetword((planet)->p_ladung[LAD_MPE]); \
	bgetword((planet)->p_ladung[LAD_LPE]); \
	bgetword((planet)->p_ladung[LAD_RPE]); \
	bgetword((planet)->p_ladung[LAD_MKITS]); \
	bgetword((planet)->p_ladung[LAD_LKITS]); \
	bgetword((planet)->p_ladung[LAD_RKITS]); \
	bgetword((planet)->p_ladung[LAD_FKITS]); \
	bgetword((planet)->p_ladung[LAD_KOLONIST]); \
	bgetword((planet)->p_festungen); \
	bgetword((planet)->p_loyal); \
	bgetword((planet)->p_kampf); \
	bgetword((planet)->p_num_ships); \
	for (wz = 0; wz < MAX_WERFT; wz++) \
	{ \
		bgetbyte((planet)->p_werft[wz].w_groesse); \
		bgetbyte((planet)->p_werft[wz].w_pe_in_runde); \
		bgetword((planet)->p_werft[wz].w_pe); \
		bgetbyte((planet)->p_werft[wz].w_typ); \
		bgetbyte((planet)->p_werft[wz].w_erster); \
	} \
	bgetbyte((planet)->p_visited); \
	bgetbyte((planet)->p_bonus); \
	bgetword((planet)->p_no_use1); \
	bgetword((planet)->p_no_use2)


#ifndef UNUSED
#  define UNUSED(x) if (x){}
#endif



/* Prototypen	*/

#ifdef __STDC__
#  define _(x) x
#  define P(x) x
#  define PP(X)
#else
#  define _(x) ()
#  define P(x)
#  define PP(x) x
#endif

#if !defined (HAVE_STRSTR)
char *strstr _(( const char *haystack, const char *needle ));
#endif

extern int verbose, quiet, debug;

WORD fgetword _(( FILE * datei_handle ));
long datei_laenge _(( FILE *fp ));
long sgetint _(( char **str_p ));

BYTE get_config _(( void ));
BYTE put_config _(( void ));
BYTE get_gcb _(( char *pathname, GC_MISC *gcb ));
BYTE get_lgb _(( char *pathname, BYTE **lgb, int zeichensatz ));
BYTE get_nas _(( PLAYER *player, char *pathname, WORD * ));
BYTE get_bas _(( PLAYER *player, char *pathname, WORD * ));
BYTE get_pln _(( PLAYER *player, char *pathname ));
BYTE get_plb _(( PLAYER *player, char *pathname ));
BYTE get_fln _(( PLAYER *player, char *pathname ));
BYTE get_flb _(( PLAYER *player, char *pathname ));
BYTE get_vln _(( PLAYER *player, char *pathname ));
BYTE get_vlb _(( PLAYER *player, char *pathname ));
BYTE get_map _(( PLAYER *player, char *pathname, int check_version ));

BYTE put_gcb _(( PLAYER *player, char *pathname ));
BYTE put_pln _(( PLAYER *player, char *pathname ));
BYTE put_plb _(( PLAYER *player, char *pathname ));
BYTE put_fln _(( PLAYER *player, char *pathname ));
BYTE put_flb _(( PLAYER *player, char *pathname ));
BYTE put_nas _(( PLAYER *player, char *pathname ));
BYTE put_bas _(( PLAYER *player, char *pathname ));
BYTE put_bef _(( PLAYER *player, char *pathname ));
BYTE put_map _(( PLAYER *player, char *pathname ));

BYTE plb_to_pln _(( PLAYER *player, char *pathname ));
BYTE pln_to_plb _(( PLAYER *player, char *pathname ));
BYTE vlb_to_vln _(( PLAYER *player, char *pathname ));
BYTE vln_to_vlb _(( PLAYER *player, char *pathname ));

void reset_to_initial_state _(( PLAYER *player ));

WORD suche_spielername  _(( char *name, char *ext, WORD max_spieler ));
void make_player_filename _(( char *buf, char *playername ));
PLAYER *find_player_name _(( char *filename ));
PLANET *find_planet _(( PLAYER *player, WORD number, int *insert ));
PlanetList *findPlanet _(( PLAYER *aWorld, WORD planet, int *insert ));
SCHIFF *find_ship _(( PLAYER *player, WORD number, int insert ));
void f_close _(( FILE *datei ));
void delete_player _(( PLAYER *player ));

#define spieler_name(nummer) (nummer == 0 ? "----" : get_player(nummer)->pl_name)
#define player_address(nummer) (nummer == 0 ? "----" : get_player(nummer)->pl_address)
#define position_known(planet) ((planet)->p_pos_x != 0 && (planet)->p_pos_y != 0)
#define owner_name(planet) ((planet) ? spieler_name((planet)->p_owner) : "???")

#ifdef NDEBUG
#define SH_TYP(typ)  (&(ship_typ[(typ)-1]))
#define get_player(nummer) (gc_global.spieler[(nummer)-1])
#else
#define SH_TYP(typ)  (((typ) < 1 || (typ) > gc_global.anz_stypen) ? (SCH_TYP *)NULL : &(ship_typ[(typ)-1]))
#define get_player(nummer) (((nummer) < 1 || (nummer) > gc_global.anz_spieler) ? (PLAYER *)NULL : gc_global.spieler[(nummer)-1])
#endif

#define planet_status(player, planet) \
	((planet)->p_owner == (player)->pl_number ? STATUS_OWN : \
	 (position_known(planet) ? \
	  ((planet)->p_owner == 0 ? ((planet)->p_visited != 0 ? STATUS_INFO : STATUS_UNKNOWN) : STATUS_ENEMY) : \
	  ((planet)->p_visited != 0 ? STATUS_INFO : STATUS_UNKNOWN)))


#define STATUS_UNKNOWN	0				/* ausser Position nichts bekannt */
#define STATUS_INFO		1				/* schon mal Info gekriegt */
#define STATUS_OWN		2				/* eigener Planet */
#define STATUS_ENEMY	4				/* feindlicher Planet */
#define ANZ_STATUS		5

#define	STRNCPY(a,b,l) strncpy(a, b, l)[(l)-1] = '\0'
#define STRCPY(a,b) STRNCPY(a, b, MAX_PATHLEN)


#define EXT_GCB ".gcb"
#define EXT_BEF ".bef"
#define EXT_LGB ".lgb"
#define EXT_PLB ".plb"
#define EXT_PLN ".pln"
#define EXT_VLB ".vlb"
#define EXT_VLN ".vln"
#define EXT_BAS ".bas"
#define EXT_NAS ".nas"
#define EXT_FLB ".flb"
#define EXT_FLN ".fln"
#define EXT_MAP ".map"
#define EXT_MPS ".mps"
#define EXT_PS  ".ps"
#define EXT_ASC ".asc"

#ifdef __MSDOS__
#  include <alloc.h>
#  define long_alloc(x,y) farmalloc(x)
#  define long_free  farfree
#  define STATIC static
#endif
#ifndef long_alloc
#  define long_alloc MALLOC
#endif
#ifndef long_free
#  define long_free(x, size) FREE((char *)(x), size)
#endif
#ifndef STATIC
#  define STATIC /**/
#endif


/*
 * memory functions
 */
#ifndef MALLOC

#ifndef DEBUG_ALLOC
#  define DEBUG_ALLOC 0
#endif

#if DEBUG_ALLOC

typedef struct _alloc_head {
	union {
		size_t size;
		char magic2[4];
	} sf;
	char *who;
	struct _alloc_head *next;
	char magic1[4];
} ALLOC_HEAD;

#define MALLOC(size, from) debug_getmem(size, from)
#define CALLOC(nitems, size, from) debug_getcmem(nitems, size, from)
#define STRDUP(str, from) debug_str_dup(str, from)
#define NEW(type, from) (type *)debug_getmem(sizeof(type), from)
#define FREE(block, size) debug_free(block, size)
#define SFREE(str) FREE(str, -1l)
#define REALLOC(old, nitems, additional, type, from) \
	{\
		type *new;\
		\
		if (old == NULL)\
		{ \
			new = (type *)debug_getmem((nitems + additional) * sizeof(type), from);\
			if (new != NULL) memset(new, 0, (nitems + additional) * sizeof(type)); \
		} else\
			new = (type *)debug_realloc(old, (nitems + additional) * sizeof(type), nitems * sizeof(type), from);\
		if (new == (type *)0)\
		{\
			error(E_NOMEM);\
			return(0);\
		}\
		old = new;\
		nitems += additional;\
	}
extern void debug_free _(( void *block, size_t size ));
extern void *debug_getmem _(( size_t size, char *from ));
extern void *debug_getcmem _(( size_t nitems, size_t size, char *from ));
extern char *debug_str_dup _(( char *str, char *from ));
extern void *debug_realloc _(( void *block, size_t newsize, size_t oldsize, char *from ));
#else
#define MALLOC(size, from) getmem(size)
#define CALLOC(nitems, size, from) getcmem(nitems, size)
#define STRDUP(str, from) str_dup(str)
#define NEW(type, from) (type *)getmem(sizeof(type))
#define FREE(block, size) free((char *)block)
#define SFREE(str) free(str)
#define REALLOC(old, nitems, additional, type, from) \
	{\
		type *new;\
		\
		if (old == NULL)\
			new = (type *)calloc(nitems + additional, sizeof(type));\
		else\
			new = (type *)realloc(old, (nitems + additional) * sizeof(type));\
		if (new == (type *)0)\
		{\
			error(E_NOMEM);\
			return(0);\
		}\
		old = new;\
		nitems += additional;\
	}
#endif

#ifndef ASSERT
#ifdef NDEBUG
# define ASSERT(expr) /* nothing */
#else
# define ASSERT( expr )\
	do if (!(expr)) _assert_(#expr, __FILE__, (long)__LINE__); while(0)
extern void _assert_ _(( char *, char *, long ));
#endif
#endif

#define OFREE(obj) FREE(obj, sizeof(*(obj)))

#endif /* MALLOC */


/* EOF */
