#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include "gchdr.h"
#include "gcio.h"

#if !DEBUG_ALLOC
#define getmem malloc
#define getcmem calloc
#endif

/* Globale Variablen */

GC_MISC gc_global;
SCH_TYP ship_typ[MAX_STYPEN];


void reset_to_initial_state(P(PLAYER *) player)
PP(PLAYER *player;)
{
	SCHIFF **schiffe;
	SCHIFF *ship;
	PLANET **planets;
	PLANET *planet;
	WORD i, p;
	
	schiffe = player->pl_ships;
	for (i = 0; i < player->pl_num_ships; i++)
	{
		ship = schiffe[i];
		
		ship->s_new_ziel = ship->s_ziel;
		ship->s_new_pos = ship->s_pos;
		ship->s_new_tf_nr = ship->s_tf_nr;
		for (p = 0; p < ANZ_LADUNG; p++)
			ship->s_new_ladung[p] = ship->s_ladung[p];
		ship->s_schrott = 0;
		ship->s_new_owner = 0;
	}
	
	planets = player->pl_planets;
	for (p = 0; p < gc_global.anz_planeten; p++)
	{
		planet = planets[p];
		if (planet)
		{
			planet->p_new_pe = planet->p_pe;
			for (i = 0; i < MAX_WERFT; i++)
			{
				planet->p_new_werft[i] = planet->p_werft[i];
				planet->p_new_werft[i].w_pe_in_runde = 0;
			}
			for (i = 0; i < MAX_GEHEIM; i++)
			{
				planet->p_geheim[i].m_target = 0;
				planet->p_geheim[i].m_pe = 0;
			}
			planet->p_inst_mkits = 0;
			planet->p_inst_lkits = 0;
			planet->p_inst_rkits = 0;
			planet->p_inst_fkits = 0;
			for (i = 0; i < ANZ_LADUNG; i++)
				planet->p_new_ladung[i] = planet->p_ladung[i];
			for (i = 0; i < ANZ_FG; i++)
				planet->p_forschen[i] = 0;
			planet->p_new_festungen = planet->p_festungen;
			if (planet->p_new_festungen == -1)
				planet->p_new_festungen = 0;
			planet->p_new_minen = planet->p_minen;
			planet->p_new_landw = planet->p_landw;
			planet->p_new_raffs = planet->p_raffs;
			planet->p_new_fabriken = planet->p_fabriken;
		}
	}
	
	for (i = 0; i < ANZ_FG; i++)
	{
		player->pl_tech_level_new[i] = player->pl_tech_level[i];
		player->pl_tech_level_newpes[i] = player->pl_tech_level_pes[i];
	}
	
	player->pl_kg_player = 0;
	player->pl_kg_pes = 0;
}


long datei_laenge(P(FILE *) fp)
PP(FILE *fp;)
{
	long old_pos;
	long size;
	
	old_pos = ftell(fp);
	fseek(fp, 0l, 2);
	size = ftell(fp);
	fseek(fp, old_pos, 0);
	return(size);
}


WORD fgetword(P(FILE *) datei_handle)
PP(FILE *datei_handle;)
{
	int temp_word, tmp_word;

	if ((temp_word = fgetc(datei_handle)) == EOF)
	{
		return(EOF);
	}
	temp_word = temp_word << 8;
	if ((tmp_word = fgetc(datei_handle)) == EOF)
	{
		return(EOF);
	}
	temp_word = temp_word | tmp_word;

	return(temp_word);
}


long sgetint(P(char **) str_p)
PP(char **str_p;)
{
	char *str;
	long val;
	
	str = *str_p;
	while (*str == ' ' || *str == '\t')
		str++;
	val = 0;
	while (*str >= '0' && *str <= '9')
	{
		val = val * 10 + *str - '0';
		str++;
	}
	*str_p = str;
	return(val);
}


/*
 * Aus Spielername laut Anmeldung Dateiname erzeugen
 */
void make_player_filename(P(char *) buf, P(char *) playername)
PP(char *buf;)
PP(char *playername;)
{
	int len;
	
	len = 0;
	while (*playername && len < 8)
	{
		if (*playername == ' ')
			*buf = '_';
		else
			*buf = tolower(*playername);
		buf++;
		playername++;
		len++;
	}
	*buf = '\0';
}


/*
 * Spieler ueber Dateinamen suchen
 */
PLAYER *find_player_name(P(char *) filename)
PP(char *filename;)
{
	int nummer;
	PLAYER *player;
	char *name, *filename_p;
	int len;
	int c1, c2;
	
	if (gc_global.spieler == NULL)
		return(NULL);
	for (nummer = 1; nummer <= gc_global.anz_spieler; nummer++)
	{
		player = get_player(nummer);
		if (player != NULL)
		{
			name = player->pl_name;
			len = 0;
			filename_p = filename;
			while (*name != '\0' && *filename_p != '\0' && len < 8)
			{
				c1 = tolower(*name);
				c2 = tolower(*filename_p);
				if (c1 == ' ') c1 = '_';
				if (c1 != c2)
					break;
				len++;
				name++;
				filename_p++;
			}
			if ((*filename_p == '\0' && *name == '\0') || len >= 8)
				return(player);
		}
	}
	return(NULL);
}


/*
 * Sucht Pl mit dieser Nr und erhoeht ggf. die Zahl der bekannten Planeten
 * wenn insert != NULL, wird der Planet in die Tabelle eingefuegt, falls
 * noch nicht vorhanden. *insert wird in diesem Fall auf TRUE gesetzt, falls
 * der Planet neu eingefuegt wurde, und auf FALSE, wenn er schon bekannt war.
 */
PLANET *find_planet(P(PLAYER *) player, P(WORD) nummer, P(int *) insert)
PP(PLAYER *player;)
PP(WORD nummer;)
PP(int *insert;)
{
	PLANET *planet;
	
	if (nummer <= 0 || nummer > gc_global.anz_planeten || player->pl_planets == NULL)
	{
		errno = FEHLER_F;
		return(NULL);
	}
	planet = player->pl_planets[nummer - 1];
	if (planet == NULL)
	{
		if (insert != NULL)
		{
			planet = (PLANET *)CALLOC(1, sizeof(PLANET), "find_planet");
			player->pl_planets[nummer - 1] = planet;
			if (planet != NULL)
			{
				planet->p_number = nummer;
				planet->p_festungen = -1;
				player->pl_known_planets++;
				*insert = TRUE;
			} else {
				errno = FEHLER_M;
			}
		}
	} else {
		if (insert != NULL)
			*insert = FALSE;
	}
	return(planet);
}


SCHIFF *find_ship(P(PLAYER *) player, P(WORD) number, P(int) insert)
PP(PLAYER *player;)
PP(WORD number;)
PP(int insert;)
{
	SCHIFF **ships, *ship;
	WORD i;
	
	UNUSED(insert);
	ships = player->pl_ships;
	for (i = 0; i < player->pl_num_ships; i++)
	{
		ship = ships[i];
		if (number == ship->s_number)
			return(ship);
	}
	return(NULL);
}


/*
 * Planeten in Liste fuer Spieler suchen
 */
PlanetList *findPlanet(P(PLAYER *) aWorld, P(WORD) planet, P(int *) insert)
PP(PLAYER *aWorld;)
PP(WORD planet;)
PP(int *insert;)
{
	PlanetList *list, *father;
	
	list = aWorld->pl_planetlist;
	father = list;
	while ((list != NULL) && (planet != list->l_number))
	{
		father = list;
		list = list->l_next;
	}
	
	if (list == NULL)
	{
		if (insert != NULL)
		{
			list = (PlanetList *)CALLOC(1, sizeof(PlanetList), "findPlanet");
			if (list != NULL)
			{
				list->l_number = planet;
				list->l_flight_min = 0;
				list->l_flight_max = 0;
				list->l_natdef = 0;
				list->l_festungen = -1;
				list->l_visited = 0;
				list->l_next = NULL;
				list->l_planet = find_planet(aWorld, planet, NULL);
				if (list->l_planet != NULL)
				{
					list->l_status = planet_status(aWorld, list->l_planet);
					if (list->l_status == STATUS_OWN)
					{
						list->l_planetrange = regel.radius[aWorld->pl_tech_level[FG_SPY]];
						list->l_owner = aWorld->pl_number;
					} else {
						list->l_planetrange = 0;
					}
					/*
					list->l_natdef = list->l_planet->p_nat_def;
					list->l_festungen = list->l_planet->p_festungen;
					list->l_visited = list->l_planet->p_visited;
					list->l_next = aWorld->pl_planetlist;
					*/
				}
				if (father == NULL)
					aWorld->pl_planetlist = list;
				else
					father->l_next = list;
				*insert = TRUE;
			} else {
				errno = FEHLER_M;
			}
		}
	} else {
		if (insert != NULL)
			*insert = FALSE;
	}
	return(list);
}


void f_close(P(FILE *) datei)
PP(FILE *datei;)
{
#if defined(__PUREC__) && !defined(__MINT__)
	fflush(datei);
	if (ferror(datei))
	{
		fclose(datei);
		/* workaround a library bug */
		if (datei->Flags & 3)
		{
			close(datei->Handle);
			if (datei->Flags & 0x08)
				free(datei->BufStart);
			datei->Flags = 0;
		}
	} else
#endif
	fclose(datei);
}


/*
 * Alle Daten fuer Spieler freigeben
 */
void delete_player(P(PLAYER *) player)
PP(PLAYER *player;)
{
	if (player != NULL)
	{
		/*
		 * Planeten
		 */
		if (player->pl_planets != NULL)
		{
			WORD i;
			
			for (i = 0; i < gc_global.anz_planeten; i++)
			{
				if (player->pl_planets[i] != NULL)
					OFREE(player->pl_planets[i]);
			}
			FREE(player->pl_planets, gc_global.anz_planeten * sizeof(PLANET *));
			player->pl_planets = NULL;
		}
		/*
		 * Planeten-Liste
		 */
		{
			PlanetList *list, *next;
			
			for (list = player->pl_planetlist; list != NULL; list = next)
			{
				next = list->l_next;
				OFREE(list);
			}
			player->pl_planetlist = NULL;
		}
		/*
		 * Schiffe
		 */
		{
			WORD i;
			
			for (i = 0; i < player->pl_num_ships; i++)
				OFREE(player->pl_ships[i]);
		}
		/*
		 * Grenzen
		 */
		{
			LIMES *list, *next;
			
			for (list = player->pl_limes; list != NULL; list = next)
			{
				next = list->l_next;
				OFREE(list);
			}
			player->pl_limes = NULL;
		}
	}
}
