#include <stdio.h>
#include <ctype.h>
#include "gchdr.h"
#include "gcio.h"
#include "gcmapps.h"


#if !DEBUG_ALLOC
#define getmem malloc
#endif


static void setInfo _(( PLAYER *, WORD, WORD, WORD, UBYTE, WORD ));

static void setInfo(P(PLAYER *) aWorld, P(WORD) planet, P(WORD) status,
	P(WORD) range, P(UBYTE) natdef, P(WORD) festungen)
PP(PLAYER *aWorld;)
PP(WORD planet;)
PP(WORD status;)
PP(WORD range;)
PP(UBYTE natdef;)
PP(WORD festungen;)
{
	PlanetList	*list;

	for (list = aWorld->pl_planetlist; list; list = list->l_next)
	{
		if (list->l_number == planet)
		{
			if (range > list->l_planetrange)
				list->l_planetrange = range;
			if ((status == STATUS_OWN) && (list->l_status == STATUS_ENEMY))
				list->l_planetrange = regel.radius[aWorld->pl_tech_level[FG_SPY]];
			if (natdef)
				list->l_natdef = natdef;
			if (list->l_festungen == -1)
				list->l_festungen = festungen;
			return;
		}
	}
}


BYTE get_mps(P(char *) fname, P(PLAYER *) aWorld)
PP(char *fname;)
PP(PLAYER *aWorld;)
{
	char	fmpsname[128];
	BYTE	cmd[10];
	FILE	*fp;
	double	xf, yf;
	int		x, y, line, max_line, planet, status, range, natdef, festungen;
	int		info_found;
	
	strcpy (fmpsname, fname);
	strcat (fmpsname, EXT_MPS);
	max_line = 0;
	info_found = 0;
	if ((fp = fopen (fmpsname, "r")) != NULL)
	{
		if (verbose)
			fprintf (stderr, "reading %s ... ", fmpsname);
		for (;;)
		{
			fscanf (fp, "%s", cmd);
			if (feof (fp)) break;
			switch (tolower (cmd[0]))
			{
			case 'r':
				fscanf (fp, "%d %d", &planet, &range);
				setInfo(aWorld, planet, -1, range, 0, -1);
				break;
			case 'i':
				fscanf (fp, "%d %d %d %d", &planet, &range, &natdef, &festungen);
				setInfo(aWorld, planet, -1, range, natdef, festungen);
				info_found++;
				break;
			case 'p':
				fscanf (fp, "%d %d %d %d %d", &planet, &status, &range, &natdef, &festungen);
				setInfo(aWorld, planet, status, range, natdef, festungen);
				info_found++;
				break;
			case 'l':
				fscanf (fp, " %d %d %d", &x, &y, &line);
				if (line >= max_line)
					max_line = line+1;
				line += aWorld->pl_limes_number;
				if (AddLime(&aWorld->pl_limes, 0, (double)x, (double)y, line) == NULL)
				{
					f_close(fp);
					return(FEHLER_M);
				}
				break;
			case 'b':
				fscanf (fp, " %lg %lg %d", &xf, &yf, &line);
				if (line >= max_line)
					max_line = line+1;
				line += aWorld->pl_limes_number;
				if (AddLime(&aWorld->pl_limes, 0, xf, yf, line) == NULL)
				{
					f_close(fp);
					return(FEHLER_M);
				}
				break;
			default:
				break;
			}
		}
		f_close (fp);
		if (verbose)
			fprintf(stderr, "found %d infos\n", info_found);
	}
	aWorld->pl_limes_number += max_line;
	return(OK);
}


void SortLimes(P(PLAYER *) aWorld)
PP(PLAYER *aWorld;)
{	
	int found;
	LIMES *start2, *previous2;
	LIMES *start, *previous;
	LIMES *limes, *limes2;
	LIMES *pre, *pre2;
	WORD line;
	
	if ((limesline)&&(aWorld->pl_limes_number >= 2))
	{
		start2 = aWorld->pl_limes;
		line = 0;
		previous2 = start2;
		while ((start2)&&(start2->l_limes_number == line))
		{
			previous2 = start2;
			start2 = start2->l_next;
		}
		start = aWorld->pl_limes;
		previous = start;
		if (start2)
		{
			while ((start)&&(start->l_limes_number != start2->l_limes_number)&&
					(start->l_x != start2->l_x)&&
					(start->l_y != start2->l_y))
			{
				previous = start;
				start = start->l_next;
			}
		}
		
		limes = start;
		limes2 = start2;
		pre = NULL;
		pre2 = NULL;
		found = 0;
		while ((limes)&&(limes2)&&(limes->l_limes_number != limes2->l_limes_number)&&
				(limes->l_x == limes2->l_x)&&
				(limes->l_y == limes2->l_y))
		{
			found++;
			pre = limes;
			limes = limes->l_next;		
			pre2 = limes2;
			limes2 = limes2->l_next;
		}
		if (found > 1)
		{
			if (start == aWorld->pl_limes)
				aWorld->pl_limes = start2;
			else
				previous->l_next = start2;
			if (limes != start2)
				pre2->l_next = limes;
			previous2->l_next = limes2;
			while ((start != limes)&&(start))
			{
				pre = start;
				start = start->l_next;
				OFREE (pre);
			}
		}
	}
}


BYTE put_mps(P(char *) fname, P(PLAYER *) aWorld)
PP(char *fname;)
PP(PLAYER *aWorld;)
{
	char	fmpsname[128];
	FILE	*fp;
	PlanetList	*list;
	LIMES	*limes;

	strcpy (fmpsname, fname);
	strcat (fmpsname, EXT_MPS);
	
	if ((fp = fopen (fmpsname, "w")) == NULL)
	{
		return(FEHLER_C);
	}
	if (verbose)
		fprintf (stderr, "writing %s\n", fmpsname);
	for (list = aWorld->pl_planetlist; list != NULL; list = list->l_next)
	{
		fprintf (fp, "planet %d %d %d %d %d\n",
			list->l_number, list->l_status,
			list->l_planetrange, list->l_natdef,
			list->l_festungen);
	}
	
	for (limes = aWorld->pl_limes; limes != NULL; limes = limes->l_next)
	{
		fprintf (fp, "boader %g %g %d\n",
			limes->l_x, limes->l_y, limes->l_limes_number);
	}
	f_close (fp);
	return(OK);
}


LIMES *AddLime(P(LIMES **) list, P(WORD) number,
	P(double) x, P(double) y, P(WORD) line_number)
PP(LIMES **list;)
PP(WORD number;)
PP(double x;)
PP(double y;)
PP(WORD line_number;)
{
	LIMES *limes;
	LIMES *pre;
	
	pre = NULL;
	for (limes = *list; limes != NULL; limes = limes->l_next)
		pre = limes;
	limes = NEW(LIMES, "AddLime");
	if (limes == NULL)
	{
		return(NULL);
	}
	if (pre == NULL)
	{
		*list = limes;
	} else {
		pre->l_next = limes;
	}
	limes->l_number = number;
	limes->l_x = x;
	limes->l_y = y;
	limes->l_limes_number = line_number;
	limes->l_next = NULL;
	return(limes);
}


void DelLime(P(LIMES **) list, P(WORD) line_number)
PP(LIMES **list;)
PP(WORD line_number;)
{
	LIMES *limes;
	LIMES *pre, *next;
	
	limes = *list;
	pre = NULL;
	while (limes != NULL)
	{
		next = limes->l_next;
		if (limes->l_limes_number == line_number)
		{
			if (pre == NULL)
				*list = next;
			else
				pre->l_next = next;
			OFREE(limes);
		} else {
			pre = limes;
		}
		limes = next;
	}
}


void FreeLimes(P(LIMES *) list)
PP(LIMES *list;)
{
	LIMES *next;
	
	for (; list != NULL; list = next)
	{
		next = list->l_next;
		OFREE(list);
	}
}


void UpdateLimesPos(P(PLAYER *) player, P(LIMES *) limes)
PP(PLAYER *player;)
PP(LIMES *limes;)
{
	PLANET *planet;
	
	while (limes != NULL)
	{
		if (limes->l_number != 0)
		{
			planet = find_planet(player, limes->l_number, NULL);
			if (planet == NULL || !position_known(planet))
			{
				if (!quiet)
					fprintf(stderr, "warning: position of planet %d not known\n", limes->l_number);
			} else {
				limes->l_number = 0;
				limes->l_x = (double) planet->p_pos_x;
				limes->l_y = (double) planet->p_pos_y;
			}
		}
		limes = limes->l_next;
	}
}
