#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gcio.h"

#define CONFIG_DATEI	"config.gc"

/* Globale Variablen */

GC_CONFIG regel = {
	/* percent_planetoff */
	5,
	/* percent_planetdef */
	1,
	/* range */
	{ 2, 3, 4, 5, 6, 7, 8, 9, 10 },
	/* radius */
	{ 5, 6, 7, 8, 10, 12, 14, 18, 22, 28 },
	/* percent_spionage */
	{ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 },
	/* loyal */
	{ 1, 1, 1, 1, 2, 2, 3, 4, 6, 8 },
	/* percent_medicine */
	{ 0, 4, 10, 18, 28, 40, 54, 70, 88, 108 },
	/* percent_arms */
	5,
	/* percent_shield */
	8,
	/* drive */
	{ 0, 2, 5, 9, 14, 20, 27, 35, 44, 54 },
	/* percent_construction */
	10,
	/* percent_kills */
	2,
	/* bonus_festung */
	1,
	/* spares_per_pe */
	2,
	/* percent_natdef */
	5,
	/* percent_loyal */
	5,
	/* percent_pop_grow */
	1
};

int language = DEUTSCH;
static BYTE line[BUFFER_GR];

static BYTE *text[NATIONS][MESSAGES + 1] =
{
	{"Drive",
	 "Medicine",
	 "Information",
	 "Construction",
	 "Kills",
	 "Planetdefense",
	 "Arms",
	 "Schild",
	 "Loyal",
	 "Defensefaktor",
	 "Spares",
	 "Version",
	 "XXX"},							/* zum Vereinfachen der Nachrichtennummernabfrage */
	{"Antrieb",
	 "Medizin",
	 "Nachrichtentechnik",
	 "Konstruktion",
	 "Kills",
	 "Planetenverteidigung",
	 "Bewaffnung",
	 "Schutzschild",
	 "Loyal",
	 "Verteidigungsfaktor",
	 "Ersatzteile",
	 "Version",
	 "XXX"}};							/* s.o. */

/* Prototypen */

static BYTE conf_get(FILE * datei_handle);
static BYTE conf_put(FILE * datei_handle);

/* Einlesen und setzen der "Spielwerte" aus der CONFIG_DATEI    */
/* Die "Spielwerte" sind Schiffsbaukostentabellen u..          */
/* Wegen eben dieser Schiffsbaukostentabelle mu die GCB-DATEI  */
/* unbedingt vorher eingelesen werden, da dort die Anzahl der   */
/* Schiffstypen steht und der Speicher fr die Struktur         */
/* allociert wird !!!!!!!!!!!!!!!!!!!!!                         */

BYTE get_config()
{
	FILE *config_datei;
	BYTE result;

	if ((config_datei = fopen(CONFIG_DATEI, "r")) == NULL)
		return FEHLER_O;

	result = conf_get(config_datei);
	fclose(config_datei);

	return (result);
}


static BYTE conf_get(FILE * config_datei)
{
	int wert, wert2, wert3;
	UBYTE ende, t_level, meldung, zaehler = 0;
	char *b_zeiger;

	/* einlesen der Werte */
	while (NULL != fgets(line, BUFFER_GR, config_datei))
	{
		/* Suchen ob die Zeile eins der Schlsselworte enthlt */
		meldung = 0;
		while ((NULL == strstr(line, text[DEUTSCH][meldung])) &&
			   (NULL == strstr(line, text[ENGLISH][meldung])) &&
			   (meldung < MESSAGES))
			meldung++;
		switch (meldung)
		{
		case VERSION:
			{
				int major, minor;
				
				if (NULL == fgets(line, BUFFER_GR, config_datei))
					return(FEHLER_R);
				if (sscanf(line, " %d %d", &major, &minor) != 2)
					return(FEHLER_F);
				if (major != GC_MAJOR || minor != GC_MINOR)
					return(FEHLER_V);
			}
			break;
			/* zunahme der Schiffsreichweite, fuer jeden TL.
			   Bezogen auf TL 0, und nicht, wie in der
			   Anleitung, auf den vorhergehenden TL */
		case DRIVE:
			if (NULL == fgets(line, BUFFER_GR, config_datei))
				return FEHLER_R;
			b_zeiger = line;
			for (t_level = 0; t_level < ANZ_TL; t_level++)
			{
				if (b_zeiger == NULL)
					return (FEHLER_F);
				if (sscanf(b_zeiger, " %d", &wert) != 1)
					return (FEHLER_F);
				regel.drive[t_level] = wert;
				b_zeiger = strchr(++b_zeiger, ' ');
			}
			break;

			/* zunahme des Bevoelkerungswachstums, fuer jeden TL.
			   Auch hier wieder bezogen auf TL 0    */
		case MEDICINE:
			if (NULL == fgets(line, BUFFER_GR, config_datei))
				return FEHLER_R;
			b_zeiger = line;
			for (t_level = 0; t_level < ANZ_TL; t_level++)
			{
				if (b_zeiger == NULL)
					return (FEHLER_F);
				if (sscanf(b_zeiger, " %d", &wert) != 1)
					return (FEHLER_F);
				regel.percent_medicine[t_level] = wert;
				b_zeiger = strchr(++b_zeiger, ' ');
			}
			break;

			/* Da in der Anleitung zur Abwechslung mal absolute
			   Werte stehen, die Nachrichtentechniktabelle.
			   Sie muss aber 3-teilig sein. Schluesselwort,
			   Unterschluessel, Werte. Und das in Reihenfolge
			   Radius, spionage und Loyalitaet. Der 
			   Unterschluessel wird z.z. nicht abgefragt, kann
			   daher auch durch eine leere Zeile ersetzt werden.
			   */
		case INFORMATION:
			if (NULL == fgets(line, BUFFER_GR, config_datei))
				return FEHLER_R;
			if (NULL == fgets(line, BUFFER_GR, config_datei))
				return FEHLER_R;
			b_zeiger = line;
			/* hier gehts um den Sichtbereich um die eigene PL */
			for (t_level = 0; t_level < ANZ_TL; t_level++)
			{
				if (b_zeiger == NULL)
					return (FEHLER_F);
				if (sscanf(b_zeiger, " %d", &wert) != 1)
					return (FEHLER_F);
				regel.radius[t_level] = wert;
				b_zeiger = strchr(++b_zeiger, ' ');
			}
			if (NULL == fgets(line, BUFFER_GR, config_datei))
				return FEHLER_R;
			if (NULL == fgets(line, BUFFER_GR, config_datei))
				return FEHLER_R;
			b_zeiger = line;
			/* % erfolg eine Spionageversuchs pro PE */
			for (t_level = 0; t_level < ANZ_TL; t_level++)
			{
				if (b_zeiger == NULL)
					return (FEHLER_F);
				if (sscanf(b_zeiger, " %d", &wert) != 1)
					return (FEHLER_F);
				regel.percent_spionage[t_level] = wert;
				b_zeiger = strchr(++b_zeiger, ' ');
			}
			if (NULL == fgets(line, BUFFER_GR, config_datei))
				return FEHLER_R;
			if (NULL == fgets(line, BUFFER_GR, config_datei))
				return FEHLER_R;
			b_zeiger = line;
			/* Loyalitaetsaenderung pro 10 PE */
			for (t_level = 0; t_level < ANZ_TL; t_level++)
			{
				if (b_zeiger == NULL)
					return (FEHLER_F);
				if (sscanf(b_zeiger, " %d", &wert) != 1)
					return (FEHLER_F);
				regel.loyal[t_level] = wert;
				b_zeiger = strchr(++b_zeiger, ' ');
			}
			break;

			/* Schiffsbaukosten, sowohl als Rechenwert,
			   % Ersparnis pro TL, als auch als Tabelle fuer
			   jedes Schiff, um Rundungs-'Faxen' zu vermeiden
			   */
		case CONSTRUCTION:
			if (NULL == fgets(line, BUFFER_GR, config_datei))
				return FEHLER_R;
			if (sscanf(line, "%d", &wert) != 1)
				return (FEHLER_F);
			regel.percent_construction = wert;
			ende = gc_global.anz_stypen;
			while ((NULL != fgets(line, BUFFER_GR, config_datei)) &&
				   (zaehler < ende))
			{
				if (sscanf(line, " %d", &wert) != 1)
					return (FEHLER_F);
				/* Ueberpruefen das die Kosten unveraendert */
				if (wert == ship_typ[zaehler].t_kosten[0])
				{
					b_zeiger = line;
					for (t_level = 0; t_level < ANZ_TL; t_level++)
					{
						if (b_zeiger == NULL)
							return (FEHLER_F);
						if (sscanf(b_zeiger, " %d", &wert) != 1)
							return (FEHLER_F);
						ship_typ[zaehler].t_kosten[t_level] = wert;
						b_zeiger = strchr(++b_zeiger, ' ');
					}
				}
				zaehler++;
			}
			break;

			/* zunahme der Trefferwahrscheinlichkeit eines
			   Schiffes, pro Treffer den es erzielt hat */
		case KILLS:
			if (NULL == fgets(line, BUFFER_GR, config_datei))
				return FEHLER_R;
			if (sscanf(line, " %d", &wert) != 1)
				return (FEHLER_F);
			regel.percent_kills = wert;
			break;

			/* Aenderung der Trefferwahrscheinlichkeit, sowohl
			   fuer das Schiessen, als auch fuer das Beschossen
			   werden, und die Kostenersparnis beim Festungsbau
			   pro TL, diesmal aber relativ, also bei TL 3 ist
			   die Ersparnis 3*regel.bonus_festung */
		case PLANETDEFENSE:
			if (NULL == fgets(line, BUFFER_GR, config_datei))
				return FEHLER_R;
			if (sscanf(line, "off: %d def: %d Festung: %d",
					   &wert,
					   &wert2,
					   &wert3) != 3)
				return (FEHLER_F);
			regel.percent_planetoff = wert;
			regel.percent_planetdef = wert2;
			regel.bonus_festung = wert3;
			break;

			/* Erhoehung der Trefferwahrscheinlichkeit pro TL.
			   Auch wieder nicht absolut, da linear.    */
		case ARMS:
			if (NULL == fgets(line, BUFFER_GR, config_datei))
				return FEHLER_R;
			if (sscanf(line, " %d", &wert) != 1)
				return (FEHLER_F);
			regel.percent_arms = wert;
			break;

			/* Erniedrigung der Wahrscheinlichkeit getroffen
			   zu werden pro TL; auch linear */
		case SCHILD:
			if (NULL == fgets(line, BUFFER_GR, config_datei))
				return FEHLER_R;
			if (sscanf(line, " %d", &wert) != 1)
				return (FEHLER_F);
			regel.percent_shield = wert;
			break;

			/* Erhoehung der Produktivitaet. z.z ist die 
			   Produktivitaet eines Planeten:
			   50% + regel.percent_loyal*PL_loyalitaet */
		case LOYAL:
			if (NULL == fgets(line, BUFFER_GR, config_datei))
				return FEHLER_R;
			if (sscanf(line, " %d", &wert) != 1)
				return (FEHLER_F);
			regel.percent_loyal = wert;
			break;

			/* Einfluss der natuerlichen Planetenverteidigung.
			   Erniedrigung der Wahrscheinlichkeit eine Festung
			   zu treffen, soetwas wie der Schutzschild bei
			   Schiffen. 
			   Bevoelkerungswachstum = 10 - nat. PLver. * wert */
		case DEFENSEFAKTOR:
			if (NULL == fgets(line, BUFFER_GR, config_datei))
				return FEHLER_R;
			if (sscanf(line, "natdef: %d pop grow: %d",
					   &wert,
					   &wert2) != 2)
				return (FEHLER_F);
			regel.percent_natdef = wert;
			regel.percent_pop_grow = wert2;
			break;

			/* Anzahl der Ersatzteile pro PE */
		case SPARES:
			if (NULL == fgets(line, BUFFER_GR, config_datei))
				return FEHLER_R;
			if (sscanf(line, " %d", &wert) != 1)
				return (FEHLER_F);
			regel.spares_per_pe = wert;
			break;
		}
	}
	return OK;
}

/* Und hier nun das Ganze umgekehrt. Man kann die Datei auch von "Hand" */
/* editieren, ist ja ASCII, aber warum nicht gleich mit integrieren     */

BYTE put_config()
{
	FILE *config_datei;
	BYTE result;

	if ((config_datei = fopen(CONFIG_DATEI, "w")) == NULL)
		return FEHLER_O;

	result = conf_put(config_datei);
	fclose(config_datei);

	return (result);
}


static BYTE conf_put(FILE * config_datei)
{
	UBYTE ende, t_level, zaehler = 0;

	if (EOF == fprintf(config_datei, "%s:\n", text[language][VERSION]))
		return(FEHLER_W);
	if (EOF == fprintf(config_datei, " %d %d\n", GC_MAJOR, GC_MINOR))
		return(FEHLER_W);
	
	if (EOF == fprintf(config_datei, "%s:\n", text[language][DRIVE]))
		return FEHLER_W;

	for (t_level = 0; t_level < ANZ_TL; t_level++)
	{
		if (EOF == fprintf(config_datei, " %d", regel.drive[t_level]))
			return FEHLER_W;
	}

	if (EOF == fprintf(config_datei, "\n\n%s:\n", text[language][MEDICINE]))
		return FEHLER_W;

	for (t_level = 0; t_level < ANZ_TL; t_level++)
	{
		if (EOF == fprintf(config_datei, " %d", regel.percent_medicine[t_level]))
			return FEHLER_W;
	}

	if (EOF == fprintf(config_datei, "\n\n%s:\n", text[language][INFORMATION]))
		return FEHLER_W;

	if (EOF == fprintf(config_datei, " Radius:\n"))
		return FEHLER_W;

	for (t_level = 0; t_level < ANZ_TL; t_level++)
	{
		if (EOF == fprintf(config_datei, " %d", regel.radius[t_level]))
			return FEHLER_W;
	}

	if (EOF == fprintf(config_datei, "\n Spionage:\n"))
		return FEHLER_W;

	for (t_level = 0; t_level < ANZ_TL; t_level++)
	{
		if (EOF == fprintf(config_datei, " %d", regel.percent_spionage[t_level]))
			return FEHLER_W;
	}
	if (EOF == fprintf(config_datei, "\n Loyal:\n"))
		return FEHLER_W;

	for (t_level = 0; t_level < ANZ_TL; t_level++)
	{
		if (EOF == fprintf(config_datei, " %d", regel.loyal[t_level]))
			return FEHLER_W;
	}

	if (EOF == fprintf(config_datei, "\n\n%s:\n", text[language][CONSTRUCTION]))
		return FEHLER_W;

	if (EOF == fprintf(config_datei, "%d\n", regel.percent_construction))
		return FEHLER_W;

	ende = gc_global.anz_stypen;
	for (zaehler = 0; zaehler < ende; zaehler++)
	{
		for (t_level = 0; t_level < ANZ_TL; t_level++)
		{
			if (EOF == fprintf(config_datei, " %d", ship_typ[zaehler].t_kosten[t_level]))
				return FEHLER_W;
		}
		if (EOF == fprintf(config_datei, "\n"))
			return FEHLER_W;
	}

	if (EOF == fprintf(config_datei, "\n%s\n", text[language][KILLS]))
		return FEHLER_W;

	if (EOF == fprintf(config_datei, " %d\n", regel.percent_kills))
		return FEHLER_W;

	if (EOF == fprintf(config_datei, "\n%s\n", text[language][PLANETDEFENSE]))
		return FEHLER_W;

	if (EOF == fprintf(config_datei, "off: %d def: %d Festung: %d\n",
					   regel.percent_planetoff,
					   regel.percent_planetdef,
					   regel.bonus_festung))
		return FEHLER_W;

	if (EOF == fprintf(config_datei, "\n%s\n", text[language][ARMS]))
		return FEHLER_W;

	if (EOF == fprintf(config_datei, " %d\n", regel.percent_arms))
		return FEHLER_W;

	if (EOF == fprintf(config_datei, "\n%s\n", text[language][SCHILD]))
		return FEHLER_W;

	if (EOF == fprintf(config_datei, " %d\n", regel.percent_shield))
		return FEHLER_W;

	if (EOF == fprintf(config_datei, "\n%s\n", text[language][LOYAL]))
		return FEHLER_W;

	if (EOF == fprintf(config_datei, " %d\n", regel.percent_loyal))
		return FEHLER_W;

	if (EOF == fprintf(config_datei, "\n%s\n", text[language][DEFENSEFAKTOR]))
		return FEHLER_W;

	if (EOF == fprintf(config_datei, "natdef: %d pop grow: %d\n",
					   regel.percent_natdef,
					   regel.percent_pop_grow))
		return FEHLER_W;

	if (EOF == fprintf(config_datei, "\n%s\n", text[language][SPARES]))
		return FEHLER_W;

	if (EOF == fprintf(config_datei, " %d\n", regel.spares_per_pe))
		return FEHLER_W;

	return OK;
}
