#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>
#include "gcio.h"

#ifdef __TURBOC__
#include <ext.h>
#else
#if defined(DIRENT) || (defined(_POSIX_VERSION) && !defined(NeXT))
#include <dirent.h>
#ifdef direct
#undef direct
#endif
#define direct dirent
#define NLENGTH(direct) (strlen((direct)->d_name))
#else /* not (DIRENT or _POSIX_VERSION) */
#define NLENGTH(direct) ((direct)->d_namlen)
#ifdef SYSNDIR
#include <sys/ndir.h>
#endif /* SYSNDIR */
#ifdef SYSDIR
#include <sys/dir.h>
#endif /* SYSDIR */
#ifdef NDIR
#include <ndir.h>
#endif /* NDIR */
#endif /* DIRENT or _POSIX_VERSION */
#endif /* __TURBOC__ */

#ifdef VOID_CLOSEDIR
/* Fake a return value. */
#define CLOSEDIR(d) (closedir (d), 0)
#else
#define CLOSEDIR(d) closedir (d)
#endif

#ifndef UNUSED
#  define UNUSED(x) if (x){}
#endif

#if !DEBUG_ALLOC
#define getmem malloc
#define getcmem calloc
#endif


/* Globale Variablen */

GC_MISC gc_global;
SCH_TYP ship_typ[MAX_STYPEN];
extern int verbose, quiet;

/* Prototypen */

static INLINE WORD fgetword (FILE * datei_handle);
static long datei_laenge(FILE *fp);


void reset_to_initial_state(PLAYER *player)
{
	SCHIFF **schiffe;
	SCHIFF *ship;
	PLANET **planets;
	PLANET *planet;
	WORD i, p;
	
	schiffe = player->pl_ships;
	for (i = 0; i < player->pl_num_ships; i++)
	{
		ship = schiffe[i];
		
		ship->s_new_ziel = ship->s_ziel;
		ship->s_new_pos = ship->s_pos;
		ship->s_new_tf_nr = ship->s_tf_nr;
		for (p = 0; p < ANZ_LADUNG; p++)
			ship->s_new_ladung[p] = ship->s_ladung[p];
		ship->s_schrott = 0;
		ship->s_new_owner = 0;
	}
	
	planets = player->pl_planets;
	for (p = 0; p < gc_global.anz_planeten; p++)
	{
		planet = planets[p];
		if (planet)
		{
			planet->p_new_pe = planet->p_pe;
			for (i = 0; i < MAX_WERFT; i++)
			{
				planet->p_new_werft[i] = planet->p_werft[i];
				planet->p_new_werft[i].w_pe += planet->p_new_werft[i].w_pe_in_runde;
				planet->p_new_werft[i].w_pe_in_runde = 0;
			}
			for (i = 0; i < MAX_GEHEIM; i++)
			{
				planet->p_geheim[i].m_target = 0;
				planet->p_geheim[i].m_pe = 0;
			}
			planet->p_inst_mkits = 0;
			planet->p_inst_lkits = 0;
			planet->p_inst_rkits = 0;
			planet->p_inst_fkits = 0;
			for (i = 0; i < ANZ_LADUNG; i++)
				planet->p_new_ladung[i] = planet->p_ladung[i];
			for (i = 0; i < ANZ_FG; i++)
				planet->p_forschen[i] = 0;
			planet->p_new_festungen = planet->p_festungen;
			planet->p_new_minen = planet->p_minen;
			planet->p_new_landw = planet->p_landw;
			planet->p_new_raffs = planet->p_raffs;
			planet->p_new_fabriken = planet->p_fabriken;
		}
	}
	
	for (i = 0; i < ANZ_FG; i++)
	{
		player->pl_tech_level_new[i] = player->pl_tech_level[i];
		player->pl_tech_level_newpes[i] = player->pl_tech_level_pes[i];
	}
	
	player->pl_kg_player = 0;
	player->pl_kg_pes = 0;
}


static long datei_laenge(FILE *fp)
{
	long old_pos;
	long size;
	
	old_pos = ftell(fp);
	fseek(fp, 0l, 2);
	size = ftell(fp);
	fseek(fp, old_pos, 0);
	return(size);
}


static INLINE WORD fgetword (FILE * datei_handle)
{
	int temp_word, tmp_word;

	if ((temp_word = fgetc(datei_handle))==EOF)
	{
		return(EOF);
	}
	temp_word = temp_word << 8;
	if ((tmp_word=fgetc(datei_handle))==EOF)
	{
		return(EOF);
	}
	temp_word = temp_word | tmp_word;

	return temp_word;
}


#define bgetbyte(var) \
	var = r_buf[(offset)++]

#define bgetword(var) \
	var = (r_buf[(offset)] << 8) | r_buf[(offset)+1]; offset += 2


#define fputbyte(datei, b) putc((b), datei)

#define fputword(datei, w) \
	fputbyte(datei, ((w) >> 8) & 0xff); \
	fputbyte(datei, (w) & 0xff)


static INLINE long sgetint(char **str_p)
{
	char *str;
	long val;
	
	str = *str_p;
	while (*str == ' ' || *str == '\t')
		str++;
	val = 0;
	while (*str >= '0' && *str <= '9')
	{
		val = val * 10 + *str - '0';
		str++;
	}
	*str_p = str;
	return(val);
}


/* Hier wird die Hauptstruktur mit den Spielrundendaten initialisiert   */
/* Muss unbedingt vor get_config aufgerufen werden, wegen Initalisierung */
/* der Schiffsstruktur!!!!!!!!!!!!!                                     */

static BYTE _get_gcb(FILE * gcb_datei, GC_MISC *gcb)
{
	char *temp_zeiger, *space;
	WORD zaehler, grenze, tl;
	int wert;
	char line[BUFFER_GR+1];
	int heimat;
	PLAYER *player;
	
	/* Aktuelle Versionsnummer des Zugeditors */

	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
		return (FEHLER_R);
	temp_zeiger = line;
	gcb->major = (UBYTE) sgetint(&temp_zeiger);
	if (*temp_zeiger != '.')
		return (FEHLER_F);
	temp_zeiger++;
	gcb->minor = (UBYTE) sgetint(&temp_zeiger);

	if (gcb->major != GC_MAJOR || gcb->minor != GC_MINOR)
	{
		return (FEHLER_V);
	}
	
	/* Kennung der GC-Runde */

	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
		return (FEHLER_R);
	sscanf(line, "%s ", gcb->gc_id);

	/* Eigene Spielernummer */

	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
		return (FEHLER_R);
	if (sscanf(line, "%d ", &wert) != 1)
		return (FEHLER_F);
	gcb->sp_nummer = (UBYTE) wert;

	/* Nummer des Heimatplaneten */

	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
		return (FEHLER_R);
	if (sscanf(line, "%d ", &wert) != 1)
		return (FEHLER_F);
	heimat = wert;
	
	/* Groesse des Universums */
	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
		return (FEHLER_R);
	if (sscanf(line, "%d ", &wert) != 1)
		return (FEHLER_F);
	gcb->maxMapSize = wert;

	/* Anzahl der vorhandenen Planeten */
	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
		return (FEHLER_R);
	if (sscanf(line, "%d ", &wert) != 1)
		return (FEHLER_F);
	if (heimat <= 0 || heimat > wert)
		return (FEHLER_F);
	gcb->anz_planeten = wert;
	
	/* Anzahl der zulaessigen Task-Force */

	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
		return (FEHLER_R);
	if (sscanf(line, "%d ", &wert) != 1)
		return (FEHLER_F);
	gcb->max_tf = wert;

	/* Anzahl der teilnehmenden Spieler */
	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
		return (FEHLER_R);
	if (sscanf(line, "%d ", &wert) != 1)
		return (FEHLER_F);
	gcb->anz_spieler = wert;
	grenze = gcb->anz_spieler;
	if (grenze < 2 || grenze > MAX_SPIELER)
		return (FEHLER_SPIELER);
	if (gcb->sp_nummer < 1 || gcb->sp_nummer > gcb->anz_spieler)
		return (FEHLER_SPIELER_NUMMER);
	if (gcb->spieler == NULL)
	{
		gcb->spieler = (PLAYER **)CALLOC(grenze, sizeof(PLAYER *), "_get_gcb: spieler");
		if (gcb->spieler == NULL)
			return (FEHLER_M);
		for (zaehler = 0; zaehler < gcb->anz_spieler; zaehler++)
			if ((gcb->spieler[zaehler] = (PLAYER *)CALLOC(1, sizeof(PLAYER), "_geb_gcb: player")) == NULL)
				return(FEHLER_M);
	}
	player = get_player(gcb->sp_nummer);
	player->pl_heimat = heimat;
	player->pl_number = gcb->sp_nummer;
	player->pl_planets = (PLANET **)CALLOC(gcb->anz_planeten, sizeof(PLANET *), "_get_gcb: planets");
	if (player->pl_planets == NULL)
		return(FEHLER_M);
	
	/* Spielernamen einlesen */

	for (zaehler = 1; zaehler <= grenze; zaehler++)
	{
		PLAYER *p;
		
		if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
			return (FEHLER_R);
		if ((space = strchr(line, '\r')) != NULL)
		{
			*space = '\0';
		} else
		{
			if ((space = strchr(line, '\n')) != NULL)
				*space = '\0';
		}
		p = get_player(zaehler);
		space = line;
		while (*space)
		{
			if (*space == ' ' && space[1] == ' ')
			{
				*space = '\0';
				space += 2;
				while (*space == ' ')
					space++;
				STRNCPY(p->pl_address, space, sizeof(p->pl_address));
				break;
			} else {
				space++;
			}
		}
		STRNCPY(p->pl_name, line, sizeof(p->pl_name));
	}

	/* Anzahl der Schiffstypen */

	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
		return (FEHLER_R);
	if (sscanf(line, "%d ", &wert) != 1)
		return (FEHLER_F);
	gcb->anz_stypen = (UBYTE) wert;
	grenze = gcb->anz_stypen;
	if (grenze > MAX_STYPEN)
		return(FEHLER_STYPEN);
	
	/* Schiffstypen einlesen */

	for (zaehler = 1; zaehler <= grenze; zaehler++)
	{
		SCH_TYP *schiff;
		
		if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
			return (FEHLER_R);
		schiff = SH_TYP(zaehler);
		if (sscanf(line, "%d %d %d %d %d",
			&schiff->t_att,
			&schiff->t_def,
			&schiff->t_transp,
			&schiff->t_kosten[0],
			&schiff->t_reichw[0]) != 5)
			return (FEHLER_F);
		for (tl = 1; tl < ANZ_TL; tl++)
		{
			schiff->t_kosten[tl] = schiff->t_kosten[0] - (WORD)((((long)schiff->t_kosten[0] * tl * regel.percent_construction) / 10 + 4) / 10);
			schiff->t_reichw[tl] = schiff->t_reichw[tl-1] + regel.range[tl-1];
		}
	}

	/* Gueterkosten einlesen */

	for (zaehler = 0; zaehler < ANZ_GUETER; zaehler++)
	{
		if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
			return (FEHLER_R);
		if (sscanf(line, "%d ", &wert) != 1)
			return (FEHLER_F);
		gcb->kosten_goods[zaehler] = wert;
	}

	/* Ladevolumen einlesen */

	for (zaehler = 0; zaehler < ANZ_LADUNG; zaehler++)
	{
		if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
			return (FEHLER_R);
		if (sscanf(line, "%d ", &wert) != 1)
			return (FEHLER_F);
		gcb->trans_goods[zaehler] = wert;
	}

	/* Investitionen fuer Tech-Level einlesen */

	for (zaehler = 0; zaehler < ANZ_TL; zaehler++)
	{
		int cost;
		
		if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
			return (FEHLER_R);
		if (sscanf(line, "%d ", &cost) != 1)
			return (FEHLER_F);
		gcb->kosten_tl[zaehler] = cost;
	}
	/* Datei sollte jetzt zu Ende sein */
	if (fgets(line, BUFFER_GR, gcb_datei) != NULL)
		return (FEHLER_F);
	return OK;
}


BYTE get_gcb(char *pathname, GC_MISC *gcb)
{
	FILE *gcb_datei;
	char datei[PATH_MAX];
	BYTE fehler;

	/* Dateinamen zusammen basteln aus Spielername+Extension */
	sprintf(datei, "%s%s", pathname, EXT_GCB);

	if ((gcb_datei = fopen(datei, "r")) == NULL)
		return FEHLER_O;
	if (verbose)
		fprintf (stderr, "reading %s ...\n", datei);
	fehler = _get_gcb(gcb_datei, gcb);
	f_close(gcb_datei);
	return (fehler);
}


/*
 * Lagebericht einlesen
 */
static BYTE _get_lgb(BYTE ** lgb_datei, FILE * datei_handle, long lgb_gr, int zeichensatz)
{
	UBYTE *b_zeiger;
	UBYTE *sucher;
	WORD umlaut = 0;

	/* Wenn kein Iso-zeichensatz dann 1% mehr Platz, fuer die E's */
	if (zeichensatz == Z_IBM_TO_ASCII)
		umlaut = (int) (lgb_gr / 100) + 1;
	*lgb_datei = (BYTE *) long_alloc(lgb_gr + umlaut + 1, "_get_lgb");
	if (*lgb_datei == NULL)
		return FEHLER_M;

	/* einlesen in Anfang + Umlaut, wegen der Umlaut E's */
	sucher = (UBYTE *)(*lgb_datei + umlaut);
	if (fread(sucher, 1, lgb_gr, datei_handle) != lgb_gr)
	{
		return FEHLER_R;
	}
	sucher[lgb_gr] = '\0';
	b_zeiger = (UBYTE *)(*lgb_datei);

	switch (zeichensatz)
	{
	case Z_IBM_TO_ISO:
		while (*sucher)
		{
			/* suchen der Umlaute (>127) */
			switch (*sucher)
			{
			case 0x81:
				*b_zeiger++ = 0xfc;		/* ue */
				break;
			case 0x84:
				*b_zeiger++ = 0xe4;		/* ae */
				break;
			case 0x8e:
				*b_zeiger++ = 0xc4;		/* Ae */
				break;
			case 0x94:
				*b_zeiger++ = 0xf6;		/* oe */
				break;
			case 0x99:
				*b_zeiger++ = 0xd6;		/* Oe */
				break;
			case 0x9a:
				*b_zeiger++ = 0xdc;		/* Ue */
				break;
			case 0x9e:
			case 0xe1:
				*b_zeiger++ = 0xdf;		/* ss */
				break;
			case 0xdd:
				*b_zeiger++ = 0xa7;		/*  */
				break;
			default:
				*b_zeiger++ = *sucher;
				break;
			}
			sucher++;
		}
		break;
		
	case Z_IBM_TO_ATARI:
		while (*sucher)
		{
			switch (*sucher)
			{
			case 0xe1:
				*b_zeiger++ = 0x9e;
				break;
			default:
				*b_zeiger++ = *sucher;
			}
			sucher++;
		}
		break;
		
	case Z_IBM_TO_ASCII:
		while (*sucher && umlaut)
		{
			switch (*sucher)
			{
			case 0x81:					/* ue */
				*b_zeiger++ = 'u';
				*b_zeiger++ = 'e';
				umlaut--;
				break;
			case 0x84:					/* ae */
				*b_zeiger++ = 'a';
				*b_zeiger++ = 'e';
				umlaut--;
				break;
			case 0x8e:					/* Ae */
				*b_zeiger++ = 'A';
				*b_zeiger++ = 'e';
				umlaut--;
				break;
			case 0x94:					/* oe */
				*b_zeiger++ = 'o';
				*b_zeiger++ = 'e';
				umlaut--;
				break;
			case 0x99:					/* Oe */
				*b_zeiger++ = 'O';
				*b_zeiger++ = 'e';
				umlaut--;
				break;
			case 0x9a:					/* Ue */
				*b_zeiger++ = 'U';
				*b_zeiger++ = 'e';
				umlaut--;
				break;
			case 0x9e:
			case 0xe1:					/* ss */
				*b_zeiger++ = 's';
				*b_zeiger++ = 's';
				umlaut--;
				break;
			default:
				*b_zeiger++ = *sucher;
				break;
			}
			sucher++;
		}
		/* Rest kopieren */
		while (*sucher)
			*b_zeiger++ = *sucher++;
		*b_zeiger = '\0';
		break;
	}
	return OK;
}


BYTE get_lgb(char *pathname, BYTE ** lgb_datei, int zeichensatz)
{
	FILE *datei_handle;
	long lgb_gr;
	BYTE fehler;
	char datei[PATH_MAX + 5];

	sprintf(datei, "%s%s", pathname, EXT_LGB);

	if ((datei_handle = fopen(datei, "rb")) == NULL)
	{
		return FEHLER_O;
	}
	if (verbose)
		fprintf (stderr, "reading %s ...\n", datei);
	lgb_gr = datei_laenge(datei_handle);
	fehler = _get_lgb(lgb_datei, datei_handle, lgb_gr, zeichensatz);
	f_close(datei_handle);
	return (fehler);
}


/*
 * NAS-Datei einlesen
 */
static BYTE _get_nas(FILE *nas_datei, PLAYER *player, WORD *found)
{
	WORD nummer, eigner;
	int pl_zahl;
	WORD zaehler, wz;
	UBYTE spieler;
	char r_buf[2048];
	PLANET *planet;
	char *p;
	int new_planet;
	
	*found = 0;
	spieler = player->pl_number;
	if (fgets(r_buf, (int)sizeof(r_buf), nas_datei) == NULL)
		return FEHLER_R;
	p = r_buf;
	pl_zahl = (int)sgetint(&p);
	zaehler = 0;
	while (fgets(r_buf, (int)sizeof(r_buf), nas_datei) != NULL)
	{
		p = r_buf;
		nummer = (WORD) sgetint(&p);

		/* Sucht Pl mit dieser Nr und
		   erhoeht gg. die Zahl der bekannten Pl */
		if ((planet = find_planet(player, nummer, &new_planet)) == NULL)
		{
			return errno;
		}
		planet->p_old = 1;
		zaehler++;
		
		planet->p_number = nummer;
		planet->p_pos_x = (WORD) sgetint(&p);
		planet->p_pos_y = (WORD) sgetint(&p);

		eigner = (WORD) sgetint(&p);

		if (spieler == eigner)
		{
			/* Wenn neu erobert, dann anzahl der eigene Pl +1 */
			if (spieler != planet->p_owner)
			{
				player->pl_num_planets++;
			}
		} else {
			/* Wenn verloren, dann anzahl der eigene Pl -1 */
			if (spieler == planet->p_owner)
			{
				player->pl_num_planets--;
			}
		}

		if (eigner != 0)
			planet->p_owner = eigner;
		planet->p_nat_def = (UBYTE) sgetint(&p);

		planet->p_pe = sgetint(&p);

		planet->p_max_minen = (UBYTE) sgetint(&p);
		planet->p_minen = (UBYTE) sgetint(&p);
		planet->p_max_landw = (UBYTE) sgetint(&p);
		planet->p_landw = (UBYTE) sgetint(&p);
		planet->p_max_raffs = (UBYTE) sgetint(&p);
		planet->p_raffs = (UBYTE) sgetint(&p);

		planet->p_fabriken = sgetint(&p);
		
		planet->p_ladung[LAD_SPARES] = sgetint(&p);
		planet->p_ladung[LAD_MPE] = sgetint(&p);
		planet->p_ladung[LAD_LPE] = sgetint(&p);
		planet->p_ladung[LAD_RPE] = sgetint(&p);
		planet->p_ladung[LAD_MKITS] = sgetint(&p);
		planet->p_ladung[LAD_LKITS] = sgetint(&p);
		planet->p_ladung[LAD_RKITS] = sgetint(&p);
		planet->p_ladung[LAD_RKITS] = sgetint(&p);
		planet->p_ladung[LAD_KOLONIST] = sgetint(&p);
		
		planet->p_festungen = sgetint(&p);
		planet->p_loyal = sgetint(&p);
		planet->p_kampf = sgetint(&p);

		planet->p_num_ships = sgetint(&p);

		for (wz = 0; wz < MAX_WERFT; wz++)
		{
			planet->p_werft[wz].w_groesse = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_pe_in_runde = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_pe = sgetint(&p);
			planet->p_werft[wz].w_typ = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_erster = (UBYTE) sgetint(&p);
		}

		planet->p_visited = sgetint(&p);
		planet->p_bonus = sgetint(&p);
		planet->p_no_use1 = sgetint(&p);
		planet->p_no_use2 = sgetint(&p);
	}
	if (zaehler != pl_zahl)
		return FEHLER_R;
	*found = zaehler;
	return OK;
}


BYTE get_nas(PLAYER *player, char *pathname, WORD *bas_pl_zahl)
{
	FILE *nas_datei;
	char datei[PATH_MAX];
	BYTE fehler;
	WORD found;
	
	/* NAS Datei einlesen */
	sprintf(datei, "%s%s", pathname, EXT_NAS);
	if ((nas_datei = fopen(datei, "r")) == NULL)
	{
		return FEHLER_O;
	}

	if (verbose)
		fprintf (stderr, "reading %s ... ", datei);
	fehler = _get_nas(nas_datei, player, &found);
	if (verbose)
		fprintf(stderr, "found %d planets\n", found);
	f_close(nas_datei);
	player->pl_bas_file_changed = FALSE;
	if (bas_pl_zahl != NULL)
		*bas_pl_zahl = found;
	return(fehler);
}


#define fprint_planet(datei, planet) \
	(fprintf(datei, "%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d\n", \
	(planet)->p_number, \
	(planet)->p_pos_x, \
	(planet)->p_pos_y, \
	(planet)->p_owner, \
	(planet)->p_nat_def, \
	(planet)->p_pe, \
	(planet)->p_max_minen, \
	(planet)->p_minen, \
	(planet)->p_max_landw, \
	(planet)->p_landw, \
	(planet)->p_max_raffs, \
	(planet)->p_raffs, \
	(planet)->p_fabriken, \
	(planet)->p_ladung[LAD_SPARES], \
	(planet)->p_ladung[LAD_MPE], \
	(planet)->p_ladung[LAD_LPE], \
	(planet)->p_ladung[LAD_RPE], \
	(planet)->p_ladung[LAD_MKITS], \
	(planet)->p_ladung[LAD_LKITS], \
	(planet)->p_ladung[LAD_RKITS], \
	(planet)->p_ladung[LAD_FKITS], \
	(planet)->p_ladung[LAD_KOLONIST], \
	(planet)->p_festungen, \
	(planet)->p_loyal, \
	(planet)->p_kampf, \
	(planet)->p_num_ships, \
	(planet)->p_werft[0].w_groesse, \
	(planet)->p_werft[0].w_pe_in_runde, \
	(planet)->p_werft[0].w_pe, \
	(planet)->p_werft[0].w_typ, \
	(planet)->p_werft[0].w_erster, \
	(planet)->p_werft[1].w_groesse, \
	(planet)->p_werft[1].w_pe_in_runde, \
	(planet)->p_werft[1].w_pe, \
	(planet)->p_werft[1].w_typ, \
	(planet)->p_werft[1].w_erster, \
	(planet)->p_werft[2].w_groesse, \
	(planet)->p_werft[2].w_pe_in_runde, \
	(planet)->p_werft[2].w_pe, \
	(planet)->p_werft[2].w_typ, \
	(planet)->p_werft[2].w_erster, \
	(planet)->p_visited, \
	(planet)->p_bonus, \
	(planet)->p_no_use1, \
	(planet)->p_no_use2) == EOF)

/*
 * NAS-Datei schreiben
 */
static BYTE _put_nas(PLAYER *player, FILE *datei)
{
	WORD ende, zaehler;
	PLANET *planet, **planets;
	
	planets = player->pl_planets;
	ende = 0;
	for (zaehler = 0; zaehler < gc_global.anz_planeten; zaehler++)
		if (planets[zaehler] != NULL)
			++ende;
	
	player->pl_known_planets = ende;

	if (EOF == fprintf(datei, "%d\n", ende))
		return FEHLER_W;
	
	ende = gc_global.anz_planeten;
	for (zaehler = 0; zaehler < ende; zaehler++)
	{
		planet = planets[zaehler];
		if (planet != NULL)
		{
			if (fprint_planet(datei, planet))
				return(FEHLER_W);
		}
	}

	if (ferror(datei) || fflush(datei) == EOF)
		return(FEHLER_W);
	return OK;
}


BYTE put_nas(PLAYER *player, char *pathname)
{
	FILE *planeten_datei;
	BYTE ok;
	char datei[PATH_MAX];
	
	sprintf(datei, "%s%s", pathname, EXT_NAS);

	if ((planeten_datei = fopen(datei, "w")) == NULL)
		return FEHLER_O;

	if (verbose)
		fprintf (stderr, "writing %s ...\n", datei);
	ok = _put_nas(player, planeten_datei);

	f_close(planeten_datei);
	if (ok == OK)
		player->pl_bas_file_changed = FALSE;
	return ok;
}


#define bget_rest_of_planet(planet, r_buf, offset) \
	bgetbyte((planet)->p_nat_def); \
	bgetword((planet)->p_pe); \
	bgetbyte((planet)->p_max_minen); \
	bgetbyte((planet)->p_minen); \
	bgetbyte((planet)->p_max_landw); \
	bgetbyte((planet)->p_landw); \
	bgetbyte((planet)->p_max_raffs); \
	bgetbyte((planet)->p_raffs); \
	bgetword((planet)->p_fabriken); \
	bgetword((planet)->p_ladung[LAD_SPARES]); \
	bgetword((planet)->p_ladung[LAD_MPE]); \
	bgetword((planet)->p_ladung[LAD_LPE]); \
	bgetword((planet)->p_ladung[LAD_RPE]); \
	bgetword((planet)->p_ladung[LAD_MKITS]); \
	bgetword((planet)->p_ladung[LAD_LKITS]); \
	bgetword((planet)->p_ladung[LAD_RKITS]); \
	bgetword((planet)->p_ladung[LAD_FKITS]); \
	bgetword((planet)->p_ladung[LAD_KOLONIST]); \
	bgetword((planet)->p_festungen); \
	bgetword((planet)->p_loyal); \
	bgetword((planet)->p_kampf); \
	bgetword((planet)->p_num_ships); \
	for (wz = 0; wz < MAX_WERFT; wz++) \
	{ \
		bgetbyte((planet)->p_werft[wz].w_groesse); \
		bgetbyte((planet)->p_werft[wz].w_pe_in_runde); \
		bgetword((planet)->p_werft[wz].w_pe); \
		bgetbyte((planet)->p_werft[wz].w_typ); \
		bgetbyte((planet)->p_werft[wz].w_erster); \
	} \
	bgetbyte((planet)->p_visited); \
	bgetbyte((planet)->p_bonus); \
	bgetword((planet)->p_no_use1); \
	bgetword((planet)->p_no_use2)


 /* BAS oder CAS oder PLB Datei einlesen. Format von BAS und PLB sind	*/
 /* fest vorgegeben, wobei BAS nur aus kompatibilitaet dabei ist.		*/
 /* BAS enthaelt MAX PL Strukturen vom Typ Planet(ohne NR.)				*/
 /* CAS enthaelt aufsteigender Reihenfolge Strukturen vom Typ Planet	*/
 /* (mit Nr.) von denen die Koordinaten dem Spieler bekannt sind		*/
 /* PLB enthaelt X Strukturen vom Typ Planet(mit Nr.)					*/
  
static BYTE _get_bas(WORD pl_zahl, FILE *bas_datei, PLAYER *player, WORD *found)
{
	WORD zaehler, wz, bonus;
	UBYTE eigner, spieler, X, Y, offset, r_buf[BAS_ST_GR];
	PLANET *planet;
	int new_planet;
	
	*found = 0;
	if (pl_zahl != gc_global.anz_planeten)
		return(FEHLER_F);
	spieler = gc_global.sp_nummer;
	for (zaehler = 0; zaehler < pl_zahl; zaehler++)
	{
		offset = 0;
		if (fread(r_buf, (long)BAS_ST_GR, 1, bas_datei) != 1)
		{
			return FEHLER_R;
		}

		bgetbyte(X);
		bgetbyte(Y);
		bonus = r_buf[59];
		/* Nur fuer BAS, da in CAS und PLB nur bekannte Pl stehen */
		if (X || Y || bonus)
		{
			/* Sucht Pl mit dieser Nr und
				erhoeht gg. die Zahl der bekannten Pl */
			planet = find_planet(player, zaehler+1, &new_planet);
			if (planet == NULL)
				return errno;
			
			bgetbyte(eigner);

			if (spieler == eigner)
			{
				/* Wenn neu erobert, dann anzahl der eigene Pl +1 */
				if (spieler != planet->p_owner)
				{
					player->pl_num_planets++;
				}
			} else {
				/* Wenn verloren, dann anzahl der eigene Pl -1 */
				if (spieler == planet->p_owner)
				{
					player->pl_num_planets--;
				}
			}

			planet->p_pos_x = X;
			planet->p_pos_y = Y;
			if (eigner != 0)
				planet->p_owner = eigner;
			
			bget_rest_of_planet(planet, r_buf, offset);
			
			planet->p_old = 1;
			(*found)++;
		}
	}
	return OK;
}


BYTE get_bas(PLAYER *player, char *pathname, WORD *bas_pl_zahl)
{
	FILE *bas_datei;
	char datei[PATH_MAX];
	BYTE fehler;
	WORD pl_zahl;
	WORD found;
	
	/* BAS Datei einlesen */
	sprintf(datei, "%s%s", pathname, EXT_BAS);
	if ((bas_datei = fopen(datei, "rb")) == NULL)
	{
		return FEHLER_O;
	}
	
	if (verbose)
		fprintf (stderr, "reading %s ... ", datei);
	pl_zahl = datei_laenge(bas_datei) / BAS_ST_GR;
	fehler = _get_bas(pl_zahl, bas_datei, player, &found);
	if (verbose)
		fprintf(stderr, "found %d planets\n", found);
	f_close(bas_datei);
	player->pl_bas_file_changed = FALSE;
	if (bas_pl_zahl != NULL)
		*bas_pl_zahl = found;
	return(fehler);
}


/*
 * PLN-Datei einlesen
 */
static BYTE _get_pln(FILE *pln_datei, PLAYER *player)
{
	WORD nummer, eigner;
	WORD wz;
	UBYTE spieler;
	char r_buf[2048];
	PLANET *planet;
	char *p;
	PLANET old_planet;
	int new_planet;
	
	spieler = gc_global.sp_nummer;
	while (fgets(r_buf, (int)sizeof(r_buf), pln_datei) != NULL)
	{
		p = r_buf;
		nummer = sgetint(&p);

		/* Sucht Pl mit dieser Nr und
		   erhoeht gg. die Zahl der bekannten Pl */
		if ((planet = find_planet(player, nummer, &new_planet)) == NULL)
		{
			return errno;
		}
		old_planet = *planet;
		
		planet->p_pos_x = sgetint(&p);
		planet->p_pos_y = sgetint(&p);

		eigner = sgetint(&p);

		if (spieler == eigner)
		{
			/* Wenn neu erobert, dann anzahl der eigene Pl +1 */
			if (spieler != planet->p_owner)
			{
				player->pl_num_planets++;
				player->pl_num_won++;
			}
		} else
		{
			/* Wenn verloren, dann anzahl der eigene Pl -1 */
			if (spieler == planet->p_owner)
			{
				player->pl_num_planets--;
				player->pl_num_lost++;
			}
		}

		if (eigner != 0)
			planet->p_owner = eigner;
		planet->p_nat_def = (UBYTE) sgetint(&p);

		planet->p_pe = sgetint(&p);

		planet->p_max_minen = (UBYTE) sgetint(&p);
		planet->p_minen = (UBYTE) sgetint(&p);
		planet->p_max_landw = (UBYTE) sgetint(&p);
		planet->p_landw = (UBYTE) sgetint(&p);
		planet->p_max_raffs = (UBYTE) sgetint(&p);
		planet->p_raffs = (UBYTE) sgetint(&p);

		planet->p_fabriken = sgetint(&p);
		
		planet->p_ladung[LAD_SPARES] = sgetint(&p);
		planet->p_ladung[LAD_MPE] = sgetint(&p);
		planet->p_ladung[LAD_LPE] = sgetint(&p);
		planet->p_ladung[LAD_RPE] = sgetint(&p);
		planet->p_ladung[LAD_MKITS] = sgetint(&p);
		planet->p_ladung[LAD_LKITS] = sgetint(&p);
		planet->p_ladung[LAD_RKITS] = sgetint(&p);
		planet->p_ladung[LAD_FKITS] = sgetint(&p);
		planet->p_ladung[LAD_KOLONIST] = sgetint(&p);
		
		planet->p_festungen = sgetint(&p);
		planet->p_loyal = sgetint(&p);
		planet->p_kampf = sgetint(&p);

		planet->p_num_ships = sgetint(&p);

		for (wz = 0; wz < MAX_WERFT; wz++)
		{
			planet->p_werft[wz].w_groesse = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_pe_in_runde = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_pe = sgetint(&p);
			planet->p_werft[wz].w_typ = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_erster = (UBYTE) sgetint(&p);
		}

		planet->p_visited = sgetint(&p);
		planet->p_bonus = sgetint(&p);
		
		planet->p_no_use1 = sgetint(&p);
		planet->p_no_use2 = sgetint(&p);
		
		if (new_planet || memcmp(planet, &old_planet, GR__PLANET) != 0)
			player->pl_bas_file_changed = TRUE;
	}
	return OK;
}


BYTE get_pln(PLAYER *player, char *pathname)
{
	FILE *pln_datei;
	char datei[PATH_MAX];
	BYTE fehler;
	
	/* PLN Datei einlesen */
	sprintf(datei, "%s%s", pathname, EXT_PLN);
	if ((pln_datei = fopen(datei, "r")) == NULL)
	{
		return FEHLER_O;
	}

	if (verbose)
		fprintf (stderr, "reading %s ... \n", datei);
	fehler = _get_pln(pln_datei, player);
	f_close(pln_datei);
	return(fehler);
}


/*
 * PLB-Datei einlesen
 */
static BYTE _get_plb(WORD pl_zahl, FILE *plb_datei, PLAYER *player)
{
	WORD zaehler, wz, bonus, nummer;
	UBYTE eigner, spieler, X, Y, r_buf[PLB_ST_GR], offset;
	PLANET *planet;
	PLANET old_planet;
	int new_planet;
	
	spieler = player->pl_number;
	for (zaehler = 0; zaehler < pl_zahl; zaehler++)
	{
		offset = 0;
		if (fread(r_buf, (long)PLB_ST_GR, 1, plb_datei) != 1)
		{
			return FEHLER_R;
		}

		bgetword(nummer);
		bgetbyte(X);
		bgetbyte(Y);
		bonus = r_buf[59+2];
		/* Eigentlich nur fuer BAS, da in PLB nur bekannte Pl stehen */
		if (X || Y || bonus)
		{
			/* Sucht Pl mit dieser Nr und
				erhoeht gg. die Zahl der bekannten Pl */
			planet = find_planet(player, nummer, &new_planet);
			if (planet == NULL)
				return errno;
			
			old_planet = *planet;
			
			bgetbyte(eigner);

			if (spieler == eigner)
			{
				/* Wenn neu erobert, dann anzahl der eigene Pl +1 */
				if (spieler != planet->p_owner)
				{
					player->pl_num_planets++;
					player->pl_num_won++;
				}
			} else {
				/* Wenn verloren, dann anzahl der eigene Pl -1 */
				if (spieler == planet->p_owner)
				{
					player->pl_num_planets--;
					player->pl_num_lost++;
				}
			}

			planet->p_pos_x = X;
			planet->p_pos_y = Y;
			if (eigner != 0)
				planet->p_owner = eigner;
			
			bget_rest_of_planet(planet, r_buf, offset);
			
			if (new_planet || memcmp(planet, &old_planet, GR__PLANET) != 0)
				player->pl_bas_file_changed = TRUE;
		}
	}
	return OK;
}


BYTE get_plb(PLAYER *player, char *pathname)
{
	FILE *plb_datei;
	char datei[PATH_MAX];
	BYTE fehler;
	WORD pl_zahl;
	
	/* PLB Datei einlesen */
	sprintf(datei, "%s%s", pathname, EXT_PLB);
	if ((plb_datei = fopen(datei, "rb")) == NULL)
	{
		return FEHLER_O;
	}
	
	if (verbose)
		fprintf (stderr, "reading %s ...\n", datei);
	pl_zahl = datei_laenge(plb_datei) / PLB_ST_GR;
	fehler = _get_plb(pl_zahl, plb_datei, player);
	f_close(plb_datei);
	return(fehler);
}


/*
 * PLB-Datei -> PLN-Datei
 */
static BYTE _plb_to_pln(WORD pl_zahl, FILE *plb_datei, FILE *pln_datei, PLAYER *player)
{
	WORD zaehler, wz, bonus, nummer;
	UBYTE eigner, X, Y, r_buf[PLB_ST_GR], offset;
	PLANET *planet;
	int new_planet;
	
	for (zaehler = 0; zaehler < pl_zahl; zaehler++)
	{
		if (fread(r_buf, (long)PLB_ST_GR, 1, plb_datei) != 1)
		{
			return FEHLER_R;
		}

		offset = 0;
		bgetword(nummer);
		bgetbyte(X);
		bgetbyte(Y);
		bonus = r_buf[59+2];
		/* Eigentlich nur fuer BAS, da in PLB nur bekannte Pl stehen */
		if (X || Y || bonus)
		{
			/* Sucht Pl mit dieser Nr und
				erhoeht gg. die Zahl der bekannten Pl */
			planet = find_planet(player, nummer, &new_planet);
			if (planet == NULL)
				return errno;
			
			bgetbyte(eigner);

			planet->p_pos_x = X;
			planet->p_pos_y = Y;
			planet->p_owner = eigner;
			
			bget_rest_of_planet(planet, r_buf, offset);
			
			if (fprint_planet(pln_datei, planet))
				return(FEHLER_W);
		}
	}
	return OK;
}


BYTE plb_to_pln(PLAYER *player, char *pathname)
{
	FILE *plb_datei;
	FILE *pln_datei;
	char datei[PATH_MAX];
	BYTE fehler;
	WORD pl_zahl;
	
	/* PLB Datei einlesen */
	sprintf(datei, "%s%s", pathname, EXT_PLB);
	if ((plb_datei = fopen(datei, "rb")) == NULL)
	{
		return FEHLER_O;
	}
	sprintf(datei, "%s%s", pathname, EXT_PLN);
	if ((pln_datei = fopen(datei, "w")) == NULL)
	{
		f_close(plb_datei);
		return FEHLER_C;
	}
	
	pl_zahl = datei_laenge(plb_datei) / PLB_ST_GR;
	fehler = _plb_to_pln(pl_zahl, plb_datei, pln_datei, player);
	f_close(plb_datei);
	f_close(pln_datei);
	return(fehler);
}


#define fput_planet(datei, planet) \
	fputbyte(datei, (planet)->p_pos_x); \
	fputbyte(datei, (planet)->p_pos_y); \
	fputbyte(datei, (planet)->p_owner); \
	fputbyte(datei, (planet)->p_nat_def); \
	fputword(datei, (planet)->p_pe); \
	fputbyte(datei, (planet)->p_max_minen); \
	fputbyte(datei, (planet)->p_minen); \
	fputbyte(datei, (planet)->p_max_landw); \
	fputbyte(datei, (planet)->p_landw); \
	fputbyte(datei, (planet)->p_max_raffs); \
	fputbyte(datei, (planet)->p_raffs); \
	fputword(datei, (planet)->p_fabriken); \
	for (wz = 0; wz < ANZ_LADUNG; wz++) \
	{ \
		fputword(datei, (planet)->p_ladung[wz]); \
	} \
	fputword(datei, (planet)->p_festungen); \
	fputword(datei, (planet)->p_loyal); \
	fputword(datei, (planet)->p_kampf); \
	fputword(datei, (planet)->p_num_ships); \
	for (wz = 0; wz < MAX_WERFT; wz++) \
	{ \
		fputbyte(datei, (planet)->p_werft[wz].w_groesse); \
		fputbyte(datei, (planet)->p_werft[wz].w_pe_in_runde); \
		fputword(datei, (planet)->p_werft[wz].w_pe); \
		fputbyte(datei, (planet)->p_werft[wz].w_typ); \
		fputbyte(datei, (planet)->p_werft[wz].w_erster); \
	} \
	fputbyte(datei, (planet)->p_visited); \
	fputbyte(datei, (planet)->p_bonus); \
	fputword(datei, (planet)->p_no_use1); \
	fputword(datei, (planet)->p_no_use2)


/*
 * PLN-Datei -> PLB-Datei
 */
static BYTE _pln_to_plb(FILE *plb_datei, FILE *pln_datei, PLAYER *player)
{
	WORD nummer;
	WORD wz;
	char r_buf[2048];
	PLANET *planet;
	char *p;
	int new_planet;
	
	while (NULL != fgets(r_buf, (int)sizeof(r_buf), pln_datei))
	{
		p = r_buf;
		nummer = sgetint(&p);

		/* Sucht Pl mit dieser Nr und
		   erhoeht gg. die Zahl der bekannten Pl */
		if ((planet = find_planet(player, nummer, &new_planet)) == NULL)
		{
			return errno;
		}
		planet->p_pos_x = sgetint(&p);
		planet->p_pos_y = sgetint(&p);

		planet->p_owner = sgetint(&p);
		planet->p_nat_def = (UBYTE) sgetint(&p);

		planet->p_pe = sgetint(&p);

		planet->p_max_minen = (UBYTE) sgetint(&p);
		planet->p_minen = (UBYTE) sgetint(&p);
		planet->p_max_landw = (UBYTE) sgetint(&p);
		planet->p_landw = (UBYTE) sgetint(&p);
		planet->p_max_raffs = (UBYTE) sgetint(&p);
		planet->p_raffs = (UBYTE) sgetint(&p);

		planet->p_fabriken = sgetint(&p);
		
		planet->p_ladung[LAD_SPARES] = sgetint(&p);
		planet->p_ladung[LAD_MPE] = sgetint(&p);
		planet->p_ladung[LAD_LPE] = sgetint(&p);
		planet->p_ladung[LAD_RPE] = sgetint(&p);

		planet->p_ladung[LAD_MKITS] = sgetint(&p);
		planet->p_ladung[LAD_LKITS] = sgetint(&p);
		planet->p_ladung[LAD_RKITS] = sgetint(&p);
		planet->p_ladung[LAD_FKITS] = sgetint(&p);
		planet->p_ladung[LAD_KOLONIST] = sgetint(&p);
		
		planet->p_festungen = sgetint(&p);
		planet->p_loyal = sgetint(&p);
		planet->p_kampf = sgetint(&p);

		planet->p_num_ships = sgetint(&p);

		for (wz = 0; wz < MAX_WERFT; wz++)
		{
			planet->p_werft[wz].w_groesse = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_pe_in_runde = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_pe = sgetint(&p);
			planet->p_werft[wz].w_typ = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_erster = (UBYTE) sgetint(&p);
		}

		planet->p_visited = sgetint(&p);
		planet->p_bonus = sgetint(&p);
		planet->p_no_use1 = sgetint(&p);
		planet->p_no_use2 = sgetint(&p);
		
		fputword(plb_datei, planet->p_number);
		fput_planet(plb_datei, planet);
		if (ferror(plb_datei))
			return(FEHLER_W);
	}
	if (ferror(plb_datei) || fflush(plb_datei) == EOF)
		return(FEHLER_W);
	return OK;
}


BYTE pln_to_plb(PLAYER *player, char *pathname)
{
	FILE *plb_datei;
	FILE *pln_datei;
	char datei[PATH_MAX];
	BYTE fehler;
	
	/* PLN Datei einlesen */
	sprintf(datei, "%s%s", pathname, EXT_PLN);
	if ((pln_datei = fopen(datei, "r")) == NULL)
	{
		return FEHLER_O;
	}
	sprintf(datei, "%s%s", pathname, EXT_PLB);
	if ((plb_datei = fopen(datei, "wb")) == NULL)
	{
		f_close(pln_datei);
		return FEHLER_C;
	}
	
	fehler = _pln_to_plb(plb_datei, pln_datei, player);
	f_close(pln_datei);
	f_close(plb_datei);
	return(fehler);
}


/*
 * FLN-Datei einlesen
 */
static BYTE _get_fln(PLAYER *player, FILE *fln_datei)
{
	UWORD s_zahl = 0, lz;
	SCHIFF *ship;
	SCHIFF **schiff;
	char r_buf[2048], *p;
	
	schiff = player->pl_ships;
	while (NULL != fgets(r_buf, (int) sizeof(r_buf), fln_datei))
	{
		if (s_zahl >= MAX_SCHIFFE)
			return(FEHLER_F);
		if ((ship = NEW(SCHIFF, "_get_fln")) == NULL)
		{
			return FEHLER_M;
		}
		schiff[s_zahl] = ship;
		
		p = r_buf;
		ship->s_number = sgetint(&p);

		ship->s_kills = sgetint(&p);
		ship->s_pos = sgetint(&p);
		ship->s_ziel = sgetint(&p);
		
		ship->s_typ = (UBYTE) sgetint(&p);
		ship->s_atl = (UBYTE) sgetint(&p);
		ship->s_vtl = (UBYTE) sgetint(&p);
		ship->s_reichw = (UBYTE) sgetint(&p);

		ship->s_moved = (UBYTE) sgetint(&p);
		ship->s_distance = (UBYTE) sgetint(&p);

		ship->s_tf_nr = (UBYTE) sgetint(&p);

		ship->s_cur_def = (UBYTE) sgetint(&p);
		ship->s_cur_transp = (UBYTE) sgetint(&p);

		for (lz = 0; lz < ANZ_LADUNG; lz++)
		{
			ship->s_ladung[lz] = (UBYTE) sgetint(&p);
		}

		s_zahl++;
	}
	player->pl_num_ships = s_zahl;
	return OK;
}


BYTE get_fln(PLAYER *player, char *pathname)
{
	FILE *fln_datei;
	BYTE fehler;
	char datei[PATH_MAX];
	
	sprintf(datei, "%s%s", pathname, EXT_FLN);

	if ((fln_datei = fopen(datei, "r")) == NULL)
	{
		return FEHLER_O;
	}
	if (verbose)
		fprintf (stderr, "reading %s ...\n", datei);
	fehler = _get_fln(player, fln_datei);
	f_close(fln_datei);
	return(fehler);
}


/*
 * FLB-Datei einlesen
 */
static BYTE _get_flb (PLAYER *player, FILE *flb_datei)
{
	long platz;
	UWORD s_zahl, zaehler, lz;
	SCHIFF * ship;
	SCHIFF **schiff;
	UBYTE r_buf[FLB_ST_GR];
	WORD offset;
	
	/* aus der Laenge der Datei die Anzahl der Schiffe berechnen */
    platz = datei_laenge(flb_datei);
    s_zahl = (UWORD) (platz / FLB_ST_GR);
	if (s_zahl > MAX_SCHIFFE)
		return(FEHLER_F);
	schiff = player->pl_ships;
    for (zaehler = 0; zaehler < s_zahl; zaehler++)
    {
		if ((ship = NEW(SCHIFF, "_get_flb")) == NULL)
		{
			return FEHLER_M;
		}
		schiff[zaehler] = ship;
		
		if (fread(r_buf, FLB_ST_GR, 1, flb_datei) != 1)
    	{
	        return FEHLER_R;
		}
		
		offset = 0;
		bgetword(ship->s_number);
		bgetword(ship->s_kills);
		bgetword(ship->s_pos);
		bgetword(ship->s_ziel);
		bgetbyte(ship->s_typ);
		bgetbyte(ship->s_atl);
		bgetbyte(ship->s_vtl);
		bgetbyte(ship->s_reichw);
		bgetbyte(ship->s_moved);
		bgetbyte(ship->s_distance);
		bgetbyte(ship->s_tf_nr);
		bgetbyte(ship->s_cur_def);
		bgetbyte(ship->s_cur_transp);
		for (lz = 0; lz < ANZ_LADUNG; lz++)
		{
			bgetbyte(ship->s_ladung[lz]);
		}
	}
    player->pl_num_ships = s_zahl;
	return OK;
}


BYTE get_flb(PLAYER *player, char *pathname)
{
	FILE *flb_datei;
	BYTE fehler;
	char datei[PATH_MAX];
	
	sprintf(datei, "%s%s", pathname, EXT_FLB);

	if ((flb_datei = fopen(datei, "rb")) == NULL)
	{
		return FEHLER_O;
	}
	if (verbose)
		fprintf (stderr, "reading %s ...\n", datei);
	fehler = _get_flb(player, flb_datei);
	f_close(flb_datei);
	return(fehler);
}


/*
 * VLN-Datei einlesen
 */
static BYTE _get_vln(PLAYER *player, FILE *vln_datei, char *filename)
{
	int nachricht, wort2, wort3, wort4;
	char r_buf[2048];
	PLANET *planet;
	int new_planet;
	WORD platzierung = 0;
	
	while (NULL != fgets(r_buf, (int) sizeof(r_buf), vln_datei))
	{
		if (sscanf(r_buf, "%d %d %d %d", &nachricht, &wort2, &wort3, &wort4) != 4)
			return(FEHLER_F);
		switch (nachricht)
		{
		case 0:		/* Sternzeit */
			if (gc_global.starDate == 0)
				gc_global.starDate = wort2;
			else if (gc_global.starDate != wort2 && !quiet)
				fprintf(stderr, "warning: %s out of date (%d)\n", filename, wort2);
			break;

		case 1:		/* Info ueber Festungen */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return errno;
			if (new_planet || planet->p_festungen != wort3)
				player->pl_bas_file_changed = TRUE;
			planet->p_festungen = wort3;
			break;

		case 2:		/* Bonus */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return errno;
			if (new_planet || planet->p_bonus != wort3)
				player->pl_bas_file_changed = TRUE;
			planet->p_bonus = wort3;
			break;

		case 3:		/* Info ueber Eigentuemer eines Planeten */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return errno;
			if (new_planet || planet->p_owner != wort3)
				player->pl_bas_file_changed = TRUE;
			planet->p_owner = wort3;
			break;

		case 4:		/* Info ueber Planetenposition */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return errno;
			if (new_planet || planet->p_pos_x != wort3 || planet->p_pos_y != wort4)
				player->pl_bas_file_changed = TRUE;
			planet->p_pos_x = wort3;
			planet->p_pos_y = wort4;
			break;
		
		case 5:		/* Eigenes Schiff zerstoert */
			if (wort3 < 1 || wort3 > gc_global.anz_stypen)
				return(FEHLER_F);
			if (wort4 < 1 || wort4 > gc_global.anz_planeten)
				return(FEHLER_F);
			break;
		
		case 6:		/* Feindliches Schiff zerstoert */
			if (wort2 < 1 || wort2 > gc_global.anz_stypen)
				return(FEHLER_F);
			if (wort3 < 1 || wort3 > gc_global.anz_planeten)
				return(FEHLER_F);
			
			break;
		
		case 7:		/* Angriff auf Planet */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			if (wort3 < 1 || wort3 > gc_global.anz_spieler)
				return(FEHLER_F);
			planet = find_planet(player, wort2, FALSE);
			break;
		
		case 50:	/* Eigene Platzierung */
			player->pl_platz = wort2;
			player->pl_score = wort3;
			player->pl_zuwachs = wort4;
			break;
		
		case 51:	/* Info ueber Top 5 */
			{
				PLAYER *who;
				
				if (wort2 < 1 || wort2 > gc_global.anz_spieler)
					return(FEHLER_F);
				who = get_player(wort2);
				platzierung++;
				who->pl_platz = platzierung;
				who->pl_score = wort3;
				who->pl_zuwachs = wort4;
			}
			break;
		
		case 52:	/* Anonyme Scoreliste */
			if (wort2 >= 1 && wort2 <= gc_global.anz_spieler)
			{
				gc_global.anonym[wort2-1] = wort3;
			}
			break;
			
		case 101:	/* Info ueber Tech-Level */
			if (wort2 < 0 || wort2 >= ANZ_FG)
				return(FEHLER_F);
			player->pl_tech_level_pes[wort2] = wort3;
			player->pl_tech_level[wort2] = wort4;
			player->pl_tech_level_newpes[wort2] = wort3;
			player->pl_tech_level_new[wort2] = wort4;
			break;
		}
	}
	return OK;
}


BYTE get_vln(PLAYER *player, char *pathname)
{
	FILE *vln_datei;
    char datei[PATH_MAX];
	BYTE fehler;
	
	sprintf(datei, "%s%s", pathname, EXT_VLN);

	if ((vln_datei = fopen(datei, "r")) == NULL)
	{
		return FEHLER_O;
	}
	if (verbose)
		fprintf (stderr, "reading %s ...\n", datei);
	fehler = _get_vln(player, vln_datei, datei);
	f_close(vln_datei);
	return(fehler);
}


/*
 * VLB-Datei einlesen
 */
static BYTE _get_vlb(PLAYER *player, FILE *vlb_datei, char *filename)
{
	long platz;
	int v_zahl, zaehler=0;
	WORD nachricht, wort2, wort3, wort4;
    PLANET *planet;
	int new_planet;
	WORD platzierung = 0;
	
	/* Die Zahl der Nachrichten berechnen fuer die Schleife */
    platz = datei_laenge(vlb_datei);
    v_zahl = (UWORD) (platz / VLB_ST_GR) ;

	while (((nachricht=fgetword(vlb_datei))!=EOF) && (zaehler<v_zahl))
	{
		/* Das 2. Wort auch einlesen */
		if ((wort2 = fgetword(vlb_datei)) == EOF ||
			(wort3 = fgetword(vlb_datei)) == EOF ||
			(wort4 = fgetword(vlb_datei)) == EOF)
		{
			return ferror(vlb_datei) ? FEHLER_R : FEHLER_F;
		}
		switch(nachricht)
		{
		case 0:		/* Sternzeit */
			if (gc_global.starDate == 0)
				gc_global.starDate = wort2;
			else if (gc_global.starDate != wort2 && !quiet)
				fprintf(stderr, "warning: %s out of date (%d)\n", filename, wort2);
			break;

		case 1:		/* Info ueber Festungen */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return errno;
			if (new_planet || planet->p_festungen != wort3)
				player->pl_bas_file_changed = TRUE;
			planet->p_festungen = wort3;
			break;
		
		case 2:		/* Bonus */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return errno;
			if (new_planet || planet->p_bonus != wort3)
				player->pl_bas_file_changed = TRUE;
			planet->p_bonus = wort3;
			break;
		
		case 3:		/* Info ueber Eigentuemer eines Planeten */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return errno;
			if (new_planet || planet->p_owner != wort3)
				player->pl_bas_file_changed = TRUE;
			planet->p_owner = wort3;
			break;

		case 4:		/* Info ueber Planetenposition */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return errno;
			if (new_planet || planet->p_pos_x != wort3 || planet->p_pos_y != wort4)
				player->pl_bas_file_changed = TRUE;
			planet->p_pos_x = wort3;
			planet->p_pos_y = wort4;
			break;

		case 5:		/* Eigenes Schiff zerstoert */
			if (wort3 < 1 || wort3 > gc_global.anz_stypen)
				return(FEHLER_F);
			if (wort4 < 1 || wort4 > gc_global.anz_planeten)
				return(FEHLER_F);
			break;
		
		case 6:		/* Feindliches Schiff zerstoert */
			if (wort2 < 1 || wort2 > gc_global.anz_stypen)
				return(FEHLER_F);
			if (wort3 < 1 || wort3 > gc_global.anz_planeten)
				return(FEHLER_F);
			break;
		
		case 7:		/* Angriff auf Planet */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			if (wort3 < 1 || wort3 > gc_global.anz_spieler)
				return(FEHLER_F);
			planet = find_planet(player, wort2, FALSE);
			break;
		
		case 50:	/* Eigene Platzierung */
			player->pl_platz = wort2;
			player->pl_score = wort3;
			player->pl_zuwachs = wort4;
			break;
		
		case 51:	/* Info ueber Top 5 */
			{
				PLAYER *who;
				
				if (wort2 < 1 || wort2 > gc_global.anz_spieler)
					return(FEHLER_F);
				who = get_player(wort2);
				platzierung++;
				who->pl_platz = platzierung;
				who->pl_score = wort3;
				who->pl_zuwachs = wort4;
			}
			break;
		
		case 52:	/* Anonyme Scoreliste */
			if (wort2 >= 1 && wort2 <= gc_global.anz_spieler)
			{
				gc_global.anonym[wort2-1] = wort3;
			}
			break;
			
		case 101:	/* Info ueber Tech-Level */
			if (wort2 < 0 || wort2 >= ANZ_FG)
				return(FEHLER_F);
			player->pl_tech_level_pes[wort2] = wort3;
			player->pl_tech_level[wort2] = wort4;
			player->pl_tech_level_newpes[wort2] = wort3;
			player->pl_tech_level_new[wort2] = wort4;
			break;
		}
		zaehler++;
	}
	return zaehler == v_zahl ? OK : FEHLER_F;
}


BYTE get_vlb(PLAYER *player, char *pathname)
{
	FILE *vlb_datei;
    char datei[PATH_MAX];
	BYTE fehler;
	
	sprintf(datei, "%s%s", pathname, EXT_VLB);
	if ((vlb_datei = fopen(datei, "rb")) == NULL)
	{
		return FEHLER_O;
	}
	if (verbose)
		fprintf (stderr, "reading %s ...\n", datei);
	fehler = _get_vlb(player, vlb_datei, datei);
	f_close(vlb_datei);
	return(fehler);
}


/*
 * Befehls-Datei schreiben
 */
static BYTE bef_put(PLAYER *player, FILE * bef_datei)
{
	SCHIFF *schiff;
	WORD zaehler, spieler;
	WORD wert;
	UBYTE ladung, fg, bnd, wft;
	PLANET *planet;

	if (EOF == fprintf(bef_datei, "#BEF %s %u %u\n", gc_global.gc_id,
					   player->pl_number, gc_global.starDate))
		return FEHLER_W;

	/*
	 * Schiffe
	 */
	for (zaehler = 0; zaehler < player->pl_num_ships; zaehler++)
	{
		schiff = player->pl_ships[zaehler];
		if (schiff->s_schrott)
			fprintf(bef_datei, "V %u\n", schiff->s_number);
		if (schiff->s_new_tf_nr != schiff->s_tf_nr)
			fprintf(bef_datei, "Z %u %u\n", schiff->s_number, schiff->s_new_tf_nr);
		if (schiff->s_new_owner)
			fprintf(bef_datei, "U %u %u\n", schiff->s_number, schiff->s_new_owner);

		for (ladung = 0; ladung < ANZ_LADUNG; ladung++)
		{
			wert = schiff->s_new_ladung[ladung] - schiff->s_ladung[ladung];
			if (wert > 0)
			{
				switch (ladung)
				{
				case LAD_MKITS:
				case LAD_RKITS:
				case LAD_LKITS:
				case LAD_FKITS:
				case LAD_KOLONIST:
					planet = find_planet(player, schiff->s_new_pos, NULL);
					if (planet == NULL)
						return(errno);
					/* XXXXXX ??? */
					fprintf(bef_datei, "P %u %u %u\n", planet->p_number, ladung + 1, wert);
					/* planet->kits = 1; */
				}
			}
			fprintf(bef_datei, "L S %u %u %u\n", schiff->s_number, ladung + 1, wert);
			if (wert < 0)
			{
				wert = wert * (-1);
				fprintf(bef_datei, "E S %u %u %u\n", schiff->s_number, ladung + 1, wert);
			}
		}
		if (schiff->s_new_ziel != schiff->s_ziel)
			fprintf(bef_datei, "B S %u %u\n", schiff->s_number, schiff->s_new_ziel);

		if (ferror(bef_datei))
			return(FEHLER_W);
	}
	
	/*
	 * Planeten
	 */
	spieler = player->pl_number;
	for (zaehler = 0; zaehler < gc_global.anz_planeten; zaehler++)
	{
		planet = find_planet(player, zaehler+1, NULL);
		if (planet != NULL && spieler == planet->p_owner)
		{
			/*
			 * Forschung
			 */
			for (fg = 0; fg < ANZ_FG; fg++)
			{
				if (planet->p_forschen[fg])
					fprintf(bef_datei, "F %u %u %u\n",
						planet->p_number,
						planet->p_forschen[fg], fg);
			}
			/*
			 * Produktion
			 */
#if 0
			{
			UBYTE good;
			
			for (good = 0; good < ANZ_GUETER; good++)
			{
				if (planet->p_new_gut[good] != planet->p_gut[good])
					/* kitabfrage */
					fprintf(bef_datei, "P %u %u %u\n",
						planet->p_number, good + 1,
						planet->p_new_gut[good] - planet->p_gut[good]);
			}
			}
#endif
			/*
			 * Kits installieren
			 */
			if (planet->p_inst_mkits)
				fprintf(bef_datei, "N %u %u %u\n",
					planet->p_number, LAD_MKITS+1,
					planet->p_inst_mkits);
			if (planet->p_inst_lkits)
				fprintf(bef_datei, "N %u %u %u\n",
					planet->p_number, LAD_LKITS+1,
					planet->p_inst_lkits);
			if (planet->p_inst_rkits)
				fprintf(bef_datei, "N %u %u %u\n",
					planet->p_number, LAD_RKITS+1,
					planet->p_inst_rkits);
			if (planet->p_inst_fkits)
				fprintf(bef_datei, "N %u %u %u\n",
					planet->p_number, LAD_FKITS+1,
					planet->p_inst_fkits);
			/*
			 * Spionage/Korruption
			 */
			for (bnd = 0; bnd < MAX_GEHEIM; bnd++)
			{
				wert = planet->p_geheim[bnd].m_pe;
				if (wert > 0)
				{
					fprintf(bef_datei, "I %u %u %u\n",
						planet->p_geheim[bnd].m_target,
						wert,
						planet->p_number);
				} else if (wert < 0)
				{
					wert = -wert;
					fprintf(bef_datei, "K %u %u %u\n",
						planet->p_geheim[bnd].m_target,
						wert,
						planet->p_number);
				}
			}
			/*
			 * Werften
			 */
			for (wft = 0; wft < MAX_WERFT; wft++)
			{
				if (planet->p_new_werft[wft].w_typ != planet->p_werft[wft].w_typ)
					fprintf(bef_datei, "W %u %u %u\n",
						planet->p_number,
						wft+1,
						planet->p_new_werft[wft].w_typ);
				if (planet->p_new_werft[wft].w_pe != planet->p_werft[wft].w_pe)
					fprintf(bef_datei, "S %u %u %u\n",
						planet->p_number,
						wft+1,
						planet->p_new_werft[wft].w_pe);
			}
		}
		
		if (ferror(bef_datei))
			return(FEHLER_W);
	}
	
	/*
	 * Kopfgeld
	 */
	if (player->pl_kg_player)
		fprintf(bef_datei, "G %u %u\n",
		   player->pl_kg_pes, player->pl_kg_player);

	fprintf(bef_datei, "#END\n");

	if (ferror(bef_datei) || fflush(bef_datei) == EOF)
		return(FEHLER_W);
	return OK;
}


BYTE put_bef(PLAYER *player, char *pathname)
{
	FILE *bef_datei;
	BYTE result;
	char datei[PATH_MAX];
	
	sprintf(datei, "%s%s", pathname, EXT_BEF);

	if ((bef_datei = fopen(datei, "w")) == NULL)
	{
		return FEHLER_O;
	}
	if (verbose)
		fprintf (stderr, "writing %s ...\n", datei);
	result = bef_put(player, bef_datei);
	f_close(bef_datei);
	return result;
}


/*
 * Aus Spielername laut Anmeldung Dateiname erzeugen
 */
void make_player_filename(char *buf, char *playername)
{
	int len;
	
	len = 0;
	while (*playername && len < 8)
	{
		if (*playername == ' ')
			*buf = '_';
		else
			*buf = tolower(*playername);
		buf++;
		playername++;
		len++;
	}
	*buf = '\0';
}


/*
 * GCB-Datei fuer Spieler im Verzeichnis suchen
 */
WORD suche_spielername(char *namen, char *ext, WORD max_namen)
{
	WORD spieler = 0;
#ifdef __TURBOC__
	WORD nichtda;
	char *gefunden;
	struct ffblk info;
	char pattern[20];
	char ext2[PATH_MAX];
	
	strcpy(ext2, ext);
	strupr(ext2);
	sprintf(pattern, "*%s", ext);
	nichtda = findfirst(pattern, &info, 0);
	while (!nichtda)
	{
		if (spieler < max_namen)
		{
			gefunden = strstr(&info.ff_name[0], ext);
			if (gefunden == NULL)
				gefunden = strstr(&info.ff_name[0], ext2);
			if (gefunden != NULL)
			{
				*gefunden = '\0';
				strncpy(namen + (MAX_NAMELG * spieler), info.ff_name, MAX_NAMELG);
				spieler++;
			}
		}
		nichtda = findnext(&info);
	}
#else	/* defined (unix) */
	DIR *ordner;
	char *gefunden;
	struct direct *info;

	ordner = opendir(".");

	while (((info = readdir(ordner)) != NULL) && (spieler < max_namen))
	{
		gefunden = strstr(&info->d_name[0], ext);
		if (gefunden != NULL)
		{
			*gefunden = '\0';
			strncpy(namen + (MAX_NAMELG * spieler), info->d_name, MAX_NAMELG);
			spieler++;
		}
	}
	closedir(ordner);
#endif	/* __TURBOC__ */
	return spieler;
}


/*
 * Planet suchen
 */
PLANET *find_planet(PLAYER *player, WORD nummer, int *insert)
{
	PLANET *planet;
	
	if (nummer <= 0 || nummer > gc_global.anz_planeten || player->pl_planets == NULL)
	{
		errno = FEHLER_F;
		return(NULL);
	}
	planet = player->pl_planets[nummer - 1];
	if (planet == NULL)
	{
		if (insert != NULL)
		{
			planet = (PLANET *)CALLOC(1, sizeof(PLANET), "find_planet");
			player->pl_planets[nummer - 1] = planet;
			if (planet)
			{
				planet->p_number = nummer;
				player->pl_known_planets++;
				*insert = TRUE;
			} else {
				errno = FEHLER_M;
			}
		}
	} else {
		if (insert != NULL)
			*insert = FALSE;
	}
	return(planet);
}


SCHIFF *find_ship(PLAYER *player, WORD number, int insert)
{
	SCHIFF **ships, *ship;
	WORD i;
	
	UNUSED(insert);
	ships = player->pl_ships;
	for (i = 0; i < player->pl_num_ships; i++)
	{
		ship = ships[i];
		if (number == ship->s_number)
			return(ship);
	}
	return(NULL);
}


/*
 * FLN-Datei schreiben
 */
static BYTE _put_fln(PLAYER *player, FILE *fln_datei)
{
	SCHIFF *ship;
	SCHIFF **schiff;
	int i;
	
	schiff = player->pl_ships;
	for (i = 0; i < player->pl_num_ships; i++)
	{
		ship = schiff[i];
		
		fprintf(fln_datei, "%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d\n",
			ship->s_number,
			ship->s_kills,
			ship->s_pos,
			ship->s_ziel,
			ship->s_typ,
			ship->s_atl,
			ship->s_vtl,
			ship->s_reichw,
			ship->s_moved,
			ship->s_distance,
			ship->s_tf_nr,
			ship->s_cur_def,
			ship->s_cur_transp,
			ship->s_ladung[LAD_SPARES],
			ship->s_ladung[LAD_MPE],
			ship->s_ladung[LAD_LPE],
			ship->s_ladung[LAD_RPE],
			ship->s_ladung[LAD_MKITS],
			ship->s_ladung[LAD_LKITS],
			ship->s_ladung[LAD_RKITS],
			ship->s_ladung[LAD_FKITS],
			ship->s_ladung[LAD_KOLONIST]);
		if (ferror(fln_datei))
			return(FEHLER_W);
	}
	return OK;
}


BYTE put_fln(PLAYER *player, char *pathname)
{
	FILE *fln_datei;
	BYTE fehler;
	char datei[PATH_MAX];
	
	sprintf(datei, "%s%s", pathname, EXT_FLN);

	if ((fln_datei = fopen(datei, "w")) == NULL)
	{
		return FEHLER_C;
	}
	if (verbose)
		fprintf (stderr, "writing %s ...\n", datei);
	fehler = _put_fln(player, fln_datei);
	f_close(fln_datei);
	return(fehler);
}


/*
 * Planeten in Liste fuer Spieler suchen
 */
PlanetList *findPlanet(PLAYER *aWorld, WORD planet, int *insert)
{
	PlanetList *list;

	list = aWorld->pl_planetlist;
	while ((list != NULL) && (planet != list->l_number))
		list = list->l_next;
	if (list == NULL)
	{
		if (insert != NULL)
		{
			list = (PlanetList *)CALLOC(1, sizeof(PlanetList), "findPlanet");
			if (list)
			{
				list->l_owner = aWorld->pl_number;
				list->l_number = planet;
				list->l_koordinate.x = 0;
				list->l_koordinate.y = 0;
				list->l_number = planet;
				list->l_planet = find_planet(aWorld, planet, insert);
				if (list->l_planet == NULL)
					return(NULL);
				list->l_status = planet_status(aWorld, list->l_planet);
				if (list->l_status == STATUS_OWN)
					list->l_planetrange = regel.radius[aWorld->pl_tech_level[FG_SPY]];
				else
					list->l_planetrange = 0;
				list->l_natdef = list->l_planet->p_nat_def;
				list->l_festungen = list->l_planet->p_festungen;
				list->l_visited = list->l_planet->p_visited;
				list->l_next = aWorld->pl_planetlist;
				aWorld->pl_planetlist = list;
				*insert = TRUE;
			} else {
				errno = FEHLER_M;
			}
		}
	} else {
		if (insert != NULL)
			*insert = FALSE;
	}
	return list;
}


/*
 * MAP-Datei lesen
 */
static BYTE _get_map(FILE *map_datei, PLAYER *player,
	int *found, int *new_found,
	int check_version, char *filename)
{
	char r_buf[2048];
	int stardate;
	int mapsize;
	int number, x, y, status;
	PlanetList *planet;
	int insert;
	
	*found = 0;
	*new_found = 0;
	if (fgets(r_buf, (int)sizeof(r_buf), map_datei) == NULL)
		return(FEHLER_R);
	if (sscanf(r_buf, "%d", &stardate) != 1)
		return(FEHLER_F);
	if (stardate != gc_global.starDate)
	{
		if (check_version)
			return(FEHLER_V);
		if (!quiet)
			fprintf(stderr, "warning: %s out of date (%d)\n", filename, stardate);
	}
	if (fgets(r_buf, (int)sizeof(r_buf), map_datei) == NULL)
		return(FEHLER_R);
	if (sscanf(r_buf, "%d", &mapsize) != 1)
		return(FEHLER_F);
	if (mapsize != gc_global.maxMapSize)
		return(FEHLER_V);
	
	while (fgets(r_buf, (int)sizeof(r_buf), map_datei) != NULL)
	{
		if (sscanf(r_buf, "%d %d %d %d", &number, &x, &y, &status) != 4)
			return(FEHLER_F);
		(*found)++;
		planet = findPlanet(player, number, &insert);
		if (planet == NULL)
			return(errno);
		if (insert)
			(*new_found)++;
		planet->l_koordinate.x = x;
		planet->l_koordinate.y = y;
		planet->l_status = status;
		if (planet->l_status == STATUS_OWN)
			planet->l_planetrange = regel.radius[player->pl_tech_level[FG_SPY]];
		else
			planet->l_planetrange = 0;
	}
	return(OK);
}


BYTE get_map(PLAYER *player, char *pathname, int check_version)
{
	FILE *map_datei;
	char datei[PATH_MAX];
	BYTE fehler;
	int found, new_found;
	
	/* MAP Datei einlesen */
	sprintf(datei, "%s%s", pathname, EXT_MAP);
	if ((map_datei = fopen(datei, "r")) == NULL)
	{
		return FEHLER_O;
	}

	if (verbose)
		fprintf(stderr, "reading %s ... ", datei);
	fehler = _get_map(map_datei, player, &found, &new_found, check_version, datei);
	if (verbose)
		fprintf(stderr, "found %d planets\n", found);
	f_close(map_datei);
	return(fehler);
}


/*
 * MAP-Datei schreiben
 */
static BYTE _put_map(PLAYER *player, FILE *map_datei)
{
	PLANET **planets;
	PLANET *planet;
	int i, status;
	
	planets = player->pl_planets;
	fprintf(map_datei, "%d\n", gc_global.starDate);
	fprintf(map_datei, "%d\n", gc_global.maxMapSize);
	for (i = 0; i < gc_global.anz_planeten; i++)
	{
		planet = planets[i];
		
		if (planet && position_known(planet))
		{
			status = planet_status(player, planet);
			fprintf(map_datei, "%d %d %d %d\n",
				planet->p_number,
				planet->p_pos_x,
				planet->p_pos_y,
				status);
		}
		if (ferror(map_datei))
			return(FEHLER_W);
	}
	return OK;
}


BYTE put_map(PLAYER *player, char *pathname)
{
	FILE *map_datei;
	BYTE fehler;
	char datei[PATH_MAX];
	
	sprintf(datei, "%s%s", pathname, EXT_MAP);

	if ((map_datei = fopen(datei, "w")) == NULL)
	{
		return FEHLER_C;
	}
	if (verbose)
		fprintf (stderr, "writing %s ...\n", datei);
	fehler = _put_map(player, map_datei);
	f_close(map_datei);
	return(fehler);
}


/*
 * FLB-Datei schreiben
 */
static BYTE _put_flb(PLAYER *player, FILE *flb_datei)
{
	SCHIFF *ship;
	SCHIFF **schiff;
	int i;
	
	schiff = player->pl_ships;
	for (i = 0; i < player->pl_num_ships; i++)
	{
		ship = schiff[i];
		fputword(flb_datei, ship->s_number);
		fputword(flb_datei, ship->s_kills);
		fputword(flb_datei, ship->s_pos);
		fputword(flb_datei, ship->s_ziel);
		fputbyte(flb_datei, ship->s_typ);
		fputbyte(flb_datei, ship->s_atl);
		fputbyte(flb_datei, ship->s_vtl);
		fputbyte(flb_datei, ship->s_reichw);
		fputbyte(flb_datei, ship->s_moved);
		fputbyte(flb_datei, ship->s_distance);
		fputbyte(flb_datei, ship->s_tf_nr);
		fputbyte(flb_datei, ship->s_cur_def);
		fputbyte(flb_datei, ship->s_cur_transp);
		fputbyte(flb_datei, ship->s_ladung[LAD_SPARES]);
		fputbyte(flb_datei, ship->s_ladung[LAD_MPE]);
		fputbyte(flb_datei, ship->s_ladung[LAD_LPE]);
		fputbyte(flb_datei, ship->s_ladung[LAD_RPE]);
		fputbyte(flb_datei, ship->s_ladung[LAD_MKITS]);
		fputbyte(flb_datei, ship->s_ladung[LAD_LKITS]);
		fputbyte(flb_datei, ship->s_ladung[LAD_RKITS]);
		fputbyte(flb_datei, ship->s_ladung[LAD_FKITS]);
		fputbyte(flb_datei, ship->s_ladung[LAD_KOLONIST]);
		if (ferror(flb_datei))
			return(FEHLER_W);
	}
	return OK;
}


BYTE put_flb(PLAYER *player, char *pathname)
{
	FILE *flb_datei;
	BYTE fehler;
	char datei[PATH_MAX];
	
	sprintf(datei, "%s%s", pathname, EXT_FLB);

	if ((flb_datei = fopen(datei, "wb")) == NULL)
	{
		return FEHLER_O;
	}
	if (verbose)
		fprintf (stderr, "writing %s ...\n", datei);
	fehler = _put_flb(player, flb_datei);
	f_close(flb_datei);
	return(fehler);
}


/*
 * VLB -> VLN
 */
static BYTE _vlb_to_vln(PLAYER *player, FILE *vlb_datei, FILE *vln_datei)
{
	long platz;
	int v_zahl, zaehler=0;
	WORD nachricht, wort2, wort3, wort4;
    PLANET *planet;
    int new_planet;
    WORD platzierung = 0;
    
	/* Die Zahl der Nachrichten berechen fuer die Schleife */
    platz = datei_laenge(vlb_datei);
    v_zahl =(UWORD) (platz / VLB_ST_GR) ;

	while (((nachricht=fgetword(vlb_datei))!=EOF) && (zaehler<v_zahl))
	{
		/* Das 2. Wort auch einlesen */
		if ((wort2 = fgetword(vlb_datei)) == EOF ||
			(wort3 = fgetword(vlb_datei)) == EOF ||
			(wort4 = fgetword(vlb_datei)) == EOF)
		{
			return ferror(vlb_datei) ? FEHLER_R : FEHLER_F;
		}
		switch(nachricht)
		{
		case 0:
			fprintf(vln_datei, "0   %4d %4d %4d  Sternzeit = %d\n", wort2, wort3, wort4, wort2);
			break;

		case 1:
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return errno;
			fprintf(vln_datei, "1   %4d %4d %4d  Festungen auf Planet %d = %d\n", wort2, wort3, wort4, wort2, wort3);
			break;
		
		case 2:	/* Bonus */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return errno;
			fprintf(vln_datei, "2   %4d %4d %4d  Bonus fuer Planet %d = %d\n", wort2, wort3, wort4, wort2, wort3);
			break;
		
		case 3:
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return errno;
			fprintf(vln_datei, "3   %4d %4d %4d  Besitzer fuer Planet %d = %d (%s)\n", wort2, wort3, wort4, wort2, wort3, spieler_name(wort3));
			break;

		case 4:
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return errno;
			fprintf(vln_datei, "4   %4d %4d %4d  Position Planet %d = %d,%d\n", wort2, wort3, wort4, wort2, wort3, wort4);
			break;

		case 5:		/* Eigenes Schiff zerstoert */
			if (wort3 < 1 || wort3 > gc_global.anz_stypen)
				return(FEHLER_F);
			if (wort4 < 1 || wort4 > gc_global.anz_planeten)
				return(FEHLER_F);
			fprintf(vln_datei, "5   %4d %4d %4d  Schiff %d (Typ %d) bei Planet %d zerstoert\n", wort2, wort3, wort4, wort2, wort3, wort4);
			break;
		
		case 6:		/* Feindliches Schiff zerstoert */
			if (wort2 < 1 || wort2 > gc_global.anz_stypen)
				return(FEHLER_F);
			if (wort3 < 1 || wort3 > gc_global.anz_planeten)
				return(FEHLER_F);
			fprintf(vln_datei, "6   %4d %4d %4d  Feindliches Schiff vom Typ %d bei Planet %d zerstoert\n", wort2, wort3, wort4, wort2, wort3);
			break;
		
		case 7:		/* Angriff auf Planet */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			if (wort3 < 1 || wort3 > gc_global.anz_spieler)
				return(FEHLER_F);
			planet = find_planet(player, wort2, FALSE);
			fprintf(vln_datei, "7   %4d %4d %4d  Angriff auf Planet %d durch %d Schiffer von %s\n", wort2, wort3, wort4, wort2, wort4, spieler_name(wort3));
			break;
		
		case 50:	/* Eigene Platzierung */
			fprintf(vln_datei, "50  %4d %4d %4d  Platz: %d.  Score: %d  Zuwachs: %d\n", wort2, wort3, wort4, wort2, wort3, wort4);
			break;
		
		case 51:	/* Info ueber Top 5 */
			{
				if (wort2 < 1 || wort2 > gc_global.anz_spieler)
					return(FEHLER_F);
				platzierung++;
				fprintf(vln_datei, "51  %4d %4d %4d  Top 5:  %d. %-*s  %d %d\n",
					wort2, wort3, wort4, platzierung, MAX_NAMELG, spieler_name(wort2), wort3, wort4);
			}
			break;
		
		case 52:	/* Anonyme Scoreliste */
			fprintf(vln_datei, "52  %4d %4d %4d  Anonyme Scoreliste: %2d. %u\n", wort2, wort3, wort4, wort2, wort3);
			break;
			
		case 101:
			if (wort2 < 0 || wort2 >= ANZ_FG)
				return(FEHLER_F);
			fprintf(vln_datei, "101 %4d %4d %4d  Techlevel %d = %d, %d PEs\n", wort2, wort3, wort4, wort2, wort4, wort3);
			break;
		
		default:
			fprintf(vln_datei, "%d %4d %4d %4d  (unbekannte Nachricht)\n", nachricht, wort2, wort3, wort4);
			break;
		}
		if (ferror(vln_datei))
			return(FEHLER_W);
		zaehler++;
	}
	return zaehler == v_zahl ? OK : FEHLER_F;
}


BYTE vlb_to_vln(PLAYER *player, char *pathname)
{
	FILE *vlb_datei;
	FILE *vln_datei;
    char datei[PATH_MAX];
	BYTE fehler;
	
	sprintf(datei, "%s%s", pathname, EXT_VLB);
	if ((vlb_datei = fopen(datei, "rb")) == NULL)
	{
		return FEHLER_O;
	}
	sprintf(datei, "%s%s", pathname, EXT_VLN);
	if ((vln_datei = fopen(datei, "w")) == NULL)
	{
		f_close(vlb_datei);
		return FEHLER_C;
	}
	
	fehler = _vlb_to_vln(player, vlb_datei, vln_datei);
	f_close(vlb_datei);
	f_close(vln_datei);
	return(fehler);
}



/*
 * VLN -> VLB
 */
static BYTE _vln_to_vlb (PLAYER *player, FILE *vln_datei, FILE *vlb_datei)
{
	int nachricht, wort2, wort3, wort4;
	char r_buf[2048];
	
	UNUSED(player);
	while (fgets(r_buf, (int) sizeof(r_buf), vln_datei) != NULL)
	{
		if (sscanf(r_buf, "%d %d %d %d", &nachricht, &wort2, &wort3, &wort4) != 4)
			return(FEHLER_F);
		fputword(vlb_datei, nachricht);
		fputword(vlb_datei, wort2);
		fputword(vlb_datei, wort3);
		fputword(vlb_datei, wort4);
	}
	if (ferror(vlb_datei) || fflush(vlb_datei) == EOF)
		return(FEHLER_W);
	return OK;
}


BYTE vln_to_vlb(PLAYER *player, char *pathname)
{
	FILE *vlb_datei;
	FILE *vln_datei;
    char datei[PATH_MAX];
	BYTE fehler;
	
	sprintf(datei, "%s%s", pathname, EXT_VLN);
	if ((vln_datei = fopen(datei, "r")) == NULL)
	{
		return FEHLER_O;
	}
	sprintf(datei, "%s%s", pathname, EXT_VLB);
	if ((vlb_datei = fopen(datei, "wb")) == NULL)
	{
		f_close(vln_datei);
		return FEHLER_C;
	}
	
	fehler = _vln_to_vlb(player, vln_datei, vlb_datei);
	f_close(vln_datei);
	f_close(vlb_datei);
	return(fehler);
}


/*
 * BAS-Datei schreiben
 */
static BYTE _put_bas(PLAYER *player, FILE *datei)
{
	WORD ende, zaehler;
	UBYTE wz;
	PLANET *planet, **planets;
	PLANET no_planet;
	
	ende = gc_global.anz_planeten;
	memset(&no_planet, 0, sizeof(no_planet));
	
	planets = player->pl_planets;
	for (zaehler = 0; zaehler < ende; zaehler++)
	{
		planet = planets[zaehler];
		if (planet == NULL)
			planet = &no_planet;
		fput_planet(datei, planet);
		if (ferror(datei))
			return(FEHLER_W);
	}
	return OK;
}


BYTE put_bas(PLAYER *player, char *pathname)
{
	FILE *planeten_datei;
	BYTE ok;
	char datei[PATH_MAX];
	
	sprintf(datei, "%s%s", pathname, EXT_BAS);

	if ((planeten_datei = fopen(datei, "wb")) == NULL)
		return FEHLER_C;

	if (verbose)
		fprintf (stderr, "writing %s ...\n", datei);
	ok = _put_bas(player, planeten_datei);

	f_close(planeten_datei);
	if (ok == OK)
		player->pl_bas_file_changed = FALSE;
	return ok;
}


void f_close(FILE *datei)
{
#ifdef __PUREC__
	fflush(datei);
	if (ferror(datei))
	{
		fclose(datei);
		/* workaround a library bug */
		if (datei->Flags & 3)
		{
			close(datei->Handle);
			if (datei->Flags & 0x08)
				free(datei->BufStart);
			datei->Flags = 0;
		}
	} else
#endif
	fclose(datei);
}


/*
 * Alle Daten fr Spieler freigeben
 */
void delete_player(PLAYER *player)
{
	if (player != NULL)
	{
		/*
		 * Planeten
		 */
		if (player->pl_planets != NULL)
		{
			WORD i;
			
			for (i = 0; i < gc_global.anz_planeten; i++)
			{
				if (player->pl_planets[i] != NULL)
					OFREE(player->pl_planets[i]);
			}
			FREE(player->pl_planets, gc_global.anz_planeten * sizeof(PLANET *));
			player->pl_planets = NULL;
		}
		/*
		 * Planeten-Liste
		 */
		{
			PlanetList *list, *next;
			
			for (list = player->pl_planetlist; list != NULL; list = next)
			{
				next = list->l_next;
				OFREE(list);
			}
			player->pl_planetlist = NULL;
		}
		/*
		 * Schiffe
		 */
		{
			WORD i;
			
			for (i = 0; i < player->pl_num_ships; i++)
				OFREE(player->pl_ships[i]);
		}
		/*
		 * Grenzen
		 */
		{
			LIMES *list, *next;
			
			for (list = player->pl_limes; list != NULL; list = next)
			{
				next = list->l_next;
				OFREE(list);
			}
			player->pl_limes = NULL;
		}
	}
}
