#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "gcio.h"

#ifndef FALSE
#  define FALSE 0
#  define TRUE (!FALSE)
#endif

int verbose = TRUE;


static int read_nas_or_bas(PLAYER *me, char *path)
{
	switch (get_nas(me, path, NULL))
	{
	case FEHLER_R:
	case FEHLER_F:
		fprintf(stderr, "error reading %s%s\n", path, EXT_NAS);
		return(FALSE);
	case FEHLER_O:
		switch (get_bas(me, path, NULL))
		{
		case FEHLER_R:
			fprintf(stderr, "error reading %s%s\n", path, EXT_BAS);
			return(FALSE);
		case FEHLER_O:
			/*
			 * keine BAS-Datei ist ok beim ersten Zug
			 */
			break;
		case FEHLER_M:
			fprintf(stderr, "not enough memory\n");
			return(FALSE);
		case OK:
			break;
		default:
			fprintf(stderr, "format error in %s%s\n", path, EXT_BAS);
			return(FALSE);
		}
		break;
	case FEHLER_M:
		fprintf(stderr, "not enough memory\n");
		return(FALSE);
	case OK:
		break;
	default:
		fprintf(stderr, "format error in %s%s\n", path, EXT_NAS);
		return(FALSE);
	}
	return(TRUE);
}



int main(int argc, char **argv)
{
	char *argp;
	char *p;
	PLAYER *me;
	int ok;
	
	while (--argc)
	{
		if (*(argp = *++argv) == '-')
		{
			switch (*++argp)
			{
			case 'v':
				verbose = TRUE;
				break;
			}
		} else {
			p = strrchr(argp, '\\');
			if (p == NULL)
				p = strrchr(argp, '/');
			if (p == NULL)
				p = argp;
			else
				++p;
			if ((p = strchr(p, '.')) != NULL)
				*p = '\0';
			ok = FALSE;
			switch (get_gcb(argp, &gc_global))
			{
			case OK:
				me = get_player(gc_global.sp_nummer);
				if (read_nas_or_bas(me, argp) == FALSE)
					exit(1);
				switch (vlb_to_vln(me, argp))
				{
				case OK:
					ok = TRUE;
					break;
				case FEHLER_O:
					fprintf(stderr, "can't open %s%s\n", argp, EXT_VLB);
					break;
				case FEHLER_R:
					fprintf(stderr, "error reading %s%s\n", argp, EXT_VLB);
					break;
				case FEHLER_F:
					fprintf(stderr, "format error in %s%s\n", argp, EXT_VLB);
					break;
				case FEHLER_C:
					fprintf(stderr, "can't create %s%s\n", argp, EXT_VLN);
					break;
				case FEHLER_W:
					fprintf(stderr, "error writing %s%s\n", argp, EXT_VLN);
					break;
				case FEHLER_M:
					fprintf(stderr, "not enough memory\n");
					break;
				}
				break;
			case FEHLER_V:
				fprintf(stderr, "version mismatch in %s%s\n", argp, EXT_GCB);
				break;
			case FEHLER_O:
				fprintf(stderr, "can't open %s%s\n", argp, EXT_GCB);
				break;
			case FEHLER_F:
				fprintf(stderr, "format error in %s%s\n", argp, EXT_GCB);
				break;
			case FEHLER_M:
				fprintf(stderr, "not enough memory\n");
				break;
			}
			if (ok == FALSE)
				exit(1);
		}
	}
	return(0);
}
