#       enread - read RIPE database entry
#
#	$RCSfile: enread.pl,v $
#	$Revision: 0.17 $
#	$Author: marten $
#	$Date: 1994/09/20 12:12:04 $
#
#       This routine reads RIPE database entries and returns them in 
#	internal representation.
#
#       file       file to read from


sub enread {

    local($file, $offs) = @_;
    local($inentry) = 0;
    local($tag, %entry);
    %entry = ();

    if (defined($offs)) {
	seek($file, $offs, 0);
    }

    while (<$file>) {

	if (/^#/) {
	    next;
	}
	if (/^\s*$/) {
	    if ($inentry) {
		$CUROBJTYPE = &entype(*entry);
		return %entry;
	    }
	    if (!$inentry) {
		next;
	    }
	}

	$inentry = 1 if !$inentry;

	if (!defined($entry{"offset"})) {
	    $entry{"offset"} = tell(db) - length($_);
	}

	s/\s*$//;
	s/\n*$//;

	if (/^\*..:\s*/) {
	    $tag = substr($_, 1, 2);
	    if ($entry{$tag}) {
		$entry{$tag} .= "\n";
	    }
	    $entry{$tag} = $entry{$tag} . substr($_, 5);
	}
	elsif (/([a-z-]+):\s*(.*)/) {
	    $tag = $1;
	    $tag = $ATTR{$1} if ($ATTR{$1});
	    if ($entry{$tag}) {
		$entry{$tag} = $entry{$tag} . "\n" . $2;
	    } else {
		$entry{$tag} = $2;
	    }
	}
    }
    $CUROBJTYPE = &entype(*entry);
    return %entry;
}

1; 	# PC version of perl seems to require this for require()
