
#       addkey - add, delete keys & get values with known keys
#
#	$RCSfile: addkey.pl,v $
#	$Revision: 2.0 $
#	$Author: ripe-dbm $
#	$Date: 1996/08/08 10:45:01 $


sub getvalues {
    local(*db, $key) = @_;

    local($value)=$db{$key};
    
    if ($value=~ s/^$OVERFLOWPREFIXREGULAR//o) {
       
       if (open(OVERFLOWGET, "<".$db[1].$OVERFLOWEXTENSION.$value)) {
          
          $value=<OVERFLOWGET>;
          close(OVERFLOWGET);
          
       }
       else {
          &fatalerror("in getvalues: cannot open for getting values $db[1]$OVERFLOWEXTENSION$value key: $key value: $offsets code: $!");
       }
   
    }
    
    return $value;
    
}


#
# addkey
#
# return 1 (for classless indexing) if the key didn't already existed, else 0

sub addkey {
    local(*db, $key, $offsets)=@_;

    local($value)=$db{$key};
    
#    print STDERR "key: $key offset: $offsets oldvalue: -$value-\n";
    
    local($length)=length($offsets)+length($key)+length($value)+4;
    
    return 1 if ((!$value) && ($length<$OVERFLOWSIZE) && ($db{$key}=$offsets));
    
    if ($value=~ s/^$OVERFLOWPREFIXREGULAR//o) {
       
       if (open(OVERFLOWADD, ">>".$db[1].$OVERFLOWEXTENSION.$value)) {
          
          print OVERFLOWADD "\,", $offsets;
          close(OVERFLOWADD);
          
          return 0;
          
       }
       else {
          &fatalerror("in addkey: cannot open for addition $db[1]$OVERFLOWEXTENSION$value key: $key value: $offsets code: $!");
       }
   
    }
    
    return 0 if ($length<$OVERFLOWSIZE) && ($db{$key}=join("\,", $value, $offsets));
    
    # print STDERR $db{$OVERFLOWKEY}, "-", $value, "-", $offsets, "-",(length($value)+length($offsets)), "<$OVERFLOWSIZE\n";
    
    local($filenumber)=++$db{$OVERFLOWKEY};
    if (open(OVERFLOWADD, ">".$db[1].$OVERFLOWEXTENSION.$filenumber)) {
       
       if ($value) {
          
          print OVERFLOWADD $value, "\,", $offsets;
          close(OVERFLOWADD);

          $db{$key}=$OVERFLOWPREFIX.$filenumber;
       
          return 0;
          
          
       }
       else {
          print OVERFLOWADD $offsets;
          close(OVERFLOWADD);

          $db{$key}=$OVERFLOWPREFIX.$filenumber;
       
          return 1;
          
       }
       
    }
    else {
       &fatalerror("in addkey: cannot open new $db[1]$OVERFLOWEXTENSION$filenumber code: $!");
    }
    
    &fatalerror("in addkey: could not add $key with value $offsets");   
    
}

sub delkey {
    local(*db, $key, $offsets)=@_;

    local($value)=$db{$key};
    
    local(@values);
    local(%mark)=();

    grep($mark{$_}++, split(/\,/, $offsets));

    if ($value=~ s/^$OVERFLOWPREFIXREGULAR//o) {
       
       if (open(OVERFLOWDEL, "+<".$db[1].$OVERFLOWEXTENSION.$value)) {
          
          if ((@values=grep(!$mark{$_}, split(/\,/, <OVERFLOWDEL>)))) {
             
             seek(OVERFLOWDEL, 0, 0);
             print OVERFLOWDEL join("\,", @values);
             close(OVERFLOWDEL);
    
          }
          else {
             
             delete $db{$key};
             close(OVERFLOWDEL);
             unlink($db[1].$OVERFLOWEXTENSION.$value);
          
          }
          
          return;
          
       }
       else {
          &fatalerror("in delkey: cannot open for deletion $db[1]$OVERFLOWEXTENSION$value key: $key value: $offsets code: $!");
       }
   
    }   
       
    if ((@values=grep(!$mark{$_}, split(/\,/, $value)))) {
       $db{$key}=join("\,", @values);
    }
    else {
       delete($db{$key});
    }
       
    return;
       
}

1;
