#       dblock - lock and unlock of db for writing
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997, 1998, 1999 by RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: dblock.pl,v 2.2 1998/07/15 18:01:25 joao Exp $
#
#	$RCSfile: dblock.pl,v $
#	$Revision: 2.2 $
#	$Author: joao $
#	$Date: 1998/07/15 18:01:25 $
#
#	!!! LOCK BOTH TEXT FILE AND DBM FILE !!!
#
#	!!! NOTE: LOCKING DOES NOT WORK ON NFS FILESYSTEMS !!!

require "defines.pl";

sub dblock {
    local(*db) = @_;

    flock($db, $LOCK_EX);
}

sub dbunlock {
    local(*db) = @_;

    flock($db, $LOCK_UN);
}

1;
