#       enukey - extract unique key
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997, 1998, 1999 by RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: enukey.pl,v 2.2 1998/07/15 18:01:30 joao Exp $
#
#	$RCSfile: enukey.pl,v $
#	$Revision: 2.2 $
#	$Author: joao $
#	$Date: 1998/07/15 18:01:30 $
#

require "defines.pl";
require "entype.pl";

sub uniquekey2entry {
    local($key)=@_;
    
    local(%entry)=();
    local(@keys)=split(/$UNIQUEKEYBINDING/o, $key);
    local($type)=shift(@keys);
    
    foreach (split(/ /,$UNIQ{$type})) {
       $entry{$_}=shift(@keys);
    }
    
    return ($type, %entry);

}

sub enukey {
    local(*entry, $type)=@_;

    # print STDERR %entry, $type, "fdfd\n";;

    local(@keys)=();
    
    local($entryvalue);
    
    foreach (split(/ /,$UNIQ{$type})) {
	
       ($entryvalue=$entry{$_}) =~ tr/A-Z/a-z/;

       #
       # remove non-necessary spaces
       #
       # and (trickey)
       #
       # commas and % signs since they are also used as
       # separators between prefixes & offsets
       
       $entryvalue=~ s/[ \,\%]+/ /g;
	
       push(@keys, $entryvalue) if ($entryvalue);
	
    }
    
    return join($UNIQUEKEYBINDING, $type, @keys);
    
}

1;
