#include <stdio.h>
#include "where.h"

/*
 * Process a message containing a feed update, mail or uux.  Default is
 * to assume a feeding dir, with dirs for each feed site.   Mails to
 * "usenet" if an invalid password is provided.
 *
 * This program is meant to be setuid to the owner of the feed control
 * files and directory.  The sitepasswd file may well be readable only
 * by this user, and it must be able to create the new_feed files in
 * the control directories for the various sites.
 */

#ifndef FEED_DIR
# define FEED_DIR "/usr/lib/news/feed"	/* directory for feed info */
#endif

/* If you don't have strtok use stringlib.c */
extern char *strtok();

#define SITEFILE "sitepasswd"		/* site info file in that dir*/

/* Define "CRYPT" if you have the crypt(3) system call, which is sadly
   deleted from some Unix systems due to the asinine polices of the
   U.S. government. */

#ifdef CRYPT
extern char *crypt();
#endif

main()
{
	char linebuf[200];		/* line buffer for input */
	char siteline[200];		/* line buffer for site */
	char *site, *pass;		/* site name and password */
	extern char *strtok();
	FILE *sfile;			/* site file */
	char *fsite, *fpass, *ffile;	/* fields from site file */
	char *cpass;			/* encrypted password */
	FILE *outfile;			/* output control file */
	int c;				/* to copy over data */


	pass = site = NULL;
	while( fgets( linebuf, sizeof(linebuf), stdin ) ) {
		/* process and parse subject line */
		if( strncmp( linebuf, "Feed:", 5 ) == 0 ) {
			site = strtok( linebuf+5, ":\n" );
			pass = strtok( NULL, ":\n" );
			break;
			}
			/* fourth arg will be this site's name */
		}
	/* Check that we got a valid feed line */

	if( !site || !pass ) {
		/* no valid password feed control line */
		error( "No valid feed control line\n" );
		}

	if( chdir( FEED_DIR ) )
		error( "Could not chdir to feed directory\n" );
	sfile = fopen( SITEFILE, "r" );

	/* Open the site file and look for this site */
	if( !sfile ) {
		error( "Could not open site file.\n" );
		}

	while( fgets( siteline, sizeof(siteline), sfile ) ) {
		if( siteline[0] == '#' )
			continue;
		fsite = strtok( siteline, ":\n" );
		fpass = strtok( NULL, ":\n" );
		ffile = strtok( NULL, ":\n" );

		if( fsite && strcmp( fsite, site ) == 0 )
			goto gotsite;
		}
	error( "Unknown site %s\n", site );

   gotsite:
	/* encrypt the transmitted password -- fixed salt -- after all this
	   is not exactly a high security thing here. Don't use dictionary
	   passwords.*/
#ifdef CRYPT
	cpass = crypt( pass, "ab" );
#else
	cpass = pass;
#endif
	if( strcmp( cpass, fpass ) != 0 ) {
		FILE *popmail;
		/* an invalid password is a serious thing.  You want to
		   know about it.  Since the password is almost always
		   provided by a program on the other end, an invalid
		   password is a sign of something ungood or a breakin
		   attempt, not usually human error */
		popmail = popen( "mail usenet", "w" );
		if( popmail ) {
			fprintf( popmail, "Invalid feed password attempt.\n" );
			fprintf( popmail, "Site %s, bad word %s, data follows.\n", site, pass  );

			while( ( c = getchar() ) != EOF )
				putc( c, popmail );
			pclose( popmail );
			}
		error( "Invalid password\n" );
		}

	/*ok, we're here, we got the password, we are happy */

	/* We copy the rest to the "new_feed" file.  The transmission
	   program will process this into the .newsrc.  To avoid locking
	   problems, we write to a temp file, and then mv that file onto
	   new_feed when done. */

	if( ffile )
		outfile = fopen( ffile, "w" );
	 else {
		if( chdir( site ) )
			error( "Could not chdir to site directory\n" );
		outfile = fopen( "T_new_feed", "w" );
		}
	if( !outfile )
		error( "Could not write to new feed file.\n" );

	/* copy the rest over */
	while( ( c = getchar() ) != EOF )
		putc( c, outfile );
	close( ffile );
	/* Now quickly put the new feed file in place */
	if( link( "T_new_feed", "new_feed" ) || unlink( "T_new_feed" ) ) 
		error( "Unable to link new_feed file into place.\n" );
	exit( 0 );
}

error( form, a, b, c, d, e, f, g, h )
char *form;
{
	fprintf( stderr, form, a,b,c,d,e,f,g,h );
	exit(1);
}
