
#include <stdio.h>
/* String library for people missing the handy SYSV string tools */

/* strpbrk, like strchr, but searches for any one of a set of chars */

char *
strpbrk( str, lchars )
char *str;		/* string to search in */
char *lchars;
{
	register char *p;

	for( p = str; *p; p++ )
		if( strchr( lchars, *p ) )
			return p;
	return (char *)0;
}

/* strtok - string parsing routine */

static char *tokstring;

char *
strtok( string, delims )
char *string;		/* string to parse, or null to continue old string */
char *delims;		/* delimiters to parse on */
{
	register char *p, *del;		/* scanning pointer */
	char *start;

	p = string ? string : tokstring;

	/* skip over initial delimiters */
	while( *p ) {
		for( del = delims; *del; del++ )
			if( *del == *p )
				goto nextc;
		break;		/* not a delim */
		nextc: p++;
		}
			
	if( !*p )
		return NULL;

	start = p;

	/* go to next delimiter */
	while( *p ) {
		for( del = delims; *del; del++ )
			if( *del == *p )
				goto tok_done;
		p++;
		}
	tok_done:
	/* store 0 on top of delimiter */
	if( *p )
		*p++ = 0;
	/* save in static for next call */
	tokstring = p;

	return start;
}

/*
 * The following is provided for those people who do not have strcspn() in
 * their C libraries.  They should get off their butts and do something
 * about it; at least one public-domain implementation of those (highly
 * useful) string routines has been published on Usenet.
 */
/*
 * strcspn - find length of initial segment of s1 consisting entirely
 * of characters not from s2  (Henry Spencer)
 */

int
strcspn(s1, s2)
char *s1;
char *s2;
{
	register char *scan1;
	register char *scan2;
	register int count;

	count = 0;
	for (scan1 = s1; *scan1 != '\0'; scan1++) {
		for (scan2 = s2; *scan2 != '\0';)	/* ++ moved down. */
			if (*scan1 == *scan2++)
				return(count);
		count++;
	}
	return(count);
}

/* The ANSI C memset routine -- not very efficient! */

memset( s, c, n )
register char *s;
register int c;
register int n;
{
	while( n-- >= 0 )
		*s++ = c;
}
