
/* Copyright 1989 Looking Glass Software Limited.  All Rights Reserved. */


typedef struct node {
	byte	ntype;			/* type of node */
	byte	nflags;			/* flags on the node */
	struct node *parent;		/* parent of the node */
	unsigned short line_num;	/* line number of the node */
	dtype	ndtype;			/* data type of the node */
	struct node *kids[1];		/* flex array of node children */
	} *nodep;

#define NIL (nodep)0

/* structure for linked lists in the tree */
/* The main lists are lists of lines, so this is a good place to put the
   line number information */

typedef struct link_list {
	byte	ntype;			/* to match regular nodes */
	byte	nflags;			/* flags on the node */
	struct node *parent;		/* parent of the node */
	unsigned short	line_num;	/* line number of node in original src*/
	nodep	kid;			/* the element in the list */
	struct link_list *next;		/* next in the chain, or nil */
	char	*filename;		/* original source filename */
	} *listp;

struct typelist {
	byte	argmin;			/* minimum arguments that may be given*/
	byte 	argmax;			/* max args that may be given */
	byte	argcount;		/* number of types in the arg list */
	dtype	*args;			/* actual list of args */
	};


/* Node flags */


struct node_info {
	char *printcode;		/* how to print the node */
	int flags;
	byte kids;			/* number of tree kids */
	byte fullkids;			/* number of kids to alloc for */
	};

#define MAX_KIDS 4			/* max kids any tree node has */

#define kid0(x)	x->kids[0]
#define kid1(x)	x->kids[1]
#define kid2(x)	x->kids[2]
#define kid3(x)	x->kids[3]

/* flags to cast or otherwise flag nodes */

#define CAST_NGNAME 1
#define CAST_MAILNAME 2
#define CAST_DATE 3
#define CAST_INT 4
#define CAST_MASK 7
#define NF_LVALUE 8
#define NF_ARRASG 16			/* can be overloaded with LVALUE */

/* flags indicating type structure of kids */

#define TF_ONEINT 1
#define TF_2INT 2
#define TF_RET 4			/* this node involves return */
#define TF_RETINT 8		/* this node always returns an int */
