#include "nl.h"

/* Definitions of the header variables -- the user can define others */

char	*message_id;
username *approved;
char	*control;
time_t	date;
char	*distribution;
time_t	expires;
array	*followup_to;
username *from;
array	*keywords;
int	lines;
array	*newsgroups;
char	*organization;
array	*path;
char	*posting_version;
array	*references;
username *reply_to;
username *sender;
char	*subject;
char	*summary;
array	*xref;

 /*
  * Newsclip(TM) Library Source Code.
  * Copyright 1989 Looking Glass Software Limited.  All Rights Reserved.
  * Unless otherwise licenced, the only authorized use of this source
  * code is compilation into a binary of the newsclip library for the
  * use of licenced Newsclip customers.  Minor source code modifications
  * are allowed.
  */



char *hlines[MAX_HLINES];		/* pointer to header fields */
struct hitem_list *htypes[MAX_HLINES];	/* what type of header line this is */
int header_size;			/* num bytes in header */

/*
 * The master routine to read a header and parse it.
 * A header structure (an array of hitem_lists structures) has been
 * created in the user program, indicating which headers are to be
 * parsed into variables, and how they are to be parsed.
 */

int
read_header( in )
FILE *in;
{
	int len;		/* length of string in buffer */
	struct hitem_list *look_header();
	int i;
	int real_heads;		/* number of real header lines */
	int num_heads;		/* number of headers we like */
	struct hitem_list *whathead;	/* what header line this is */
	bool wantcont;		/* do I want the continuation lines? */
	char *delim;		/* location of header delimiter */
	char buf[HLINE_SIZE];	/* buffer to read line into */
	int oldsize;		/* size of last desired header line, including
					the 0 byte at the end. */

	clear_header();		/* erase all the header variables */


	num_heads = 0;
	real_heads = 0;
	header_size = 0;


	/* read in all the header lines, joining together multiple lines
	   that are part of one field.  We do not allocate memory for
	   lines we do not wish. */

	/* For this routine, we use the temporary allocator.  When we
	   get a multiple part line, we use the temporary reallocator.
	   In this case, this will almost always not involve moving any
	   memory, but just adjusting some pointers, and as such it will
	   be very fast. */

	while( fgets( buf, HLINE_SIZE, in ) ) {
		len = strlen(buf);
		header_size += len;
		if( buf[len-1] == '\n' ) {
			if( len == 1 )
				break;		/* header terminated */
			buf[--len] = 0;	/* clear away newline */
			/* if starts with white space, join to previous line */
			if( buf[0] == ' ' || buf[0] == '\t' ) {
				if( wantcont ) {
					hlines[num_heads-1] = temp_realloc(
						hlines[num_heads-1], oldsize,
						oldsize+len );
					/* stick line into new buffer */
					/* we write on top of the old zero */
					strcpy(hlines[num_heads-1]+oldsize-1,
								buf);
					oldsize += len;
					}
				}
			 else {
				real_heads++;
				delim = strchr( buf, ':' );
				wantcont = FALSE;
				if( delim ) {
					*delim = 0;
					whathead = look_header(buf);
					if( whathead ) {
						htypes[num_heads] = whathead;
						/* delim-buf is 1 too small, and
						   that gives us the 1 for the
						   zero byte at the end */
						oldsize = len-(delim-buf);
						hlines[num_heads] = temp_alloc(
							oldsize );
						strcpy( hlines[num_heads],	
								delim+1 );
						num_heads++;
						wantcont = TRUE;
						}
					}
				}
			}
		 else {
			/* a line longer than the very large buffer! --
			   we ignore it, it's probably a garbled header. */
			;
			}
		}


	/* The header has now been read in.  Break it up and parse it */

	for( i = 0; i < num_heads; i++ ) {
		extern int preserve_case;
		char *arg;	/* argument */

		/* find out what header it was */
		whathead = htypes[i];

		/* find start of argument */
		arg = whitestrip( hlines[i] );
		/* lowercase the whole field unless it is an explicit
		   two-case field */
		if( !(whathead->dtype & T_DUALCASE) && !preserve_case )
			lowercase( arg );

		prepare_var( whathead->dtype, whathead->var, arg,
					whathead->delims );
				
		}

	/* now we should initialize the temporary memory allocator with
	   what is left in the static buffer, plus the rest of the blocks
	   allocated for it */

	return real_heads;
				
}


/* parse the various data types and store them in the variable provided */
/* This does handle arrays with a bit of recursion */

prepare_var( type, var, arg, delims )
int type;		/* data type to parse */
datau *var;		/* pointer to variable */
char *arg;		/* string argument to be parsed */
char *delims;		/* array parse delimiters */
{
	extern time_t getdate();

	if( type & T_ARRAY ) {
		*(array **)var = parse_array( arg, delims, type );
		}
	 else switch( type & T_BASETYPE ) {
		case T_INTEGER:
			var->uinteger = atoi(arg);
			break;
		case T_DATE:
			var->udate = getdate( arg );
			break;
		case T_STRING:
			var->ustring = arg;
			break;
		case T_NEWSGROUP:
			var->uinteger = ng_number( arg );
			break;
		case T_USERNAME:
			var->uusername =(username*)temp_alloc(sizeof(username));
			proc_username( var->uusername, arg );
			break;
		}
}

/*
 * This routine searches for the header item that matches the line we have
 * been provided with, and returns the descriptor struct for it.
 */

struct hitem_list *
look_header( hstr )
char *hstr;			/* string with header name */
{
	register int res;
	register int low, high, mid;	/* binary search points */
	extern int num_headers;		/* generated in user program */
	extern struct hitem_list header_items[];

	low = 0;
	high = num_headers-1;

	lowercase(hstr);

	/* perform a binary search to see which header item this is */

	while (low <= high) {
		mid = (low + high) / 2;
		res = strcmp(hstr, header_items[mid].hname);
		if (res < 0)
			high = mid - 1;
		else if (res > 0)
			low = mid + 1;
		else
			return &header_items[mid];
	}
	return (struct hitem_list *)0;
}

/* Zero out all the header variables before processing an article */

clear_header()
{
	int i;
	datau *tv;
	extern struct hitem_list header_items[];

	for( i = 0; header_items[i].hname; i++ ) {
		tv = header_items[i].var;
		if( header_items[i].dtype & T_ARRAY )
			*(array **)tv = (array *)0;
		 else switch( header_items[i].dtype ) {
			case T_INTEGER:
			case T_NEWSGROUP:
				tv->uinteger = 0;
				break;
			case T_DATE:
				tv->udate = 0;
				break;
			case T_STRING:
				tv->ustring = (char *)0;
				break;
			case T_USERNAME:
				tv->uusername = 0;
				break;
			}
		}
}

/* Turn a From: style line into an emailname and a full name */

/*
 * The three formats allowed on usenet for From: lines are
 *	user@domain
 *	user@domain (Full name)
 *	Full name <user@domain>
 *
 */

proc_username( uname, string )
username *uname;
char *string;
{
	char *mailname;		/* place for mail name */
	char *fname;		/* temp store of full name */

	if( mailname = strchr( string, '<' ) ) {
		/* null out the < character */
		*mailname++ = 0;
		mailname = white_delim_strip( mailname, '>' );
		fname = whitestrip( string );
		}
	 else {
		if( fname = strchr( string, '(' ) ) {
			*fname++ = 0;
			fname = white_delim_strip( fname, ')' );
			}
		mailname = whitestrip( string );
		}
			
	uname->emailname = mailname;
	uname->fullname = fname;
}

/*
 * Turn a string into an array.
 */

array *
parse_array( str, delims, type )
char *str;		/* the string to parse */
char *delims;		/* delimiters to use */
int type;		/* type of data */
{
	/* parse this field into an array */
	char *p;
	char atemp[sizeof(array)+MAX_ARRAY*sizeof(datau)];
	array *ar, *real;
	bool strip;
	int i, count;

	/* allocate temporary place for array */
	ar = (array *)/*&*/atemp;
	count = 0;

	/* if the first character of the delimiter list is an 'S', we
	   strip white space from the tokens. */
	if( strip = (delims[0] == STRIP_CODE) )
		delims++;		/* eliminate the S */
	/* loop, parsing the line */

	for( p = strtok( str, delims ); p && count < MAX_ARRAY ;
				p = strtok( NULL, delims ) ) {

		if( strip )
			p = whitestrip( p );

		prepare_var( type & T_BASETYPE, &ar->vals[count++], p, NULL );
		}

	/* now create the array properly */

	real = fresh_array( count, type );
	for( i = 0; i < count; i++ )
		real->vals[i] = ar->vals[i];
	return real;
}

/* User routine to turn a string into a variable.  All this does is make
   a temporary copy of the string first, since prepare_var is destructive
   on the string */

uprepare_var( type, var, arg, delims )
int type;		/* data type to parse */
datau *var;		/* pointer to variable */
char *arg;		/* string argument to be parsed */
char *delims;
{
	prepare_var( type, var, temp_string(arg), delims );
}

/* create an empty array of a given size */

array *
fresh_array( nels, type )
int nels;			/* number of elements in array */
int type;			/* type of array */
{
	array *retar;
	int size;

	if( nels < 0 ) {
		warning( 1, "Invalid Array size %d\n", nels );
		nels = 0;
		}

	size = sizeof(array) + (nels-1) * sizeof(datau);
	retar = (array *)temp_alloc( size );
	zero( retar, size );
	retar->arsize = nels;
	retar->artype = type & T_BASETYPE;
	return retar;
}
