

/****************************************************************************/
/*                                                                          */
/*      NNstat -- Internet Statistics Collection Package                    */
/*      April 1991                                                          */
/*                                                                          */
/*            Written by: Bob Braden & Annette DeSchon                      */
/*            USC Information Sciences Institute                            */
/*            Marina del Rey, California                                    */
/*                                                                          */
/*      Copyright (c) 1991 University of Southern California.               */
/*      All rights reserved.                                                */
/*                                                                          */
/*      Redistribution and use in source and binary forms are permitted     */
/*      provided that the above copyright notice and this paragraph are     */
/*      duplicated in all such forms and that any documentation,            */
/*      advertising materials, and other materials related to such          */
/*      distribution and use acknowledge that the software was              */
/*      developed by the University of Southern California, Information     */
/*      Sciences Institute.  The name of the University may not be used     */
/*      to endorse or promote products derived from this software           */
/*      without specific prior written permission.                          */
/*      THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR        */
/*      IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED      */
/*      WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR          */
/*      PURPOSE.                                                            */
/*                                                                          */
/****************************************************************************/


#ifdef ULTRIX
/*  This routine replaces "etherif.c" for use with Ultrix.
    It uses the Ultrix packet filter instead of
    the proprietary Sun NIT interface.  There are no
    copyright restrictions on this code. 
    -- Written by Jeff Mogul, DEC WRL
*/

#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/errno.h>
#include <net/pfilt.h>

#include "stat.h"
#include "packet.h"

#define DATANEEDED (64+sizeof(union ip_data)+sizeof(struct ether_header))
int snaplen = DATANEEDED;  /* alignment handled by packet filter driver */

#define READBUFSIZE (1024*128)

char readbuf[READBUFSIZE];

extern int errno;
int if_fd = -1;
extern char *EtherIface;

#ifdef  FALIGN
#define EHSIZE  (sizeof(struct ether_header))
#define WSIZE   (sizeof(int))
#define ALIGN_OFF   (WSIZE - (EHSIZE%WSIZE))
#else
#define ALIGN_OFF   0
#endif  FALIGN

static  u_long  TotPkts = 0;        /* can't oflow for 79 hrs on ether */
static  u_long  TotDrops = 0;       /* count of dropped packets */
static  long    TotMissed = 0;      /* missed by i/f during this run */
static  long    OrigMissed = -1;    /* missed by i/f before this run */

/*
 *  Open packet filter and initialize it.
 *
 *  The parameter passed selects a particular ethernet type field.
 */

initdevice(EtherType)
int EtherType;
{
#ifdef DEBUG
    register int i;
    struct endevp devp;
#endif DEBUG
    struct eniocb ctl;
    struct enfilter filter;
    unsigned maxwaiting;
    struct timeval timeout;
    int truncation;
    int enmode;

    if (if_fd < 0) {

        /*  Open the device. */
    
        /* works even if EtherIface is NULL */
        if_fd = pfopen(EtherIface, O_RDONLY);
            
        if (if_fd == -1) {
            perror("packet filter open error");
            exit(-1);
        }
    
#ifdef  DEBUG
        /*  Get device parameters. */
    
        if (ioctl(if_fd, EIOCDEVP, &devp) == -1) {
            perror("enet EIOCDEVP ioctl error");
            exit(-1);
        }
        printf("type = %d, adrlen = %d, hdrlen = %d, MTU = %d\n",
            (int) devp.end_dev_type, (int) devp.end_addr_len, 
            (int) devp.end_hdr_len, (int) devp.end_MTU);
        printf("addr = ");
        for (i=0; i< devp.end_addr_len; i++) {
            if (i != 0) printf(":");
            printf("%x", devp.end_addr[i]);
        }
        printf("\n");
        printf("broadcast addr = ");
        for (i=0; i< devp.end_addr_len; i++) {
            if (i != 0) printf(":");
            printf("%x", devp.end_broadaddr[i]);
        }
        printf("\n");
#endif  DEBUG
    
        /*  Get operating parameters. */
    
        if (ioctl(if_fd, EIOCGETP, &ctl) == -1) {
            perror("Ioctl EIOCGETP");
            exit(-1);
        }

#ifdef  DEBUG
        printf("Maxwaiting = %d, Maxprio = %d, timeout = %ld, maxfilters = %d\n", (int) ctl.en_maxwaiting, (int) ctl.en_maxpriority, ctl.en_rtout, ctl.en_maxfilters);
#endif  DEBUG
    
        /*  Set operating parameters. */
    
        timeout.tv_sec = 1;
        timeout.tv_usec = 0;
        if (ioctl(if_fd, EIOCSRTIMEOUT, &timeout) < 0) {
            perror("Ioctl EIOCSRTIMEOUT");
            exit(-1);
        }

        truncation = DATANEEDED;
        if (ioctl(if_fd, EIOCTRUNCATE, &truncation) < 0) {
            perror("Ioctl EIOCTRUNCATE");
            exit(-1);
        }

        enmode = ENBATCH|ENTSTAMP|ENPROMISC|ENNONEXCL;
        if (ioctl(if_fd, EIOCMBIS, &enmode) < 0) {
            perror("Ioctl EIOCMBIS");
            exit(-1);
        }

        if (ioctl(if_fd, EIOCSETP, &ctl) == -1) {
            perror("enet ioctl EIOCSETP error");
            exit(-1);
        }

        /*  Set the receive queue depth to its maximum. */

        maxwaiting = -1;
        if (ioctl(if_fd, EIOCSETW, &maxwaiting) == -1) {
            perror("enet ioctl EIOCSETW error");
            exit(-1);
        }
    
        /*  Set the filter. */
    
        filter.enf_Priority = 3;
        filter.enf_FilterLen = 0;
        if (EtherType != -1) {
            /* Filter on specific Ethernet packet type */
            /* ASSUMES STANDARD ETHERNET */
            filter.enf_Filter[filter.enf_FilterLen++] =
            ENF_PUSHWORD + 6;
            filter.enf_Filter[filter.enf_FilterLen++] =
            ENF_PUSHLIT | ENF_EQ;
            filter.enf_Filter[filter.enf_FilterLen++] =
            htons(EtherType);
        }
        if (ioctl(if_fd, EIOCSETF, &filter) == -1) {
            perror("enet ioctl EIOCSETF error");
            exit(-1);
        }

        /*  Flush the receive queue, since we've changed
            the operating parameters and we otherwise might
            receive data without headers or from the wrong
            filter. */

        if (ioctl(if_fd, EIOCFLUSH) == -1) {
            perror("enet ioctl EIOCFLUSH error");
            exit(-1);
        }

    }
}

deinitdevice()
{
    close(if_fd);
    if_fd = -1;
}

readether()
{
    register char *bp;
    struct enstamp stamp;
    register struct enstamp *stp;
    int datalen = 0;
    register int readlen;
    int captured;

#ifdef  FALIGN
    stp = &stamp;       /* this will never change */
#endif  FALIGN

        if (if_fd < 0) return;
    /*
     * Make sure that IP header fields are aligned
     */
    readlen = read(if_fd, (caddr_t) (readbuf + ALIGN_OFF),
             (sizeof(readbuf) - ALIGN_OFF));
    if (readlen < 0) {
        lseek(if_fd, 0, 0);
        readlen = read(if_fd, (caddr_t) readbuf, sizeof(readbuf));
        if (readlen < 0)
            perror("readether error");
    }

    bp = readbuf + ALIGN_OFF;
    while (readlen > 0) {
#ifdef  FALIGN
        /* avoid alignment issues here */
        bcopy(bp, &stamp, sizeof(stamp));
#else
        stp = (struct enstamp *)bp;
#endif  FALIGN

        if (stp->ens_stamplen != sizeof(struct enstamp)) {
/*          fprintf(stderr, "bad ens_stamplen %d\n",
                        stp->ens_stamplen);   */
            break;  /* treat the entire buffer as garbage */
        }

        captured = stp->ens_count;
        if (captured > DATANEEDED)
            captured = DATANEEDED;
        parse(&(bp[sizeof(struct enstamp)]), captured,
            stp->ens_count, stp->ens_tstamp);

        TotPkts++;
        TotDrops += stp->ens_dropped;
        TotMissed = stp->ens_ifoverflows;
        if (OrigMissed < 0)
            OrigMissed = TotMissed;

        if (readlen == (captured + sizeof(struct enstamp))) {
            break;  /* this was the last packet in the batch */
        }

        captured = ENALIGN(captured);   /* skip padding */
        readlen -= (captured + sizeof(struct enstamp));
        bp += (captured + sizeof(struct enstamp));
    }
}


/*
 * returns non-zero IFF something has been dropped or missed
 *  Doesn't reference "outp" if it returns 0.
 */
boolean
if_stats(outp)
char *outp;
{
    int missed = TotMissed - OrigMissed;
    static buf[80];

    if (OrigMissed < 0) /* not initialized, so not relevant */
        missed = 0;

    if ((TotDrops + missed) == 0)
        return(FALSE);
    (void)sprintf(outp, "%d packets", TotPkts);
    if (TotDrops) {
        (void)sprintf(buf, " + %d discarded by kernel", TotDrops);
        strcat(outp, buf);
    }
    if (missed) {
        (void)sprintf(buf, " + %d discarded by interface", missed);
        strcat(outp, buf);
    }
    strcat(outp, "\n");
    return(TRUE);
}
#endif ULTRIX
