//: X1:CustomHandler.java
// How to write custom handler
// {Broken}
import com.bruceeckel.simpletest.*;
import java.util.logging.*;
import java.util.*;

public class CustomHandler {
  private static Logger logger =
    Logger.getLogger("CustomHandler");
  private static List strHolder = new ArrayList();
  public static void main(String[] args) {
    SimpleTest monitor =
      new SimpleTest("CustomHandler");
    logger.addHandler(new Handler() {
      public void publish(LogRecord logRecord) {
        strHolder.add(logRecord.getLevel() + ":");
        strHolder.add(
          logRecord.getSourceClassName() + ":");
        strHolder.add(
          logRecord.getSourceMethodName() + ":");
        strHolder.add(
          "<" + logRecord.getMessage() + ">");
        strHolder.add(
          System.getProperty("line.separator"));
      }
      public void flush() {}
      public void close() {}
    });
    logger.warning("Logging Warning");
    logger.info("Logging Info");
    System.out.print(strHolder);
    monitor.expect(new String[] {
      "[WARNING:, CustomHandler:, main:, <Logging Warning>, ",
      ", INFO:, CustomHandler:, main:, <Logging Info>, ",
      "]"});
  }
} ///:~