/*
 * Copyright (c) 1993,1994
 *	Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Texas A&M University
 *	and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *             David K. Hess, Douglas Lee Schales, David R. Safford
 */
// From manage.c
unsigned short chkSum(unsigned char *,unsigned short,unsigned short *);
void deliverPacket(Socket *, unsigned char , void * , int);
void handleSync(SyncPacket * , int , Socket *);
void handleReboot(void *,int , Socket *);
void handleNewkey(unsigned char *, int , Socket *);
void handleQuery(QueryPacket * , int , Socket *);
void handleLoad(LoadPacket * , int , Socket *);
void handleWrite(void *,int ,Socket *);
void handleRelease(ReleasePacket *, int , Socket * );
void handleStatistics(StatisticsPacket *,int ,Socket *);
void filtMessage(unsigned char *, int , Socket * );
void initManage(void);

// From filter.c
unsigned char networkCacheLookup(in_addr);
unsigned char networkCacheFetch(in_addr,NetworkCacheEntry *);
void networkCacheFlush(void);
int checkIncomingTcp( in_addr , in_addr , unsigned short , unsigned short );
int checkOutgoingTcp( in_addr , in_addr , unsigned short , unsigned short );
int checkIncomingUdp( in_addr , in_addr , unsigned short , unsigned short );
int checkOutgoingUdp( in_addr , in_addr , unsigned short , unsigned short );
int checkIncomingPacket(unsigned short, unsigned char *, int );
int checkOutgoingPacket(unsigned short, unsigned char *, int );
void checkCard(CardHandle *, CardHandle *, CheckFunction ,unsigned short,unsigned long *,unsigned long *);
void checkCards(void);
void initMemory(void);
void initTables(void);
void initNetworks(void);

// From potp.c
void clientInit(unsigned char *,Key *,SyncPacket *);
void serverInit(unsigned char *,Key *,SyncPacket *);
void buildNewSessionKey(Key *,Key *,Key *);
void encrypt(unsigned char *,unsigned char *,Key *,unsigned short);
void decrypt(unsigned char *,unsigned char *,Key *,unsigned short);
void initFromPass(unsigned char *,Key *);
void initFromTime(Key *);
unsigned long randLong(Key *);
unsigned char randByte(Key *k);
unsigned char randBit(Key *);
unsigned char lfsr(unsigned long *,unsigned long);
void initPotp(void);

// From ndis.c
unsigned short __pascal systemRequest(unsigned long,unsigned long,unsigned short,
						unsigned short,unsigned short);
unsigned short __pascal requestConfirm(unsigned short,unsigned short,unsigned short,
						unsigned short,unsigned short,unsigned short);
unsigned short __pascal transmitConfirm(unsigned short,unsigned short,
						unsigned short,unsigned short,unsigned short);
unsigned short __pascal receiveLookahead(unsigned short,unsigned short,
						unsigned short,unsigned char *,
						unsigned char *,unsigned short);
unsigned short __pascal indicationComplete(unsigned short,unsigned short);
unsigned short __pascal receiveChain(unsigned short,unsigned short,unsigned short,
						RxBufDescr *,unsigned char *,unsigned short);
unsigned short __pascal status(unsigned short,unsigned short,unsigned char *,
						unsigned short,unsigned short);
void far systemRequestGlue(void);
void far requestConfirmGlue(void);
void far transmitConfirmGlue(void);
void far receiveLookaheadGlue(void);
void far indicationCompleteGlue(void);
void far receiveChainGlue(void);
void far statusGlue(void);

void renumberPacketQueues(void);
void scanQueue(Queue *,unsigned long *,unsigned long *,unsigned long);
void sendPacket(PktBuf *,int);
void printNdisError(unsigned short);
void openNdis(void);
void parseNdisConfig(void);
void registerNdisAndBind(void);
void checkMacFeatures(CardHandle *);
void startMac(CardHandle *);
void shutdownNdis(void);
void initNdis(CardHandle **, CardHandle **);

// From queue.c
PktBuf *pktBufFromHandle(int);
void enqueuePktBuf(Queue *, PktBuf *);
PktBuf *dequeuePktBuf(Queue *, PktBuf *);
void freePktBuf(PktBuf *);
PktBuf *allocPktBuf(void);
PktBuf *allocPktBufMgmt(void);
void initQueue(void);

// From main.c
void init(void);
void checkMisc(void);
void fastCopy(unsigned char *dest,unsigned char *src,int length);
ScheduledEvent *addScheduledEvent(unsigned long,unsigned long,EventCallBack);
void deleteScheduledEvent(ScheduledEvent *);
void usage(void);
int main(int , char *[]);

// From ip.c
unsigned char *inet_ntoa(unsigned char *,in_addr *);
in_addr *inet_aton(unsigned char *,in_addr *);
ArpEntry *arpLookupIp(in_addr);
ArpEntry *arpLookupHardware(HardwareAddress *);
ArpEntry *arpAdd(void);
void arpCallBack(ScheduledEvent *);
void sendvRawMac(IoVec *,int ,HardwareAddress *,unsigned short ,int );
void sendvRaw(IoVec *,int,HardwareAddress *,unsigned short,...);
void sendArp(in_addr);
void sendvIp(in_addr *,unsigned char ,IoVec *,int );
void sendvUdp(IoVec *,int ,Socket *);
void handleArp(ArpHeader *,int);
void handleIp(IpHeader *,int );
void handleIcmp(IcmpHeader *,int ,in_addr *);
void handleUdp(UdpHeader *,int ,in_addr *);
int checkLocal(unsigned short,HardwareAddress *,unsigned short,unsigned char *);
Socket *socket(int,unsigned short,in_addr *,unsigned short,int,CallBack);
void initIp(void);
void checkIp(void);

// From bridge.c
int bridgeLookUp(HardwareAddress *);
int bridge(unsigned short,unsigned char *);
void initBridge(void);

// From misc.asm
unsigned long swapLong(unsigned long);
in_addr swapAddr(in_addr);
unsigned short swapWord(unsigned short);
void swapLongPtr(unsigned long *);
void swapWordPtr(unsigned short *);
void moveBytes(unsigned char *,unsigned char *,int);
void moveWords(unsigned char *,unsigned char *,int);
void moveLongs(unsigned char *,unsigned char *,int);
void xmsCall(XmsRegs *);

unsigned char networkCacheLookup(in_addr);
unsigned char networkCacheFetch(in_addr host,NetworkCacheEntry *);
void networkCacheFlush(void);

unsigned short xmsAllocMem(unsigned long);
void xmsFreeMem(unsigned short);
void xmsCopy(unsigned short,unsigned long,unsigned short,unsigned long,unsigned long);
unsigned short xmsQueryFree(void);
void initXms(void);

void printStats(void);
void clearStats(void);
void initStats(void);
void keyCheckCallBack(ScheduledEvent *);

// From sl.c
void initSyslog(void);
// in_addr long2Addr(unsigned long);
void syslogMessage(unsigned long,...);
