/*  ARC - Archive utility - ARCDOS

    Version 1.44, created on 07/25/86 at 14:17:38

(C) COPYRIGHT 1985 by System Enhancement Associates; ALL RIGHTS RESERVED

    By:  Thom Henderson

    Description:
         This file contains certain DOS level routines that assist
         in doing fancy things with an archive, primarily reading and
         setting the date and time last modified.

         These are, by nature, system dependant functions.  But they are
         also, by nature, very expendable.

    Language:
         Computer Innovations Optimizing C86
*/
#include <stdio.h>
#include "arc.h"
#include "fileio2.h"                   /* needed for filehand */

getstamp(f,date,time)                  /* get a file's date/time stamp */
FILE *f;                               /* file to get stamp from */
unsigned int *date, *time;             /* storage for the stamp */
{
    struct {int ax,bx,cx,dx,si,di,ds,es;} reg;

    reg.ax = 0x5700;                   /* get date/time */
    reg.bx = filehand(f);              /* file handle */
    if(sysint21(&reg,&reg)&1)          /* DOS call */
         printf("Get timestamp fail (%d)\n",reg.ax);

    *date = reg.dx;                    /* save date/time */
    *time = reg.cx;
}

setstamp(f,date,time)                  /* set a file's date/time stamp */
FILE *f;                               /* file to set stamp on */
unsigned int date, time;               /* desired date, time */
{
    struct {int ax,bx,cx,dx,si,di,ds,es;} reg;

    fflush(f);                         /* force any pending output */

    reg.ax = 0x5701;                   /* set date/time */
    reg.bx = filehand(f);              /* file handle */
    reg.cx = time;                     /* desired time */
    reg.dx = date;                     /* desired date */
    if(sysint21(&reg,&reg)&1)          /* DOS call */
         printf("Set timestamp fail (%d)\n",reg.ax);
}

int filehand(stream)                   /* find handle on a file */
struct bufstr *stream;                 /* file to grab onto */
{
    return stream->bufhand;            /* return DOS 2.0 file handle */
}
