/*  ARC - Archive utility - ARCRUN

    Version 1.20, created on 03/24/86 at 19:34:31

(C) COPYRIGHT 1985,85 by System Enhancement Associates; ALL RIGHTS RESERVED

    By:  Thom Henderson

    Description:
         This file contains the routines used to "run" a file
         which is stored in an archive.  At present, all we really do
         is (a) extract a temporary file, (b) give its name as a system
         command, and then (c) delete the file.

    Language:
         Computer Innovations Optimizing C86
*/
#include <stdio.h>
#include "arc.h"

runarc(num,arg)                        /* run file from archive */
int num;                               /* number of arguments */
char *arg[];                           /* pointers to arguments */
{
    struct heads hdr;                  /* file header */
    char *makefnam();                  /* filename fixer */
    char buf[100];                 /* filename buffer */
    FILE *fopen();                     /* file opener */

    rempath(num,arg);                  /* strip off paths */

    openarc(0);                        /* open archive for reading */

    if(num)                            /* if files were named */
    {    while(readhdr(&hdr,arc))      /* while more files to check */
         {    if(match(hdr.name,makefnam(arg[0],".*",buf)))
                   runfile(&hdr,num,&arg[1]);
              else fseek(arc,hdr.size,1);
         }
    }

    else while(readhdr(&hdr,arc))      /* else run all files */
         runfile(&hdr,0,NULL);

    closearc(0);                       /* close archive after changes */
}

static runfile(hdr,num,arg)            /* run a file */
struct heads *hdr;                     /* pointer to header data */
int num;                               /* number of arguments */
char *arg[];                           /* pointers to arguments */
{
    FILE *tmp, *fopen();               /* temporary file */
    char buf[100], *makefnam();    /* temp file name, fixer */
    char sys[100];                 /* invocation command buffer */
    char *dir, *gcdir();               /* directory stuff */
    int n;                             /* index */

    makefnam("$ARCTEMP",hdr->name,buf);

    if(!strcmp(buf,"$ARCTEMP.BAS"))
         strcpy(sys,"BASICA $ARCTEMP");

    else if(!strcmp(buf,"$ARCTEMP.BAT")
         || !strcmp(buf,"$ARCTEMP.COM")
         || !strcmp(buf,"$ARCTEMP.EXE"))
         strcpy(sys,"$ARCTEMP");

    else
    {    if(warn)
         {    printf("File %s is not a .BAS, .BAT, .COM, or .EXE\n",
                   hdr->name);
              nerrs++;
         }
         fseek(arc,hdr->size,1);  /* skip this file */
         return;
    }

    if(warn)
         if(tmp=fopen(buf,"rb"))
              abort("Temporary file %s already exists",buf);
    if(!(tmp=fopen(makefnam("$ARCTEMP",hdr->name,buf),"wrb")))
         abort("Unable to create temporary file %s",buf);

    if(note)
         printf("Invoking file: %s\n",hdr->name);

    for(n=0; n<num; n++)               /* add command line arguments */
    {    strcat(sys," ");
         strcat(sys,arg[n]);
    }

    dir = gcdir("");                   /* see where we are */
    unpack(arc,tmp,hdr);               /* unpack the entry */
    fclose(tmp);                       /* release the file */
    system(sys);                       /* try to invoke it */
    chdir(dir); free(dir);             /* return to whence we started */
    if(unlink(buf) && warn)
    {    printf("Cannot unsave temporary file %s\n",buf);
         nerrs++;
    }
}
