/*
signal.c - a signal package for Turbo C 1.0.

This program and accompanying documentation, henceforth collectively known as
"this software", are copyrighted thus:  (C) Copyright 1987 Rahul Dhesi, all
rights reserved.  This software may be used and distributed in any way
whatsoever, whether commercial or noncommercial, with the following
exceptions:  (a) this paragraph and this copyright notice must be included
unchanged;  (b) it is forbidden to copy this software for distribution as
part of any collection over which a compilation copyright is claimed.
Notwithstanding the above, there are no restrictions of any kind on the
machine-readable object code produced by compiling this program with a C
compiler.

                                   -- Rahul Dhesi 1987/08/08
*/

/*
Note:  When assigning an address to the variable `handler', a race
condition can theoretically occur if a user interrupt occurs during
the assignment.  However, current versions of MS-DOS cause a user
interrupt to take effect only during system calls, so in practice it
won't happen.
*/

/* The following include files are already supplied with Turbo C */
#include <signal.h>
#include <errno.h>

/*
NOTE:  For best results, edit your <signal.h> file, provided with
Turbo C, to include the following declaration at the end:
     int (*_Cdecl signal (int sig, int (*action)())) ();
*/

void ctrlbrk (int (*fptr)(void));

static int (*handler)() = SIG_DFL;
int main_handler();

int (*_Cdecl signal (int sig, int (*action) ())) ()
{
    int (*retval) ();
    static int installed = 0;
    if (sig != SIGINT) {
        errno = EINVAL;
        return SIG_ERR;                 /* error return */
    }
    if (!installed) {
        ctrlbrk (main_handler);         /* ctrlbrk() is in Turbo C library */
        installed = 1;
    }

    retval = handler;
    handler = action;
    return (retval);
}

#define ABORT_PGM   0
#define RESUME_PGM  1

/* Every keyboard interrupt is handled here first */
int main_handler()
{
    int (*old_handler)(void);

    if (handler == SIG_IGN)
        return (RESUME_PGM);
    if (handler == SIG_DFL)
        return (ABORT_PGM);
    old_handler = handler;          /* Save user's handler address */
    handler = SIG_DFL;              /* Reset handler, like System V does */
    (*old_handler)();               /* call the user's handler */
    return (RESUME_PGM);
}
